package drr.regulation.csa.rewrite.trade.functions;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.event.functions.IntendedToClear;
import drr.base.qualification.event.functions.IsCleared;
import drr.regulation.common.ClearingException;
import drr.regulation.common.ClearingExceptionReasonEnum;
import drr.regulation.common.ClearingExceptionsAndExemptionsEnum;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ClearingExceptionsAndExemptions;
import drr.regulation.common.metafields.FieldWithMetaRegimeNameEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ClearingExceptionsAndExemptionsCounterparty.ClearingExceptionsAndExemptionsCounterpartyDefault.class)
public abstract class ClearingExceptionsAndExemptionsCounterparty implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected ClearingExceptionsAndExemptions clearingExceptionsAndExemptions;
	@Inject protected IntendedToClear intendedToClear;
	@Inject protected IsCleared isCleared;
	@Inject protected SupervisoryBodyForCSA supervisoryBodyForCSA;

	/**
	* @param transactionReportInstruction 
	* @param party 
	* @return _clearingExceptionsAndExemptions 
	*/
	public List<ClearingExceptionsAndExemptionsEnum> evaluate(TransactionReportInstruction transactionReportInstruction, Party party) {
		List<ClearingExceptionsAndExemptionsEnum> _clearingExceptionsAndExemptions = doEvaluate(transactionReportInstruction, party);
		
		return _clearingExceptionsAndExemptions;
	}

	protected abstract List<ClearingExceptionsAndExemptionsEnum> doEvaluate(TransactionReportInstruction transactionReportInstruction, Party party);

	public static class ClearingExceptionsAndExemptionsCounterpartyDefault extends ClearingExceptionsAndExemptionsCounterparty {
		@Override
		protected List<ClearingExceptionsAndExemptionsEnum> doEvaluate(TransactionReportInstruction transactionReportInstruction, Party party) {
			List<ClearingExceptionsAndExemptionsEnum> _clearingExceptionsAndExemptions = new ArrayList<>();
			return assignOutput(_clearingExceptionsAndExemptions, transactionReportInstruction, party);
		}
		
		protected List<ClearingExceptionsAndExemptionsEnum> assignOutput(List<ClearingExceptionsAndExemptionsEnum> _clearingExceptionsAndExemptions, TransactionReportInstruction transactionReportInstruction, Party party) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(transactionReportInstruction)
				.mapSingleToItem(item -> item
					.filterSingleNullSafe(_item -> areEqual(MapperS.of(isCleared.evaluate(_item.<WorkflowStep>map("getOriginatingWorkflowStep", _transactionReportInstruction -> _transactionReportInstruction.getOriginatingWorkflowStep()).get())), MapperS.of(false), CardinalityOperator.All).and(areEqual(MapperS.of(intendedToClear.evaluate(_item.<WorkflowStep>map("getOriginatingWorkflowStep", _transactionReportInstruction -> _transactionReportInstruction.getOriginatingWorkflowStep()).get())), MapperS.of(false), CardinalityOperator.All)).get()));
			_clearingExceptionsAndExemptions.addAll(thenArg
				.mapSingleToList(reportInstruction -> {
					final MapperC<PartyInformation> thenArg0 = reportInstruction.<ReportableInformation>map("getReportableInformation", _transactionReportInstruction -> _transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation())
						.filterItemNullSafe(item -> areEqual(item.<ReferenceWithMetaParty>map("getPartyReference", partyInformation -> partyInformation.getPartyReference()).<Party>map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()), MapperS.of(party), CardinalityOperator.All).get());
					final MapperC<PartyInformation> thenArg1 = thenArg0
						.filterItemNullSafe(item -> areEqual(item.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).<ClearingException>map("getClearingException", reportingRegime -> reportingRegime.getClearingException()).<Boolean>map("getClearingException", clearingException -> clearingException.getClearingException()), MapperS.of(true), CardinalityOperator.Any).get());
					final MapperListOfLists<ReportingRegime> thenArg2 = thenArg1
						.mapItemToList(item -> item.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()));
					final MapperC<ReportingRegime> thenArg3 = thenArg2
						.flattenList();
					final MapperC<ClearingExceptionsAndExemptionsEnum> ifThenElseResult;
					if (areEqual(thenArg3.<FieldWithMetaRegimeNameEnum>map("getRegimeName", reportingRegime -> reportingRegime.getRegimeName()).<RegimeNameEnum>map("Type coercion", fieldWithMetaRegimeNameEnum -> fieldWithMetaRegimeNameEnum.getValue()), MapperS.of(RegimeNameEnum.DODD_FRANK_ACT), CardinalityOperator.Any).or(areEqual(thenArg3.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.CFTC), CardinalityOperator.Any)).getOrDefault(false)) {
						final MapperC<ReportingRegime> thenArg4 = thenArg3
							.filterItemNullSafe(item -> areEqual(item.<FieldWithMetaRegimeNameEnum>map("getRegimeName", reportingRegime -> reportingRegime.getRegimeName()).<RegimeNameEnum>map("Type coercion", fieldWithMetaRegimeNameEnum -> fieldWithMetaRegimeNameEnum == null ? null : fieldWithMetaRegimeNameEnum.getValue()), MapperS.of(RegimeNameEnum.CSA), CardinalityOperator.All).get());
						final MapperC<ReportingRegime> thenArg5 = thenArg4
							.filterItemNullSafe(item -> areEqual(MapperC.<SupervisoryBodyEnum>of(supervisoryBodyForCSA.evaluate()), item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), CardinalityOperator.Any).get());
						final MapperListOfLists<ClearingExceptionReasonEnum> thenArg6 = thenArg5
							.mapItemToList(item -> item.<ClearingException>map("getClearingException", reportingRegime -> reportingRegime.getClearingException()).<ClearingExceptionReasonEnum>mapC("getClearingExceptionReason", clearingException -> clearingException.getClearingExceptionReason()));
						final MapperC<ClearingExceptionReasonEnum> thenArg7 = thenArg6
							.flattenList();
						ifThenElseResult = thenArg7
							.mapItem(item -> MapperS.of(clearingExceptionsAndExemptions.evaluate(item.get())));
					} else {
						final MapperC<ReportingRegime> thenArg8 = thenArg3
							.filterItemNullSafe(item -> areEqual(item.<FieldWithMetaRegimeNameEnum>map("getRegimeName", reportingRegime -> reportingRegime.getRegimeName()).<RegimeNameEnum>map("Type coercion", fieldWithMetaRegimeNameEnum -> fieldWithMetaRegimeNameEnum == null ? null : fieldWithMetaRegimeNameEnum.getValue()), MapperS.of(RegimeNameEnum.CSA), CardinalityOperator.All).get());
						final MapperC<ReportingRegime> thenArg9 = thenArg8
							.filterItemNullSafe(item -> areEqual(MapperC.<SupervisoryBodyEnum>of(supervisoryBodyForCSA.evaluate()), item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), CardinalityOperator.Any).get());
						final MapperListOfLists<ClearingExceptionReasonEnum> thenArg10 = thenArg9
							.mapItemToList(item -> item.<ClearingException>map("getClearingException", reportingRegime -> reportingRegime.getClearingException()).<ClearingExceptionReasonEnum>mapC("getClearingExceptionReason", clearingException -> clearingException.getClearingExceptionReason()));
						final MapperC<ClearingExceptionReasonEnum> thenArg11 = thenArg10
							.flattenList();
						final MapperC<ClearingExceptionReasonEnum> thenArg12 = thenArg11
							.filterItemNullSafe(item -> areEqual(MapperC.<ClearingExceptionReasonEnum>of(MapperS.of(ClearingExceptionReasonEnum.INTER_AFFILIATE), MapperS.of(ClearingExceptionReasonEnum.EXCEPTION)), item, CardinalityOperator.Any).get());
						ifThenElseResult = thenArg12
							.mapItem(item -> MapperS.of(clearingExceptionsAndExemptions.evaluate(item.get())));
					}
					return ifThenElseResult;
				}).getMulti());
			
			return _clearingExceptionsAndExemptions;
		}
	}
}
