package drr.regulation.csa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.base.trade.payment.OtherPayment;
import drr.regulation.csa.rewrite.dtcc.DTCCAdditionalFields;
import drr.regulation.csa.rewrite.trade.CSATransactionReportTrade;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 7.0.0-dev.66
 */
@RosettaDataRule("CSATransactionReportTradeDTCC_CSA_VR_0140_01")
@ImplementedBy(CSATransactionReportTradeDTCC_CSA_VR_0140_01.Default.class)
public interface CSATransactionReportTradeDTCC_CSA_VR_0140_01 extends Validator<CSATransactionReportTrade> {
	
	String NAME = "CSATransactionReportTradeDTCC_CSA_VR_0140_01";
	String DEFINITION = "if otherPayment -> receiver exists and otherPayment -> receiver count > 1 then (otherPayment -> receiver count = otherPayment -> amount count and otherPayment -> receiver count = dtccAdditionalFields -> otherPaymentReceiverIDType count)";
	
	class Default implements CSATransactionReportTradeDTCC_CSA_VR_0140_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReportTrade cSATransactionReportTrade) {
			ComparisonResult result = executeDataRule(cSATransactionReportTrade);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CSATransactionReportTrade", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CSATransactionReportTrade", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CSATransactionReportTrade cSATransactionReportTrade) {
			try {
				if (exists(MapperS.of(cSATransactionReportTrade).<OtherPayment>mapC("getOtherPayment", _cSATransactionReportTrade -> _cSATransactionReportTrade.getOtherPayment()).<String>map("getReceiver", otherPayment -> otherPayment.getReceiver())).and(greaterThan(MapperS.of(MapperS.of(cSATransactionReportTrade).<OtherPayment>mapC("getOtherPayment", _cSATransactionReportTrade -> _cSATransactionReportTrade.getOtherPayment()).<String>map("getReceiver", otherPayment -> otherPayment.getReceiver()).resultCount()), MapperS.of(1), CardinalityOperator.All)).getOrDefault(false)) {
					return areEqual(MapperS.of(MapperS.of(cSATransactionReportTrade).<OtherPayment>mapC("getOtherPayment", _cSATransactionReportTrade -> _cSATransactionReportTrade.getOtherPayment()).<String>map("getReceiver", otherPayment -> otherPayment.getReceiver()).resultCount()), MapperS.of(MapperS.of(cSATransactionReportTrade).<OtherPayment>mapC("getOtherPayment", _cSATransactionReportTrade -> _cSATransactionReportTrade.getOtherPayment()).<BigDecimal>map("getAmount", otherPayment -> otherPayment.getAmount()).resultCount()), CardinalityOperator.All).and(areEqual(MapperS.of(MapperS.of(cSATransactionReportTrade).<OtherPayment>mapC("getOtherPayment", _cSATransactionReportTrade -> _cSATransactionReportTrade.getOtherPayment()).<String>map("getReceiver", otherPayment -> otherPayment.getReceiver()).resultCount()), MapperS.of(MapperS.of(cSATransactionReportTrade).<DTCCAdditionalFields>map("getDtccAdditionalFields", _cSATransactionReportTrade -> _cSATransactionReportTrade.getDtccAdditionalFields()).<String>mapC("getOtherPaymentReceiverIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getOtherPaymentReceiverIDType()).resultCount()), CardinalityOperator.All));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CSATransactionReportTradeDTCC_CSA_VR_0140_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReportTrade cSATransactionReportTrade) {
			return Collections.emptyList();
		}
	}
}
