package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.event.functions.IsAllowableAction;
import drr.base.trade.ReportingSide;
import drr.regulation.common.ESMAPartyInformation;
import drr.regulation.common.FCAPartyInformation;
import drr.regulation.common.NatureOfPartyEnum;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.party.functions.ExtractRegimeInformation;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ReportingObligationOfTheCounterparty2Rule.ReportingObligationOfTheCounterparty2RuleDefault.class)
public abstract class ReportingObligationOfTheCounterparty2Rule implements ReportFunction<TransactionReportInstruction, List<Boolean>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractRegimeInformation extractRegimeInformation;
	@Inject protected IsAllowableAction isAllowableAction;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<Boolean> evaluate(TransactionReportInstruction input) {
		List<Boolean> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<Boolean> doEvaluate(TransactionReportInstruction input);

	public static class ReportingObligationOfTheCounterparty2RuleDefault extends ReportingObligationOfTheCounterparty2Rule {
		@Override
		protected List<Boolean> doEvaluate(TransactionReportInstruction input) {
			List<Boolean> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<Boolean> assignOutput(List<Boolean> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperC<ReportingRegime> thenArg1 = thenArg0
				.mapSingleToList(item -> {
					final ReferenceWithMetaParty referenceWithMetaParty = item.<ReportingSide>map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingCounterparty", reportingSide -> reportingSide.getReportingCounterparty()).get();
					return MapperC.<ReportingRegime>of(extractRegimeInformation.evaluate(item.get(), (referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue())));
				});
			final MapperC<ReportingRegime> thenArg2 = thenArg1
				.filterItemNullSafe(item -> areEqual(MapperC.<NatureOfPartyEnum>of(MapperS.of(NatureOfPartyEnum.FINANCIAL), MapperS.of(NatureOfPartyEnum.NON_FINANCIAL)), item.<FCAPartyInformation>map("getFcaPartyInformation", reportingRegime -> reportingRegime.getFcaPartyInformation()).<NatureOfPartyEnum>map("getNatureOfParty", fCAPartyInformation -> fCAPartyInformation.getNatureOfParty()), CardinalityOperator.Any).get());
			output = thenArg2
				.mapItem(item -> areEqual(item.<FCAPartyInformation>map("getFcaPartyInformation", reportingRegime -> reportingRegime.getFcaPartyInformation()).<NatureOfPartyEnum>map("getNatureOfParty", fCAPartyInformation -> fCAPartyInformation.getNatureOfParty()), MapperS.of(NatureOfPartyEnum.FINANCIAL), CardinalityOperator.All).or(areEqual(item.<FCAPartyInformation>map("getFcaPartyInformation", reportingRegime -> reportingRegime.getFcaPartyInformation()).<NatureOfPartyEnum>map("getNatureOfParty", fCAPartyInformation -> fCAPartyInformation.getNatureOfParty()), MapperS.of(NatureOfPartyEnum.NON_FINANCIAL), CardinalityOperator.All).and(areEqual(item.<ESMAPartyInformation>map("getEsmaPartyInformation", reportingRegime -> reportingRegime.getEsmaPartyInformation()).<Boolean>map("getExceedsClearingThreshold", eSMAPartyInformation -> eSMAPartyInformation.getExceedsClearingThreshold()), MapperS.of(true), CardinalityOperator.All))).asMapper()).getMulti();
			
			return output;
		}
	}
}
