package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.base.qualification.event.functions.IsVRAllowedForActionType;
import drr.enrichment.eic.functions.IsAcceptedEicCode;
import drr.regulation.common.ReportableDelivery;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 7.0.0-dev.66
 */
@RosettaDataRule("FCAUKEMIRTransactionReportUKEMIR_VR_2123_01")
@ImplementedBy(FCAUKEMIRTransactionReportUKEMIR_VR_2123_01.Default.class)
public interface FCAUKEMIRTransactionReportUKEMIR_VR_2123_01 extends Validator<FCAUKEMIRTransactionReport> {
	
	String NAME = "FCAUKEMIRTransactionReportUKEMIR_VR_2123_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) and deliveryReport exists then (deliveryReport extract dr [ if IsAcceptedEicCode(deliveryPoint) or IsAcceptedEicCode(interconnectionPoint) then dr -> deliveryEndTime exists else dr -> deliveryEndTime is absent ] then all = True)";
	
	class Default implements FCAUKEMIRTransactionReportUKEMIR_VR_2123_01 {
	
		@Inject protected IsAcceptedEicCode isAcceptedEicCode;
		
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			try {
				if (ComparisonResult.of(MapperS.of(isVRAllowedForActionType.evaluate(MapperS.of(fCAUKEMIRTransactionReport).<ActionTypeEnum>map("getActionType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getActionType()).get()))).and(exists(MapperS.of(fCAUKEMIRTransactionReport).<ReportableDelivery>mapC("getDeliveryReport", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getDeliveryReport()))).getOrDefault(false)) {
					final MapperC<Boolean> thenArg = MapperS.of(fCAUKEMIRTransactionReport).<ReportableDelivery>mapC("getDeliveryReport", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getDeliveryReport())
						.mapItem(dr -> {
							if (ComparisonResult.of(MapperS.of(isAcceptedEicCode.evaluate(MapperS.of(fCAUKEMIRTransactionReport).<String>mapC("getDeliveryPoint", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getDeliveryPoint()).getMulti()))).or(ComparisonResult.of(MapperS.of(isAcceptedEicCode.evaluate(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getInterconnectionPoint", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getInterconnectionPoint()).getMulti())))).getOrDefault(false)) {
								return exists(dr.<LocalTime>map("getDeliveryEndTime", reportableDelivery -> reportableDelivery.getDeliveryEndTime())).asMapper();
							}
							return notExists(dr.<LocalTime>map("getDeliveryEndTime", reportableDelivery -> reportableDelivery.getDeliveryEndTime())).asMapper();
						});
					return ComparisonResult.of(areEqual(thenArg, MapperS.of(true), CardinalityOperator.All).asMapper());
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRTransactionReportUKEMIR_VR_2123_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
