package drr.regulation.hkma.rewrite.margin.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.base.util.party.PartyIdentifierFormat2Enum;
import drr.regulation.hkma.rewrite.margin.HKMAMarginReport;
import drr.standards.iso.CollateralisationType3Code__1;
import drr.standards.iso.MarginActionEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class HKMAMarginReportValidator implements Validator<HKMAMarginReport> {

	private List<ComparisonResult> getComparisonResults(HKMAMarginReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("reportingTimestamp", (ZonedDateTime) o.getReportingTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty1", (String) o.getCounterparty1() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2", (String) o.getCounterparty2() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2Name", (String) o.getCounterparty2Name() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2IdentifierTypeIndicator", (Boolean) o.getCounterparty2IdentifierTypeIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("collateralPortfolioIndicator", (Boolean) o.getCollateralPortfolioIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginPostedByTheReportingCounterparty1PreHaircut", (BigDecimal) o.getInitialMarginPostedByTheReportingCounterparty1PreHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginPostedByTheReportingCounterparty1PostHaircut", (BigDecimal) o.getInitialMarginPostedByTheReportingCounterparty1PostHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfInitialMarginPosted", (ISOCurrencyCodeEnum) o.getCurrencyOfInitialMarginPosted() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginCollectedByTheReportingCounterparty1PreHaircut", (BigDecimal) o.getInitialMarginCollectedByTheReportingCounterparty1PreHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginCollectedByTheReportingCounterparty1PostHaircut", (BigDecimal) o.getInitialMarginCollectedByTheReportingCounterparty1PostHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfInitialMarginCollected", (ISOCurrencyCodeEnum) o.getCurrencyOfInitialMarginCollected() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginPostedByTheReportingCounterparty1PreHaircut", (BigDecimal) o.getVariationMarginPostedByTheReportingCounterparty1PreHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginPostedByTheReportingCounterparty1PostHaircut", (BigDecimal) o.getVariationMarginPostedByTheReportingCounterparty1PostHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfVariationMarginPosted", (ISOCurrencyCodeEnum) o.getCurrencyOfVariationMarginPosted() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginCollectedByTheReportingCounterparty1PreHaircut", (BigDecimal) o.getVariationMarginCollectedByTheReportingCounterparty1PreHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginCollectedByTheReportingCounterparty1PostHaircut", (BigDecimal) o.getVariationMarginCollectedByTheReportingCounterparty1PostHaircut() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfVariationMarginCollected", (ISOCurrencyCodeEnum) o.getCurrencyOfVariationMarginCollected() != null ? 1 : 0, 0, 1), 
				checkCardinality("excessCollateralPostedByTheCounterparty1", (BigDecimal) o.getExcessCollateralPostedByTheCounterparty1() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfExcessCollateralPosted", (String) o.getCurrencyOfExcessCollateralPosted() != null ? 1 : 0, 0, 1), 
				checkCardinality("excessCollateralCollectedByTheCounterparty1", (BigDecimal) o.getExcessCollateralCollectedByTheCounterparty1() != null ? 1 : 0, 0, 1), 
				checkCardinality("currencyOfTheExcessCollateralCollected", (String) o.getCurrencyOfTheExcessCollateralCollected() != null ? 1 : 0, 0, 1), 
				checkCardinality("collateralisationCategory", (CollateralisationType3Code__1) o.getCollateralisationCategory() != null ? 1 : 0, 0, 1), 
				checkCardinality("actionType", (MarginActionEnum) o.getActionType() != null ? 1 : 0, 0, 1), 
				checkCardinality("eventTimestamp", (ZonedDateTime) o.getEventTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("uniqueTransactionIdentifier", (String) o.getUniqueTransactionIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginCollateralPortfolioCode", (String) o.getInitialMarginCollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("portfolioContainingNonReportableComponentIndicator", (Boolean) o.getPortfolioContainingNonReportableComponentIndicator() != null ? 1 : 0, 1, 1), 
				checkCardinality("variationMarginCollateralPortfolioCode", (String) o.getVariationMarginCollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("submitterIdentifier", (String) o.getSubmitterIdentifier() != null ? 1 : 0, 1, 1), 
				checkCardinality("entityResponsibleForReporting", (String) o.getEntityResponsibleForReporting() != null ? 1 : 0, 0, 1), 
				checkCardinality("collateralTimestamp", (ZonedDateTime) o.getCollateralTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("numberRecords", (BigDecimal) o.getNumberRecords() != null ? 1 : 0, 1, 1), 
				checkCardinality("technicalRecordId", (String) o.getTechnicalRecordId() != null ? 1 : 0, 1, 1), 
				checkCardinality("eventDate", (Date) o.getEventDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("counterparty2IdentifierFormat", (PartyIdentifierFormat2Enum) o.getCounterparty2IdentifierFormat() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMAMarginReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("HKMAMarginReport", ValidationResult.ValidationType.CARDINALITY, "HKMAMarginReport", path, "", res.getError());
				}
				return success("HKMAMarginReport", ValidationResult.ValidationType.CARDINALITY, "HKMAMarginReport", path, "");
			})
			.collect(toList());
	}

}
