package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.trade.party.functions.ExecutionAgentOfCounterparty1_Validation;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;


/**
 * @version 7.0.0-dev.66
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0001a_01")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0001a_01.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0001a_01 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0001a_01";
	String DEFINITION = "common.party.ExecutionAgentOfCounterparty1_Validation( actionType, counterparty1, counterparty2, executionAgentCounterparty1, executionAgentCounterparty2, reportSubmittingEntityID )";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0001a_01 {
	
		@Inject protected ExecutionAgentOfCounterparty1_Validation executionAgentOfCounterparty1_Validation;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				return ComparisonResult.of(MapperS.of(executionAgentOfCounterparty1_Validation.evaluate(MapperS.of(mASTransactionReport).<ActionTypeEnum>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()).get(), MapperS.of(mASTransactionReport).<String>map("getCounterparty1", _mASTransactionReport -> _mASTransactionReport.getCounterparty1()).get(), MapperS.of(mASTransactionReport).<String>map("getCounterparty2", _mASTransactionReport -> _mASTransactionReport.getCounterparty2()).get(), MapperS.of(mASTransactionReport).<String>map("getExecutionAgentCounterparty1", _mASTransactionReport -> _mASTransactionReport.getExecutionAgentCounterparty1()).get(), MapperS.of(mASTransactionReport).<String>map("getExecutionAgentCounterparty2", _mASTransactionReport -> _mASTransactionReport.getExecutionAgentCounterparty2()).get(), MapperS.of(mASTransactionReport).<String>map("getReportSubmittingEntityID", _mASTransactionReport -> _mASTransactionReport.getReportSubmittingEntityID()).get())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0001a_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
