package drr.regulation.sec.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.reports.EnrichmentDataRule;
import drr.enrichment.common.reports.UpiPostEnrichmentDataRule;
import drr.enrichment.common.reports.UpiPreEnrichmentDataRule;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.dtcc.reports.DTCC_Comment1Rule;
import drr.regulation.common.dtcc.reports.DTCC_CorporateActionNewTradeParty1LEIRule;
import drr.regulation.common.dtcc.reports.DTCC_DeliveryLocationRule;
import drr.regulation.common.dtcc.reports.DTCC_Leg1CommodityInstrumentIDRule;
import drr.regulation.common.dtcc.reports.DTCC_Leg2CommodityInstrumentIDRule;
import drr.regulation.common.dtcc.reports.DTCC_MaturityDateOfTheUnderlyingRule;
import drr.regulation.common.dtcc.reports.DTCC_OptionStyleRule;
import drr.regulation.common.dtcc.reports.DTCC_OptionTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_PrimaryAssetClassRule;
import drr.regulation.common.dtcc.reports.DTCC_ProductGradeRule;
import drr.regulation.common.dtcc.reports.DTCC_ProductIDRule;
import drr.regulation.common.dtcc.reports.DTCC_ResponsibleDataSubmitterIDRule;
import drr.regulation.common.dtcc.reports.DTCC_ResponsibleDataSubmitterIDTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_SettlementTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_SubmittedForPartyRule;
import drr.regulation.common.dtcc.reports.DTCC_SubmittingPartyIDTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeLegTypesRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty1ExecutionAgentIDRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty1ExecutionAgentIDTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty1ReportingDestinationRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty1TransactionIDRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty2ExecutionAgentIDRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty2ExecutionAgentIDTypeRule;
import drr.regulation.common.dtcc.reports.DTCC_TradeParty2ReportingDestinationRule;
import drr.regulation.common.trade.collateral.reports.InitialMarginCollateralPortfolioCodeRule;
import drr.regulation.common.trade.collateral.reports.VariationMarginCollateralPortfolioCodeRule;
import drr.regulation.common.trade.contract.reports.AssetClassRule;
import drr.regulation.common.trade.contract.reports.ContractTypeRule;
import drr.regulation.common.trade.contract.reports.DeliveryTypeRule;
import drr.regulation.common.trade.contract.reports.MasterAgreementTypeRule;
import drr.regulation.common.trade.contract.reports.MasterAgreementVersionRule;
import drr.regulation.common.trade.contract.reports.OptionStyleRule;
import drr.regulation.common.trade.contract.reports.OptionTypeRule;
import drr.regulation.common.trade.datetime.reports.ClearingTimestampRule;
import drr.regulation.common.trade.datetime.reports.ConfirmationTimestampRule;
import drr.regulation.common.trade.datetime.reports.MaturityDateOfTheUnderlierRule;
import drr.regulation.common.trade.execution.reports.BookingLocationRule;
import drr.regulation.common.trade.execution.reports.TraderLocationRule;
import drr.regulation.common.trade.index.reports.SeniorityRule;
import drr.regulation.common.trade.index.reports.SeriesRule;
import drr.regulation.common.trade.index.reports.VersionRule;
import drr.regulation.common.trade.link.reports.PriorUSIRule;
import drr.regulation.common.trade.link.reports.SecondaryTransactionIdentifierRule;
import drr.regulation.common.trade.link.reports.SubsequentPositionUTIRule;
import drr.regulation.common.trade.link.reports.SwapLinkIDRule;
import drr.regulation.common.trade.party.reports.BrokerIDRule;
import drr.regulation.common.trade.party.reports.Counterparty2IdentifierSourceRule;
import drr.regulation.common.trade.party.reports.Counterparty2NameRule;
import drr.regulation.common.trade.party.reports.CountryOfCounterparty2Rule;
import drr.regulation.common.trade.party.reports.EntityResponsibleForReportingRule;
import drr.regulation.common.trade.party.reports.ExecutionAgentCounterparty1Rule;
import drr.regulation.common.trade.party.reports.ExecutionAgentCounterparty2Rule;
import drr.regulation.common.trade.party.reports.IntragroupRule;
import drr.regulation.common.trade.party.reports.ReportSubmittingEntityRule;
import drr.regulation.common.trade.price.reports.SingleOrUpperAndLowerBarrierRule;
import drr.regulation.common.trade.underlier.reports.NameOfTheUnderlyingIndexRule;
import drr.regulation.sec.rewrite.dtcc.reports.DTCC_ClearingVenueIDTypeRule;
import drr.regulation.sec.rewrite.dtcc.reports.DTCC_ExecutionVenueIDRule;
import drr.regulation.sec.rewrite.dtcc.reports.DTCC_ExecutionVenueIDTypeRule;
import drr.regulation.sec.rewrite.dtcc.reports.DTCC_Leg1FloatingRateIndexRule;
import drr.regulation.sec.rewrite.dtcc.reports.DTCC_Leg2FloatingRateIndexRule;
import drr.regulation.sec.rewrite.dtcc.reports.DTCC_MessageIDRule;
import drr.regulation.sec.rewrite.dtcc.reports.DTCC_OriginalSwapSDRIDTypeRule;
import drr.regulation.sec.rewrite.dtcc.reports.DTCC_SEFOrDCMAnonymousExecutionIndicatorRule;
import drr.regulation.sec.rewrite.dtcc.reports.DTCC_TradeParty1ClearingBrokerIDTypeRule;
import drr.regulation.sec.rewrite.dtcc.reports.DTCC_TradeParty1IDTypeRule;
import drr.regulation.sec.rewrite.dtcc.reports.DTCC_UnderlyingAssetIDRule;
import drr.regulation.sec.rewrite.dtcc.reports.DTCC_UnderlyingAssetNameRule;
import drr.regulation.sec.rewrite.trade.SECTransactionReport;
import drr.regulation.sec.rewrite.trade.labels.SECTradeLabelProvider;
import drr.standards.iosco.cde.version2.execution.reports.FinalContractualSettlementDateRule;
import drr.standards.iosco.cde.version3.basket.reports.BasketConstituentsRule;
import drr.standards.iosco.cde.version3.basket.reports.CustomBasketCodeRule;
import drr.standards.iosco.cde.version3.collateral.reports.CollateralPortfolioIndicatorRule;
import drr.standards.iosco.cde.version3.datetime.reports.EarlyTerminationDateRule;
import drr.standards.iosco.cde.version3.datetime.reports.EventTimestampRule;
import drr.standards.iosco.cde.version3.datetime.reports.ReportingTimestampRule;
import drr.standards.iosco.cde.version3.datetime.reports.ValuationTimestampRule;
import drr.standards.iosco.cde.version3.event.reports.ActionTypeRule;
import drr.standards.iosco.cde.version3.event.reports.LevelRule;
import drr.standards.iosco.cde.version3.execution.reports.ConfirmedRule;
import drr.standards.iosco.cde.version3.party.reports.Beneficiary1IdentifierTypeIndicatorRule;
import drr.standards.iosco.cde.version3.party.reports.Beneficiary1Rule;
import drr.standards.iosco.cde.version3.party.reports.Counterparty2IdentifierTypeIndicatorRule;
import drr.standards.iosco.cde.version3.party.reports.Counterparty2Rule;
import drr.standards.iosco.cde.version3.party.reports.Direction1Rule;
import drr.standards.iosco.cde.version3.price.reports.ExchangeRateBasisRule;
import drr.standards.iosco.cde.version3.price.reports.ExchangeRateRule;
import drr.standards.iosco.cde.version3.price.reports.PriceScheduleRule;
import drr.standards.iosco.cde.version3.price.reports.StrikePriceScheduleRule;
import drr.standards.iosco.cde.version3.quantity.reports.DeltaRule;
import drr.standards.iosco.cde.version3.underlier.reports.CryptoAssetUnderlyingIndicatorRule;
import drr.standards.iosco.cde.version3.underlier.reports.UnderlierIDOtherRule;
import drr.standards.iosco.cde.version3.underlier.reports.UnderlierIDOtherSourceRule;
import drr.standards.iosco.cde.version3.valuation.reports.ValuationAmountRule;
import drr.standards.iosco.cde.version3.valuation.reports.ValuationCurrencyRule;
import drr.standards.iosco.upi.reports.UniqueProductIdentifierRule;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.sec.rewrite.trade", body="SEC", corpusList={"Trade"})
@RuneLabelProvider(labelProvider=SECTradeLabelProvider.class)
@ImplementedBy(SECTradeReportFunction.SECTradeReportFunctionDefault.class)
public abstract class SECTradeReportFunction implements ReportFunction<TransactionReportInstruction, SECTransactionReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected AllocationTypeRule allocationTypeRule;
	@Inject protected AmendmentIndicatorRule amendmentIndicatorRule;
	@Inject protected AssetClassRule assetClassRule;
	@Inject protected AttachmentPointRule attachmentPointRule;
	@Inject protected BasketConstituentsRule basketConstituentsRule;
	@Inject protected Beneficiary1IdentifierTypeIndicatorRule beneficiary1IdentifierTypeIndicatorRule;
	@Inject protected Beneficiary1Rule beneficiary1Rule;
	@Inject protected BookingLocationRule bookingLocationRule;
	@Inject protected BrokerIDRule brokerIDRule;
	@Inject protected BuyerPayer1Rule buyerPayer1Rule;
	@Inject protected CallAmountRule callAmountRule;
	@Inject protected CallCurrencyRule callCurrencyRule;
	@Inject protected ClearingExceptionTypeParty2Rule clearingExceptionTypeParty2Rule;
	@Inject protected ClearingExceptionTypeRule clearingExceptionTypeRule;
	@Inject protected ClearingReceiptDateTimeRule clearingReceiptDateTimeRule;
	@Inject protected ClearingStatusRule clearingStatusRule;
	@Inject protected ClearingSwapUSIIDRule clearingSwapUSIIDRule;
	@Inject protected ClearingSwapUTIIDRule clearingSwapUTIIDRule;
	@Inject protected ClearingTimestampRule clearingTimestampRule;
	@Inject protected ClearingVenueIDRule clearingVenueIDRule;
	@Inject protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
	@Inject protected ConfirmationTimestampRule confirmationTimestampRule;
	@Inject protected ConfirmedRule confirmedRule;
	@Inject protected ContractTypeRule contractTypeRule;
	@Inject protected Counterparty1FinancialEntityIndicatorRule counterparty1FinancialEntityIndicatorRule;
	@Inject protected Counterparty2FinancialEntityIndicatorRule counterparty2FinancialEntityIndicatorRule;
	@Inject protected Counterparty2IdentifierSourceRule counterparty2IdentifierSourceRule;
	@Inject protected Counterparty2IdentifierTypeIndicatorRule counterparty2IdentifierTypeIndicatorRule;
	@Inject protected Counterparty2NameRule counterparty2NameRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CountryOfCounterparty2Rule countryOfCounterparty2Rule;
	@Inject protected CryptoAssetUnderlyingIndicatorRule cryptoAssetUnderlyingIndicatorRule;
	@Inject protected CustomBasketCodeRule customBasketCodeRule;
	@Inject protected CustomBasketIndicatorRule customBasketIndicatorRule;
	@Inject protected DTCC_ClearingVenueIDTypeRule dTCC_ClearingVenueIDTypeRule;
	@Inject protected DTCC_Comment1Rule dTCC_Comment1Rule;
	@Inject protected DTCC_CorporateActionNewTradeParty1LEIRule dTCC_CorporateActionNewTradeParty1LEIRule;
	@Inject protected DTCC_DeliveryLocationRule dTCC_DeliveryLocationRule;
	@Inject protected DTCC_ExecutionVenueIDRule dTCC_ExecutionVenueIDRule;
	@Inject protected DTCC_ExecutionVenueIDTypeRule dTCC_ExecutionVenueIDTypeRule;
	@Inject protected DTCC_Leg1CommodityInstrumentIDRule dTCC_Leg1CommodityInstrumentIDRule;
	@Inject protected DTCC_Leg1FloatingRateIndexRule dTCC_Leg1FloatingRateIndexRule;
	@Inject protected DTCC_Leg2CommodityInstrumentIDRule dTCC_Leg2CommodityInstrumentIDRule;
	@Inject protected DTCC_Leg2FloatingRateIndexRule dTCC_Leg2FloatingRateIndexRule;
	@Inject protected DTCC_MaturityDateOfTheUnderlyingRule dTCC_MaturityDateOfTheUnderlyingRule;
	@Inject protected DTCC_MessageIDRule dTCC_MessageIDRule;
	@Inject protected DTCC_OptionStyleRule dTCC_OptionStyleRule;
	@Inject protected DTCC_OptionTypeRule dTCC_OptionTypeRule;
	@Inject protected DTCC_OriginalSwapSDRIDTypeRule dTCC_OriginalSwapSDRIDTypeRule;
	@Inject protected DTCC_PrimaryAssetClassRule dTCC_PrimaryAssetClassRule;
	@Inject protected DTCC_ProductGradeRule dTCC_ProductGradeRule;
	@Inject protected DTCC_ProductIDRule dTCC_ProductIDRule;
	@Inject protected DTCC_ResponsibleDataSubmitterIDRule dTCC_ResponsibleDataSubmitterIDRule;
	@Inject protected DTCC_ResponsibleDataSubmitterIDTypeRule dTCC_ResponsibleDataSubmitterIDTypeRule;
	@Inject protected DTCC_SEFOrDCMAnonymousExecutionIndicatorRule dTCC_SEFOrDCMAnonymousExecutionIndicatorRule;
	@Inject protected DTCC_SettlementTypeRule dTCC_SettlementTypeRule;
	@Inject protected DTCC_SubmittedForPartyRule dTCC_SubmittedForPartyRule;
	@Inject protected DTCC_SubmittingPartyIDTypeRule dTCC_SubmittingPartyIDTypeRule;
	@Inject protected DTCC_TradeLegTypesRule dTCC_TradeLegTypesRule;
	@Inject protected DTCC_TradeParty1ClearingBrokerIDTypeRule dTCC_TradeParty1ClearingBrokerIDTypeRule;
	@Inject protected DTCC_TradeParty1ExecutionAgentIDRule dTCC_TradeParty1ExecutionAgentIDRule;
	@Inject protected DTCC_TradeParty1ExecutionAgentIDTypeRule dTCC_TradeParty1ExecutionAgentIDTypeRule;
	@Inject protected DTCC_TradeParty1IDTypeRule dTCC_TradeParty1IDTypeRule;
	@Inject protected DTCC_TradeParty1ReportingDestinationRule dTCC_TradeParty1ReportingDestinationRule;
	@Inject protected DTCC_TradeParty1TransactionIDRule dTCC_TradeParty1TransactionIDRule;
	@Inject protected DTCC_TradeParty2ExecutionAgentIDRule dTCC_TradeParty2ExecutionAgentIDRule;
	@Inject protected DTCC_TradeParty2ExecutionAgentIDTypeRule dTCC_TradeParty2ExecutionAgentIDTypeRule;
	@Inject protected DTCC_TradeParty2ReportingDestinationRule dTCC_TradeParty2ReportingDestinationRule;
	@Inject protected DTCC_UnderlyingAssetIDRule dTCC_UnderlyingAssetIDRule;
	@Inject protected DTCC_UnderlyingAssetNameRule dTCC_UnderlyingAssetNameRule;
	@Inject protected DeliveryTypeRule deliveryTypeRule;
	@Inject protected DeltaRule deltaRule;
	@Inject protected Direction1Rule direction1Rule;
	@Inject protected EarlyTerminationDateRule earlyTerminationDateRule;
	@Inject protected EffectiveDateRule effectiveDateRule;
	@Inject protected EmbeddedOptionOnSwapRule embeddedOptionOnSwapRule;
	@Inject protected EnrichmentDataRule enrichmentDataRule;
	@Inject protected EntityResponsibleForReportingRule entityResponsibleForReportingRule;
	@Inject protected EventIdentifierRule eventIdentifierRule;
	@Inject protected EventTimestampRule eventTimestampRule;
	@Inject protected EventTypeRule eventTypeRule;
	@Inject protected ExchangeRateBasisRule exchangeRateBasisRule;
	@Inject protected ExchangeRateRule exchangeRateRule;
	@Inject protected ExecutionAgentCounterparty1Rule executionAgentCounterparty1Rule;
	@Inject protected ExecutionAgentCounterparty2Rule executionAgentCounterparty2Rule;
	@Inject protected ExhaustionPointRule exhaustionPointRule;
	@Inject protected ExpirationDateRule expirationDateRule;
	@Inject protected FinalContractualSettlementDateRule finalContractualSettlementDateRule;
	@Inject protected FirstExerciseDateRule firstExerciseDateRule;
	@Inject protected FixedRateDayCountConventionLeg1Rule fixedRateDayCountConventionLeg1Rule;
	@Inject protected FixedRateDayCountConventionLeg2Rule fixedRateDayCountConventionLeg2Rule;
	@Inject protected FixedRateInitialLeg1Rule fixedRateInitialLeg1Rule;
	@Inject protected FixedRateInitialLeg2Rule fixedRateInitialLeg2Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodLeg1Rule fixedRatePaymentFrequencyPeriodLeg1Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodLeg2Rule fixedRatePaymentFrequencyPeriodLeg2Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodMultiplierLeg1Rule fixedRatePaymentFrequencyPeriodMultiplierLeg1Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodMultiplierLeg2Rule fixedRatePaymentFrequencyPeriodMultiplierLeg2Rule;
	@Inject protected FixingDateLeg1Rule fixingDateLeg1Rule;
	@Inject protected FixingDateLeg2Rule fixingDateLeg2Rule;
	@Inject protected FloatingRateDayCountConventionLeg1Rule floatingRateDayCountConventionLeg1Rule;
	@Inject protected FloatingRateDayCountConventionLeg2Rule floatingRateDayCountConventionLeg2Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodLeg1Rule floatingRatePaymentFrequencyPeriodLeg1Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodLeg2Rule floatingRatePaymentFrequencyPeriodLeg2Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodMultiplierLeg1Rule floatingRatePaymentFrequencyPeriodMultiplierLeg1Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodMultiplierLeg2Rule floatingRatePaymentFrequencyPeriodMultiplierLeg2Rule;
	@Inject protected IndexFactorRule indexFactorRule;
	@Inject protected InitialMarginCollateralPortfolioCodeRule initialMarginCollateralPortfolioCodeRule;
	@Inject protected IntragroupRule intragroupRule;
	@Inject protected LevelRule levelRule;
	@Inject protected MasterAgreementTypeRule masterAgreementTypeRule;
	@Inject protected MasterAgreementVersionRule masterAgreementVersionRule;
	@Inject protected MaturityDateOfTheUnderlierRule maturityDateOfTheUnderlierRule;
	@Inject protected NameOfTheUnderlyingIndexRule nameOfTheUnderlyingIndexRule;
	@Inject protected NewSDRIdentifierRule newSDRIdentifierRule;
	@Inject protected NonStandardTradeIndicatorRule nonStandardTradeIndicatorRule;
	@Inject protected NotionalAmount1Rule notionalAmount1Rule;
	@Inject protected NotionalAmount2Rule notionalAmount2Rule;
	@Inject protected NotionalAmountScheduleLeg1Rule notionalAmountScheduleLeg1Rule;
	@Inject protected NotionalAmountScheduleLeg2Rule notionalAmountScheduleLeg2Rule;
	@Inject protected NotionalCurrency1Rule notionalCurrency1Rule;
	@Inject protected NotionalCurrency2Rule notionalCurrency2Rule;
	@Inject protected OptionStyleRule optionStyleRule;
	@Inject protected OptionTypeRule optionTypeRule;
	@Inject protected OriginRule originRule;
	@Inject protected OriginalExecutionTimestampRule originalExecutionTimestampRule;
	@Inject protected OriginalSwapSDRIDRule originalSwapSDRIDRule;
	@Inject protected OriginalSwapUSIRule originalSwapUSIRule;
	@Inject protected OriginalSwapUTIRule originalSwapUTIRule;
	@Inject protected OtherPaymentRule otherPaymentRule;
	@Inject protected PackageIdentifierRule packageIdentifierRule;
	@Inject protected PackageIndicatorRule packageIndicatorRule;
	@Inject protected PackageTransactionPriceCurrencyRule packageTransactionPriceCurrencyRule;
	@Inject protected PackageTransactionPriceNotationRule packageTransactionPriceNotationRule;
	@Inject protected PackageTransactionPriceRule packageTransactionPriceRule;
	@Inject protected PackageTransactionSpreadCurrencyRule packageTransactionSpreadCurrencyRule;
	@Inject protected PackageTransactionSpreadNotationRule packageTransactionSpreadNotationRule;
	@Inject protected PackageTransactionSpreadRule packageTransactionSpreadRule;
	@Inject protected Payment1PayerRule payment1PayerRule;
	@Inject protected Payment1ReceiverRule payment1ReceiverRule;
	@Inject protected Payment2PayerRule payment2PayerRule;
	@Inject protected PlatformIdentifierRule platformIdentifierRule;
	@Inject protected PostPricedSwapIndicatorRule postPricedSwapIndicatorRule;
	@Inject protected PremiumAmountRule premiumAmountRule;
	@Inject protected PremiumCurrencyRule premiumCurrencyRule;
	@Inject protected PremiumPaymentDateUnadjustedRule premiumPaymentDateUnadjustedRule;
	@Inject protected PriceCurrencyRule priceCurrencyRule;
	@Inject protected PriceNotationRule priceNotationRule;
	@Inject protected PriceRule priceRule;
	@Inject protected PriceScheduleRule priceScheduleRule;
	@Inject protected PriorUSIRule priorUSIRule;
	@Inject protected PriorUTIIDRule priorUTIIDRule;
	@Inject protected PutAmountRule putAmountRule;
	@Inject protected PutCurrencyRule putCurrencyRule;
	@Inject protected QuantityUnitOfMeasureLeg1Rule quantityUnitOfMeasureLeg1Rule;
	@Inject protected QuantityUnitOfMeasureLeg2Rule quantityUnitOfMeasureLeg2Rule;
	@Inject protected ReceiverIdentifierLeg2Rule receiverIdentifierLeg2Rule;
	@Inject protected ReportSubmittingEntityRule reportSubmittingEntityRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected ResetFrequencyPeriod1Rule resetFrequencyPeriod1Rule;
	@Inject protected ResetFrequencyPeriod2Rule resetFrequencyPeriod2Rule;
	@Inject protected ResetFrequencyPeriodMultiplier1Rule resetFrequencyPeriodMultiplier1Rule;
	@Inject protected ResetFrequencyPeriodMultiplier2Rule resetFrequencyPeriodMultiplier2Rule;
	@Inject protected SecondaryTransactionIdentifierRule secondaryTransactionIdentifierRule;
	@Inject protected SellerPayer2Rule sellerPayer2Rule;
	@Inject protected SeniorityRule seniorityRule;
	@Inject protected SeriesRule seriesRule;
	@Inject protected SettlementCurrency1Rule settlementCurrency1Rule;
	@Inject protected SettlementCurrency2Rule settlementCurrency2Rule;
	@Inject protected SettlementLocationLeg1Rule settlementLocationLeg1Rule;
	@Inject protected SingleOrUpperAndLowerBarrierRule singleOrUpperAndLowerBarrierRule;
	@Inject protected SpreadAmountLeg1Rule spreadAmountLeg1Rule;
	@Inject protected SpreadAmountLeg2Rule spreadAmountLeg2Rule;
	@Inject protected SpreadCurrencyLeg1Rule spreadCurrencyLeg1Rule;
	@Inject protected SpreadCurrencyLeg2Rule spreadCurrencyLeg2Rule;
	@Inject protected SpreadNotationLeg1Rule spreadNotationLeg1Rule;
	@Inject protected SpreadNotationLeg2Rule spreadNotationLeg2Rule;
	@Inject protected StrikePriceCurrencyRule strikePriceCurrencyRule;
	@Inject protected StrikePriceNotationRule strikePriceNotationRule;
	@Inject protected StrikePriceRule strikePriceRule;
	@Inject protected StrikePriceScheduleRule strikePriceScheduleRule;
	@Inject protected SubsequentPositionUTIRule subsequentPositionUTIRule;
	@Inject protected SwapLinkIDRule swapLinkIDRule;
	@Inject protected SwapReportingJurisdictionRule swapReportingJurisdictionRule;
	@Inject protected TotalNotionalQuantityLeg1Rule totalNotionalQuantityLeg1Rule;
	@Inject protected TotalNotionalQuantityLeg2Rule totalNotionalQuantityLeg2Rule;
	@Inject protected TradeParty1ClearingBrokerIDRule tradeParty1ClearingBrokerIDRule;
	@Inject protected TradeParty1IDRule tradeParty1IDRule;
	@Inject protected TraderLocationRule traderLocationRule;
	@Inject protected USIIDRule uSIIDRule;
	@Inject protected UTIIDRule uTIIDRule;
	@Inject protected UnderlierIDOtherRule underlierIDOtherRule;
	@Inject protected UnderlierIDOtherSourceRule underlierIDOtherSourceRule;
	@Inject protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
	@Inject protected UnitsRule unitsRule;
	@Inject protected UpiPostEnrichmentDataRule upiPostEnrichmentDataRule;
	@Inject protected UpiPreEnrichmentDataRule upiPreEnrichmentDataRule;
	@Inject protected ValuationAmountRule valuationAmountRule;
	@Inject protected ValuationCurrencyRule valuationCurrencyRule;
	@Inject protected ValuationTimestampRule valuationTimestampRule;
	@Inject protected VariationMarginCollateralPortfolioCodeRule variationMarginCollateralPortfolioCodeRule;
	@Inject protected VersionRule versionRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public SECTransactionReport evaluate(TransactionReportInstruction input) {
		SECTransactionReport.SECTransactionReportBuilder outputBuilder = doEvaluate(input);
		
		final SECTransactionReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(SECTransactionReport.class, output);
		}
		
		return output;
	}

	protected abstract SECTransactionReport.SECTransactionReportBuilder doEvaluate(TransactionReportInstruction input);

	public static class SECTradeReportFunctionDefault extends SECTradeReportFunction {
		@Override
		protected SECTransactionReport.SECTransactionReportBuilder doEvaluate(TransactionReportInstruction input) {
			SECTransactionReport.SECTransactionReportBuilder output = SECTransactionReport.builder();
			return assignOutput(output, input);
		}
		
		protected SECTransactionReport.SECTransactionReportBuilder assignOutput(SECTransactionReport.SECTransactionReportBuilder output, TransactionReportInstruction input) {
			output
				.setEffectiveDateOverriddenAsDate(effectiveDateRule.evaluate(input));
			
			output
				.setEarlyTerminationDate(earlyTerminationDateRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setExecutionTimestampOverriddenAsZonedDateTime(originalExecutionTimestampRule.evaluate(input));
			
			output
				.setExpirationDate(expirationDateRule.evaluate(input));
			
			output
				.setCounterparty1(tradeParty1IDRule.evaluate(input));
			
			output
				.setCounterparty2OverriddenAsString(counterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2IdentifierType(counterparty2IdentifierTypeIndicatorRule.evaluate(input));
			
			output
				.setBeneficiary1(beneficiary1Rule.evaluate(input));
			
			output
				.setBeneficiary1IdentifierTypeIndicator(beneficiary1IdentifierTypeIndicatorRule.evaluate(input));
			
			output
				.setBuyerIdentifier(buyerPayer1Rule.evaluate(input));
			
			output
				.setSellerIdentifier(sellerPayer2Rule.evaluate(input));
			
			output
				.setClearedOverriddenAsClearedEnum(clearingStatusRule.evaluate(input));
			
			output
				.setCentralCounterparty(clearingVenueIDRule.evaluate(input));
			
			output
				.setClearingMember(tradeParty1ClearingBrokerIDRule.evaluate(input));
			
			output
				.setConfirmed(confirmedRule.evaluate(input));
			
			output
				.setCallAmount(callAmountRule.evaluate(input));
			
			output
				.setPutAmount(putAmountRule.evaluate(input));
			
			output
				.setCallCurrency(callCurrencyRule.evaluate(input));
			
			output
				.setPutCurrency(putCurrencyRule.evaluate(input));
			
			output
				.setDelta(deltaRule.evaluate(input));
			
			output
				.setPriceSchedule(priceScheduleRule.evaluate(input));
			
			output
				.setStrikePriceSchedule(strikePriceScheduleRule.evaluate(input));
			
			output
				.setPrice(priceRule.evaluate(input));
			
			output
				.setPriceNotation(priceNotationRule.evaluate(input));
			
			output
				.setPriceCurrency(priceCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionPrice(packageTransactionPriceRule.evaluate(input));
			
			output
				.setPackageTransactionPriceNotation(packageTransactionPriceNotationRule.evaluate(input));
			
			output
				.setPackageTransactionPriceCurrency(packageTransactionPriceCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionSpread(packageTransactionSpreadRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadNotation(packageTransactionSpreadNotationRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadCurrency(packageTransactionSpreadCurrencyRule.evaluate(input));
			
			output
				.setPackageIdentifier(packageIdentifierRule.evaluate(input));
			
			output
				.setStrikePrice(strikePriceRule.evaluate(input));
			
			output
				.setStrikePriceNotation(strikePriceNotationRule.evaluate(input));
			
			output
				.setStrikePriceCurrency(strikePriceCurrencyRule.evaluate(input));
			
			output
				.setPriceUnitOfMeasure(unitsRule.evaluate(input));
			
			output
				.setOptionPremiumAmount(premiumAmountRule.evaluate(input));
			
			output
				.setOptionPremiumCurrency(premiumCurrencyRule.evaluate(input));
			
			output
				.setOptionPremiumPaymentDate(premiumPaymentDateUnadjustedRule.evaluate(input));
			
			output
				.setExchangeRate(exchangeRateRule.evaluate(input));
			
			output
				.setExchangeRateBasis(exchangeRateBasisRule.evaluate(input));
			
			output
				.setCdSIndexAttachmentPoint(attachmentPointRule.evaluate(input));
			
			output
				.setCdSIndexDetachmentPoint(exhaustionPointRule.evaluate(input));
			
			output
				.setCollateralPortfolioIndicator(collateralPortfolioIndicatorRule.evaluate(input));
			
			output
				.setFirstExerciseDate(firstExerciseDateRule.evaluate(input));
			
			output
				.setFinalContractualSettlementDate(finalContractualSettlementDateRule.evaluate(input));
			
			output
				.setSettlementLocation(settlementLocationLeg1Rule.evaluate(input));
			
			output
				.setPriorUTI(priorUTIIDRule.evaluate(input));
			
			output
				.setDirection1(direction1Rule.evaluate(input));
			
			output
				.setValuationAmount(valuationAmountRule.evaluate(input));
			
			output
				.setValuationCurrency(valuationCurrencyRule.evaluate(input));
			
			output
				.setValuationTimestamp(valuationTimestampRule.evaluate(input));
			
			output
				.setCustomBasketCode(customBasketCodeRule.evaluate(input));
			
			output
				.setBasketConstituents(basketConstituentsRule.evaluate(input));
			
			output
				.setOtherPayment(otherPaymentRule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFixedRateDayCountConvention(fixedRateDayCountConventionLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRateDayCountConvention(floatingRateDayCountConventionLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFixedRatePaymentFrequencyPeriod(fixedRatePaymentFrequencyPeriodLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRatePaymentFrequencyPeriod(floatingRatePaymentFrequencyPeriodLeg1Rule.evaluate(input));
			
			final BigDecimal bigDecimal0 = fixedRatePaymentFrequencyPeriodMultiplierLeg1Rule.evaluate(input);
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFixedRatePaymentFrequencyPeriodMultiplier((bigDecimal0 == null ? null : bigDecimal0.intValueExact()));
			
			final BigDecimal bigDecimal1 = floatingRatePaymentFrequencyPeriodMultiplierLeg1Rule.evaluate(input);
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRatePaymentFrequencyPeriodMultiplier((bigDecimal1 == null ? null : bigDecimal1.intValueExact()));
			
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRateResetFrequencyPeriod(resetFrequencyPeriod1Rule.evaluate(input));
			
			final BigDecimal bigDecimal2 = resetFrequencyPeriodMultiplier1Rule.evaluate(input);
			output
				.getOrCreateLeg1()
				.getOrCreatePeriodicPayment()
				.setFloatingRateResetFrequencyMultiplier((bigDecimal2 == null ? null : bigDecimal2.intValueExact()));
			
			output
				.getOrCreateLeg1()
				.setNotionalAmount(notionalAmount1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setNotionalAmountSchedule(notionalAmountScheduleLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setNotionalCurrency(notionalCurrency1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setTotalNotionalQuantity(totalNotionalQuantityLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setFixedRate(fixedRateInitialLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setSettlementCurrency(settlementCurrency1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setSpread(spreadAmountLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setSpreadNotation(spreadNotationLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setSpreadCurrency(spreadCurrencyLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setQuantityUnitOfMeasure(quantityUnitOfMeasureLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setFixingDate(fixingDateLeg1Rule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setPayerIdentifier(payment1PayerRule.evaluate(input));
			
			output
				.getOrCreateLeg1()
				.setReceiverIdentifier(payment1ReceiverRule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFixedRateDayCountConvention(fixedRateDayCountConventionLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRateDayCountConvention(floatingRateDayCountConventionLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFixedRatePaymentFrequencyPeriod(fixedRatePaymentFrequencyPeriodLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRatePaymentFrequencyPeriod(floatingRatePaymentFrequencyPeriodLeg2Rule.evaluate(input));
			
			final BigDecimal bigDecimal3 = fixedRatePaymentFrequencyPeriodMultiplierLeg2Rule.evaluate(input);
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFixedRatePaymentFrequencyPeriodMultiplier((bigDecimal3 == null ? null : bigDecimal3.intValueExact()));
			
			final BigDecimal bigDecimal4 = floatingRatePaymentFrequencyPeriodMultiplierLeg2Rule.evaluate(input);
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRatePaymentFrequencyPeriodMultiplier((bigDecimal4 == null ? null : bigDecimal4.intValueExact()));
			
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRateResetFrequencyPeriod(resetFrequencyPeriod2Rule.evaluate(input));
			
			final BigDecimal bigDecimal5 = resetFrequencyPeriodMultiplier2Rule.evaluate(input);
			output
				.getOrCreateLeg2()
				.getOrCreatePeriodicPayment()
				.setFloatingRateResetFrequencyMultiplier((bigDecimal5 == null ? null : bigDecimal5.intValueExact()));
			
			output
				.getOrCreateLeg2()
				.setNotionalAmount(notionalAmount2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setNotionalAmountSchedule(notionalAmountScheduleLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setNotionalCurrency(notionalCurrency2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setTotalNotionalQuantity(totalNotionalQuantityLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setFixedRate(fixedRateInitialLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setSettlementCurrency(settlementCurrency2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setSpread(spreadAmountLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setSpreadNotation(spreadNotationLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setSpreadCurrency(spreadCurrencyLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setQuantityUnitOfMeasure(quantityUnitOfMeasureLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setFixingDate(fixingDateLeg2Rule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setPayerIdentifier(payment2PayerRule.evaluate(input));
			
			output
				.getOrCreateLeg2()
				.setReceiverIdentifier(receiverIdentifierLeg2Rule.evaluate(input));
			
			output
				.setUnderlyingIdOther(underlierIDOtherRule.evaluate(input));
			
			output
				.setUnderlyingIdOtherSource(underlierIDOtherSourceRule.evaluate(input));
			
			output
				.setCryptoAssetUnderlyingIndicator(cryptoAssetUnderlyingIndicatorRule.evaluate(input));
			
			output
				.setLevel(levelRule.evaluate(input));
			
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setEventType(eventTypeRule.evaluate(input));
			
			output
				.setEventIdentifier(eventIdentifierRule.evaluate(input));
			
			output
				.setEventTimestampOverriddenAsZonedDateTime(eventTimestampRule.evaluate(input));
			
			output
				.setConfirmationTimestamp(confirmationTimestampRule.evaluate(input));
			
			output
				.setPlatformIdentifier(platformIdentifierRule.evaluate(input));
			
			output
				.setBookingLocation(bookingLocationRule.evaluate(input));
			
			output
				.setTraderLocation(traderLocationRule.evaluate(input));
			
			output
				.setDeliveryType(deliveryTypeRule.evaluate(input));
			
			output
				.setExecutionAgentCounterparty1(executionAgentCounterparty1Rule.evaluate(input));
			
			output
				.setExecutionAgentCounterparty2(executionAgentCounterparty2Rule.evaluate(input));
			
			output
				.setClearingExceptionsAndExemptionsCounterparty1(clearingExceptionTypeRule.evaluate(input));
			
			output
				.setClearingExceptionsAndExemptionsCounterparty2(clearingExceptionTypeParty2Rule.evaluate(input));
			
			output
				.setCounterparty2Name(counterparty2NameRule.evaluate(input));
			
			output
				.setReportSubmittingEntityID(reportSubmittingEntityRule.evaluate(input));
			
			output
				.setEntityResponsibleForReporting(entityResponsibleForReportingRule.evaluate(input));
			
			output
				.setCountryOfTheCounterparty2(countryOfCounterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2IdentifierSourceOverriddenAsCounterparty2IdentifierEnum(counterparty2IdentifierSourceRule.evaluate(input));
			
			output
				.setBrokerID(brokerIDRule.evaluate(input));
			
			output
				.setContractType(contractTypeRule.evaluate(input));
			
			output
				.setAssetClass(assetClassRule.evaluate(input));
			
			output
				.setOptionType(optionTypeRule.evaluate(input));
			
			output
				.setOptionStyle(optionStyleRule.evaluate(input));
			
			output
				.setEmbeddedOptionType(embeddedOptionOnSwapRule.evaluate(input));
			
			output
				.setMasterAgreementType(masterAgreementTypeRule.evaluate(input));
			
			output
				.setMasterAgreementVersion(masterAgreementVersionRule.evaluate(input));
			
			output
				.setSecondaryTransactionIdentifier(secondaryTransactionIdentifierRule.evaluate(input));
			
			output
				.setIntragroup(intragroupRule.evaluate(input));
			
			output
				.setNonStandardizedTermIndicator(nonStandardTradeIndicatorRule.evaluate(input));
			
			output
				.setAmendmentIndicator(amendmentIndicatorRule.evaluate(input));
			
			output
				.setNameOfTheUnderlyingIndex(nameOfTheUnderlyingIndexRule.evaluate(input));
			
			output
				.setMaturityDateOfTheUnderlying(maturityDateOfTheUnderlierRule.evaluate(input));
			
			output
				.setSwapLinkID(swapLinkIDRule.evaluate(input));
			
			output
				.setPackageIndicatorOverriddenAsBoolean(packageIndicatorRule.evaluate(input));
			
			output
				.setCustomBasketIndicatorOverriddenAsBoolean(customBasketIndicatorRule.evaluate(input));
			
			output
				.setClearingTimestamp(clearingTimestampRule.evaluate(input));
			
			output
				.setClearingAccountOrigin(originRule.evaluate(input));
			
			output
				.setClearingReceiptTimestamp(clearingReceiptDateTimeRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifier(uTIIDRule.evaluate(input));
			
			output
				.setUniqueProductIdentifier(uniqueProductIdentifierRule.evaluate(input));
			
			output
				.setOriginalSwapUTI(originalSwapUTIRule.evaluate(input));
			
			output
				.setSubsequentPositionUTI(subsequentPositionUTIRule.evaluate(input));
			
			output
				.setOriginalSwapSDRIdentifier(originalSwapSDRIDRule.evaluate(input));
			
			output
				.setPriorUSI(priorUSIRule.evaluate(input));
			
			output
				.setNewSDRIdentifier(newSDRIdentifierRule.evaluate(input));
			
			output
				.setSeniority(seniorityRule.evaluate(input));
			
			final BigDecimal bigDecimal6 = seriesRule.evaluate(input);
			output
				.setSeries((bigDecimal6 == null ? null : bigDecimal6.intValueExact()));
			
			output
				.setIndexFactor(indexFactorRule.evaluate(input));
			
			final BigDecimal bigDecimal7 = versionRule.evaluate(input);
			output
				.setSeriesVersion((bigDecimal7 == null ? null : bigDecimal7.intValueExact()));
			
			output
				.setBarrier(singleOrUpperAndLowerBarrierRule.evaluate(input));
			
			output
				.setInitialMarginCollateralPortfolioCode(initialMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.setVariationMarginCollateralPortfolioCode(variationMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setEnrichment(enrichmentDataRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setPreUpiData(upiPreEnrichmentDataRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setPostUpiData(upiPostEnrichmentDataRule.evaluate(input));
			
			output
				.setClearingSwapUSIs(clearingSwapUSIIDRule.evaluate(input));
			
			output
				.setClearingSwapUTIs(clearingSwapUTIIDRule.evaluate(input));
			
			output
				.setOriginalSwapUSI(originalSwapUSIRule.evaluate(input));
			
			output
				.setPostPricedSwapIndicator(postPricedSwapIndicatorRule.evaluate(input));
			
			output
				.setAllocationIndicator(allocationTypeRule.evaluate(input));
			
			output
				.setUniqueSwapIdentifier(uSIIDRule.evaluate(input));
			
			output
				.setCounterparty1FinancialEntityIndicator(counterparty1FinancialEntityIndicatorRule.evaluate(input));
			
			output
				.setCounterparty2FinancialEntityIndicator(counterparty2FinancialEntityIndicatorRule.evaluate(input));
			
			output
				.setJurisdiction(swapReportingJurisdictionRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setClearingVenueIDType(dTCC_ClearingVenueIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1ClearingBrokerIDType(dTCC_TradeParty1ClearingBrokerIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setSubmittingPartyIDType(dTCC_SubmittingPartyIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setSubmittedForParty(dTCC_SubmittedForPartyRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeLegTypes(dTCC_TradeLegTypesRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1ReportingDestination(dTCC_TradeParty1ReportingDestinationRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty2ReportingDestination(dTCC_TradeParty2ReportingDestinationRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setPrimaryAssetClass(dTCC_PrimaryAssetClassRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setComment1(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setOptionStyle(dTCC_OptionStyleRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setOptionType(dTCC_OptionTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setProductID(dTCC_ProductIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty2ExecutionAgentID(dTCC_TradeParty2ExecutionAgentIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty2ExecutionAgentIDType(dTCC_TradeParty2ExecutionAgentIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1ExecutionAgentID(dTCC_TradeParty1ExecutionAgentIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1ExecutionAgentIDType(dTCC_TradeParty1ExecutionAgentIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1TransactionID(dTCC_TradeParty1TransactionIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setSettlementType(dTCC_SettlementTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setProductGrade(dTCC_ProductGradeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setDeliveryLocation(dTCC_DeliveryLocationRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setLeg1CommodityInstrumentID(dTCC_Leg1CommodityInstrumentIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setLeg2CommodityInstrumentID(dTCC_Leg2CommodityInstrumentIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setResponsibleDataSubmitterIDType(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setResponsibleDataSubmitterID(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setMaturityDateOfTheUnderlying(dTCC_MaturityDateOfTheUnderlyingRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setCorporateActionNewTradeParty1Lei(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setSefOrDcmAnonymousExecutionIndicator(dTCC_SEFOrDCMAnonymousExecutionIndicatorRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setExecutionVenueID(dTCC_ExecutionVenueIDRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setExecutionVenueIDType(dTCC_ExecutionVenueIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setLeg1FloatingRateIndex(dTCC_Leg1FloatingRateIndexRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setLeg2FloatingRateIndex(dTCC_Leg2FloatingRateIndexRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setUnderlyingAssetName(dTCC_UnderlyingAssetNameRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setUnderlyingAssetID(null);
			
			output
				.getOrCreateDtccAdditionalFields()
				.setOriginalSwapSDRIDType(dTCC_OriginalSwapSDRIDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setTradeParty1IDType(dTCC_TradeParty1IDTypeRule.evaluate(input));
			
			output
				.getOrCreateDtccAdditionalFields()
				.setMessageID(dTCC_MessageIDRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
