package drr.standards.iosco.cde.version1.collateral.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.margin.CollateralDetails;
import drr.base.margin.CollateralReportInstructionBase;
import drr.standards.iso.CollateralisationType3Code__1;


@ImplementedBy(CollateralisationCategoryRule.CollateralisationCategoryRuleDefault.class)
public abstract class CollateralisationCategoryRule implements ReportFunction<CollateralReportInstructionBase, CollateralisationType3Code__1> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CollateralisationType3Code__1 evaluate(CollateralReportInstructionBase input) {
		CollateralisationType3Code__1 output = doEvaluate(input);
		
		return output;
	}

	protected abstract CollateralisationType3Code__1 doEvaluate(CollateralReportInstructionBase input);

	public static class CollateralisationCategoryRuleDefault extends CollateralisationCategoryRule {
		@Override
		protected CollateralisationType3Code__1 doEvaluate(CollateralReportInstructionBase input) {
			CollateralisationType3Code__1 output = null;
			return assignOutput(output, input);
		}
		
		protected CollateralisationType3Code__1 assignOutput(CollateralisationType3Code__1 output, CollateralReportInstructionBase input) {
			output = MapperS.of(input).<CollateralDetails>map("getCollateralDetails", collateralReportInstructionBase -> collateralReportInstructionBase.getCollateralDetails()).<CollateralisationType3Code__1>map("getCollateralisationCategory", collateralDetails -> collateralDetails.getCollateralisationCategory()).get();
			
			return output;
		}
	}
}
