package drr.standards.iosco.cde.version1.execution.functions;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.AdjustableDates;
import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.datetime.AdjustableOrRelativeDates;
import cdm.product.template.AmericanExercise;
import cdm.product.template.BermudaExercise;
import cdm.product.template.EuropeanExercise;
import cdm.product.template.OptionExercise;
import cdm.product.template.OptionStyle;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.util.datetime.functions.AdjustableDateResolution;
import drr.base.util.datetime.functions.AdjustableDatesResolution;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;


@ImplementedBy(SettlementDateFromExerciseTerms.SettlementDateFromExerciseTermsDefault.class)
public abstract class SettlementDateFromExerciseTerms implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected AdjustableDateResolution adjustableDateResolution;
	@Inject protected AdjustableDatesResolution adjustableDatesResolution;

	/**
	* @param exerciseTerms 
	* @return date 
	*/
	public List<Date> evaluate(OptionExercise exerciseTerms) {
		List<Date> date = doEvaluate(exerciseTerms);
		
		return date;
	}

	protected abstract List<Date> doEvaluate(OptionExercise exerciseTerms);

	public static class SettlementDateFromExerciseTermsDefault extends SettlementDateFromExerciseTerms {
		@Override
		protected List<Date> doEvaluate(OptionExercise exerciseTerms) {
			List<Date> date = new ArrayList<>();
			return assignOutput(date, exerciseTerms);
		}
		
		protected List<Date> assignOutput(List<Date> date, OptionExercise exerciseTerms) {
			date.addAll(MapperS.of(exerciseTerms).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<EuropeanExercise>map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise()).<AdjustableOrRelativeDate>mapC("getExpirationDate", europeanExercise -> europeanExercise.getExpirationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
				.mapItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get()))).getMulti());
			
			date.addAll(MapperS.of(exerciseTerms).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<AmericanExercise>map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise()).<AdjustableOrRelativeDate>map("getExpirationDate", americanExercise -> americanExercise.getExpirationDate()).<AdjustableDate>map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())
				.mapSingleToItem(item -> MapperS.of(adjustableDateResolution.evaluate(item.get()))).getMulti());
			
			date.addAll(MapperS.of(exerciseTerms).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<BermudaExercise>map("getBermudaExercise", optionStyle -> optionStyle.getBermudaExercise()).<AdjustableOrRelativeDates>map("getBermudaExerciseDates", bermudaExercise -> bermudaExercise.getBermudaExerciseDates()).<AdjustableDates>map("getAdjustableDates", adjustableOrRelativeDates -> adjustableOrRelativeDates.getAdjustableDates())
				.mapSingleToList(item -> MapperC.<Date>of(adjustableDatesResolution.evaluate(item.get()))).getMulti());
			
			return date;
		}
	}
}
