package drr.standards.iso;

import com.rosetta.model.lib.annotations.RosettaEnum;
import com.rosetta.model.lib.annotations.RosettaEnumValue;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * Specifies the type used for the calculation of the valuation.
 * @version 7.0.0-dev.66
 */
@RosettaEnum("ValuationType1Code")
public enum ValuationType1Code {

	/**
	 * Central counterparty (CCP) valuation.
	 */
	@RosettaEnumValue(value = "CCPV") 
	CCPV("CCPV", null),
	
	/**
	 * Mark to market valuation.
	 */
	@RosettaEnumValue(value = "MTMA") 
	MTMA("MTMA", null),
	
	/**
	 * Mark to model valuation.
	 */
	@RosettaEnumValue(value = "MTMO") 
	MTMO("MTMO", null)
;
	private static Map<String, ValuationType1Code> values;
	static {
        Map<String, ValuationType1Code> map = new ConcurrentHashMap<>();
		for (ValuationType1Code instance : ValuationType1Code.values()) {
			map.put(instance.toDisplayString(), instance);
		}
		values = Collections.unmodifiableMap(map);
    }

	private final String rosettaName;
	private final String displayName;

	ValuationType1Code(String rosettaName, String displayName) {
		this.rosettaName = rosettaName;
		this.displayName = displayName;
	}

	public static ValuationType1Code fromDisplayName(String name) {
		ValuationType1Code value = values.get(name);
		if (value == null) {
			throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
		}
		return value;
	}

	@Override
	public String toString() {
		return toDisplayString();
	}

	public String toDisplayString() {
		return displayName != null ?  displayName : rosettaName;
	}
}
