package iso20022.auth030.asic.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.asic.Counterparty45__3;
import iso20022.auth030.asic.validation.Counterparty45__3TypeFormatValidator;
import iso20022.auth030.asic.validation.Counterparty45__3Validator;
import iso20022.auth030.asic.validation.exists.Counterparty45__3OnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version ${project.version}
 */
@RosettaMeta(model=Counterparty45__3.class)
public class Counterparty45__3Meta implements RosettaMetaData<Counterparty45__3> {

	@Override
	public List<Validator<? super Counterparty45__3>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super Counterparty45__3, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super Counterparty45__3> validator(ValidatorFactory factory) {
		return factory.<Counterparty45__3>create(Counterparty45__3Validator.class);
	}

	@Override
	public Validator<? super Counterparty45__3> typeFormatValidator(ValidatorFactory factory) {
		return factory.<Counterparty45__3>create(Counterparty45__3TypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super Counterparty45__3> validator() {
		return new Counterparty45__3Validator();
	}

	@Deprecated
	@Override
	public Validator<? super Counterparty45__3> typeFormatValidator() {
		return new Counterparty45__3TypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super Counterparty45__3, Set<String>> onlyExistsValidator() {
		return new Counterparty45__3OnlyExistsValidator();
	}
}
