package iso20022.auth030.esma.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import iso20022.auth030.esma.AssetClassCommodityMetal2Choice;
import iso20022.auth030.esma.MetalCommodityNonPrecious2;
import iso20022.auth030.esma.MetalCommodityPrecious2;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class AssetClassCommodityMetal2ChoiceOnlyExistsValidator implements ValidatorWithArg<AssetClassCommodityMetal2Choice, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends AssetClassCommodityMetal2Choice> ValidationResult<AssetClassCommodityMetal2Choice> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("nonPrcs", ExistenceChecker.isSet((MetalCommodityNonPrecious2) o.getNonPrcs()))
				.put("prcs", ExistenceChecker.isSet((MetalCommodityPrecious2) o.getPrcs()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("AssetClassCommodityMetal2Choice", ValidationResult.ValidationType.ONLY_EXISTS, "AssetClassCommodityMetal2Choice", path, "");
		}
		return failure("AssetClassCommodityMetal2Choice", ValidationResult.ValidationType.ONLY_EXISTS, "AssetClassCommodityMetal2Choice", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
