# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['Security']

from cdm.base.staticdata.asset.common.Listing import Listing

class Security(Listing):
    """
    Identifies a security by referencing a product identifier and by specifying the sector.
    """
    securityType: cdm.base.staticdata.asset.common.SecurityTypeEnum.SecurityTypeEnum = Field(..., description="Identifies the type of security using an enumerated list.")
    """
    Identifies the type of security using an enumerated list.
    """
    debtType: Optional[cdm.base.staticdata.asset.common.DebtType.DebtType] = Field(None, description="Identifies the type of debt and selected debt economics.")
    """
    Identifies the type of debt and selected debt economics.
    """
    equityType: Optional[cdm.base.staticdata.asset.common.EquityTypeEnum.EquityTypeEnum] = Field(None, description="Identifies the type of equity.")
    """
    Identifies the type of equity.
    """
    fundType: Optional[cdm.base.staticdata.asset.common.FundProductTypeEnum.FundProductTypeEnum] = Field(None, description="Identifies the type of fund.")
    """
    Identifies the type of fund.
    """
    economicTerms: Optional[cdm.product.template.EconomicTerms.EconomicTerms] = Field(None, description="The economic terms associated with a contractual product, i.e. the set of features that are price-forming.")
    """
    The economic terms associated with a contractual product, i.e. the set of features that are price-forming.
    """
    
    @rosetta_condition
    def condition_0_DebtSubType(self):
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "debtType")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(any_elements(rosetta_resolve_attr(self, "securityType"), "<>", rosetta_resolve_attr(SecurityTypeEnum, "DEBT")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_EquitySubType(self):
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "equityType")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(any_elements(rosetta_resolve_attr(self, "securityType"), "<>", rosetta_resolve_attr(SecurityTypeEnum, "EQUITY")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_2_FundSubType(self):
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "fundType")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(any_elements(rosetta_resolve_attr(self, "securityType"), "<>", rosetta_resolve_attr(SecurityTypeEnum, "FUND")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_3_BondEconomicTerms(self):
        item = self
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(self, "securityType"), "=", rosetta_resolve_attr(SecurityTypeEnum, "DEBT"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "economicTerms")), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.asset.common.SecurityTypeEnum
import cdm.base.staticdata.asset.common.DebtType
import cdm.base.staticdata.asset.common.EquityTypeEnum
import cdm.base.staticdata.asset.common.FundProductTypeEnum
import cdm.product.template.EconomicTerms
from cdm.base.staticdata.asset.common.SecurityTypeEnum import SecurityTypeEnum
