# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CleanOrDirtyPrice']


class CleanOrDirtyPrice(BaseDataClass):
    """
     Class specifying the bond price as either clean or dirty in a bond valuation model.
    """
    cleanPrice: Optional[cdm.observable.asset.CleanPrice.CleanPrice] = Field(None, description="The clean price and accruals presented separately.")
    """
    The clean price and accruals presented separately.
    """
    dirtyPrice: Optional[Decimal] = Field(None, description="The dirty price presented as a single number.")
    """
    The dirty price presented as a single number.
    """

import cdm 
import cdm.observable.asset.CleanPrice
