# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AverageTradingVolume']


class AverageTradingVolume(BaseDataClass):
    """
    Represents the average trading volume of an Equity product upon an exchange or set of exchanges.
    """
    period: cdm.base.datetime.Period.Period = Field(..., description="Represents the period of the equities average trading volume on the exchange/s.")
    """
    Represents the period of the equities average trading volume on the exchange/s.
    """
    methodology: cdm.product.collateral.AverageTradingVolumeMethodologyEnum.AverageTradingVolumeMethodologyEnum = Field(..., description="Indicates the type of equity average trading volume being stated (single) the highest amount on one exchange, or (consolidated) volumes across multiple exchanges.")
    """
    Indicates the type of equity average trading volume being stated (single) the highest amount on one exchange, or (consolidated) volumes across multiple exchanges.
    """

import cdm 
import cdm.base.datetime.Period
import cdm.product.collateral.AverageTradingVolumeMethodologyEnum
