# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ReturnAmount']


class ReturnAmount(BaseDataClass):
    """
    A class to specify the application of Interest Amount with respect the Return Amount.
    """
    includesDefaultLanguage: Optional[bool] = Field(None, description="Default language is included when True, and excluded when False.")
    """
    Default language is included when True, and excluded when False.
    """
    customElection: Optional[str] = Field(None, description="Custom election that might be specified by the parties to the agreement.")
    """
    Custom election that might be specified by the parties to the agreement.
    """
    
    @rosetta_condition
    def condition_0_CustomElection(self):
        """
        A data rule to specify that when a custom election exists then default language should not be included.
        """
        item = self
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(self, "includesDefaultLanguage"), "=", False)
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "customElection")), _then_fn0, _else_fn0)

import cdm 
