# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['EarlyTerminationProvision']


class EarlyTerminationProvision(BaseDataClass):
    """
    A data defining:  an early termination provision for a swap. This early termination is at fair value, i.e. on termination the fair value of the product must be settled between the parties.
    """
    mandatoryEarlyTermination: Optional[cdm.product.template.MandatoryEarlyTermination.MandatoryEarlyTermination] = Field(None, description="A mandatory early termination provision to terminate the swap at fair value.")
    """
    A mandatory early termination provision to terminate the swap at fair value.
    """
    mandatoryEarlyTerminationDateTenor: Optional[cdm.base.datetime.Period.Period] = Field(None, description="Period after trade date of the mandatory early termination date.")
    """
    Period after trade date of the mandatory early termination date.
    """
    optionalEarlyTermination: Optional[cdm.product.template.OptionalEarlyTermination.OptionalEarlyTermination] = Field(None, description="An option for either or both parties to terminate the swap at fair value.")
    """
    An option for either or both parties to terminate the swap at fair value.
    """
    optionalEarlyTerminationParameters: Optional[cdm.product.template.ExercisePeriod.ExercisePeriod] = Field(None, description="Definition of the first early termination date and the frequency of the termination dates subsequent to that. American exercise is defined by having a frequency of one day.")
    """
    Definition of the first early termination date and the frequency of the termination dates subsequent to that. American exercise is defined by having a frequency of one day.
    """
    
    @rosetta_condition
    def condition_0_MandatoryEarlyTermination(self):
        """
        The FpML MandatoryEarlyTermination.model specifies a required choice node. The choice node associated with the FpML EarlyTerminationProvision is quite complex and using the data rule provides a more flexible approach than adding complexity to the condition grammar.
        """
        item = self
        return ((rosetta_attr_exists(rosetta_resolve_attr(self, "mandatoryEarlyTermination")) or rosetta_attr_exists(rosetta_resolve_attr(self, "optionalEarlyTermination"))) or (rosetta_attr_exists(rosetta_resolve_attr(self, "mandatoryEarlyTermination")) and rosetta_attr_exists(rosetta_resolve_attr(self, "optionalEarlyTermination"))))

import cdm 
import cdm.product.template.MandatoryEarlyTermination
import cdm.base.datetime.Period
import cdm.product.template.OptionalEarlyTermination
import cdm.product.template.ExercisePeriod
