# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['MandatoryEarlyTerminationAdjustedDates']


class MandatoryEarlyTerminationAdjustedDates(BaseDataClass):
    """
    A data defining:  the adjusted dates associated with a mandatory early termination provision.
    """
    adjustedEarlyTerminationDate: datetime.date = Field(..., description="The early termination date that is applicable if an early termination provision is exercised. This date should already be adjusted for any applicable business day convention.")
    """
    The early termination date that is applicable if an early termination provision is exercised. This date should already be adjusted for any applicable business day convention.
    """
    adjustedCashSettlementValuationDate: datetime.date = Field(..., description="The date by which the cash settlement amount must be agreed. This date should already be adjusted for any applicable business day convention.")
    """
    The date by which the cash settlement amount must be agreed. This date should already be adjusted for any applicable business day convention.
    """
    adjustedCashSettlementPaymentDate: datetime.date = Field(..., description="The date on which the cash settlement amount is paid. This date should already be adjusted for any applicable business date convention.")
    """
    The date on which the cash settlement amount is paid. This date should already be adjusted for any applicable business date convention.
    """
    
    @rosetta_condition
    def condition_0_FpML_ird_44(self):
        """
        FpML validation rule ird-44 - AdjustedEarlyTerminationDate must be before or equal to adjustedCashSettlementValuationDate must be before or the same as adjustedCashSettlementPaymentDate
        """
        item = self
        return (all_elements(rosetta_resolve_attr(self, "adjustedEarlyTerminationDate"), "<=", rosetta_resolve_attr(self, "adjustedCashSettlementValuationDate")) and all_elements(rosetta_resolve_attr(self, "adjustedCashSettlementValuationDate"), "<=", rosetta_resolve_attr(self, "adjustedCashSettlementPaymentDate")))

import cdm 
