# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ManualExercise']


class ManualExercise(BaseDataClass):
    """
    A class defining manual exercise, i.e. that the option buyer counterparty must give notice to the option seller of exercise.
    """
    exerciseNotice: Optional[cdm.product.template.ExerciseNotice.ExerciseNotice] = Field(None, description="Definition of the party to whom notice of exercise should be given.")
    """
    Definition of the party to whom notice of exercise should be given.
    """
    fallbackExercise: Optional[bool] = Field(None, description="If fallback exercise is specified then the notional amount of the underlying swap, not previously exercised under the swaption, will be automatically exercised at the expiration time on the expiration date if at such time the buyer is in-the-money, provided that the difference between the settlement rate and the fixed rate under the relevant underlying swap is not less than one tenth of a percentage point (0.10% or 0.001). The term in-the-money is assumed to have the meaning defined in the 2000 ISDA Definitions, Section 17.4. In-the-money.")
    """
    If fallback exercise is specified then the notional amount of the underlying swap, not previously exercised under the swaption, will be automatically exercised at the expiration time on the expiration date if at such time the buyer is in-the-money, provided that the difference between the settlement rate and the fixed rate under the relevant underlying swap is not less than one tenth of a percentage point (0.10% or 0.001). The term in-the-money is assumed to have the meaning defined in the 2000 ISDA Definitions, Section 17.4. In-the-money.
    """
    
    @rosetta_condition
    def condition_0_ManualExerciseNoticeReceiverParty(self):
        item = self
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "exerciseNotice"), "exerciseNoticeReceiver"), "=", rosetta_resolve_attr(AncillaryRoleEnum, "EXERCISE_NOTICE_RECEIVER_PARTY_MANUAL"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "exerciseNotice"), "exerciseNoticeReceiver")), _then_fn0, _else_fn0)

import cdm 
import cdm.product.template.ExerciseNotice
from cdm.base.staticdata.party.AncillaryRoleEnum import AncillaryRoleEnum
