/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade;

import cdm.event.common.PositionIdentifier;
import cdm.observable.asset.PriceSchedule;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.base.qualification.event.ReportableActionEnum;
import drr.base.trade.ConfirmationMethodEnum;
import drr.base.trade.ExecutionVenueTypeEnum;
import drr.base.trade.ReportablePriceSource;
import drr.base.trade.basket.CustomBasket;
import drr.base.trade.meta.ReportableInformationBaseMeta;
import drr.enrichment.common.EnrichmentData;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ReportableInformationBase", builder=ReportableInformationBaseBuilderImpl.class, version="7.0.0-dev.73")
@RuneDataType(value="ReportableInformationBase", model="drr", builder=ReportableInformationBaseBuilderImpl.class, version="7.0.0-dev.73")
public interface ReportableInformationBase
extends RosettaModelObject {
    public static final ReportableInformationBaseMeta metaData = new ReportableInformationBaseMeta();

    public ConfirmationMethodEnum getConfirmationMethod();

    public ExecutionVenueTypeEnum getExecutionVenueType();

    public Boolean getIntragroup();

    public Boolean getAffiliated();

    public Boolean getLargeSizeTrade();

    public Boolean getSefOrDcmAnonymousIndicator();

    public ZonedDateTime getOriginalExecutionTimestamp();

    public Boolean getCryptoBased();

    public PriceSchedule getUnderlyingAssetLastAvailableSpotPrice();

    public List<? extends ReportablePriceSource> getUnderlyingAssetPriceSource();

    public ReportableActionEnum getReportableAction();

    public PositionIdentifier getSubsequentPositionUTI();

    public PositionIdentifier getCounterpartyPositionPriorUTI();

    public CustomBasket getCustomBasket();

    public Date getFinalContractualSettlementDate();

    public EnrichmentData getEnrichment();

    public ReportableInformationBase build();

    public ReportableInformationBaseBuilder toBuilder();

    public static ReportableInformationBaseBuilder builder() {
        return new ReportableInformationBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends ReportableInformationBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReportableInformationBase> getType() {
        return ReportableInformationBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("confirmationMethod"), ConfirmationMethodEnum.class, (Object)this.getConfirmationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionVenueType"), ExecutionVenueTypeEnum.class, (Object)this.getExecutionVenueType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("intragroup"), Boolean.class, (Object)this.getIntragroup(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("affiliated"), Boolean.class, (Object)this.getAffiliated(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("largeSizeTrade"), Boolean.class, (Object)this.getLargeSizeTrade(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sefOrDcmAnonymousIndicator"), Boolean.class, (Object)this.getSefOrDcmAnonymousIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalExecutionTimestamp"), ZonedDateTime.class, (Object)this.getOriginalExecutionTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cryptoBased"), Boolean.class, (Object)this.getCryptoBased(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyingAssetLastAvailableSpotPrice"), processor, PriceSchedule.class, (RosettaModelObject)this.getUnderlyingAssetLastAvailableSpotPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyingAssetPriceSource"), processor, ReportablePriceSource.class, this.getUnderlyingAssetPriceSource(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportableAction"), ReportableActionEnum.class, (Object)this.getReportableAction(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("subsequentPositionUTI"), processor, PositionIdentifier.class, (RosettaModelObject)this.getSubsequentPositionUTI(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("counterpartyPositionPriorUTI"), processor, PositionIdentifier.class, (RosettaModelObject)this.getCounterpartyPositionPriorUTI(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("customBasket"), processor, CustomBasket.class, this.getCustomBasket(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("enrichment"), processor, EnrichmentData.class, this.getEnrichment(), new AttributeMeta[0]);
    }

    public static class ReportableInformationBaseBuilderImpl
    implements ReportableInformationBaseBuilder {
        protected ConfirmationMethodEnum confirmationMethod;
        protected ExecutionVenueTypeEnum executionVenueType;
        protected Boolean intragroup;
        protected Boolean affiliated;
        protected Boolean largeSizeTrade;
        protected Boolean sefOrDcmAnonymousIndicator;
        protected ZonedDateTime originalExecutionTimestamp;
        protected Boolean cryptoBased;
        protected PriceSchedule.PriceScheduleBuilder underlyingAssetLastAvailableSpotPrice;
        protected List<ReportablePriceSource.ReportablePriceSourceBuilder> underlyingAssetPriceSource = new ArrayList<ReportablePriceSource.ReportablePriceSourceBuilder>();
        protected ReportableActionEnum reportableAction;
        protected PositionIdentifier.PositionIdentifierBuilder subsequentPositionUTI;
        protected PositionIdentifier.PositionIdentifierBuilder counterpartyPositionPriorUTI;
        protected CustomBasket.CustomBasketBuilder customBasket;
        protected Date finalContractualSettlementDate;
        protected EnrichmentData.EnrichmentDataBuilder enrichment;

        @Override
        @RosettaAttribute(value="confirmationMethod")
        @RuneAttribute(value="confirmationMethod")
        public ConfirmationMethodEnum getConfirmationMethod() {
            return this.confirmationMethod;
        }

        @Override
        @RosettaAttribute(value="executionVenueType", isRequired=true)
        @RuneAttribute(value="executionVenueType", isRequired=true)
        public ExecutionVenueTypeEnum getExecutionVenueType() {
            return this.executionVenueType;
        }

        @Override
        @RosettaAttribute(value="intragroup")
        @RuneAttribute(value="intragroup")
        public Boolean getIntragroup() {
            return this.intragroup;
        }

        @Override
        @RosettaAttribute(value="affiliated")
        @RuneAttribute(value="affiliated")
        public Boolean getAffiliated() {
            return this.affiliated;
        }

        @Override
        @RosettaAttribute(value="largeSizeTrade")
        @RuneAttribute(value="largeSizeTrade")
        public Boolean getLargeSizeTrade() {
            return this.largeSizeTrade;
        }

        @Override
        @RosettaAttribute(value="sefOrDcmAnonymousIndicator")
        @RuneAttribute(value="sefOrDcmAnonymousIndicator")
        public Boolean getSefOrDcmAnonymousIndicator() {
            return this.sefOrDcmAnonymousIndicator;
        }

        @Override
        @RosettaAttribute(value="originalExecutionTimestamp")
        @RuneAttribute(value="originalExecutionTimestamp")
        public ZonedDateTime getOriginalExecutionTimestamp() {
            return this.originalExecutionTimestamp;
        }

        @Override
        @RosettaAttribute(value="cryptoBased")
        @RuneAttribute(value="cryptoBased")
        public Boolean getCryptoBased() {
            return this.cryptoBased;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetLastAvailableSpotPrice")
        @RuneAttribute(value="underlyingAssetLastAvailableSpotPrice")
        public PriceSchedule.PriceScheduleBuilder getUnderlyingAssetLastAvailableSpotPrice() {
            return this.underlyingAssetLastAvailableSpotPrice;
        }

        @Override
        public PriceSchedule.PriceScheduleBuilder getOrCreateUnderlyingAssetLastAvailableSpotPrice() {
            PriceSchedule.PriceScheduleBuilder result = this.underlyingAssetLastAvailableSpotPrice != null ? this.underlyingAssetLastAvailableSpotPrice : (this.underlyingAssetLastAvailableSpotPrice = PriceSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public List<? extends ReportablePriceSource.ReportablePriceSourceBuilder> getUnderlyingAssetPriceSource() {
            return this.underlyingAssetPriceSource;
        }

        @Override
        public ReportablePriceSource.ReportablePriceSourceBuilder getOrCreateUnderlyingAssetPriceSource(int index) {
            if (this.underlyingAssetPriceSource == null) {
                this.underlyingAssetPriceSource = new ArrayList<ReportablePriceSource.ReportablePriceSourceBuilder>();
            }
            return (ReportablePriceSource.ReportablePriceSourceBuilder)this.getIndex(this.underlyingAssetPriceSource, index, () -> {
                ReportablePriceSource.ReportablePriceSourceBuilder newUnderlyingAssetPriceSource = ReportablePriceSource.builder();
                return newUnderlyingAssetPriceSource;
            });
        }

        @Override
        @RosettaAttribute(value="reportableAction")
        @RuneAttribute(value="reportableAction")
        public ReportableActionEnum getReportableAction() {
            return this.reportableAction;
        }

        @Override
        @RosettaAttribute(value="subsequentPositionUTI")
        @RuneAttribute(value="subsequentPositionUTI")
        public PositionIdentifier.PositionIdentifierBuilder getSubsequentPositionUTI() {
            return this.subsequentPositionUTI;
        }

        @Override
        public PositionIdentifier.PositionIdentifierBuilder getOrCreateSubsequentPositionUTI() {
            PositionIdentifier.PositionIdentifierBuilder result = this.subsequentPositionUTI != null ? this.subsequentPositionUTI : (this.subsequentPositionUTI = PositionIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="counterpartyPositionPriorUTI")
        @RuneAttribute(value="counterpartyPositionPriorUTI")
        public PositionIdentifier.PositionIdentifierBuilder getCounterpartyPositionPriorUTI() {
            return this.counterpartyPositionPriorUTI;
        }

        @Override
        public PositionIdentifier.PositionIdentifierBuilder getOrCreateCounterpartyPositionPriorUTI() {
            PositionIdentifier.PositionIdentifierBuilder result = this.counterpartyPositionPriorUTI != null ? this.counterpartyPositionPriorUTI : (this.counterpartyPositionPriorUTI = PositionIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="customBasket")
        @RuneAttribute(value="customBasket")
        public CustomBasket.CustomBasketBuilder getCustomBasket() {
            return this.customBasket;
        }

        @Override
        public CustomBasket.CustomBasketBuilder getOrCreateCustomBasket() {
            CustomBasket.CustomBasketBuilder result = this.customBasket != null ? this.customBasket : (this.customBasket = CustomBasket.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public Date getFinalContractualSettlementDate() {
            return this.finalContractualSettlementDate;
        }

        @Override
        @RosettaAttribute(value="enrichment")
        @RuneAttribute(value="enrichment")
        public EnrichmentData.EnrichmentDataBuilder getEnrichment() {
            return this.enrichment;
        }

        @Override
        public EnrichmentData.EnrichmentDataBuilder getOrCreateEnrichment() {
            EnrichmentData.EnrichmentDataBuilder result = this.enrichment != null ? this.enrichment : (this.enrichment = EnrichmentData.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="confirmationMethod")
        @RuneAttribute(value="confirmationMethod")
        public ReportableInformationBaseBuilder setConfirmationMethod(ConfirmationMethodEnum _confirmationMethod) {
            this.confirmationMethod = _confirmationMethod == null ? null : _confirmationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionVenueType", isRequired=true)
        @RuneAttribute(value="executionVenueType", isRequired=true)
        public ReportableInformationBaseBuilder setExecutionVenueType(ExecutionVenueTypeEnum _executionVenueType) {
            this.executionVenueType = _executionVenueType == null ? null : _executionVenueType;
            return this;
        }

        @Override
        @RosettaAttribute(value="intragroup")
        @RuneAttribute(value="intragroup")
        public ReportableInformationBaseBuilder setIntragroup(Boolean _intragroup) {
            this.intragroup = _intragroup == null ? null : _intragroup;
            return this;
        }

        @Override
        @RosettaAttribute(value="affiliated")
        @RuneAttribute(value="affiliated")
        public ReportableInformationBaseBuilder setAffiliated(Boolean _affiliated) {
            this.affiliated = _affiliated == null ? null : _affiliated;
            return this;
        }

        @Override
        @RosettaAttribute(value="largeSizeTrade")
        @RuneAttribute(value="largeSizeTrade")
        public ReportableInformationBaseBuilder setLargeSizeTrade(Boolean _largeSizeTrade) {
            this.largeSizeTrade = _largeSizeTrade == null ? null : _largeSizeTrade;
            return this;
        }

        @Override
        @RosettaAttribute(value="sefOrDcmAnonymousIndicator")
        @RuneAttribute(value="sefOrDcmAnonymousIndicator")
        public ReportableInformationBaseBuilder setSefOrDcmAnonymousIndicator(Boolean _sefOrDcmAnonymousIndicator) {
            this.sefOrDcmAnonymousIndicator = _sefOrDcmAnonymousIndicator == null ? null : _sefOrDcmAnonymousIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalExecutionTimestamp")
        @RuneAttribute(value="originalExecutionTimestamp")
        public ReportableInformationBaseBuilder setOriginalExecutionTimestamp(ZonedDateTime _originalExecutionTimestamp) {
            this.originalExecutionTimestamp = _originalExecutionTimestamp == null ? null : _originalExecutionTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="cryptoBased")
        @RuneAttribute(value="cryptoBased")
        public ReportableInformationBaseBuilder setCryptoBased(Boolean _cryptoBased) {
            this.cryptoBased = _cryptoBased == null ? null : _cryptoBased;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetLastAvailableSpotPrice")
        @RuneAttribute(value="underlyingAssetLastAvailableSpotPrice")
        public ReportableInformationBaseBuilder setUnderlyingAssetLastAvailableSpotPrice(PriceSchedule _underlyingAssetLastAvailableSpotPrice) {
            this.underlyingAssetLastAvailableSpotPrice = _underlyingAssetLastAvailableSpotPrice == null ? null : _underlyingAssetLastAvailableSpotPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public ReportableInformationBaseBuilder addUnderlyingAssetPriceSource(ReportablePriceSource _underlyingAssetPriceSource) {
            if (_underlyingAssetPriceSource != null) {
                this.underlyingAssetPriceSource.add(_underlyingAssetPriceSource.toBuilder());
            }
            return this;
        }

        @Override
        public ReportableInformationBaseBuilder addUnderlyingAssetPriceSource(ReportablePriceSource _underlyingAssetPriceSource, int idx) {
            this.getIndex(this.underlyingAssetPriceSource, idx, () -> _underlyingAssetPriceSource.toBuilder());
            return this;
        }

        @Override
        public ReportableInformationBaseBuilder addUnderlyingAssetPriceSource(List<? extends ReportablePriceSource> underlyingAssetPriceSources) {
            if (underlyingAssetPriceSources != null) {
                for (ReportablePriceSource reportablePriceSource : underlyingAssetPriceSources) {
                    this.underlyingAssetPriceSource.add(reportablePriceSource.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="underlyingAssetPriceSource")
        public ReportableInformationBaseBuilder setUnderlyingAssetPriceSource(List<? extends ReportablePriceSource> underlyingAssetPriceSources) {
            this.underlyingAssetPriceSource = underlyingAssetPriceSources == null ? new ArrayList<ReportablePriceSource.ReportablePriceSourceBuilder>() : (List)underlyingAssetPriceSources.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="reportableAction")
        @RuneAttribute(value="reportableAction")
        public ReportableInformationBaseBuilder setReportableAction(ReportableActionEnum _reportableAction) {
            this.reportableAction = _reportableAction == null ? null : _reportableAction;
            return this;
        }

        @Override
        @RosettaAttribute(value="subsequentPositionUTI")
        @RuneAttribute(value="subsequentPositionUTI")
        public ReportableInformationBaseBuilder setSubsequentPositionUTI(PositionIdentifier _subsequentPositionUTI) {
            this.subsequentPositionUTI = _subsequentPositionUTI == null ? null : _subsequentPositionUTI.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="counterpartyPositionPriorUTI")
        @RuneAttribute(value="counterpartyPositionPriorUTI")
        public ReportableInformationBaseBuilder setCounterpartyPositionPriorUTI(PositionIdentifier _counterpartyPositionPriorUTI) {
            this.counterpartyPositionPriorUTI = _counterpartyPositionPriorUTI == null ? null : _counterpartyPositionPriorUTI.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasket")
        @RuneAttribute(value="customBasket")
        public ReportableInformationBaseBuilder setCustomBasket(CustomBasket _customBasket) {
            this.customBasket = _customBasket == null ? null : _customBasket.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public ReportableInformationBaseBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
            this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="enrichment")
        @RuneAttribute(value="enrichment")
        public ReportableInformationBaseBuilder setEnrichment(EnrichmentData _enrichment) {
            this.enrichment = _enrichment == null ? null : _enrichment.toBuilder();
            return this;
        }

        @Override
        public ReportableInformationBase build() {
            return new ReportableInformationBaseImpl(this);
        }

        @Override
        public ReportableInformationBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public ReportableInformationBaseBuilder prune() {
            if (this.underlyingAssetLastAvailableSpotPrice != null && !this.underlyingAssetLastAvailableSpotPrice.prune().hasData()) {
                this.underlyingAssetLastAvailableSpotPrice = null;
            }
            this.underlyingAssetPriceSource = this.underlyingAssetPriceSource.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.subsequentPositionUTI != null && !this.subsequentPositionUTI.prune().hasData()) {
                this.subsequentPositionUTI = null;
            }
            if (this.counterpartyPositionPriorUTI != null && !this.counterpartyPositionPriorUTI.prune().hasData()) {
                this.counterpartyPositionPriorUTI = null;
            }
            if (this.customBasket != null && !this.customBasket.prune().hasData()) {
                this.customBasket = null;
            }
            if (this.enrichment != null && !this.enrichment.prune().hasData()) {
                this.enrichment = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getConfirmationMethod() != null) {
                return true;
            }
            if (this.getExecutionVenueType() != null) {
                return true;
            }
            if (this.getIntragroup() != null) {
                return true;
            }
            if (this.getAffiliated() != null) {
                return true;
            }
            if (this.getLargeSizeTrade() != null) {
                return true;
            }
            if (this.getSefOrDcmAnonymousIndicator() != null) {
                return true;
            }
            if (this.getOriginalExecutionTimestamp() != null) {
                return true;
            }
            if (this.getCryptoBased() != null) {
                return true;
            }
            if (this.getUnderlyingAssetLastAvailableSpotPrice() != null && this.getUnderlyingAssetLastAvailableSpotPrice().hasData()) {
                return true;
            }
            if (this.getUnderlyingAssetPriceSource() != null && this.getUnderlyingAssetPriceSource().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getReportableAction() != null) {
                return true;
            }
            if (this.getSubsequentPositionUTI() != null && this.getSubsequentPositionUTI().hasData()) {
                return true;
            }
            if (this.getCounterpartyPositionPriorUTI() != null && this.getCounterpartyPositionPriorUTI().hasData()) {
                return true;
            }
            if (this.getCustomBasket() != null && this.getCustomBasket().hasData()) {
                return true;
            }
            if (this.getFinalContractualSettlementDate() != null) {
                return true;
            }
            return this.getEnrichment() != null && this.getEnrichment().hasData();
        }

        public ReportableInformationBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReportableInformationBaseBuilder o = (ReportableInformationBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyingAssetLastAvailableSpotPrice(), (RosettaModelObjectBuilder)o.getUnderlyingAssetLastAvailableSpotPrice(), this::setUnderlyingAssetLastAvailableSpotPrice);
            merger.mergeRosetta(this.getUnderlyingAssetPriceSource(), o.getUnderlyingAssetPriceSource(), this::getOrCreateUnderlyingAssetPriceSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSubsequentPositionUTI(), (RosettaModelObjectBuilder)o.getSubsequentPositionUTI(), this::setSubsequentPositionUTI);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCounterpartyPositionPriorUTI(), (RosettaModelObjectBuilder)o.getCounterpartyPositionPriorUTI(), this::setCounterpartyPositionPriorUTI);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCustomBasket(), (RosettaModelObjectBuilder)o.getCustomBasket(), this::setCustomBasket);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEnrichment(), (RosettaModelObjectBuilder)o.getEnrichment(), this::setEnrichment);
            merger.mergeBasic((Object)this.getConfirmationMethod(), (Object)o.getConfirmationMethod(), this::setConfirmationMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionVenueType(), (Object)o.getExecutionVenueType(), this::setExecutionVenueType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIntragroup(), (Object)o.getIntragroup(), this::setIntragroup, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAffiliated(), (Object)o.getAffiliated(), this::setAffiliated, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLargeSizeTrade(), (Object)o.getLargeSizeTrade(), this::setLargeSizeTrade, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSefOrDcmAnonymousIndicator(), (Object)o.getSefOrDcmAnonymousIndicator(), this::setSefOrDcmAnonymousIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOriginalExecutionTimestamp(), (Object)o.getOriginalExecutionTimestamp(), this::setOriginalExecutionTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCryptoBased(), (Object)o.getCryptoBased(), this::setCryptoBased, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportableAction(), (Object)o.getReportableAction(), this::setReportableAction, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFinalContractualSettlementDate(), (Object)o.getFinalContractualSettlementDate(), this::setFinalContractualSettlementDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReportableInformationBase _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.confirmationMethod, (Object)_that.getConfirmationMethod())) {
                return false;
            }
            if (!Objects.equals((Object)this.executionVenueType, (Object)_that.getExecutionVenueType())) {
                return false;
            }
            if (!Objects.equals(this.intragroup, _that.getIntragroup())) {
                return false;
            }
            if (!Objects.equals(this.affiliated, _that.getAffiliated())) {
                return false;
            }
            if (!Objects.equals(this.largeSizeTrade, _that.getLargeSizeTrade())) {
                return false;
            }
            if (!Objects.equals(this.sefOrDcmAnonymousIndicator, _that.getSefOrDcmAnonymousIndicator())) {
                return false;
            }
            if (!Objects.equals(this.originalExecutionTimestamp, _that.getOriginalExecutionTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.cryptoBased, _that.getCryptoBased())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetLastAvailableSpotPrice, _that.getUnderlyingAssetLastAvailableSpotPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.underlyingAssetPriceSource, _that.getUnderlyingAssetPriceSource())) {
                return false;
            }
            if (!Objects.equals((Object)this.reportableAction, (Object)_that.getReportableAction())) {
                return false;
            }
            if (!Objects.equals(this.subsequentPositionUTI, _that.getSubsequentPositionUTI())) {
                return false;
            }
            if (!Objects.equals(this.counterpartyPositionPriorUTI, _that.getCounterpartyPositionPriorUTI())) {
                return false;
            }
            if (!Objects.equals(this.customBasket, _that.getCustomBasket())) {
                return false;
            }
            if (!Objects.equals(this.finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) {
                return false;
            }
            return Objects.equals(this.enrichment, _that.getEnrichment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.confirmationMethod != null ? ((Object)((Object)this.confirmationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.executionVenueType != null ? ((Object)((Object)this.executionVenueType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.intragroup != null ? this.intragroup.hashCode() : 0);
            _result = 31 * _result + (this.affiliated != null ? this.affiliated.hashCode() : 0);
            _result = 31 * _result + (this.largeSizeTrade != null ? this.largeSizeTrade.hashCode() : 0);
            _result = 31 * _result + (this.sefOrDcmAnonymousIndicator != null ? this.sefOrDcmAnonymousIndicator.hashCode() : 0);
            _result = 31 * _result + (this.originalExecutionTimestamp != null ? this.originalExecutionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.cryptoBased != null ? this.cryptoBased.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetLastAvailableSpotPrice != null ? this.underlyingAssetLastAvailableSpotPrice.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetPriceSource != null ? this.underlyingAssetPriceSource.hashCode() : 0);
            _result = 31 * _result + (this.reportableAction != null ? ((Object)((Object)this.reportableAction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.subsequentPositionUTI != null ? this.subsequentPositionUTI.hashCode() : 0);
            _result = 31 * _result + (this.counterpartyPositionPriorUTI != null ? this.counterpartyPositionPriorUTI.hashCode() : 0);
            _result = 31 * _result + (this.customBasket != null ? this.customBasket.hashCode() : 0);
            _result = 31 * _result + (this.finalContractualSettlementDate != null ? this.finalContractualSettlementDate.hashCode() : 0);
            _result = 31 * _result + (this.enrichment != null ? this.enrichment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReportableInformationBaseBuilder {confirmationMethod=" + String.valueOf((Object)this.confirmationMethod) + ", executionVenueType=" + String.valueOf((Object)this.executionVenueType) + ", intragroup=" + this.intragroup + ", affiliated=" + this.affiliated + ", largeSizeTrade=" + this.largeSizeTrade + ", sefOrDcmAnonymousIndicator=" + this.sefOrDcmAnonymousIndicator + ", originalExecutionTimestamp=" + String.valueOf(this.originalExecutionTimestamp) + ", cryptoBased=" + this.cryptoBased + ", underlyingAssetLastAvailableSpotPrice=" + String.valueOf(this.underlyingAssetLastAvailableSpotPrice) + ", underlyingAssetPriceSource=" + String.valueOf(this.underlyingAssetPriceSource) + ", reportableAction=" + String.valueOf((Object)this.reportableAction) + ", subsequentPositionUTI=" + String.valueOf(this.subsequentPositionUTI) + ", counterpartyPositionPriorUTI=" + String.valueOf(this.counterpartyPositionPriorUTI) + ", customBasket=" + String.valueOf(this.customBasket) + ", finalContractualSettlementDate=" + String.valueOf(this.finalContractualSettlementDate) + ", enrichment=" + String.valueOf(this.enrichment) + "}";
        }
    }

    public static interface ReportableInformationBaseBuilder
    extends ReportableInformationBase,
    RosettaModelObjectBuilder {
        public PriceSchedule.PriceScheduleBuilder getOrCreateUnderlyingAssetLastAvailableSpotPrice();

        public PriceSchedule.PriceScheduleBuilder getUnderlyingAssetLastAvailableSpotPrice();

        public ReportablePriceSource.ReportablePriceSourceBuilder getOrCreateUnderlyingAssetPriceSource(int var1);

        public List<? extends ReportablePriceSource.ReportablePriceSourceBuilder> getUnderlyingAssetPriceSource();

        public PositionIdentifier.PositionIdentifierBuilder getOrCreateSubsequentPositionUTI();

        public PositionIdentifier.PositionIdentifierBuilder getSubsequentPositionUTI();

        public PositionIdentifier.PositionIdentifierBuilder getOrCreateCounterpartyPositionPriorUTI();

        public PositionIdentifier.PositionIdentifierBuilder getCounterpartyPositionPriorUTI();

        public CustomBasket.CustomBasketBuilder getOrCreateCustomBasket();

        @Override
        public CustomBasket.CustomBasketBuilder getCustomBasket();

        public EnrichmentData.EnrichmentDataBuilder getOrCreateEnrichment();

        @Override
        public EnrichmentData.EnrichmentDataBuilder getEnrichment();

        public ReportableInformationBaseBuilder setConfirmationMethod(ConfirmationMethodEnum var1);

        public ReportableInformationBaseBuilder setExecutionVenueType(ExecutionVenueTypeEnum var1);

        public ReportableInformationBaseBuilder setIntragroup(Boolean var1);

        public ReportableInformationBaseBuilder setAffiliated(Boolean var1);

        public ReportableInformationBaseBuilder setLargeSizeTrade(Boolean var1);

        public ReportableInformationBaseBuilder setSefOrDcmAnonymousIndicator(Boolean var1);

        public ReportableInformationBaseBuilder setOriginalExecutionTimestamp(ZonedDateTime var1);

        public ReportableInformationBaseBuilder setCryptoBased(Boolean var1);

        public ReportableInformationBaseBuilder setUnderlyingAssetLastAvailableSpotPrice(PriceSchedule var1);

        public ReportableInformationBaseBuilder addUnderlyingAssetPriceSource(ReportablePriceSource var1);

        public ReportableInformationBaseBuilder addUnderlyingAssetPriceSource(ReportablePriceSource var1, int var2);

        public ReportableInformationBaseBuilder addUnderlyingAssetPriceSource(List<? extends ReportablePriceSource> var1);

        public ReportableInformationBaseBuilder setUnderlyingAssetPriceSource(List<? extends ReportablePriceSource> var1);

        public ReportableInformationBaseBuilder setReportableAction(ReportableActionEnum var1);

        public ReportableInformationBaseBuilder setSubsequentPositionUTI(PositionIdentifier var1);

        public ReportableInformationBaseBuilder setCounterpartyPositionPriorUTI(PositionIdentifier var1);

        public ReportableInformationBaseBuilder setCustomBasket(CustomBasket var1);

        public ReportableInformationBaseBuilder setFinalContractualSettlementDate(Date var1);

        public ReportableInformationBaseBuilder setEnrichment(EnrichmentData var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("confirmationMethod"), ConfirmationMethodEnum.class, (Object)this.getConfirmationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionVenueType"), ExecutionVenueTypeEnum.class, (Object)this.getExecutionVenueType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("intragroup"), Boolean.class, (Object)this.getIntragroup(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("affiliated"), Boolean.class, (Object)this.getAffiliated(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("largeSizeTrade"), Boolean.class, (Object)this.getLargeSizeTrade(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sefOrDcmAnonymousIndicator"), Boolean.class, (Object)this.getSefOrDcmAnonymousIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalExecutionTimestamp"), ZonedDateTime.class, (Object)this.getOriginalExecutionTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cryptoBased"), Boolean.class, (Object)this.getCryptoBased(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyingAssetLastAvailableSpotPrice"), processor, PriceSchedule.PriceScheduleBuilder.class, (RosettaModelObjectBuilder)this.getUnderlyingAssetLastAvailableSpotPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyingAssetPriceSource"), processor, ReportablePriceSource.ReportablePriceSourceBuilder.class, this.getUnderlyingAssetPriceSource(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportableAction"), ReportableActionEnum.class, (Object)this.getReportableAction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("subsequentPositionUTI"), processor, PositionIdentifier.PositionIdentifierBuilder.class, (RosettaModelObjectBuilder)this.getSubsequentPositionUTI(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("counterpartyPositionPriorUTI"), processor, PositionIdentifier.PositionIdentifierBuilder.class, (RosettaModelObjectBuilder)this.getCounterpartyPositionPriorUTI(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("customBasket"), processor, CustomBasket.CustomBasketBuilder.class, this.getCustomBasket(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("enrichment"), processor, EnrichmentData.EnrichmentDataBuilder.class, this.getEnrichment(), new AttributeMeta[0]);
        }

        public ReportableInformationBaseBuilder prune();
    }

    public static class ReportableInformationBaseImpl
    implements ReportableInformationBase {
        private final ConfirmationMethodEnum confirmationMethod;
        private final ExecutionVenueTypeEnum executionVenueType;
        private final Boolean intragroup;
        private final Boolean affiliated;
        private final Boolean largeSizeTrade;
        private final Boolean sefOrDcmAnonymousIndicator;
        private final ZonedDateTime originalExecutionTimestamp;
        private final Boolean cryptoBased;
        private final PriceSchedule underlyingAssetLastAvailableSpotPrice;
        private final List<? extends ReportablePriceSource> underlyingAssetPriceSource;
        private final ReportableActionEnum reportableAction;
        private final PositionIdentifier subsequentPositionUTI;
        private final PositionIdentifier counterpartyPositionPriorUTI;
        private final CustomBasket customBasket;
        private final Date finalContractualSettlementDate;
        private final EnrichmentData enrichment;

        protected ReportableInformationBaseImpl(ReportableInformationBaseBuilder builder) {
            this.confirmationMethod = builder.getConfirmationMethod();
            this.executionVenueType = builder.getExecutionVenueType();
            this.intragroup = builder.getIntragroup();
            this.affiliated = builder.getAffiliated();
            this.largeSizeTrade = builder.getLargeSizeTrade();
            this.sefOrDcmAnonymousIndicator = builder.getSefOrDcmAnonymousIndicator();
            this.originalExecutionTimestamp = builder.getOriginalExecutionTimestamp();
            this.cryptoBased = builder.getCryptoBased();
            this.underlyingAssetLastAvailableSpotPrice = Optional.ofNullable(builder.getUnderlyingAssetLastAvailableSpotPrice()).map(f -> f.build()).orElse(null);
            this.underlyingAssetPriceSource = Optional.ofNullable(builder.getUnderlyingAssetPriceSource()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.reportableAction = builder.getReportableAction();
            this.subsequentPositionUTI = Optional.ofNullable(builder.getSubsequentPositionUTI()).map(f -> f.build()).orElse(null);
            this.counterpartyPositionPriorUTI = Optional.ofNullable(builder.getCounterpartyPositionPriorUTI()).map(f -> f.build()).orElse(null);
            this.customBasket = Optional.ofNullable(builder.getCustomBasket()).map(f -> f.build()).orElse(null);
            this.finalContractualSettlementDate = builder.getFinalContractualSettlementDate();
            this.enrichment = Optional.ofNullable(builder.getEnrichment()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="confirmationMethod")
        @RuneAttribute(value="confirmationMethod")
        public ConfirmationMethodEnum getConfirmationMethod() {
            return this.confirmationMethod;
        }

        @Override
        @RosettaAttribute(value="executionVenueType", isRequired=true)
        @RuneAttribute(value="executionVenueType", isRequired=true)
        public ExecutionVenueTypeEnum getExecutionVenueType() {
            return this.executionVenueType;
        }

        @Override
        @RosettaAttribute(value="intragroup")
        @RuneAttribute(value="intragroup")
        public Boolean getIntragroup() {
            return this.intragroup;
        }

        @Override
        @RosettaAttribute(value="affiliated")
        @RuneAttribute(value="affiliated")
        public Boolean getAffiliated() {
            return this.affiliated;
        }

        @Override
        @RosettaAttribute(value="largeSizeTrade")
        @RuneAttribute(value="largeSizeTrade")
        public Boolean getLargeSizeTrade() {
            return this.largeSizeTrade;
        }

        @Override
        @RosettaAttribute(value="sefOrDcmAnonymousIndicator")
        @RuneAttribute(value="sefOrDcmAnonymousIndicator")
        public Boolean getSefOrDcmAnonymousIndicator() {
            return this.sefOrDcmAnonymousIndicator;
        }

        @Override
        @RosettaAttribute(value="originalExecutionTimestamp")
        @RuneAttribute(value="originalExecutionTimestamp")
        public ZonedDateTime getOriginalExecutionTimestamp() {
            return this.originalExecutionTimestamp;
        }

        @Override
        @RosettaAttribute(value="cryptoBased")
        @RuneAttribute(value="cryptoBased")
        public Boolean getCryptoBased() {
            return this.cryptoBased;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetLastAvailableSpotPrice")
        @RuneAttribute(value="underlyingAssetLastAvailableSpotPrice")
        public PriceSchedule getUnderlyingAssetLastAvailableSpotPrice() {
            return this.underlyingAssetLastAvailableSpotPrice;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public List<? extends ReportablePriceSource> getUnderlyingAssetPriceSource() {
            return this.underlyingAssetPriceSource;
        }

        @Override
        @RosettaAttribute(value="reportableAction")
        @RuneAttribute(value="reportableAction")
        public ReportableActionEnum getReportableAction() {
            return this.reportableAction;
        }

        @Override
        @RosettaAttribute(value="subsequentPositionUTI")
        @RuneAttribute(value="subsequentPositionUTI")
        public PositionIdentifier getSubsequentPositionUTI() {
            return this.subsequentPositionUTI;
        }

        @Override
        @RosettaAttribute(value="counterpartyPositionPriorUTI")
        @RuneAttribute(value="counterpartyPositionPriorUTI")
        public PositionIdentifier getCounterpartyPositionPriorUTI() {
            return this.counterpartyPositionPriorUTI;
        }

        @Override
        @RosettaAttribute(value="customBasket")
        @RuneAttribute(value="customBasket")
        public CustomBasket getCustomBasket() {
            return this.customBasket;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public Date getFinalContractualSettlementDate() {
            return this.finalContractualSettlementDate;
        }

        @Override
        @RosettaAttribute(value="enrichment")
        @RuneAttribute(value="enrichment")
        public EnrichmentData getEnrichment() {
            return this.enrichment;
        }

        @Override
        public ReportableInformationBase build() {
            return this;
        }

        @Override
        public ReportableInformationBaseBuilder toBuilder() {
            ReportableInformationBaseBuilder builder = ReportableInformationBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReportableInformationBaseBuilder builder) {
            Optional.ofNullable(this.getConfirmationMethod()).ifPresent(builder::setConfirmationMethod);
            Optional.ofNullable(this.getExecutionVenueType()).ifPresent(builder::setExecutionVenueType);
            Optional.ofNullable(this.getIntragroup()).ifPresent(builder::setIntragroup);
            Optional.ofNullable(this.getAffiliated()).ifPresent(builder::setAffiliated);
            Optional.ofNullable(this.getLargeSizeTrade()).ifPresent(builder::setLargeSizeTrade);
            Optional.ofNullable(this.getSefOrDcmAnonymousIndicator()).ifPresent(builder::setSefOrDcmAnonymousIndicator);
            Optional.ofNullable(this.getOriginalExecutionTimestamp()).ifPresent(builder::setOriginalExecutionTimestamp);
            Optional.ofNullable(this.getCryptoBased()).ifPresent(builder::setCryptoBased);
            Optional.ofNullable(this.getUnderlyingAssetLastAvailableSpotPrice()).ifPresent(builder::setUnderlyingAssetLastAvailableSpotPrice);
            Optional.ofNullable(this.getUnderlyingAssetPriceSource()).ifPresent(builder::setUnderlyingAssetPriceSource);
            Optional.ofNullable(this.getReportableAction()).ifPresent(builder::setReportableAction);
            Optional.ofNullable(this.getSubsequentPositionUTI()).ifPresent(builder::setSubsequentPositionUTI);
            Optional.ofNullable(this.getCounterpartyPositionPriorUTI()).ifPresent(builder::setCounterpartyPositionPriorUTI);
            Optional.ofNullable(this.getCustomBasket()).ifPresent(builder::setCustomBasket);
            Optional.ofNullable(this.getFinalContractualSettlementDate()).ifPresent(builder::setFinalContractualSettlementDate);
            Optional.ofNullable(this.getEnrichment()).ifPresent(builder::setEnrichment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReportableInformationBase _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.confirmationMethod, (Object)_that.getConfirmationMethod())) {
                return false;
            }
            if (!Objects.equals((Object)this.executionVenueType, (Object)_that.getExecutionVenueType())) {
                return false;
            }
            if (!Objects.equals(this.intragroup, _that.getIntragroup())) {
                return false;
            }
            if (!Objects.equals(this.affiliated, _that.getAffiliated())) {
                return false;
            }
            if (!Objects.equals(this.largeSizeTrade, _that.getLargeSizeTrade())) {
                return false;
            }
            if (!Objects.equals(this.sefOrDcmAnonymousIndicator, _that.getSefOrDcmAnonymousIndicator())) {
                return false;
            }
            if (!Objects.equals(this.originalExecutionTimestamp, _that.getOriginalExecutionTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.cryptoBased, _that.getCryptoBased())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetLastAvailableSpotPrice, _that.getUnderlyingAssetLastAvailableSpotPrice())) {
                return false;
            }
            if (!ListEquals.listEquals(this.underlyingAssetPriceSource, _that.getUnderlyingAssetPriceSource())) {
                return false;
            }
            if (!Objects.equals((Object)this.reportableAction, (Object)_that.getReportableAction())) {
                return false;
            }
            if (!Objects.equals(this.subsequentPositionUTI, _that.getSubsequentPositionUTI())) {
                return false;
            }
            if (!Objects.equals(this.counterpartyPositionPriorUTI, _that.getCounterpartyPositionPriorUTI())) {
                return false;
            }
            if (!Objects.equals(this.customBasket, _that.getCustomBasket())) {
                return false;
            }
            if (!Objects.equals(this.finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) {
                return false;
            }
            return Objects.equals(this.enrichment, _that.getEnrichment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.confirmationMethod != null ? ((Object)((Object)this.confirmationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.executionVenueType != null ? ((Object)((Object)this.executionVenueType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.intragroup != null ? this.intragroup.hashCode() : 0);
            _result = 31 * _result + (this.affiliated != null ? this.affiliated.hashCode() : 0);
            _result = 31 * _result + (this.largeSizeTrade != null ? this.largeSizeTrade.hashCode() : 0);
            _result = 31 * _result + (this.sefOrDcmAnonymousIndicator != null ? this.sefOrDcmAnonymousIndicator.hashCode() : 0);
            _result = 31 * _result + (this.originalExecutionTimestamp != null ? this.originalExecutionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.cryptoBased != null ? this.cryptoBased.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetLastAvailableSpotPrice != null ? this.underlyingAssetLastAvailableSpotPrice.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetPriceSource != null ? this.underlyingAssetPriceSource.hashCode() : 0);
            _result = 31 * _result + (this.reportableAction != null ? ((Object)((Object)this.reportableAction)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.subsequentPositionUTI != null ? this.subsequentPositionUTI.hashCode() : 0);
            _result = 31 * _result + (this.counterpartyPositionPriorUTI != null ? this.counterpartyPositionPriorUTI.hashCode() : 0);
            _result = 31 * _result + (this.customBasket != null ? this.customBasket.hashCode() : 0);
            _result = 31 * _result + (this.finalContractualSettlementDate != null ? this.finalContractualSettlementDate.hashCode() : 0);
            _result = 31 * _result + (this.enrichment != null ? this.enrichment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReportableInformationBase {confirmationMethod=" + String.valueOf((Object)this.confirmationMethod) + ", executionVenueType=" + String.valueOf((Object)this.executionVenueType) + ", intragroup=" + this.intragroup + ", affiliated=" + this.affiliated + ", largeSizeTrade=" + this.largeSizeTrade + ", sefOrDcmAnonymousIndicator=" + this.sefOrDcmAnonymousIndicator + ", originalExecutionTimestamp=" + String.valueOf(this.originalExecutionTimestamp) + ", cryptoBased=" + this.cryptoBased + ", underlyingAssetLastAvailableSpotPrice=" + String.valueOf(this.underlyingAssetLastAvailableSpotPrice) + ", underlyingAssetPriceSource=" + String.valueOf(this.underlyingAssetPriceSource) + ", reportableAction=" + String.valueOf((Object)this.reportableAction) + ", subsequentPositionUTI=" + String.valueOf(this.subsequentPositionUTI) + ", counterpartyPositionPriorUTI=" + String.valueOf(this.counterpartyPositionPriorUTI) + ", customBasket=" + String.valueOf(this.customBasket) + ", finalContractualSettlementDate=" + String.valueOf(this.finalContractualSettlementDate) + ", enrichment=" + String.valueOf(this.enrichment) + "}";
        }
    }
}

