/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.basket.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetQuantityForConstituentDefault.class)
public abstract class GetQuantityForConstituent
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public NonNegativeQuantitySchedule evaluate(String identifier, List<? extends TradeLot> tradeLots) {
        NonNegativeQuantitySchedule result;
        NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder resultBuilder = this.doEvaluate(identifier, tradeLots);
        if (resultBuilder == null) {
            result = null;
        } else {
            result = resultBuilder.build();
            this.objectValidator.validate(NonNegativeQuantitySchedule.class, (RosettaModelObject)result);
        }
        return result;
    }

    protected abstract NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(String var1, List<? extends TradeLot> var2);

    public static class GetQuantityForConstituentDefault
    extends GetQuantityForConstituent {
        @Override
        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(String identifier, List<? extends TradeLot> tradeLots) {
            if (tradeLots == null) {
                tradeLots = Collections.emptyList();
            }
            NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder result = NonNegativeQuantitySchedule.builder();
            return this.assignOutput(result, identifier, tradeLots);
        }

        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder assignOutput(NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder result, String identifier, List<? extends TradeLot> tradeLots) {
            MapperC thenArg0 = MapperC.of(tradeLots).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getObservable", priceQuantity -> priceQuantity.getObservable()).mapC("getProductIdentifier", observable -> observable.getProductIdentifier()).map("Type coercion", fieldWithMetaProductIdentifier -> fieldWithMetaProductIdentifier.getValue()).map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()), (Mapper)MapperS.of((Object)identifier), (CardinalityOperator)CardinalityOperator.Any).get());
            MapperListOfLists thenArg1 = thenArg0.mapItemToList(item -> item.mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()));
            FieldWithMetaNonNegativeQuantitySchedule fieldWithMetaNonNegativeQuantitySchedule = (FieldWithMetaNonNegativeQuantitySchedule)MapperS.of((Object)((FieldWithMetaNonNegativeQuantitySchedule)thenArg1.flattenList().get())).get();
            result = fieldWithMetaNonNegativeQuantitySchedule == null ? null : (NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder)this.toBuilder((RosettaModelObject)fieldWithMetaNonNegativeQuantitySchedule.getValue());
            return Optional.ofNullable(result).map(o -> o.prune()).orElse(null);
        }
    }
}

