/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.price.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.functions.NotationFromPrice;
import drr.standards.iso.functions.ConvertNonISOToISOCurrency;
import javax.inject.Inject;

@ImplementedBy(value=CurrencyPairOrCurrencyFromPriceDefault.class)
public abstract class CurrencyPairOrCurrencyFromPrice
implements RosettaFunction {
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected NotationFromPrice notationFromPrice;

    public String evaluate(PriceSchedule price, Boolean defaultSingleCurrency) {
        String currency = this.doEvaluate(price, defaultSingleCurrency);
        return currency;
    }

    protected abstract String doEvaluate(PriceSchedule var1, Boolean var2);

    public static class CurrencyPairOrCurrencyFromPriceDefault
    extends CurrencyPairOrCurrencyFromPrice {
        @Override
        protected String doEvaluate(PriceSchedule price, Boolean defaultSingleCurrency) {
            String currency = null;
            return this.assignOutput(currency, price, defaultSingleCurrency);
        }

        protected String assignOutput(String currency, PriceSchedule price, Boolean defaultSingleCurrency) {
            MapperS thenArg0 = MapperS.of((Object)price);
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)this.notationFromPrice.evaluate((PriceSchedule)item.get()))), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)price);
                }
                return MapperS.ofNull();
            });
            currency = (String)thenArg1.mapSingleToItem(item -> {
                if (ExpressionOperators.areEqual((Mapper)item.map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)PriceTypeEnum.EXCHANGE_RATE), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.exists((Mapper)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getCurrency", unitType -> unitType.getCurrency()))).and(ExpressionOperators.exists((Mapper)item.map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    FieldWithMetaString fieldWithMetaString0 = (FieldWithMetaString)item.map("getPerUnitOf", priceSchedule -> priceSchedule.getPerUnitOf()).map("getCurrency", unitType -> unitType.getCurrency()).get();
                    FieldWithMetaString fieldWithMetaString1 = (FieldWithMetaString)item.map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get();
                    return MapperMaths.add((Mapper)MapperMaths.add((Mapper)MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue())).map("to-string", ISOCurrencyCodeEnum::toDisplayString), (Mapper)MapperS.of((Object)"/")), (Mapper)MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue())).map("to-string", ISOCurrencyCodeEnum::toDisplayString));
                }
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)defaultSingleCurrency), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    FieldWithMetaString fieldWithMetaString2 = (FieldWithMetaString)item.map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get();
                    return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString2 == null ? null : fieldWithMetaString2.getValue())).map("to-string", ISOCurrencyCodeEnum::toDisplayString);
                }
                return MapperS.ofNull();
            }).get();
            return currency;
        }
    }
}

