/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.price.functions;

import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.EconomicTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.SchedulePeriod;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForEvent;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CurrentSchedulePeriodDefault.class)
public abstract class CurrentSchedulePeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected Qualify_Commodity_Forward qualify_Commodity_Forward;
    @Inject
    protected Qualify_Commodity_Option qualify_Commodity_Option;
    @Inject
    protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
    @Inject
    protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
    @Inject
    protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;

    public SchedulePeriod evaluate(ReportableEventBase reportableEvent) {
        SchedulePeriod schedulePeriod;
        SchedulePeriod.SchedulePeriodBuilder schedulePeriodBuilder = this.doEvaluate(reportableEvent);
        if (schedulePeriodBuilder == null) {
            schedulePeriod = null;
        } else {
            schedulePeriod = schedulePeriodBuilder.build();
            this.objectValidator.validate(SchedulePeriod.class, (RosettaModelObject)schedulePeriod);
        }
        return schedulePeriod;
    }

    protected abstract SchedulePeriod.SchedulePeriodBuilder doEvaluate(ReportableEventBase var1);

    protected abstract MapperS<Date> eventDate(ReportableEventBase var1);

    protected abstract MapperS<? extends EconomicTerms> product(ReportableEventBase var1);

    protected abstract MapperS<? extends CalculationSchedule> schedule(ReportableEventBase var1);

    public static class CurrentSchedulePeriodDefault
    extends CurrentSchedulePeriod {
        @Override
        protected SchedulePeriod.SchedulePeriodBuilder doEvaluate(ReportableEventBase reportableEvent) {
            SchedulePeriod.SchedulePeriodBuilder schedulePeriod = SchedulePeriod.builder();
            return this.assignOutput(schedulePeriod, reportableEvent);
        }

        protected SchedulePeriod.SchedulePeriodBuilder assignOutput(SchedulePeriod.SchedulePeriodBuilder schedulePeriod, ReportableEventBase reportableEvent) {
            if (ExpressionOperators.lessThanEquals(this.eventDate(reportableEvent), (Mapper)this.schedule(reportableEvent).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()).min(), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                schedulePeriod = (SchedulePeriod.SchedulePeriodBuilder)this.toBuilder((RosettaModelObject)this.schedule(reportableEvent).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).min(item -> item.map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate())).get());
            } else if (ExpressionOperators.greaterThanEquals(this.eventDate(reportableEvent), (Mapper)this.schedule(reportableEvent).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).map("getEndDate", dateRange -> dateRange.getEndDate()).max(), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                schedulePeriod = (SchedulePeriod.SchedulePeriodBuilder)this.toBuilder((RosettaModelObject)this.schedule(reportableEvent).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).max(item -> item.map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate())).get());
            } else {
                MapperC thenArg0 = this.schedule(reportableEvent).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod());
                MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperators.lessThanEquals((Mapper)item.map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()), this.eventDate(reportableEvent), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.greaterThanEquals((Mapper)item.map("getCalculationPeriod", _schedulePeriod -> _schedulePeriod.getCalculationPeriod()).map("getEndDate", dateRange -> dateRange.getEndDate()), this.eventDate(reportableEvent), (CardinalityOperator)CardinalityOperator.All)).get());
                schedulePeriod = (SchedulePeriod.SchedulePeriodBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((SchedulePeriod)thenArg1.get())).get());
            }
            return Optional.ofNullable(schedulePeriod).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<Date> eventDate(ReportableEventBase reportableEvent) {
            return MapperS.of((Object)reportableEvent).map("getOriginatingWorkflowStep", reportableEventBase -> reportableEventBase.getOriginatingWorkflowStep()).map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).map("getEventDate", businessEvent -> businessEvent.getEventDate());
        }

        @Override
        protected MapperS<? extends EconomicTerms> product(ReportableEventBase reportableEvent) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(this.productForEvent.evaluate(reportableEvent)));
        }

        @Override
        protected MapperS<? extends CalculationSchedule> schedule(ReportableEventBase reportableEvent) {
            if (ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_FixedFloat.evaluate((EconomicTerms)this.product(reportableEvent).get()))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_Basis.evaluate((EconomicTerms)this.product(reportableEvent).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.product(reportableEvent).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getSchedule", commodityPayout -> commodityPayout.getSchedule()).first();
            }
            if (ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Option.evaluate((EconomicTerms)this.product(reportableEvent).get()))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Swaption.evaluate((EconomicTerms)this.product(reportableEvent).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((OptionPayout)this.product(reportableEvent).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getSchedule", optionPayout -> optionPayout.getSchedule());
            }
            Boolean _boolean = this.qualify_Commodity_Forward.evaluate((EconomicTerms)this.product(reportableEvent).get());
            if (_boolean != null && _boolean.booleanValue()) {
                return MapperS.of((Object)((ForwardPayout)this.product(reportableEvent).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getSchedule", forwardPayout -> forwardPayout.getSchedule());
            }
            return MapperS.ofNull();
        }
    }
}

