/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.quantity.functions;

import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.base.qualification.event.functions.IsActionTypeTERM;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.BeforeTradeForEvent;
import drr.base.trade.functions.TradeForEvent;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetTradeForQuantityDefault.class)
public abstract class GetTradeForQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected BeforeTradeForEvent beforeTradeForEvent;
    @Inject
    protected IsActionTypeTERM isActionTypeTERM;
    @Inject
    protected TradeForEvent tradeForEvent;

    public Trade evaluate(ReportableEventBase reportableEvent) {
        Trade trade;
        Trade.TradeBuilder tradeBuilder = this.doEvaluate(reportableEvent);
        if (tradeBuilder == null) {
            trade = null;
        } else {
            trade = tradeBuilder.build();
            this.objectValidator.validate(Trade.class, (RosettaModelObject)trade);
        }
        return trade;
    }

    protected abstract Trade.TradeBuilder doEvaluate(ReportableEventBase var1);

    public static class GetTradeForQuantityDefault
    extends GetTradeForQuantity {
        @Override
        protected Trade.TradeBuilder doEvaluate(ReportableEventBase reportableEvent) {
            Trade.TradeBuilder trade = Trade.builder();
            return this.assignOutput(trade, reportableEvent);
        }

        protected Trade.TradeBuilder assignOutput(Trade.TradeBuilder trade, ReportableEventBase reportableEvent) {
            Boolean _boolean = this.isActionTypeTERM.evaluate(reportableEvent);
            trade = _boolean != null && _boolean != false ? (Trade.TradeBuilder)this.toBuilder((RosettaModelObject)this.beforeTradeForEvent.evaluate(reportableEvent)) : (Trade.TradeBuilder)this.toBuilder((RosettaModelObject)this.tradeForEvent.evaluate(reportableEvent));
            return Optional.ofNullable(trade).map(o -> o.prune()).orElse(null);
        }
    }
}

