/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.base.trade.ReportablePriceSource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ReportablePriceSourceChoice")
@ImplementedBy(value=Default.class)
public interface ReportablePriceSourceChoice
extends Validator<ReportablePriceSource> {
    public static final String NAME = "ReportablePriceSourceChoice";
    public static final String DEFINITION = "required choice productIdentifier, otherId";

    public static class NoOp
    implements ReportablePriceSourceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportablePriceSource reportablePriceSource) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ReportablePriceSourceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ReportablePriceSource reportablePriceSource) {
            ComparisonResult result = this.executeDataRule(reportablePriceSource);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ReportablePriceSourceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReportablePriceSource", (RosettaPath)path, (String)ReportablePriceSourceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ReportablePriceSourceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ReportablePriceSource", (RosettaPath)path, (String)ReportablePriceSourceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ReportablePriceSource reportablePriceSource) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)reportablePriceSource), Arrays.asList("productIdentifier", "otherId"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

