/*
 * Decompiled with CFR 0.152.
 */
package drr.base.util.party.functions;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.base.staticdata.party.RelatedParty;
import cdm.base.staticdata.party.functions.FilterRelatedPartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ExtractPartyFromRelatedPartyByRoleDefault.class)
public abstract class ExtractPartyFromRelatedPartyByRole
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected FilterRelatedPartyByRole filterRelatedPartyByRole;

    public Party evaluate(List<? extends RelatedParty> relatedParties, PartyRoleEnum partyRole) {
        Party party;
        Party.PartyBuilder partyBuilder = this.doEvaluate(relatedParties, partyRole);
        if (partyBuilder == null) {
            party = null;
        } else {
            party = partyBuilder.build();
            this.objectValidator.validate(Party.class, (RosettaModelObject)party);
        }
        return party;
    }

    protected abstract Party.PartyBuilder doEvaluate(List<? extends RelatedParty> var1, PartyRoleEnum var2);

    public static class ExtractPartyFromRelatedPartyByRoleDefault
    extends ExtractPartyFromRelatedPartyByRole {
        @Override
        protected Party.PartyBuilder doEvaluate(List<? extends RelatedParty> relatedParties, PartyRoleEnum partyRole) {
            if (relatedParties == null) {
                relatedParties = Collections.emptyList();
            }
            Party.PartyBuilder party = Party.builder();
            return this.assignOutput(party, relatedParties, partyRole);
        }

        protected Party.PartyBuilder assignOutput(Party.PartyBuilder party, List<? extends RelatedParty> relatedParties, PartyRoleEnum partyRole) {
            ReferenceWithMetaParty referenceWithMetaParty = (ReferenceWithMetaParty)ExpressionOperators.distinct((Mapper)MapperC.of((List)this.filterRelatedPartyByRole.evaluate(relatedParties, partyRole)).map("getPartyReference", relatedParty -> relatedParty.getPartyReference())).get();
            party = referenceWithMetaParty == null ? null : (Party.PartyBuilder)this.toBuilder((RosettaModelObject)referenceWithMetaParty.getValue());
            return Optional.ofNullable(party).map(o -> o.prune()).orElse(null);
        }
    }
}

