/*
 * Decompiled with CFR 0.152.
 */
package drr.enrichment.common;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.enrichment.common.meta.EnrichmentDataMeta;
import drr.enrichment.lei.LeiData;
import drr.enrichment.upi.UpiData;
import drr.standards.iso.MicData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="EnrichmentData", builder=EnrichmentDataBuilderImpl.class, version="7.0.0-dev.73")
@RuneDataType(value="EnrichmentData", model="drr", builder=EnrichmentDataBuilderImpl.class, version="7.0.0-dev.73")
public interface EnrichmentData
extends RosettaModelObject {
    public static final EnrichmentDataMeta metaData = new EnrichmentDataMeta();

    public List<? extends MicData> getMicData();

    public List<? extends LeiData> getLeiData();

    public List<? extends UpiData> getUpiData();

    public EnrichmentData build();

    public EnrichmentDataBuilder toBuilder();

    public static EnrichmentDataBuilder builder() {
        return new EnrichmentDataBuilderImpl();
    }

    default public RosettaMetaData<? extends EnrichmentData> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EnrichmentData> getType() {
        return EnrichmentData.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("micData"), processor, MicData.class, this.getMicData(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leiData"), processor, LeiData.class, this.getLeiData(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("upiData"), processor, UpiData.class, this.getUpiData(), new AttributeMeta[0]);
    }

    public static class EnrichmentDataBuilderImpl
    implements EnrichmentDataBuilder {
        protected List<MicData.MicDataBuilder> micData = new ArrayList<MicData.MicDataBuilder>();
        protected List<LeiData.LeiDataBuilder> leiData = new ArrayList<LeiData.LeiDataBuilder>();
        protected List<UpiData.UpiDataBuilder> upiData = new ArrayList<UpiData.UpiDataBuilder>();

        @Override
        @RosettaAttribute(value="micData")
        @RuneAttribute(value="micData")
        public List<? extends MicData.MicDataBuilder> getMicData() {
            return this.micData;
        }

        @Override
        public MicData.MicDataBuilder getOrCreateMicData(int index) {
            if (this.micData == null) {
                this.micData = new ArrayList<MicData.MicDataBuilder>();
            }
            return (MicData.MicDataBuilder)this.getIndex(this.micData, index, () -> {
                MicData.MicDataBuilder newMicData = MicData.builder();
                return newMicData;
            });
        }

        @Override
        @RosettaAttribute(value="leiData")
        @RuneAttribute(value="leiData")
        public List<? extends LeiData.LeiDataBuilder> getLeiData() {
            return this.leiData;
        }

        @Override
        public LeiData.LeiDataBuilder getOrCreateLeiData(int index) {
            if (this.leiData == null) {
                this.leiData = new ArrayList<LeiData.LeiDataBuilder>();
            }
            return (LeiData.LeiDataBuilder)this.getIndex(this.leiData, index, () -> {
                LeiData.LeiDataBuilder newLeiData = LeiData.builder();
                return newLeiData;
            });
        }

        @Override
        @RosettaAttribute(value="upiData")
        @RuneAttribute(value="upiData")
        public List<? extends UpiData.UpiDataBuilder> getUpiData() {
            return this.upiData;
        }

        @Override
        public UpiData.UpiDataBuilder getOrCreateUpiData(int index) {
            if (this.upiData == null) {
                this.upiData = new ArrayList<UpiData.UpiDataBuilder>();
            }
            return (UpiData.UpiDataBuilder)this.getIndex(this.upiData, index, () -> {
                UpiData.UpiDataBuilder newUpiData = UpiData.builder();
                return newUpiData;
            });
        }

        @Override
        @RosettaAttribute(value="micData")
        @RuneAttribute(value="micData")
        public EnrichmentDataBuilder addMicData(MicData _micData) {
            if (_micData != null) {
                this.micData.add(_micData.toBuilder());
            }
            return this;
        }

        @Override
        public EnrichmentDataBuilder addMicData(MicData _micData, int idx) {
            this.getIndex(this.micData, idx, () -> _micData.toBuilder());
            return this;
        }

        @Override
        public EnrichmentDataBuilder addMicData(List<? extends MicData> micDatas) {
            if (micDatas != null) {
                for (MicData micData : micDatas) {
                    this.micData.add(micData.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="micData")
        public EnrichmentDataBuilder setMicData(List<? extends MicData> micDatas) {
            this.micData = micDatas == null ? new ArrayList<MicData.MicDataBuilder>() : (List)micDatas.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="leiData")
        @RuneAttribute(value="leiData")
        public EnrichmentDataBuilder addLeiData(LeiData _leiData) {
            if (_leiData != null) {
                this.leiData.add(_leiData.toBuilder());
            }
            return this;
        }

        @Override
        public EnrichmentDataBuilder addLeiData(LeiData _leiData, int idx) {
            this.getIndex(this.leiData, idx, () -> _leiData.toBuilder());
            return this;
        }

        @Override
        public EnrichmentDataBuilder addLeiData(List<? extends LeiData> leiDatas) {
            if (leiDatas != null) {
                for (LeiData leiData : leiDatas) {
                    this.leiData.add(leiData.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="leiData")
        public EnrichmentDataBuilder setLeiData(List<? extends LeiData> leiDatas) {
            this.leiData = leiDatas == null ? new ArrayList<LeiData.LeiDataBuilder>() : (List)leiDatas.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="upiData")
        @RuneAttribute(value="upiData")
        public EnrichmentDataBuilder addUpiData(UpiData _upiData) {
            if (_upiData != null) {
                this.upiData.add(_upiData.toBuilder());
            }
            return this;
        }

        @Override
        public EnrichmentDataBuilder addUpiData(UpiData _upiData, int idx) {
            this.getIndex(this.upiData, idx, () -> _upiData.toBuilder());
            return this;
        }

        @Override
        public EnrichmentDataBuilder addUpiData(List<? extends UpiData> upiDatas) {
            if (upiDatas != null) {
                for (UpiData upiData : upiDatas) {
                    this.upiData.add(upiData.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="upiData")
        public EnrichmentDataBuilder setUpiData(List<? extends UpiData> upiDatas) {
            this.upiData = upiDatas == null ? new ArrayList<UpiData.UpiDataBuilder>() : (List)upiDatas.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public EnrichmentData build() {
            return new EnrichmentDataImpl(this);
        }

        @Override
        public EnrichmentDataBuilder toBuilder() {
            return this;
        }

        @Override
        public EnrichmentDataBuilder prune() {
            this.micData = this.micData.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.leiData = this.leiData.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.upiData = this.upiData.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getMicData() != null && this.getMicData().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLeiData() != null && this.getLeiData().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getUpiData() != null && this.getUpiData().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public EnrichmentDataBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EnrichmentDataBuilder o = (EnrichmentDataBuilder)other;
            merger.mergeRosetta(this.getMicData(), o.getMicData(), this::getOrCreateMicData);
            merger.mergeRosetta(this.getLeiData(), o.getLeiData(), this::getOrCreateLeiData);
            merger.mergeRosetta(this.getUpiData(), o.getUpiData(), this::getOrCreateUpiData);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EnrichmentData _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.micData, _that.getMicData())) {
                return false;
            }
            if (!ListEquals.listEquals(this.leiData, _that.getLeiData())) {
                return false;
            }
            return ListEquals.listEquals(this.upiData, _that.getUpiData());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.micData != null ? this.micData.hashCode() : 0);
            _result = 31 * _result + (this.leiData != null ? this.leiData.hashCode() : 0);
            _result = 31 * _result + (this.upiData != null ? this.upiData.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EnrichmentDataBuilder {micData=" + String.valueOf(this.micData) + ", leiData=" + String.valueOf(this.leiData) + ", upiData=" + String.valueOf(this.upiData) + "}";
        }
    }

    public static interface EnrichmentDataBuilder
    extends EnrichmentData,
    RosettaModelObjectBuilder {
        public MicData.MicDataBuilder getOrCreateMicData(int var1);

        public List<? extends MicData.MicDataBuilder> getMicData();

        public LeiData.LeiDataBuilder getOrCreateLeiData(int var1);

        public List<? extends LeiData.LeiDataBuilder> getLeiData();

        public UpiData.UpiDataBuilder getOrCreateUpiData(int var1);

        public List<? extends UpiData.UpiDataBuilder> getUpiData();

        public EnrichmentDataBuilder addMicData(MicData var1);

        public EnrichmentDataBuilder addMicData(MicData var1, int var2);

        public EnrichmentDataBuilder addMicData(List<? extends MicData> var1);

        public EnrichmentDataBuilder setMicData(List<? extends MicData> var1);

        public EnrichmentDataBuilder addLeiData(LeiData var1);

        public EnrichmentDataBuilder addLeiData(LeiData var1, int var2);

        public EnrichmentDataBuilder addLeiData(List<? extends LeiData> var1);

        public EnrichmentDataBuilder setLeiData(List<? extends LeiData> var1);

        public EnrichmentDataBuilder addUpiData(UpiData var1);

        public EnrichmentDataBuilder addUpiData(UpiData var1, int var2);

        public EnrichmentDataBuilder addUpiData(List<? extends UpiData> var1);

        public EnrichmentDataBuilder setUpiData(List<? extends UpiData> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("micData"), processor, MicData.MicDataBuilder.class, this.getMicData(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leiData"), processor, LeiData.LeiDataBuilder.class, this.getLeiData(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("upiData"), processor, UpiData.UpiDataBuilder.class, this.getUpiData(), new AttributeMeta[0]);
        }

        public EnrichmentDataBuilder prune();
    }

    public static class EnrichmentDataImpl
    implements EnrichmentData {
        private final List<? extends MicData> micData;
        private final List<? extends LeiData> leiData;
        private final List<? extends UpiData> upiData;

        protected EnrichmentDataImpl(EnrichmentDataBuilder builder) {
            this.micData = Optional.ofNullable(builder.getMicData()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.leiData = Optional.ofNullable(builder.getLeiData()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.upiData = Optional.ofNullable(builder.getUpiData()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="micData")
        @RuneAttribute(value="micData")
        public List<? extends MicData> getMicData() {
            return this.micData;
        }

        @Override
        @RosettaAttribute(value="leiData")
        @RuneAttribute(value="leiData")
        public List<? extends LeiData> getLeiData() {
            return this.leiData;
        }

        @Override
        @RosettaAttribute(value="upiData")
        @RuneAttribute(value="upiData")
        public List<? extends UpiData> getUpiData() {
            return this.upiData;
        }

        @Override
        public EnrichmentData build() {
            return this;
        }

        @Override
        public EnrichmentDataBuilder toBuilder() {
            EnrichmentDataBuilder builder = EnrichmentData.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EnrichmentDataBuilder builder) {
            Optional.ofNullable(this.getMicData()).ifPresent(builder::setMicData);
            Optional.ofNullable(this.getLeiData()).ifPresent(builder::setLeiData);
            Optional.ofNullable(this.getUpiData()).ifPresent(builder::setUpiData);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EnrichmentData _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.micData, _that.getMicData())) {
                return false;
            }
            if (!ListEquals.listEquals(this.leiData, _that.getLeiData())) {
                return false;
            }
            return ListEquals.listEquals(this.upiData, _that.getUpiData());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.micData != null ? this.micData.hashCode() : 0);
            _result = 31 * _result + (this.leiData != null ? this.leiData.hashCode() : 0);
            _result = 31 * _result + (this.upiData != null ? this.upiData.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EnrichmentData {micData=" + String.valueOf(this.micData) + ", leiData=" + String.valueOf(this.leiData) + ", upiData=" + String.valueOf(this.upiData) + "}";
        }
    }
}

