/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.esma.emir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;

@ImplementedBy(value=GetSttlmDtDefault.class)
public abstract class GetSttlmDt
implements RosettaFunction {
    public Date evaluate(ESMAEMIRTransactionReport drrReport) {
        Date sttlmDt = this.doEvaluate(drrReport);
        return sttlmDt;
    }

    protected abstract Date doEvaluate(ESMAEMIRTransactionReport var1);

    public static class GetSttlmDtDefault
    extends GetSttlmDt {
        @Override
        protected Date doEvaluate(ESMAEMIRTransactionReport drrReport) {
            Date sttlmDt = null;
            return this.assignOutput(sttlmDt, drrReport);
        }

        protected Date assignOutput(Date sttlmDt, ESMAEMIRTransactionReport drrReport) {
            sttlmDt = (Date)MapperS.of((Object)drrReport).map("getFinalContractualSettlementDate", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getFinalContractualSettlementDate()).get();
            return sttlmDt;
        }
    }
}

