/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.quantity.NotionalPeriod;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.reports.PayoutLeg1Rule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalQuantityScheduleRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=NotionalQuantityScheduleLeg1RuleDefault.class)
public abstract class NotionalQuantityScheduleLeg1Rule
implements ReportFunction<TransactionReportInstruction, List<? extends NotionalPeriod>> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected IsAllowableActionForASIC isAllowableActionForASIC;
    @Inject
    protected NotionalQuantityScheduleRule notionalQuantityScheduleRule;
    @Inject
    protected PayoutLeg1Rule payoutLeg1Rule;

    public List<? extends NotionalPeriod> evaluate(TransactionReportInstruction input) {
        List output;
        List<NotionalPeriod.NotionalPeriodBuilder> outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.stream().map(NotionalPeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(NotionalPeriod.class, output);
        }
        return output;
    }

    protected abstract List<NotionalPeriod.NotionalPeriodBuilder> doEvaluate(TransactionReportInstruction var1);

    public static class NotionalQuantityScheduleLeg1RuleDefault
    extends NotionalQuantityScheduleLeg1Rule {
        @Override
        protected List<NotionalPeriod.NotionalPeriodBuilder> doEvaluate(TransactionReportInstruction input) {
            ArrayList<NotionalPeriod.NotionalPeriodBuilder> output = new ArrayList<NotionalPeriod.NotionalPeriodBuilder>();
            return this.assignOutput(output, input);
        }

        protected List<NotionalPeriod.NotionalPeriodBuilder> assignOutput(List<NotionalPeriod.NotionalPeriodBuilder> output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForASIC.evaluate((ReportableEventBase)item.get()));
            output = this.toBuilder(MapperC.of(this.notionalQuantityScheduleRule.evaluate(this.payoutLeg1Rule.evaluate((ReportableEventBase)thenArg.get()))).getMulti());
            return Optional.ofNullable(output).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

