/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.dtcc;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.cftc.rewrite.dtcc.meta.DTCCAdditionalFieldsMeta;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.dtcc.CommonDTCCAdditionalFields;
import drr.regulation.common.dtcc.ProductGradeReport;
import drr.standards.iso.OptionStyleEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="DTCCAdditionalFields", builder=DTCCAdditionalFieldsBuilderImpl.class, version="7.0.0-dev.73")
@RuneDataType(value="DTCCAdditionalFields", model="drr", builder=DTCCAdditionalFieldsBuilderImpl.class, version="7.0.0-dev.73")
public interface DTCCAdditionalFields
extends CommonDTCCAdditionalFields {
    public static final DTCCAdditionalFieldsMeta metaData = new DTCCAdditionalFieldsMeta();

    public String getTradeParty1IDType();

    public String getMessageID();

    public String getLeg1CommodityUnderlyerID();

    public String getLeg2CommodityUnderlyerID();

    public BigDecimal getChangeInNotionalAmount1();

    public BigDecimal getChangeInNotionalAmount2();

    public Boolean getLargeNotionalOffFacilitySwapElectionIndicator();

    public Boolean getMandatoryClearingIndicator();

    public String getMessageType();

    public PartyIdentifierTypeEnum getOriginalSwapSDRIDType();

    public Boolean getPhysicalCommodityContractIndicator();

    public Boolean getSdMspIndicatorCounterparty1();

    public Boolean getSdMspIndicatorCounterparty2();

    public Boolean getSefOrDcmIndicator();

    public String getVersion();

    @Override
    public DTCCAdditionalFields build();

    @Override
    public DTCCAdditionalFieldsBuilder toBuilder();

    public static DTCCAdditionalFieldsBuilder builder() {
        return new DTCCAdditionalFieldsBuilderImpl();
    }

    default public RosettaMetaData<? extends DTCCAdditionalFields> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DTCCAdditionalFields> getType() {
        return DTCCAdditionalFields.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("clearingVenueIDType"), PartyIdentifierTypeEnum.class, (Object)this.getClearingVenueIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ClearingBrokerIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1ClearingBrokerIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, (Object)this.getSubmittingPartyIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submittedForParty"), String.class, (Object)this.getSubmittedForParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeLegTypes"), String.class, (Object)this.getTradeLegTypes(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty1ReportingDestination(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty2ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty2ReportingDestination(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("primaryAssetClass"), AssetClassEnum.class, (Object)this.getPrimaryAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("secondaryAssetClass"), AssetClassEnum.class, (Object)this.getSecondaryAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment1"), String.class, (Object)this.getComment1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), String.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("productID"), String.class, (Object)this.getProductID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentID"), String.class, (Object)this.getTradeParty2ExecutionAgentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty2ExecutionAgentIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentID"), String.class, (Object)this.getTradeParty1ExecutionAgentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1ExecutionAgentIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1TransactionID"), String.class, (Object)this.getTradeParty1TransactionID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementType"), String.class, (Object)this.getSettlementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productGrade"), processor, ProductGradeReport.class, this.getProductGrade(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryLocation"), String.class, (Object)this.getDeliveryLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("leg1CommodityInstrumentID"), String.class, (Object)this.getLeg1CommodityInstrumentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("leg2CommodityInstrumentID"), String.class, (Object)this.getLeg2CommodityInstrumentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("responsibleDataSubmitterIDType"), PartyIdentifierTypeEnum.class, (Object)this.getResponsibleDataSubmitterIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("responsibleDataSubmitterID"), String.class, (Object)this.getResponsibleDataSubmitterID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateActionNewTradeParty1Lei"), String.class, (Object)this.getCorporateActionNewTradeParty1Lei(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("otherPaymentPayerIDType"), String.class, this.getOtherPaymentPayerIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("otherPaymentReceiverIDType"), String.class, this.getOtherPaymentReceiverIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sefOrDcmAnonymousExecutionIndicator"), Boolean.class, (Object)this.getSefOrDcmAnonymousExecutionIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionVenueID"), String.class, (Object)this.getExecutionVenueID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionVenueIDType"), PartyIdentifierTypeEnum.class, (Object)this.getExecutionVenueIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("leg1FloatingRateIndex"), String.class, (Object)this.getLeg1FloatingRateIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("leg2FloatingRateIndex"), String.class, (Object)this.getLeg2FloatingRateIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetName"), String.class, this.getUnderlyingAssetName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1IDType"), String.class, (Object)this.getTradeParty1IDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("messageID"), String.class, (Object)this.getMessageID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("leg1CommodityUnderlyerID"), String.class, (Object)this.getLeg1CommodityUnderlyerID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("leg2CommodityUnderlyerID"), String.class, (Object)this.getLeg2CommodityUnderlyerID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("changeInNotionalAmount1"), BigDecimal.class, (Object)this.getChangeInNotionalAmount1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("changeInNotionalAmount2"), BigDecimal.class, (Object)this.getChangeInNotionalAmount2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("largeNotionalOffFacilitySwapElectionIndicator"), Boolean.class, (Object)this.getLargeNotionalOffFacilitySwapElectionIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("mandatoryClearingIndicator"), Boolean.class, (Object)this.getMandatoryClearingIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("messageType"), String.class, (Object)this.getMessageType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapSDRIDType"), PartyIdentifierTypeEnum.class, (Object)this.getOriginalSwapSDRIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("physicalCommodityContractIndicator"), Boolean.class, (Object)this.getPhysicalCommodityContractIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sdMspIndicatorCounterparty1"), Boolean.class, (Object)this.getSdMspIndicatorCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sdMspIndicatorCounterparty2"), Boolean.class, (Object)this.getSdMspIndicatorCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sefOrDcmIndicator"), Boolean.class, (Object)this.getSefOrDcmIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("version"), String.class, (Object)this.getVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class DTCCAdditionalFieldsBuilderImpl
    extends CommonDTCCAdditionalFields.CommonDTCCAdditionalFieldsBuilderImpl
    implements DTCCAdditionalFieldsBuilder {
        protected String tradeParty1IDType;
        protected String messageID;
        protected String leg1CommodityUnderlyerID;
        protected String leg2CommodityUnderlyerID;
        protected BigDecimal changeInNotionalAmount1;
        protected BigDecimal changeInNotionalAmount2;
        protected Boolean largeNotionalOffFacilitySwapElectionIndicator;
        protected Boolean mandatoryClearingIndicator;
        protected String messageType;
        protected PartyIdentifierTypeEnum originalSwapSDRIDType;
        protected Boolean physicalCommodityContractIndicator;
        protected Boolean sdMspIndicatorCounterparty1;
        protected Boolean sdMspIndicatorCounterparty2;
        protected Boolean sefOrDcmIndicator;
        protected String version;

        @Override
        @RosettaAttribute(value="tradeParty1IDType", isRequired=true)
        @RuneAttribute(value="tradeParty1IDType", isRequired=true)
        public String getTradeParty1IDType() {
            return this.tradeParty1IDType;
        }

        @Override
        @RosettaAttribute(value="messageID")
        @RuneAttribute(value="messageID")
        public String getMessageID() {
            return this.messageID;
        }

        @Override
        @RosettaAttribute(value="leg1CommodityUnderlyerID")
        @RuneAttribute(value="leg1CommodityUnderlyerID")
        public String getLeg1CommodityUnderlyerID() {
            return this.leg1CommodityUnderlyerID;
        }

        @Override
        @RosettaAttribute(value="leg2CommodityUnderlyerID")
        @RuneAttribute(value="leg2CommodityUnderlyerID")
        public String getLeg2CommodityUnderlyerID() {
            return this.leg2CommodityUnderlyerID;
        }

        @Override
        @RosettaAttribute(value="changeInNotionalAmount1")
        @RuneAttribute(value="changeInNotionalAmount1")
        public BigDecimal getChangeInNotionalAmount1() {
            return this.changeInNotionalAmount1;
        }

        @Override
        @RosettaAttribute(value="changeInNotionalAmount2")
        @RuneAttribute(value="changeInNotionalAmount2")
        public BigDecimal getChangeInNotionalAmount2() {
            return this.changeInNotionalAmount2;
        }

        @Override
        @RosettaAttribute(value="largeNotionalOffFacilitySwapElectionIndicator")
        @RuneAttribute(value="largeNotionalOffFacilitySwapElectionIndicator")
        public Boolean getLargeNotionalOffFacilitySwapElectionIndicator() {
            return this.largeNotionalOffFacilitySwapElectionIndicator;
        }

        @Override
        @RosettaAttribute(value="mandatoryClearingIndicator", isRequired=true)
        @RuneAttribute(value="mandatoryClearingIndicator", isRequired=true)
        public Boolean getMandatoryClearingIndicator() {
            return this.mandatoryClearingIndicator;
        }

        @Override
        @RosettaAttribute(value="messageType")
        @RuneAttribute(value="messageType")
        public String getMessageType() {
            return this.messageType;
        }

        @Override
        @RosettaAttribute(value="originalSwapSDRIDType")
        @RuneAttribute(value="originalSwapSDRIDType")
        public PartyIdentifierTypeEnum getOriginalSwapSDRIDType() {
            return this.originalSwapSDRIDType;
        }

        @Override
        @RosettaAttribute(value="physicalCommodityContractIndicator")
        @RuneAttribute(value="physicalCommodityContractIndicator")
        public Boolean getPhysicalCommodityContractIndicator() {
            return this.physicalCommodityContractIndicator;
        }

        @Override
        @RosettaAttribute(value="sdMspIndicatorCounterparty1", isRequired=true)
        @RuneAttribute(value="sdMspIndicatorCounterparty1", isRequired=true)
        public Boolean getSdMspIndicatorCounterparty1() {
            return this.sdMspIndicatorCounterparty1;
        }

        @Override
        @RosettaAttribute(value="sdMspIndicatorCounterparty2", isRequired=true)
        @RuneAttribute(value="sdMspIndicatorCounterparty2", isRequired=true)
        public Boolean getSdMspIndicatorCounterparty2() {
            return this.sdMspIndicatorCounterparty2;
        }

        @Override
        @RosettaAttribute(value="sefOrDcmIndicator", isRequired=true)
        @RuneAttribute(value="sefOrDcmIndicator", isRequired=true)
        public Boolean getSefOrDcmIndicator() {
            return this.sefOrDcmIndicator;
        }

        @Override
        @RosettaAttribute(value="version")
        @RuneAttribute(value="version")
        public String getVersion() {
            return this.version;
        }

        @Override
        @RosettaAttribute(value="clearingVenueIDType")
        @RuneAttribute(value="clearingVenueIDType")
        public DTCCAdditionalFieldsBuilder setClearingVenueIDType(PartyIdentifierTypeEnum _clearingVenueIDType) {
            this.clearingVenueIDType = _clearingVenueIDType == null ? null : _clearingVenueIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ClearingBrokerIDType")
        @RuneAttribute(value="tradeParty1ClearingBrokerIDType")
        public DTCCAdditionalFieldsBuilder setTradeParty1ClearingBrokerIDType(PartyIdentifierTypeEnum _tradeParty1ClearingBrokerIDType) {
            this.tradeParty1ClearingBrokerIDType = _tradeParty1ClearingBrokerIDType == null ? null : _tradeParty1ClearingBrokerIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType", isRequired=true)
        @RuneAttribute(value="submittingPartyIDType", isRequired=true)
        public DTCCAdditionalFieldsBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum _submittingPartyIDType) {
            this.submittingPartyIDType = _submittingPartyIDType == null ? null : _submittingPartyIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="submittedForParty", isRequired=true)
        @RuneAttribute(value="submittedForParty", isRequired=true)
        public DTCCAdditionalFieldsBuilder setSubmittedForParty(String _submittedForParty) {
            this.submittedForParty = _submittedForParty == null ? null : _submittedForParty;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeLegTypes")
        @RuneAttribute(value="tradeLegTypes")
        public DTCCAdditionalFieldsBuilder setTradeLegTypes(String _tradeLegTypes) {
            this.tradeLegTypes = _tradeLegTypes == null ? null : _tradeLegTypes;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        public DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination) {
            if (_tradeParty1ReportingDestination != null) {
                this.tradeParty1ReportingDestination.add(_tradeParty1ReportingDestination);
            }
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination, int idx) {
            this.getIndex(this.tradeParty1ReportingDestination, idx, () -> _tradeParty1ReportingDestination);
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
            if (tradeParty1ReportingDestinations != null) {
                for (SupervisoryBodyEnum toAdd : tradeParty1ReportingDestinations) {
                    this.tradeParty1ReportingDestination.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeParty1ReportingDestination")
        public DTCCAdditionalFieldsBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
            this.tradeParty1ReportingDestination = tradeParty1ReportingDestinations == null ? new ArrayList() : (List)tradeParty1ReportingDestinations.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ReportingDestination")
        @RuneAttribute(value="tradeParty2ReportingDestination")
        public DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum _tradeParty2ReportingDestination) {
            if (_tradeParty2ReportingDestination != null) {
                this.tradeParty2ReportingDestination.add(_tradeParty2ReportingDestination);
            }
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum _tradeParty2ReportingDestination, int idx) {
            this.getIndex(this.tradeParty2ReportingDestination, idx, () -> _tradeParty2ReportingDestination);
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(List<SupervisoryBodyEnum> tradeParty2ReportingDestinations) {
            if (tradeParty2ReportingDestinations != null) {
                for (SupervisoryBodyEnum toAdd : tradeParty2ReportingDestinations) {
                    this.tradeParty2ReportingDestination.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeParty2ReportingDestination")
        public DTCCAdditionalFieldsBuilder setTradeParty2ReportingDestination(List<SupervisoryBodyEnum> tradeParty2ReportingDestinations) {
            this.tradeParty2ReportingDestination = tradeParty2ReportingDestinations == null ? new ArrayList() : (List)tradeParty2ReportingDestinations.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass", isRequired=true)
        @RuneAttribute(value="primaryAssetClass", isRequired=true)
        public DTCCAdditionalFieldsBuilder setPrimaryAssetClass(AssetClassEnum _primaryAssetClass) {
            this.primaryAssetClass = _primaryAssetClass == null ? null : _primaryAssetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="secondaryAssetClass")
        @RuneAttribute(value="secondaryAssetClass")
        public DTCCAdditionalFieldsBuilder setSecondaryAssetClass(AssetClassEnum _secondaryAssetClass) {
            this.secondaryAssetClass = _secondaryAssetClass == null ? null : _secondaryAssetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="comment1")
        @RuneAttribute(value="comment1")
        public DTCCAdditionalFieldsBuilder setComment1(String _comment1) {
            this.comment1 = _comment1 == null ? null : _comment1;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public DTCCAdditionalFieldsBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
            this.optionStyle = _optionStyle == null ? null : _optionStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public DTCCAdditionalFieldsBuilder setOptionType(String _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="productID")
        @RuneAttribute(value="productID")
        public DTCCAdditionalFieldsBuilder setProductID(String _productID) {
            this.productID = _productID == null ? null : _productID;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentID")
        @RuneAttribute(value="tradeParty2ExecutionAgentID")
        public DTCCAdditionalFieldsBuilder setTradeParty2ExecutionAgentID(String _tradeParty2ExecutionAgentID) {
            this.tradeParty2ExecutionAgentID = _tradeParty2ExecutionAgentID == null ? null : _tradeParty2ExecutionAgentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty2ExecutionAgentIDType")
        public DTCCAdditionalFieldsBuilder setTradeParty2ExecutionAgentIDType(PartyIdentifierTypeEnum _tradeParty2ExecutionAgentIDType) {
            this.tradeParty2ExecutionAgentIDType = _tradeParty2ExecutionAgentIDType == null ? null : _tradeParty2ExecutionAgentIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentID")
        @RuneAttribute(value="tradeParty1ExecutionAgentID")
        public DTCCAdditionalFieldsBuilder setTradeParty1ExecutionAgentID(String _tradeParty1ExecutionAgentID) {
            this.tradeParty1ExecutionAgentID = _tradeParty1ExecutionAgentID == null ? null : _tradeParty1ExecutionAgentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty1ExecutionAgentIDType")
        public DTCCAdditionalFieldsBuilder setTradeParty1ExecutionAgentIDType(PartyIdentifierTypeEnum _tradeParty1ExecutionAgentIDType) {
            this.tradeParty1ExecutionAgentIDType = _tradeParty1ExecutionAgentIDType == null ? null : _tradeParty1ExecutionAgentIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1TransactionID")
        @RuneAttribute(value="tradeParty1TransactionID")
        public DTCCAdditionalFieldsBuilder setTradeParty1TransactionID(String _tradeParty1TransactionID) {
            this.tradeParty1TransactionID = _tradeParty1TransactionID == null ? null : _tradeParty1TransactionID;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public DTCCAdditionalFieldsBuilder setSettlementType(String _settlementType) {
            this.settlementType = _settlementType == null ? null : _settlementType;
            return this;
        }

        @Override
        @RosettaAttribute(value="productGrade")
        @RuneAttribute(value="productGrade")
        public DTCCAdditionalFieldsBuilder addProductGrade(ProductGradeReport _productGrade) {
            if (_productGrade != null) {
                this.productGrade.add(_productGrade.toBuilder());
            }
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addProductGrade(ProductGradeReport _productGrade, int idx) {
            this.getIndex(this.productGrade, idx, () -> _productGrade.toBuilder());
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addProductGrade(List<? extends ProductGradeReport> productGrades) {
            if (productGrades != null) {
                for (ProductGradeReport productGradeReport : productGrades) {
                    this.productGrade.add(productGradeReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productGrade")
        public DTCCAdditionalFieldsBuilder setProductGrade(List<? extends ProductGradeReport> productGrades) {
            this.productGrade = productGrades == null ? new ArrayList() : (List)productGrades.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryLocation")
        @RuneAttribute(value="deliveryLocation")
        public DTCCAdditionalFieldsBuilder setDeliveryLocation(String _deliveryLocation) {
            this.deliveryLocation = _deliveryLocation == null ? null : _deliveryLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="leg1CommodityInstrumentID")
        @RuneAttribute(value="leg1CommodityInstrumentID")
        public DTCCAdditionalFieldsBuilder setLeg1CommodityInstrumentID(String _leg1CommodityInstrumentID) {
            this.leg1CommodityInstrumentID = _leg1CommodityInstrumentID == null ? null : _leg1CommodityInstrumentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="leg2CommodityInstrumentID")
        @RuneAttribute(value="leg2CommodityInstrumentID")
        public DTCCAdditionalFieldsBuilder setLeg2CommodityInstrumentID(String _leg2CommodityInstrumentID) {
            this.leg2CommodityInstrumentID = _leg2CommodityInstrumentID == null ? null : _leg2CommodityInstrumentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="responsibleDataSubmitterIDType")
        @RuneAttribute(value="responsibleDataSubmitterIDType")
        public DTCCAdditionalFieldsBuilder setResponsibleDataSubmitterIDType(PartyIdentifierTypeEnum _responsibleDataSubmitterIDType) {
            this.responsibleDataSubmitterIDType = _responsibleDataSubmitterIDType == null ? null : _responsibleDataSubmitterIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="responsibleDataSubmitterID")
        @RuneAttribute(value="responsibleDataSubmitterID")
        public DTCCAdditionalFieldsBuilder setResponsibleDataSubmitterID(String _responsibleDataSubmitterID) {
            this.responsibleDataSubmitterID = _responsibleDataSubmitterID == null ? null : _responsibleDataSubmitterID;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public DTCCAdditionalFieldsBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
            this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateActionNewTradeParty1Lei")
        @RuneAttribute(value="corporateActionNewTradeParty1Lei")
        public DTCCAdditionalFieldsBuilder setCorporateActionNewTradeParty1Lei(String _corporateActionNewTradeParty1Lei) {
            this.corporateActionNewTradeParty1Lei = _corporateActionNewTradeParty1Lei == null ? null : _corporateActionNewTradeParty1Lei;
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPaymentPayerIDType")
        @RuneAttribute(value="otherPaymentPayerIDType")
        public DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(String _otherPaymentPayerIDType) {
            if (_otherPaymentPayerIDType != null) {
                this.otherPaymentPayerIDType.add(_otherPaymentPayerIDType);
            }
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(String _otherPaymentPayerIDType, int idx) {
            this.getIndex(this.otherPaymentPayerIDType, idx, () -> _otherPaymentPayerIDType);
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(List<String> otherPaymentPayerIDTypes) {
            if (otherPaymentPayerIDTypes != null) {
                for (String toAdd : otherPaymentPayerIDTypes) {
                    this.otherPaymentPayerIDType.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPaymentPayerIDType")
        public DTCCAdditionalFieldsBuilder setOtherPaymentPayerIDType(List<String> otherPaymentPayerIDTypes) {
            this.otherPaymentPayerIDType = otherPaymentPayerIDTypes == null ? new ArrayList() : (List)otherPaymentPayerIDTypes.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPaymentReceiverIDType")
        @RuneAttribute(value="otherPaymentReceiverIDType")
        public DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(String _otherPaymentReceiverIDType) {
            if (_otherPaymentReceiverIDType != null) {
                this.otherPaymentReceiverIDType.add(_otherPaymentReceiverIDType);
            }
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(String _otherPaymentReceiverIDType, int idx) {
            this.getIndex(this.otherPaymentReceiverIDType, idx, () -> _otherPaymentReceiverIDType);
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(List<String> otherPaymentReceiverIDTypes) {
            if (otherPaymentReceiverIDTypes != null) {
                for (String toAdd : otherPaymentReceiverIDTypes) {
                    this.otherPaymentReceiverIDType.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPaymentReceiverIDType")
        public DTCCAdditionalFieldsBuilder setOtherPaymentReceiverIDType(List<String> otherPaymentReceiverIDTypes) {
            this.otherPaymentReceiverIDType = otherPaymentReceiverIDTypes == null ? new ArrayList() : (List)otherPaymentReceiverIDTypes.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="sefOrDcmAnonymousExecutionIndicator")
        @RuneAttribute(value="sefOrDcmAnonymousExecutionIndicator")
        public DTCCAdditionalFieldsBuilder setSefOrDcmAnonymousExecutionIndicator(Boolean _sefOrDcmAnonymousExecutionIndicator) {
            this.sefOrDcmAnonymousExecutionIndicator = _sefOrDcmAnonymousExecutionIndicator == null ? null : _sefOrDcmAnonymousExecutionIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionVenueID")
        @RuneAttribute(value="executionVenueID")
        public DTCCAdditionalFieldsBuilder setExecutionVenueID(String _executionVenueID) {
            this.executionVenueID = _executionVenueID == null ? null : _executionVenueID;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionVenueIDType")
        @RuneAttribute(value="executionVenueIDType")
        public DTCCAdditionalFieldsBuilder setExecutionVenueIDType(PartyIdentifierTypeEnum _executionVenueIDType) {
            this.executionVenueIDType = _executionVenueIDType == null ? null : _executionVenueIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="leg1FloatingRateIndex")
        @RuneAttribute(value="leg1FloatingRateIndex")
        public DTCCAdditionalFieldsBuilder setLeg1FloatingRateIndex(String _leg1FloatingRateIndex) {
            this.leg1FloatingRateIndex = _leg1FloatingRateIndex == null ? null : _leg1FloatingRateIndex;
            return this;
        }

        @Override
        @RosettaAttribute(value="leg2FloatingRateIndex")
        @RuneAttribute(value="leg2FloatingRateIndex")
        public DTCCAdditionalFieldsBuilder setLeg2FloatingRateIndex(String _leg2FloatingRateIndex) {
            this.leg2FloatingRateIndex = _leg2FloatingRateIndex == null ? null : _leg2FloatingRateIndex;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetName")
        @RuneAttribute(value="underlyingAssetName")
        public DTCCAdditionalFieldsBuilder addUnderlyingAssetName(String _underlyingAssetName) {
            if (_underlyingAssetName != null) {
                this.underlyingAssetName.add(_underlyingAssetName);
            }
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addUnderlyingAssetName(String _underlyingAssetName, int idx) {
            this.getIndex(this.underlyingAssetName, idx, () -> _underlyingAssetName);
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder addUnderlyingAssetName(List<String> underlyingAssetNames) {
            if (underlyingAssetNames != null) {
                for (String toAdd : underlyingAssetNames) {
                    this.underlyingAssetName.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="underlyingAssetName")
        public DTCCAdditionalFieldsBuilder setUnderlyingAssetName(List<String> underlyingAssetNames) {
            this.underlyingAssetName = underlyingAssetNames == null ? new ArrayList() : (List)underlyingAssetNames.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1IDType", isRequired=true)
        @RuneAttribute(value="tradeParty1IDType", isRequired=true)
        public DTCCAdditionalFieldsBuilder setTradeParty1IDType(String _tradeParty1IDType) {
            this.tradeParty1IDType = _tradeParty1IDType == null ? null : _tradeParty1IDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="messageID")
        @RuneAttribute(value="messageID")
        public DTCCAdditionalFieldsBuilder setMessageID(String _messageID) {
            this.messageID = _messageID == null ? null : _messageID;
            return this;
        }

        @Override
        @RosettaAttribute(value="leg1CommodityUnderlyerID")
        @RuneAttribute(value="leg1CommodityUnderlyerID")
        public DTCCAdditionalFieldsBuilder setLeg1CommodityUnderlyerID(String _leg1CommodityUnderlyerID) {
            this.leg1CommodityUnderlyerID = _leg1CommodityUnderlyerID == null ? null : _leg1CommodityUnderlyerID;
            return this;
        }

        @Override
        @RosettaAttribute(value="leg2CommodityUnderlyerID")
        @RuneAttribute(value="leg2CommodityUnderlyerID")
        public DTCCAdditionalFieldsBuilder setLeg2CommodityUnderlyerID(String _leg2CommodityUnderlyerID) {
            this.leg2CommodityUnderlyerID = _leg2CommodityUnderlyerID == null ? null : _leg2CommodityUnderlyerID;
            return this;
        }

        @Override
        @RosettaAttribute(value="changeInNotionalAmount1")
        @RuneAttribute(value="changeInNotionalAmount1")
        public DTCCAdditionalFieldsBuilder setChangeInNotionalAmount1(BigDecimal _changeInNotionalAmount1) {
            this.changeInNotionalAmount1 = _changeInNotionalAmount1 == null ? null : _changeInNotionalAmount1;
            return this;
        }

        @Override
        @RosettaAttribute(value="changeInNotionalAmount2")
        @RuneAttribute(value="changeInNotionalAmount2")
        public DTCCAdditionalFieldsBuilder setChangeInNotionalAmount2(BigDecimal _changeInNotionalAmount2) {
            this.changeInNotionalAmount2 = _changeInNotionalAmount2 == null ? null : _changeInNotionalAmount2;
            return this;
        }

        @Override
        @RosettaAttribute(value="largeNotionalOffFacilitySwapElectionIndicator")
        @RuneAttribute(value="largeNotionalOffFacilitySwapElectionIndicator")
        public DTCCAdditionalFieldsBuilder setLargeNotionalOffFacilitySwapElectionIndicator(Boolean _largeNotionalOffFacilitySwapElectionIndicator) {
            this.largeNotionalOffFacilitySwapElectionIndicator = _largeNotionalOffFacilitySwapElectionIndicator == null ? null : _largeNotionalOffFacilitySwapElectionIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="mandatoryClearingIndicator", isRequired=true)
        @RuneAttribute(value="mandatoryClearingIndicator", isRequired=true)
        public DTCCAdditionalFieldsBuilder setMandatoryClearingIndicator(Boolean _mandatoryClearingIndicator) {
            this.mandatoryClearingIndicator = _mandatoryClearingIndicator == null ? null : _mandatoryClearingIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="messageType")
        @RuneAttribute(value="messageType")
        public DTCCAdditionalFieldsBuilder setMessageType(String _messageType) {
            this.messageType = _messageType == null ? null : _messageType;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapSDRIDType")
        @RuneAttribute(value="originalSwapSDRIDType")
        public DTCCAdditionalFieldsBuilder setOriginalSwapSDRIDType(PartyIdentifierTypeEnum _originalSwapSDRIDType) {
            this.originalSwapSDRIDType = _originalSwapSDRIDType == null ? null : _originalSwapSDRIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="physicalCommodityContractIndicator")
        @RuneAttribute(value="physicalCommodityContractIndicator")
        public DTCCAdditionalFieldsBuilder setPhysicalCommodityContractIndicator(Boolean _physicalCommodityContractIndicator) {
            this.physicalCommodityContractIndicator = _physicalCommodityContractIndicator == null ? null : _physicalCommodityContractIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="sdMspIndicatorCounterparty1", isRequired=true)
        @RuneAttribute(value="sdMspIndicatorCounterparty1", isRequired=true)
        public DTCCAdditionalFieldsBuilder setSdMspIndicatorCounterparty1(Boolean _sdMspIndicatorCounterparty1) {
            this.sdMspIndicatorCounterparty1 = _sdMspIndicatorCounterparty1 == null ? null : _sdMspIndicatorCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="sdMspIndicatorCounterparty2", isRequired=true)
        @RuneAttribute(value="sdMspIndicatorCounterparty2", isRequired=true)
        public DTCCAdditionalFieldsBuilder setSdMspIndicatorCounterparty2(Boolean _sdMspIndicatorCounterparty2) {
            this.sdMspIndicatorCounterparty2 = _sdMspIndicatorCounterparty2 == null ? null : _sdMspIndicatorCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="sefOrDcmIndicator", isRequired=true)
        @RuneAttribute(value="sefOrDcmIndicator", isRequired=true)
        public DTCCAdditionalFieldsBuilder setSefOrDcmIndicator(Boolean _sefOrDcmIndicator) {
            this.sefOrDcmIndicator = _sefOrDcmIndicator == null ? null : _sefOrDcmIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="version")
        @RuneAttribute(value="version")
        public DTCCAdditionalFieldsBuilder setVersion(String _version) {
            this.version = _version == null ? null : _version;
            return this;
        }

        @Override
        public DTCCAdditionalFields build() {
            return new DTCCAdditionalFieldsImpl(this);
        }

        @Override
        public DTCCAdditionalFieldsBuilder toBuilder() {
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTradeParty1IDType() != null) {
                return true;
            }
            if (this.getMessageID() != null) {
                return true;
            }
            if (this.getLeg1CommodityUnderlyerID() != null) {
                return true;
            }
            if (this.getLeg2CommodityUnderlyerID() != null) {
                return true;
            }
            if (this.getChangeInNotionalAmount1() != null) {
                return true;
            }
            if (this.getChangeInNotionalAmount2() != null) {
                return true;
            }
            if (this.getLargeNotionalOffFacilitySwapElectionIndicator() != null) {
                return true;
            }
            if (this.getMandatoryClearingIndicator() != null) {
                return true;
            }
            if (this.getMessageType() != null) {
                return true;
            }
            if (this.getOriginalSwapSDRIDType() != null) {
                return true;
            }
            if (this.getPhysicalCommodityContractIndicator() != null) {
                return true;
            }
            if (this.getSdMspIndicatorCounterparty1() != null) {
                return true;
            }
            if (this.getSdMspIndicatorCounterparty2() != null) {
                return true;
            }
            if (this.getSefOrDcmIndicator() != null) {
                return true;
            }
            return this.getVersion() != null;
        }

        @Override
        public DTCCAdditionalFieldsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            DTCCAdditionalFieldsBuilder o = (DTCCAdditionalFieldsBuilder)other;
            merger.mergeBasic((Object)this.getTradeParty1IDType(), (Object)o.getTradeParty1IDType(), this::setTradeParty1IDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMessageID(), (Object)o.getMessageID(), this::setMessageID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLeg1CommodityUnderlyerID(), (Object)o.getLeg1CommodityUnderlyerID(), this::setLeg1CommodityUnderlyerID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLeg2CommodityUnderlyerID(), (Object)o.getLeg2CommodityUnderlyerID(), this::setLeg2CommodityUnderlyerID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getChangeInNotionalAmount1(), (Object)o.getChangeInNotionalAmount1(), this::setChangeInNotionalAmount1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getChangeInNotionalAmount2(), (Object)o.getChangeInNotionalAmount2(), this::setChangeInNotionalAmount2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLargeNotionalOffFacilitySwapElectionIndicator(), (Object)o.getLargeNotionalOffFacilitySwapElectionIndicator(), this::setLargeNotionalOffFacilitySwapElectionIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMandatoryClearingIndicator(), (Object)o.getMandatoryClearingIndicator(), this::setMandatoryClearingIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMessageType(), (Object)o.getMessageType(), this::setMessageType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOriginalSwapSDRIDType(), (Object)o.getOriginalSwapSDRIDType(), this::setOriginalSwapSDRIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPhysicalCommodityContractIndicator(), (Object)o.getPhysicalCommodityContractIndicator(), this::setPhysicalCommodityContractIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSdMspIndicatorCounterparty1(), (Object)o.getSdMspIndicatorCounterparty1(), this::setSdMspIndicatorCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSdMspIndicatorCounterparty2(), (Object)o.getSdMspIndicatorCounterparty2(), this::setSdMspIndicatorCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSefOrDcmIndicator(), (Object)o.getSefOrDcmIndicator(), this::setSefOrDcmIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVersion(), (Object)o.getVersion(), this::setVersion, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DTCCAdditionalFields _that = (DTCCAdditionalFields)this.getType().cast(o);
            if (!Objects.equals(this.tradeParty1IDType, _that.getTradeParty1IDType())) {
                return false;
            }
            if (!Objects.equals(this.messageID, _that.getMessageID())) {
                return false;
            }
            if (!Objects.equals(this.leg1CommodityUnderlyerID, _that.getLeg1CommodityUnderlyerID())) {
                return false;
            }
            if (!Objects.equals(this.leg2CommodityUnderlyerID, _that.getLeg2CommodityUnderlyerID())) {
                return false;
            }
            if (!Objects.equals(this.changeInNotionalAmount1, _that.getChangeInNotionalAmount1())) {
                return false;
            }
            if (!Objects.equals(this.changeInNotionalAmount2, _that.getChangeInNotionalAmount2())) {
                return false;
            }
            if (!Objects.equals(this.largeNotionalOffFacilitySwapElectionIndicator, _that.getLargeNotionalOffFacilitySwapElectionIndicator())) {
                return false;
            }
            if (!Objects.equals(this.mandatoryClearingIndicator, _that.getMandatoryClearingIndicator())) {
                return false;
            }
            if (!Objects.equals(this.messageType, _that.getMessageType())) {
                return false;
            }
            if (!Objects.equals(this.originalSwapSDRIDType, _that.getOriginalSwapSDRIDType())) {
                return false;
            }
            if (!Objects.equals(this.physicalCommodityContractIndicator, _that.getPhysicalCommodityContractIndicator())) {
                return false;
            }
            if (!Objects.equals(this.sdMspIndicatorCounterparty1, _that.getSdMspIndicatorCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.sdMspIndicatorCounterparty2, _that.getSdMspIndicatorCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.sefOrDcmIndicator, _that.getSefOrDcmIndicator())) {
                return false;
            }
            return Objects.equals(this.version, _that.getVersion());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradeParty1IDType != null ? this.tradeParty1IDType.hashCode() : 0);
            _result = 31 * _result + (this.messageID != null ? this.messageID.hashCode() : 0);
            _result = 31 * _result + (this.leg1CommodityUnderlyerID != null ? this.leg1CommodityUnderlyerID.hashCode() : 0);
            _result = 31 * _result + (this.leg2CommodityUnderlyerID != null ? this.leg2CommodityUnderlyerID.hashCode() : 0);
            _result = 31 * _result + (this.changeInNotionalAmount1 != null ? this.changeInNotionalAmount1.hashCode() : 0);
            _result = 31 * _result + (this.changeInNotionalAmount2 != null ? this.changeInNotionalAmount2.hashCode() : 0);
            _result = 31 * _result + (this.largeNotionalOffFacilitySwapElectionIndicator != null ? this.largeNotionalOffFacilitySwapElectionIndicator.hashCode() : 0);
            _result = 31 * _result + (this.mandatoryClearingIndicator != null ? this.mandatoryClearingIndicator.hashCode() : 0);
            _result = 31 * _result + (this.messageType != null ? this.messageType.hashCode() : 0);
            _result = 31 * _result + (this.originalSwapSDRIDType != null ? this.originalSwapSDRIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.physicalCommodityContractIndicator != null ? this.physicalCommodityContractIndicator.hashCode() : 0);
            _result = 31 * _result + (this.sdMspIndicatorCounterparty1 != null ? this.sdMspIndicatorCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.sdMspIndicatorCounterparty2 != null ? this.sdMspIndicatorCounterparty2.hashCode() : 0);
            _result = 31 * _result + (this.sefOrDcmIndicator != null ? this.sefOrDcmIndicator.hashCode() : 0);
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DTCCAdditionalFieldsBuilder {tradeParty1IDType=" + this.tradeParty1IDType + ", messageID=" + this.messageID + ", leg1CommodityUnderlyerID=" + this.leg1CommodityUnderlyerID + ", leg2CommodityUnderlyerID=" + this.leg2CommodityUnderlyerID + ", changeInNotionalAmount1=" + String.valueOf(this.changeInNotionalAmount1) + ", changeInNotionalAmount2=" + String.valueOf(this.changeInNotionalAmount2) + ", largeNotionalOffFacilitySwapElectionIndicator=" + this.largeNotionalOffFacilitySwapElectionIndicator + ", mandatoryClearingIndicator=" + this.mandatoryClearingIndicator + ", messageType=" + this.messageType + ", originalSwapSDRIDType=" + String.valueOf(this.originalSwapSDRIDType) + ", physicalCommodityContractIndicator=" + this.physicalCommodityContractIndicator + ", sdMspIndicatorCounterparty1=" + this.sdMspIndicatorCounterparty1 + ", sdMspIndicatorCounterparty2=" + this.sdMspIndicatorCounterparty2 + ", sefOrDcmIndicator=" + this.sefOrDcmIndicator + ", version=" + this.version + "} " + super.toString();
        }
    }

    public static interface DTCCAdditionalFieldsBuilder
    extends DTCCAdditionalFields,
    CommonDTCCAdditionalFields.CommonDTCCAdditionalFieldsBuilder {
        @Override
        public DTCCAdditionalFieldsBuilder setClearingVenueIDType(PartyIdentifierTypeEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeParty1ClearingBrokerIDType(PartyIdentifierTypeEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setSubmittedForParty(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeLegTypes(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum var1, int var2);

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> var1);

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum var1, int var2);

        @Override
        public DTCCAdditionalFieldsBuilder addTradeParty2ReportingDestination(List<SupervisoryBodyEnum> var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeParty2ReportingDestination(List<SupervisoryBodyEnum> var1);

        @Override
        public DTCCAdditionalFieldsBuilder setPrimaryAssetClass(AssetClassEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setSecondaryAssetClass(AssetClassEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setComment1(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setOptionStyle(OptionStyleEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setOptionType(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setProductID(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeParty2ExecutionAgentID(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeParty2ExecutionAgentIDType(PartyIdentifierTypeEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeParty1ExecutionAgentID(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeParty1ExecutionAgentIDType(PartyIdentifierTypeEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setTradeParty1TransactionID(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setSettlementType(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder addProductGrade(ProductGradeReport var1);

        @Override
        public DTCCAdditionalFieldsBuilder addProductGrade(ProductGradeReport var1, int var2);

        @Override
        public DTCCAdditionalFieldsBuilder addProductGrade(List<? extends ProductGradeReport> var1);

        @Override
        public DTCCAdditionalFieldsBuilder setProductGrade(List<? extends ProductGradeReport> var1);

        @Override
        public DTCCAdditionalFieldsBuilder setDeliveryLocation(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setLeg1CommodityInstrumentID(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setLeg2CommodityInstrumentID(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setResponsibleDataSubmitterIDType(PartyIdentifierTypeEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setResponsibleDataSubmitterID(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setMaturityDateOfTheUnderlying(Date var1);

        @Override
        public DTCCAdditionalFieldsBuilder setCorporateActionNewTradeParty1Lei(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(String var1, int var2);

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentPayerIDType(List<String> var1);

        @Override
        public DTCCAdditionalFieldsBuilder setOtherPaymentPayerIDType(List<String> var1);

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(String var1, int var2);

        @Override
        public DTCCAdditionalFieldsBuilder addOtherPaymentReceiverIDType(List<String> var1);

        @Override
        public DTCCAdditionalFieldsBuilder setOtherPaymentReceiverIDType(List<String> var1);

        @Override
        public DTCCAdditionalFieldsBuilder setSefOrDcmAnonymousExecutionIndicator(Boolean var1);

        @Override
        public DTCCAdditionalFieldsBuilder setExecutionVenueID(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setExecutionVenueIDType(PartyIdentifierTypeEnum var1);

        @Override
        public DTCCAdditionalFieldsBuilder setLeg1FloatingRateIndex(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder setLeg2FloatingRateIndex(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder addUnderlyingAssetName(String var1);

        @Override
        public DTCCAdditionalFieldsBuilder addUnderlyingAssetName(String var1, int var2);

        @Override
        public DTCCAdditionalFieldsBuilder addUnderlyingAssetName(List<String> var1);

        @Override
        public DTCCAdditionalFieldsBuilder setUnderlyingAssetName(List<String> var1);

        public DTCCAdditionalFieldsBuilder setTradeParty1IDType(String var1);

        public DTCCAdditionalFieldsBuilder setMessageID(String var1);

        public DTCCAdditionalFieldsBuilder setLeg1CommodityUnderlyerID(String var1);

        public DTCCAdditionalFieldsBuilder setLeg2CommodityUnderlyerID(String var1);

        public DTCCAdditionalFieldsBuilder setChangeInNotionalAmount1(BigDecimal var1);

        public DTCCAdditionalFieldsBuilder setChangeInNotionalAmount2(BigDecimal var1);

        public DTCCAdditionalFieldsBuilder setLargeNotionalOffFacilitySwapElectionIndicator(Boolean var1);

        public DTCCAdditionalFieldsBuilder setMandatoryClearingIndicator(Boolean var1);

        public DTCCAdditionalFieldsBuilder setMessageType(String var1);

        public DTCCAdditionalFieldsBuilder setOriginalSwapSDRIDType(PartyIdentifierTypeEnum var1);

        public DTCCAdditionalFieldsBuilder setPhysicalCommodityContractIndicator(Boolean var1);

        public DTCCAdditionalFieldsBuilder setSdMspIndicatorCounterparty1(Boolean var1);

        public DTCCAdditionalFieldsBuilder setSdMspIndicatorCounterparty2(Boolean var1);

        public DTCCAdditionalFieldsBuilder setSefOrDcmIndicator(Boolean var1);

        public DTCCAdditionalFieldsBuilder setVersion(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("clearingVenueIDType"), PartyIdentifierTypeEnum.class, (Object)this.getClearingVenueIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ClearingBrokerIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1ClearingBrokerIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, (Object)this.getSubmittingPartyIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submittedForParty"), String.class, (Object)this.getSubmittedForParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeLegTypes"), String.class, (Object)this.getTradeLegTypes(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty1ReportingDestination(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty2ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty2ReportingDestination(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("primaryAssetClass"), AssetClassEnum.class, (Object)this.getPrimaryAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("secondaryAssetClass"), AssetClassEnum.class, (Object)this.getSecondaryAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment1"), String.class, (Object)this.getComment1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), String.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("productID"), String.class, (Object)this.getProductID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentID"), String.class, (Object)this.getTradeParty2ExecutionAgentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty2ExecutionAgentIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentID"), String.class, (Object)this.getTradeParty1ExecutionAgentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1ExecutionAgentIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1TransactionID"), String.class, (Object)this.getTradeParty1TransactionID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementType"), String.class, (Object)this.getSettlementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productGrade"), processor, ProductGradeReport.ProductGradeReportBuilder.class, this.getProductGrade(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryLocation"), String.class, (Object)this.getDeliveryLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("leg1CommodityInstrumentID"), String.class, (Object)this.getLeg1CommodityInstrumentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("leg2CommodityInstrumentID"), String.class, (Object)this.getLeg2CommodityInstrumentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("responsibleDataSubmitterIDType"), PartyIdentifierTypeEnum.class, (Object)this.getResponsibleDataSubmitterIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("responsibleDataSubmitterID"), String.class, (Object)this.getResponsibleDataSubmitterID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateActionNewTradeParty1Lei"), String.class, (Object)this.getCorporateActionNewTradeParty1Lei(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("otherPaymentPayerIDType"), String.class, this.getOtherPaymentPayerIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("otherPaymentReceiverIDType"), String.class, this.getOtherPaymentReceiverIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sefOrDcmAnonymousExecutionIndicator"), Boolean.class, (Object)this.getSefOrDcmAnonymousExecutionIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionVenueID"), String.class, (Object)this.getExecutionVenueID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionVenueIDType"), PartyIdentifierTypeEnum.class, (Object)this.getExecutionVenueIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("leg1FloatingRateIndex"), String.class, (Object)this.getLeg1FloatingRateIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("leg2FloatingRateIndex"), String.class, (Object)this.getLeg2FloatingRateIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetName"), String.class, this.getUnderlyingAssetName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1IDType"), String.class, (Object)this.getTradeParty1IDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("messageID"), String.class, (Object)this.getMessageID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("leg1CommodityUnderlyerID"), String.class, (Object)this.getLeg1CommodityUnderlyerID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("leg2CommodityUnderlyerID"), String.class, (Object)this.getLeg2CommodityUnderlyerID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("changeInNotionalAmount1"), BigDecimal.class, (Object)this.getChangeInNotionalAmount1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("changeInNotionalAmount2"), BigDecimal.class, (Object)this.getChangeInNotionalAmount2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("largeNotionalOffFacilitySwapElectionIndicator"), Boolean.class, (Object)this.getLargeNotionalOffFacilitySwapElectionIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("mandatoryClearingIndicator"), Boolean.class, (Object)this.getMandatoryClearingIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("messageType"), String.class, (Object)this.getMessageType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapSDRIDType"), PartyIdentifierTypeEnum.class, (Object)this.getOriginalSwapSDRIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("physicalCommodityContractIndicator"), Boolean.class, (Object)this.getPhysicalCommodityContractIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sdMspIndicatorCounterparty1"), Boolean.class, (Object)this.getSdMspIndicatorCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sdMspIndicatorCounterparty2"), Boolean.class, (Object)this.getSdMspIndicatorCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sefOrDcmIndicator"), Boolean.class, (Object)this.getSefOrDcmIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("version"), String.class, (Object)this.getVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public DTCCAdditionalFieldsBuilder prune();
    }

    public static class DTCCAdditionalFieldsImpl
    extends CommonDTCCAdditionalFields.CommonDTCCAdditionalFieldsImpl
    implements DTCCAdditionalFields {
        private final String tradeParty1IDType;
        private final String messageID;
        private final String leg1CommodityUnderlyerID;
        private final String leg2CommodityUnderlyerID;
        private final BigDecimal changeInNotionalAmount1;
        private final BigDecimal changeInNotionalAmount2;
        private final Boolean largeNotionalOffFacilitySwapElectionIndicator;
        private final Boolean mandatoryClearingIndicator;
        private final String messageType;
        private final PartyIdentifierTypeEnum originalSwapSDRIDType;
        private final Boolean physicalCommodityContractIndicator;
        private final Boolean sdMspIndicatorCounterparty1;
        private final Boolean sdMspIndicatorCounterparty2;
        private final Boolean sefOrDcmIndicator;
        private final String version;

        protected DTCCAdditionalFieldsImpl(DTCCAdditionalFieldsBuilder builder) {
            super(builder);
            this.tradeParty1IDType = builder.getTradeParty1IDType();
            this.messageID = builder.getMessageID();
            this.leg1CommodityUnderlyerID = builder.getLeg1CommodityUnderlyerID();
            this.leg2CommodityUnderlyerID = builder.getLeg2CommodityUnderlyerID();
            this.changeInNotionalAmount1 = builder.getChangeInNotionalAmount1();
            this.changeInNotionalAmount2 = builder.getChangeInNotionalAmount2();
            this.largeNotionalOffFacilitySwapElectionIndicator = builder.getLargeNotionalOffFacilitySwapElectionIndicator();
            this.mandatoryClearingIndicator = builder.getMandatoryClearingIndicator();
            this.messageType = builder.getMessageType();
            this.originalSwapSDRIDType = builder.getOriginalSwapSDRIDType();
            this.physicalCommodityContractIndicator = builder.getPhysicalCommodityContractIndicator();
            this.sdMspIndicatorCounterparty1 = builder.getSdMspIndicatorCounterparty1();
            this.sdMspIndicatorCounterparty2 = builder.getSdMspIndicatorCounterparty2();
            this.sefOrDcmIndicator = builder.getSefOrDcmIndicator();
            this.version = builder.getVersion();
        }

        @Override
        @RosettaAttribute(value="tradeParty1IDType", isRequired=true)
        @RuneAttribute(value="tradeParty1IDType", isRequired=true)
        public String getTradeParty1IDType() {
            return this.tradeParty1IDType;
        }

        @Override
        @RosettaAttribute(value="messageID")
        @RuneAttribute(value="messageID")
        public String getMessageID() {
            return this.messageID;
        }

        @Override
        @RosettaAttribute(value="leg1CommodityUnderlyerID")
        @RuneAttribute(value="leg1CommodityUnderlyerID")
        public String getLeg1CommodityUnderlyerID() {
            return this.leg1CommodityUnderlyerID;
        }

        @Override
        @RosettaAttribute(value="leg2CommodityUnderlyerID")
        @RuneAttribute(value="leg2CommodityUnderlyerID")
        public String getLeg2CommodityUnderlyerID() {
            return this.leg2CommodityUnderlyerID;
        }

        @Override
        @RosettaAttribute(value="changeInNotionalAmount1")
        @RuneAttribute(value="changeInNotionalAmount1")
        public BigDecimal getChangeInNotionalAmount1() {
            return this.changeInNotionalAmount1;
        }

        @Override
        @RosettaAttribute(value="changeInNotionalAmount2")
        @RuneAttribute(value="changeInNotionalAmount2")
        public BigDecimal getChangeInNotionalAmount2() {
            return this.changeInNotionalAmount2;
        }

        @Override
        @RosettaAttribute(value="largeNotionalOffFacilitySwapElectionIndicator")
        @RuneAttribute(value="largeNotionalOffFacilitySwapElectionIndicator")
        public Boolean getLargeNotionalOffFacilitySwapElectionIndicator() {
            return this.largeNotionalOffFacilitySwapElectionIndicator;
        }

        @Override
        @RosettaAttribute(value="mandatoryClearingIndicator", isRequired=true)
        @RuneAttribute(value="mandatoryClearingIndicator", isRequired=true)
        public Boolean getMandatoryClearingIndicator() {
            return this.mandatoryClearingIndicator;
        }

        @Override
        @RosettaAttribute(value="messageType")
        @RuneAttribute(value="messageType")
        public String getMessageType() {
            return this.messageType;
        }

        @Override
        @RosettaAttribute(value="originalSwapSDRIDType")
        @RuneAttribute(value="originalSwapSDRIDType")
        public PartyIdentifierTypeEnum getOriginalSwapSDRIDType() {
            return this.originalSwapSDRIDType;
        }

        @Override
        @RosettaAttribute(value="physicalCommodityContractIndicator")
        @RuneAttribute(value="physicalCommodityContractIndicator")
        public Boolean getPhysicalCommodityContractIndicator() {
            return this.physicalCommodityContractIndicator;
        }

        @Override
        @RosettaAttribute(value="sdMspIndicatorCounterparty1", isRequired=true)
        @RuneAttribute(value="sdMspIndicatorCounterparty1", isRequired=true)
        public Boolean getSdMspIndicatorCounterparty1() {
            return this.sdMspIndicatorCounterparty1;
        }

        @Override
        @RosettaAttribute(value="sdMspIndicatorCounterparty2", isRequired=true)
        @RuneAttribute(value="sdMspIndicatorCounterparty2", isRequired=true)
        public Boolean getSdMspIndicatorCounterparty2() {
            return this.sdMspIndicatorCounterparty2;
        }

        @Override
        @RosettaAttribute(value="sefOrDcmIndicator", isRequired=true)
        @RuneAttribute(value="sefOrDcmIndicator", isRequired=true)
        public Boolean getSefOrDcmIndicator() {
            return this.sefOrDcmIndicator;
        }

        @Override
        @RosettaAttribute(value="version")
        @RuneAttribute(value="version")
        public String getVersion() {
            return this.version;
        }

        @Override
        public DTCCAdditionalFields build() {
            return this;
        }

        @Override
        public DTCCAdditionalFieldsBuilder toBuilder() {
            DTCCAdditionalFieldsBuilder builder = DTCCAdditionalFields.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DTCCAdditionalFieldsBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTradeParty1IDType()).ifPresent(builder::setTradeParty1IDType);
            Optional.ofNullable(this.getMessageID()).ifPresent(builder::setMessageID);
            Optional.ofNullable(this.getLeg1CommodityUnderlyerID()).ifPresent(builder::setLeg1CommodityUnderlyerID);
            Optional.ofNullable(this.getLeg2CommodityUnderlyerID()).ifPresent(builder::setLeg2CommodityUnderlyerID);
            Optional.ofNullable(this.getChangeInNotionalAmount1()).ifPresent(builder::setChangeInNotionalAmount1);
            Optional.ofNullable(this.getChangeInNotionalAmount2()).ifPresent(builder::setChangeInNotionalAmount2);
            Optional.ofNullable(this.getLargeNotionalOffFacilitySwapElectionIndicator()).ifPresent(builder::setLargeNotionalOffFacilitySwapElectionIndicator);
            Optional.ofNullable(this.getMandatoryClearingIndicator()).ifPresent(builder::setMandatoryClearingIndicator);
            Optional.ofNullable(this.getMessageType()).ifPresent(builder::setMessageType);
            Optional.ofNullable(this.getOriginalSwapSDRIDType()).ifPresent(builder::setOriginalSwapSDRIDType);
            Optional.ofNullable(this.getPhysicalCommodityContractIndicator()).ifPresent(builder::setPhysicalCommodityContractIndicator);
            Optional.ofNullable(this.getSdMspIndicatorCounterparty1()).ifPresent(builder::setSdMspIndicatorCounterparty1);
            Optional.ofNullable(this.getSdMspIndicatorCounterparty2()).ifPresent(builder::setSdMspIndicatorCounterparty2);
            Optional.ofNullable(this.getSefOrDcmIndicator()).ifPresent(builder::setSefOrDcmIndicator);
            Optional.ofNullable(this.getVersion()).ifPresent(builder::setVersion);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DTCCAdditionalFields _that = (DTCCAdditionalFields)this.getType().cast(o);
            if (!Objects.equals(this.tradeParty1IDType, _that.getTradeParty1IDType())) {
                return false;
            }
            if (!Objects.equals(this.messageID, _that.getMessageID())) {
                return false;
            }
            if (!Objects.equals(this.leg1CommodityUnderlyerID, _that.getLeg1CommodityUnderlyerID())) {
                return false;
            }
            if (!Objects.equals(this.leg2CommodityUnderlyerID, _that.getLeg2CommodityUnderlyerID())) {
                return false;
            }
            if (!Objects.equals(this.changeInNotionalAmount1, _that.getChangeInNotionalAmount1())) {
                return false;
            }
            if (!Objects.equals(this.changeInNotionalAmount2, _that.getChangeInNotionalAmount2())) {
                return false;
            }
            if (!Objects.equals(this.largeNotionalOffFacilitySwapElectionIndicator, _that.getLargeNotionalOffFacilitySwapElectionIndicator())) {
                return false;
            }
            if (!Objects.equals(this.mandatoryClearingIndicator, _that.getMandatoryClearingIndicator())) {
                return false;
            }
            if (!Objects.equals(this.messageType, _that.getMessageType())) {
                return false;
            }
            if (!Objects.equals(this.originalSwapSDRIDType, _that.getOriginalSwapSDRIDType())) {
                return false;
            }
            if (!Objects.equals(this.physicalCommodityContractIndicator, _that.getPhysicalCommodityContractIndicator())) {
                return false;
            }
            if (!Objects.equals(this.sdMspIndicatorCounterparty1, _that.getSdMspIndicatorCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.sdMspIndicatorCounterparty2, _that.getSdMspIndicatorCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.sefOrDcmIndicator, _that.getSefOrDcmIndicator())) {
                return false;
            }
            return Objects.equals(this.version, _that.getVersion());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradeParty1IDType != null ? this.tradeParty1IDType.hashCode() : 0);
            _result = 31 * _result + (this.messageID != null ? this.messageID.hashCode() : 0);
            _result = 31 * _result + (this.leg1CommodityUnderlyerID != null ? this.leg1CommodityUnderlyerID.hashCode() : 0);
            _result = 31 * _result + (this.leg2CommodityUnderlyerID != null ? this.leg2CommodityUnderlyerID.hashCode() : 0);
            _result = 31 * _result + (this.changeInNotionalAmount1 != null ? this.changeInNotionalAmount1.hashCode() : 0);
            _result = 31 * _result + (this.changeInNotionalAmount2 != null ? this.changeInNotionalAmount2.hashCode() : 0);
            _result = 31 * _result + (this.largeNotionalOffFacilitySwapElectionIndicator != null ? this.largeNotionalOffFacilitySwapElectionIndicator.hashCode() : 0);
            _result = 31 * _result + (this.mandatoryClearingIndicator != null ? this.mandatoryClearingIndicator.hashCode() : 0);
            _result = 31 * _result + (this.messageType != null ? this.messageType.hashCode() : 0);
            _result = 31 * _result + (this.originalSwapSDRIDType != null ? this.originalSwapSDRIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.physicalCommodityContractIndicator != null ? this.physicalCommodityContractIndicator.hashCode() : 0);
            _result = 31 * _result + (this.sdMspIndicatorCounterparty1 != null ? this.sdMspIndicatorCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.sdMspIndicatorCounterparty2 != null ? this.sdMspIndicatorCounterparty2.hashCode() : 0);
            _result = 31 * _result + (this.sefOrDcmIndicator != null ? this.sefOrDcmIndicator.hashCode() : 0);
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DTCCAdditionalFields {tradeParty1IDType=" + this.tradeParty1IDType + ", messageID=" + this.messageID + ", leg1CommodityUnderlyerID=" + this.leg1CommodityUnderlyerID + ", leg2CommodityUnderlyerID=" + this.leg2CommodityUnderlyerID + ", changeInNotionalAmount1=" + String.valueOf(this.changeInNotionalAmount1) + ", changeInNotionalAmount2=" + String.valueOf(this.changeInNotionalAmount2) + ", largeNotionalOffFacilitySwapElectionIndicator=" + this.largeNotionalOffFacilitySwapElectionIndicator + ", mandatoryClearingIndicator=" + this.mandatoryClearingIndicator + ", messageType=" + this.messageType + ", originalSwapSDRIDType=" + String.valueOf(this.originalSwapSDRIDType) + ", physicalCommodityContractIndicator=" + this.physicalCommodityContractIndicator + ", sdMspIndicatorCounterparty1=" + this.sdMspIndicatorCounterparty1 + ", sdMspIndicatorCounterparty2=" + this.sdMspIndicatorCounterparty2 + ", sefOrDcmIndicator=" + this.sefOrDcmIndicator + ", version=" + this.version + "} " + super.toString();
        }
    }
}

