/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.meta.ASICPartyInformationMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ASICPartyInformation", builder=ASICPartyInformationBuilderImpl.class, version="7.0.0-dev.73")
@RuneDataType(value="ASICPartyInformation", model="drr", builder=ASICPartyInformationBuilderImpl.class, version="7.0.0-dev.73")
public interface ASICPartyInformation
extends RosettaModelObject {
    public static final ASICPartyInformationMeta metaData = new ASICPartyInformationMeta();

    public Boolean getNonReportedTradePortfolio();

    public Boolean getSmallScaleBuySideIndicator();

    public ASICPartyInformation build();

    public ASICPartyInformationBuilder toBuilder();

    public static ASICPartyInformationBuilder builder() {
        return new ASICPartyInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends ASICPartyInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ASICPartyInformation> getType() {
        return ASICPartyInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("nonReportedTradePortfolio"), Boolean.class, (Object)this.getNonReportedTradePortfolio(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("smallScaleBuySideIndicator"), Boolean.class, (Object)this.getSmallScaleBuySideIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ASICPartyInformationBuilderImpl
    implements ASICPartyInformationBuilder {
        protected Boolean nonReportedTradePortfolio;
        protected Boolean smallScaleBuySideIndicator;

        @Override
        @RosettaAttribute(value="nonReportedTradePortfolio")
        @RuneAttribute(value="nonReportedTradePortfolio")
        public Boolean getNonReportedTradePortfolio() {
            return this.nonReportedTradePortfolio;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideIndicator")
        @RuneAttribute(value="smallScaleBuySideIndicator")
        public Boolean getSmallScaleBuySideIndicator() {
            return this.smallScaleBuySideIndicator;
        }

        @Override
        @RosettaAttribute(value="nonReportedTradePortfolio")
        @RuneAttribute(value="nonReportedTradePortfolio")
        public ASICPartyInformationBuilder setNonReportedTradePortfolio(Boolean _nonReportedTradePortfolio) {
            this.nonReportedTradePortfolio = _nonReportedTradePortfolio == null ? null : _nonReportedTradePortfolio;
            return this;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideIndicator")
        @RuneAttribute(value="smallScaleBuySideIndicator")
        public ASICPartyInformationBuilder setSmallScaleBuySideIndicator(Boolean _smallScaleBuySideIndicator) {
            this.smallScaleBuySideIndicator = _smallScaleBuySideIndicator == null ? null : _smallScaleBuySideIndicator;
            return this;
        }

        @Override
        public ASICPartyInformation build() {
            return new ASICPartyInformationImpl(this);
        }

        @Override
        public ASICPartyInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public ASICPartyInformationBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getNonReportedTradePortfolio() != null) {
                return true;
            }
            return this.getSmallScaleBuySideIndicator() != null;
        }

        public ASICPartyInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ASICPartyInformationBuilder o = (ASICPartyInformationBuilder)other;
            merger.mergeBasic((Object)this.getNonReportedTradePortfolio(), (Object)o.getNonReportedTradePortfolio(), this::setNonReportedTradePortfolio, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSmallScaleBuySideIndicator(), (Object)o.getSmallScaleBuySideIndicator(), this::setSmallScaleBuySideIndicator, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ASICPartyInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.nonReportedTradePortfolio, _that.getNonReportedTradePortfolio())) {
                return false;
            }
            return Objects.equals(this.smallScaleBuySideIndicator, _that.getSmallScaleBuySideIndicator());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.nonReportedTradePortfolio != null ? this.nonReportedTradePortfolio.hashCode() : 0);
            _result = 31 * _result + (this.smallScaleBuySideIndicator != null ? this.smallScaleBuySideIndicator.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ASICPartyInformationBuilder {nonReportedTradePortfolio=" + this.nonReportedTradePortfolio + ", smallScaleBuySideIndicator=" + this.smallScaleBuySideIndicator + "}";
        }
    }

    public static interface ASICPartyInformationBuilder
    extends ASICPartyInformation,
    RosettaModelObjectBuilder {
        public ASICPartyInformationBuilder setNonReportedTradePortfolio(Boolean var1);

        public ASICPartyInformationBuilder setSmallScaleBuySideIndicator(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("nonReportedTradePortfolio"), Boolean.class, (Object)this.getNonReportedTradePortfolio(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("smallScaleBuySideIndicator"), Boolean.class, (Object)this.getSmallScaleBuySideIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ASICPartyInformationBuilder prune();
    }

    public static class ASICPartyInformationImpl
    implements ASICPartyInformation {
        private final Boolean nonReportedTradePortfolio;
        private final Boolean smallScaleBuySideIndicator;

        protected ASICPartyInformationImpl(ASICPartyInformationBuilder builder) {
            this.nonReportedTradePortfolio = builder.getNonReportedTradePortfolio();
            this.smallScaleBuySideIndicator = builder.getSmallScaleBuySideIndicator();
        }

        @Override
        @RosettaAttribute(value="nonReportedTradePortfolio")
        @RuneAttribute(value="nonReportedTradePortfolio")
        public Boolean getNonReportedTradePortfolio() {
            return this.nonReportedTradePortfolio;
        }

        @Override
        @RosettaAttribute(value="smallScaleBuySideIndicator")
        @RuneAttribute(value="smallScaleBuySideIndicator")
        public Boolean getSmallScaleBuySideIndicator() {
            return this.smallScaleBuySideIndicator;
        }

        @Override
        public ASICPartyInformation build() {
            return this;
        }

        @Override
        public ASICPartyInformationBuilder toBuilder() {
            ASICPartyInformationBuilder builder = ASICPartyInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ASICPartyInformationBuilder builder) {
            Optional.ofNullable(this.getNonReportedTradePortfolio()).ifPresent(builder::setNonReportedTradePortfolio);
            Optional.ofNullable(this.getSmallScaleBuySideIndicator()).ifPresent(builder::setSmallScaleBuySideIndicator);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ASICPartyInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.nonReportedTradePortfolio, _that.getNonReportedTradePortfolio())) {
                return false;
            }
            return Objects.equals(this.smallScaleBuySideIndicator, _that.getSmallScaleBuySideIndicator());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.nonReportedTradePortfolio != null ? this.nonReportedTradePortfolio.hashCode() : 0);
            _result = 31 * _result + (this.smallScaleBuySideIndicator != null ? this.smallScaleBuySideIndicator.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ASICPartyInformation {nonReportedTradePortfolio=" + this.nonReportedTradePortfolio + ", smallScaleBuySideIndicator=" + this.smallScaleBuySideIndicator + "}";
        }
    }
}

