/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.CFTCEntityClassificationEnum;
import drr.regulation.common.CFTCFederalEntityClassificationEnum;
import drr.regulation.common.CFTCFinancialEntityClassificationEnum;
import drr.regulation.common.meta.CFTCPartyInformationMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CFTCPartyInformation", builder=CFTCPartyInformationBuilderImpl.class, version="7.0.0-dev.73")
@RuneDataType(value="CFTCPartyInformation", model="drr", builder=CFTCPartyInformationBuilderImpl.class, version="7.0.0-dev.73")
public interface CFTCPartyInformation
extends RosettaModelObject {
    public static final CFTCPartyInformationMeta metaData = new CFTCPartyInformationMeta();

    public CFTCEntityClassificationEnum getOrganizationType();

    public CFTCFederalEntityClassificationEnum getFederalEntity();

    public CFTCFinancialEntityClassificationEnum getFinancialEntity();

    public Boolean getPhysicalCommodityContractIndicator();

    public Boolean getIsUSPerson();

    public Boolean getNonReportedTradePortfolio();

    public CFTCPartyInformation build();

    public CFTCPartyInformationBuilder toBuilder();

    public static CFTCPartyInformationBuilder builder() {
        return new CFTCPartyInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends CFTCPartyInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CFTCPartyInformation> getType() {
        return CFTCPartyInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("organizationType"), CFTCEntityClassificationEnum.class, (Object)this.getOrganizationType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("federalEntity"), CFTCFederalEntityClassificationEnum.class, (Object)this.getFederalEntity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("financialEntity"), CFTCFinancialEntityClassificationEnum.class, (Object)this.getFinancialEntity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("physicalCommodityContractIndicator"), Boolean.class, (Object)this.getPhysicalCommodityContractIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isUSPerson"), Boolean.class, (Object)this.getIsUSPerson(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonReportedTradePortfolio"), Boolean.class, (Object)this.getNonReportedTradePortfolio(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CFTCPartyInformationBuilderImpl
    implements CFTCPartyInformationBuilder {
        protected CFTCEntityClassificationEnum organizationType;
        protected CFTCFederalEntityClassificationEnum federalEntity;
        protected CFTCFinancialEntityClassificationEnum financialEntity;
        protected Boolean physicalCommodityContractIndicator;
        protected Boolean isUSPerson;
        protected Boolean nonReportedTradePortfolio;

        @Override
        @RosettaAttribute(value="organizationType")
        @RuneAttribute(value="organizationType")
        public CFTCEntityClassificationEnum getOrganizationType() {
            return this.organizationType;
        }

        @Override
        @RosettaAttribute(value="federalEntity")
        @RuneAttribute(value="federalEntity")
        public CFTCFederalEntityClassificationEnum getFederalEntity() {
            return this.federalEntity;
        }

        @Override
        @RosettaAttribute(value="financialEntity")
        @RuneAttribute(value="financialEntity")
        public CFTCFinancialEntityClassificationEnum getFinancialEntity() {
            return this.financialEntity;
        }

        @Override
        @RosettaAttribute(value="physicalCommodityContractIndicator")
        @RuneAttribute(value="physicalCommodityContractIndicator")
        public Boolean getPhysicalCommodityContractIndicator() {
            return this.physicalCommodityContractIndicator;
        }

        @Override
        @RosettaAttribute(value="isUSPerson")
        @RuneAttribute(value="isUSPerson")
        public Boolean getIsUSPerson() {
            return this.isUSPerson;
        }

        @Override
        @RosettaAttribute(value="nonReportedTradePortfolio")
        @RuneAttribute(value="nonReportedTradePortfolio")
        public Boolean getNonReportedTradePortfolio() {
            return this.nonReportedTradePortfolio;
        }

        @Override
        @RosettaAttribute(value="organizationType")
        @RuneAttribute(value="organizationType")
        public CFTCPartyInformationBuilder setOrganizationType(CFTCEntityClassificationEnum _organizationType) {
            this.organizationType = _organizationType == null ? null : _organizationType;
            return this;
        }

        @Override
        @RosettaAttribute(value="federalEntity")
        @RuneAttribute(value="federalEntity")
        public CFTCPartyInformationBuilder setFederalEntity(CFTCFederalEntityClassificationEnum _federalEntity) {
            this.federalEntity = _federalEntity == null ? null : _federalEntity;
            return this;
        }

        @Override
        @RosettaAttribute(value="financialEntity")
        @RuneAttribute(value="financialEntity")
        public CFTCPartyInformationBuilder setFinancialEntity(CFTCFinancialEntityClassificationEnum _financialEntity) {
            this.financialEntity = _financialEntity == null ? null : _financialEntity;
            return this;
        }

        @Override
        @RosettaAttribute(value="physicalCommodityContractIndicator")
        @RuneAttribute(value="physicalCommodityContractIndicator")
        public CFTCPartyInformationBuilder setPhysicalCommodityContractIndicator(Boolean _physicalCommodityContractIndicator) {
            this.physicalCommodityContractIndicator = _physicalCommodityContractIndicator == null ? null : _physicalCommodityContractIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="isUSPerson")
        @RuneAttribute(value="isUSPerson")
        public CFTCPartyInformationBuilder setIsUSPerson(Boolean _isUSPerson) {
            this.isUSPerson = _isUSPerson == null ? null : _isUSPerson;
            return this;
        }

        @Override
        @RosettaAttribute(value="nonReportedTradePortfolio")
        @RuneAttribute(value="nonReportedTradePortfolio")
        public CFTCPartyInformationBuilder setNonReportedTradePortfolio(Boolean _nonReportedTradePortfolio) {
            this.nonReportedTradePortfolio = _nonReportedTradePortfolio == null ? null : _nonReportedTradePortfolio;
            return this;
        }

        @Override
        public CFTCPartyInformation build() {
            return new CFTCPartyInformationImpl(this);
        }

        @Override
        public CFTCPartyInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public CFTCPartyInformationBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getOrganizationType() != null) {
                return true;
            }
            if (this.getFederalEntity() != null) {
                return true;
            }
            if (this.getFinancialEntity() != null) {
                return true;
            }
            if (this.getPhysicalCommodityContractIndicator() != null) {
                return true;
            }
            if (this.getIsUSPerson() != null) {
                return true;
            }
            return this.getNonReportedTradePortfolio() != null;
        }

        public CFTCPartyInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CFTCPartyInformationBuilder o = (CFTCPartyInformationBuilder)other;
            merger.mergeBasic((Object)this.getOrganizationType(), (Object)o.getOrganizationType(), this::setOrganizationType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFederalEntity(), (Object)o.getFederalEntity(), this::setFederalEntity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFinancialEntity(), (Object)o.getFinancialEntity(), this::setFinancialEntity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPhysicalCommodityContractIndicator(), (Object)o.getPhysicalCommodityContractIndicator(), this::setPhysicalCommodityContractIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIsUSPerson(), (Object)o.getIsUSPerson(), this::setIsUSPerson, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNonReportedTradePortfolio(), (Object)o.getNonReportedTradePortfolio(), this::setNonReportedTradePortfolio, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CFTCPartyInformation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.organizationType, (Object)_that.getOrganizationType())) {
                return false;
            }
            if (!Objects.equals((Object)this.federalEntity, (Object)_that.getFederalEntity())) {
                return false;
            }
            if (!Objects.equals((Object)this.financialEntity, (Object)_that.getFinancialEntity())) {
                return false;
            }
            if (!Objects.equals(this.physicalCommodityContractIndicator, _that.getPhysicalCommodityContractIndicator())) {
                return false;
            }
            if (!Objects.equals(this.isUSPerson, _that.getIsUSPerson())) {
                return false;
            }
            return Objects.equals(this.nonReportedTradePortfolio, _that.getNonReportedTradePortfolio());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.organizationType != null ? ((Object)((Object)this.organizationType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.federalEntity != null ? ((Object)((Object)this.federalEntity)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.financialEntity != null ? ((Object)((Object)this.financialEntity)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.physicalCommodityContractIndicator != null ? this.physicalCommodityContractIndicator.hashCode() : 0);
            _result = 31 * _result + (this.isUSPerson != null ? this.isUSPerson.hashCode() : 0);
            _result = 31 * _result + (this.nonReportedTradePortfolio != null ? this.nonReportedTradePortfolio.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CFTCPartyInformationBuilder {organizationType=" + String.valueOf((Object)this.organizationType) + ", federalEntity=" + String.valueOf((Object)this.federalEntity) + ", financialEntity=" + String.valueOf((Object)this.financialEntity) + ", physicalCommodityContractIndicator=" + this.physicalCommodityContractIndicator + ", isUSPerson=" + this.isUSPerson + ", nonReportedTradePortfolio=" + this.nonReportedTradePortfolio + "}";
        }
    }

    public static interface CFTCPartyInformationBuilder
    extends CFTCPartyInformation,
    RosettaModelObjectBuilder {
        public CFTCPartyInformationBuilder setOrganizationType(CFTCEntityClassificationEnum var1);

        public CFTCPartyInformationBuilder setFederalEntity(CFTCFederalEntityClassificationEnum var1);

        public CFTCPartyInformationBuilder setFinancialEntity(CFTCFinancialEntityClassificationEnum var1);

        public CFTCPartyInformationBuilder setPhysicalCommodityContractIndicator(Boolean var1);

        public CFTCPartyInformationBuilder setIsUSPerson(Boolean var1);

        public CFTCPartyInformationBuilder setNonReportedTradePortfolio(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("organizationType"), CFTCEntityClassificationEnum.class, (Object)this.getOrganizationType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("federalEntity"), CFTCFederalEntityClassificationEnum.class, (Object)this.getFederalEntity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("financialEntity"), CFTCFinancialEntityClassificationEnum.class, (Object)this.getFinancialEntity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("physicalCommodityContractIndicator"), Boolean.class, (Object)this.getPhysicalCommodityContractIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isUSPerson"), Boolean.class, (Object)this.getIsUSPerson(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonReportedTradePortfolio"), Boolean.class, (Object)this.getNonReportedTradePortfolio(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CFTCPartyInformationBuilder prune();
    }

    public static class CFTCPartyInformationImpl
    implements CFTCPartyInformation {
        private final CFTCEntityClassificationEnum organizationType;
        private final CFTCFederalEntityClassificationEnum federalEntity;
        private final CFTCFinancialEntityClassificationEnum financialEntity;
        private final Boolean physicalCommodityContractIndicator;
        private final Boolean isUSPerson;
        private final Boolean nonReportedTradePortfolio;

        protected CFTCPartyInformationImpl(CFTCPartyInformationBuilder builder) {
            this.organizationType = builder.getOrganizationType();
            this.federalEntity = builder.getFederalEntity();
            this.financialEntity = builder.getFinancialEntity();
            this.physicalCommodityContractIndicator = builder.getPhysicalCommodityContractIndicator();
            this.isUSPerson = builder.getIsUSPerson();
            this.nonReportedTradePortfolio = builder.getNonReportedTradePortfolio();
        }

        @Override
        @RosettaAttribute(value="organizationType")
        @RuneAttribute(value="organizationType")
        public CFTCEntityClassificationEnum getOrganizationType() {
            return this.organizationType;
        }

        @Override
        @RosettaAttribute(value="federalEntity")
        @RuneAttribute(value="federalEntity")
        public CFTCFederalEntityClassificationEnum getFederalEntity() {
            return this.federalEntity;
        }

        @Override
        @RosettaAttribute(value="financialEntity")
        @RuneAttribute(value="financialEntity")
        public CFTCFinancialEntityClassificationEnum getFinancialEntity() {
            return this.financialEntity;
        }

        @Override
        @RosettaAttribute(value="physicalCommodityContractIndicator")
        @RuneAttribute(value="physicalCommodityContractIndicator")
        public Boolean getPhysicalCommodityContractIndicator() {
            return this.physicalCommodityContractIndicator;
        }

        @Override
        @RosettaAttribute(value="isUSPerson")
        @RuneAttribute(value="isUSPerson")
        public Boolean getIsUSPerson() {
            return this.isUSPerson;
        }

        @Override
        @RosettaAttribute(value="nonReportedTradePortfolio")
        @RuneAttribute(value="nonReportedTradePortfolio")
        public Boolean getNonReportedTradePortfolio() {
            return this.nonReportedTradePortfolio;
        }

        @Override
        public CFTCPartyInformation build() {
            return this;
        }

        @Override
        public CFTCPartyInformationBuilder toBuilder() {
            CFTCPartyInformationBuilder builder = CFTCPartyInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CFTCPartyInformationBuilder builder) {
            Optional.ofNullable(this.getOrganizationType()).ifPresent(builder::setOrganizationType);
            Optional.ofNullable(this.getFederalEntity()).ifPresent(builder::setFederalEntity);
            Optional.ofNullable(this.getFinancialEntity()).ifPresent(builder::setFinancialEntity);
            Optional.ofNullable(this.getPhysicalCommodityContractIndicator()).ifPresent(builder::setPhysicalCommodityContractIndicator);
            Optional.ofNullable(this.getIsUSPerson()).ifPresent(builder::setIsUSPerson);
            Optional.ofNullable(this.getNonReportedTradePortfolio()).ifPresent(builder::setNonReportedTradePortfolio);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CFTCPartyInformation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.organizationType, (Object)_that.getOrganizationType())) {
                return false;
            }
            if (!Objects.equals((Object)this.federalEntity, (Object)_that.getFederalEntity())) {
                return false;
            }
            if (!Objects.equals((Object)this.financialEntity, (Object)_that.getFinancialEntity())) {
                return false;
            }
            if (!Objects.equals(this.physicalCommodityContractIndicator, _that.getPhysicalCommodityContractIndicator())) {
                return false;
            }
            if (!Objects.equals(this.isUSPerson, _that.getIsUSPerson())) {
                return false;
            }
            return Objects.equals(this.nonReportedTradePortfolio, _that.getNonReportedTradePortfolio());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.organizationType != null ? ((Object)((Object)this.organizationType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.federalEntity != null ? ((Object)((Object)this.federalEntity)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.financialEntity != null ? ((Object)((Object)this.financialEntity)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.physicalCommodityContractIndicator != null ? this.physicalCommodityContractIndicator.hashCode() : 0);
            _result = 31 * _result + (this.isUSPerson != null ? this.isUSPerson.hashCode() : 0);
            _result = 31 * _result + (this.nonReportedTradePortfolio != null ? this.nonReportedTradePortfolio.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CFTCPartyInformation {organizationType=" + String.valueOf((Object)this.organizationType) + ", federalEntity=" + String.valueOf((Object)this.federalEntity) + ", financialEntity=" + String.valueOf((Object)this.financialEntity) + ", physicalCommodityContractIndicator=" + this.physicalCommodityContractIndicator + ", isUSPerson=" + this.isUSPerson + ", nonReportedTradePortfolio=" + this.nonReportedTradePortfolio + "}";
        }
    }
}

