/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import cdm.base.staticdata.identifier.Identifier;
import cdm.product.collateral.Collateral;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ValuationDetails;
import drr.regulation.common.meta.ReportableValuationMeta;
import drr.standards.iso.ReportLevelEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ReportableValuation", builder=ReportableValuationBuilderImpl.class, version="7.0.0-dev.73")
@RuneDataType(value="ReportableValuation", model="drr", builder=ReportableValuationBuilderImpl.class, version="7.0.0-dev.73")
public interface ReportableValuation
extends RosettaModelObject {
    public static final ReportableValuationMeta metaData = new ReportableValuationMeta();

    public ValuationDetails getValuationDetails();

    public ReportableInformation getReportableInformation();

    public Collateral getCollateralDetails();

    public List<? extends Identifier> getEventIdentifier();

    public ReportLevelEnum getLevel();

    public ReportableValuation build();

    public ReportableValuationBuilder toBuilder();

    public static ReportableValuationBuilder builder() {
        return new ReportableValuationBuilderImpl();
    }

    default public RosettaMetaData<? extends ReportableValuation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReportableValuation> getType() {
        return ReportableValuation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("valuationDetails"), processor, ValuationDetails.class, this.getValuationDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.class, this.getReportableInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralDetails"), processor, Collateral.class, (RosettaModelObject)this.getCollateralDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, Identifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ReportableValuationBuilderImpl
    implements ReportableValuationBuilder {
        protected ValuationDetails.ValuationDetailsBuilder valuationDetails;
        protected ReportableInformation.ReportableInformationBuilder reportableInformation;
        protected Collateral.CollateralBuilder collateralDetails;
        protected List<Identifier.IdentifierBuilder> eventIdentifier = new ArrayList<Identifier.IdentifierBuilder>();
        protected ReportLevelEnum level;

        @Override
        @RosettaAttribute(value="valuationDetails")
        @RuneAttribute(value="valuationDetails")
        public ValuationDetails.ValuationDetailsBuilder getValuationDetails() {
            return this.valuationDetails;
        }

        @Override
        public ValuationDetails.ValuationDetailsBuilder getOrCreateValuationDetails() {
            ValuationDetails.ValuationDetailsBuilder result = this.valuationDetails != null ? this.valuationDetails : (this.valuationDetails = ValuationDetails.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportableInformation", isRequired=true)
        @RuneAttribute(value="reportableInformation", isRequired=true)
        public ReportableInformation.ReportableInformationBuilder getReportableInformation() {
            return this.reportableInformation;
        }

        @Override
        public ReportableInformation.ReportableInformationBuilder getOrCreateReportableInformation() {
            ReportableInformation.ReportableInformationBuilder result = this.reportableInformation != null ? this.reportableInformation : (this.reportableInformation = ReportableInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralDetails")
        @RuneAttribute(value="collateralDetails")
        public Collateral.CollateralBuilder getCollateralDetails() {
            return this.collateralDetails;
        }

        @Override
        public Collateral.CollateralBuilder getOrCreateCollateralDetails() {
            Collateral.CollateralBuilder result = this.collateralDetails != null ? this.collateralDetails : (this.collateralDetails = Collateral.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public List<? extends Identifier.IdentifierBuilder> getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        public Identifier.IdentifierBuilder getOrCreateEventIdentifier(int index) {
            if (this.eventIdentifier == null) {
                this.eventIdentifier = new ArrayList<Identifier.IdentifierBuilder>();
            }
            return (Identifier.IdentifierBuilder)this.getIndex(this.eventIdentifier, index, () -> {
                Identifier.IdentifierBuilder newEventIdentifier = Identifier.builder();
                return newEventIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public ReportLevelEnum getLevel() {
            return this.level;
        }

        @Override
        @RosettaAttribute(value="valuationDetails")
        @RuneAttribute(value="valuationDetails")
        public ReportableValuationBuilder setValuationDetails(ValuationDetails _valuationDetails) {
            this.valuationDetails = _valuationDetails == null ? null : _valuationDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportableInformation", isRequired=true)
        @RuneAttribute(value="reportableInformation", isRequired=true)
        public ReportableValuationBuilder setReportableInformation(ReportableInformation _reportableInformation) {
            this.reportableInformation = _reportableInformation == null ? null : _reportableInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralDetails")
        @RuneAttribute(value="collateralDetails")
        public ReportableValuationBuilder setCollateralDetails(Collateral _collateralDetails) {
            this.collateralDetails = _collateralDetails == null ? null : _collateralDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public ReportableValuationBuilder addEventIdentifier(Identifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ReportableValuationBuilder addEventIdentifier(Identifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public ReportableValuationBuilder addEventIdentifier(List<? extends Identifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (Identifier identifier : eventIdentifiers) {
                    this.eventIdentifier.add(identifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public ReportableValuationBuilder setEventIdentifier(List<? extends Identifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList<Identifier.IdentifierBuilder>() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public ReportableValuationBuilder setLevel(ReportLevelEnum _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        public ReportableValuation build() {
            return new ReportableValuationImpl(this);
        }

        @Override
        public ReportableValuationBuilder toBuilder() {
            return this;
        }

        @Override
        public ReportableValuationBuilder prune() {
            if (this.valuationDetails != null && !this.valuationDetails.prune().hasData()) {
                this.valuationDetails = null;
            }
            if (this.reportableInformation != null && !this.reportableInformation.prune().hasData()) {
                this.reportableInformation = null;
            }
            if (this.collateralDetails != null && !this.collateralDetails.prune().hasData()) {
                this.collateralDetails = null;
            }
            this.eventIdentifier = this.eventIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getValuationDetails() != null && this.getValuationDetails().hasData()) {
                return true;
            }
            if (this.getReportableInformation() != null && this.getReportableInformation().hasData()) {
                return true;
            }
            if (this.getCollateralDetails() != null && this.getCollateralDetails().hasData()) {
                return true;
            }
            if (this.getEventIdentifier() != null && this.getEventIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getLevel() != null;
        }

        public ReportableValuationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReportableValuationBuilder o = (ReportableValuationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationDetails(), (RosettaModelObjectBuilder)o.getValuationDetails(), this::setValuationDetails);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportableInformation(), (RosettaModelObjectBuilder)o.getReportableInformation(), this::setReportableInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralDetails(), (RosettaModelObjectBuilder)o.getCollateralDetails(), this::setCollateralDetails);
            merger.mergeRosetta(this.getEventIdentifier(), o.getEventIdentifier(), this::getOrCreateEventIdentifier);
            merger.mergeBasic((Object)this.getLevel(), (Object)o.getLevel(), this::setLevel, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReportableValuation _that = this.getType().cast(o);
            if (!Objects.equals(this.valuationDetails, _that.getValuationDetails())) {
                return false;
            }
            if (!Objects.equals(this.reportableInformation, _that.getReportableInformation())) {
                return false;
            }
            if (!Objects.equals(this.collateralDetails, _that.getCollateralDetails())) {
                return false;
            }
            if (!ListEquals.listEquals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            return Objects.equals((Object)this.level, (Object)_that.getLevel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.valuationDetails != null ? this.valuationDetails.hashCode() : 0);
            _result = 31 * _result + (this.reportableInformation != null ? this.reportableInformation.hashCode() : 0);
            _result = 31 * _result + (this.collateralDetails != null ? this.collateralDetails.hashCode() : 0);
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.level != null ? ((Object)((Object)this.level)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReportableValuationBuilder {valuationDetails=" + String.valueOf(this.valuationDetails) + ", reportableInformation=" + String.valueOf(this.reportableInformation) + ", collateralDetails=" + String.valueOf(this.collateralDetails) + ", eventIdentifier=" + String.valueOf(this.eventIdentifier) + ", level=" + String.valueOf((Object)this.level) + "}";
        }
    }

    public static interface ReportableValuationBuilder
    extends ReportableValuation,
    RosettaModelObjectBuilder {
        public ValuationDetails.ValuationDetailsBuilder getOrCreateValuationDetails();

        @Override
        public ValuationDetails.ValuationDetailsBuilder getValuationDetails();

        public ReportableInformation.ReportableInformationBuilder getOrCreateReportableInformation();

        @Override
        public ReportableInformation.ReportableInformationBuilder getReportableInformation();

        public Collateral.CollateralBuilder getOrCreateCollateralDetails();

        public Collateral.CollateralBuilder getCollateralDetails();

        public Identifier.IdentifierBuilder getOrCreateEventIdentifier(int var1);

        public List<? extends Identifier.IdentifierBuilder> getEventIdentifier();

        public ReportableValuationBuilder setValuationDetails(ValuationDetails var1);

        public ReportableValuationBuilder setReportableInformation(ReportableInformation var1);

        public ReportableValuationBuilder setCollateralDetails(Collateral var1);

        public ReportableValuationBuilder addEventIdentifier(Identifier var1);

        public ReportableValuationBuilder addEventIdentifier(Identifier var1, int var2);

        public ReportableValuationBuilder addEventIdentifier(List<? extends Identifier> var1);

        public ReportableValuationBuilder setEventIdentifier(List<? extends Identifier> var1);

        public ReportableValuationBuilder setLevel(ReportLevelEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("valuationDetails"), processor, ValuationDetails.ValuationDetailsBuilder.class, this.getValuationDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.ReportableInformationBuilder.class, this.getReportableInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralDetails"), processor, Collateral.CollateralBuilder.class, (RosettaModelObjectBuilder)this.getCollateralDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, Identifier.IdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ReportableValuationBuilder prune();
    }

    public static class ReportableValuationImpl
    implements ReportableValuation {
        private final ValuationDetails valuationDetails;
        private final ReportableInformation reportableInformation;
        private final Collateral collateralDetails;
        private final List<? extends Identifier> eventIdentifier;
        private final ReportLevelEnum level;

        protected ReportableValuationImpl(ReportableValuationBuilder builder) {
            this.valuationDetails = Optional.ofNullable(builder.getValuationDetails()).map(f -> f.build()).orElse(null);
            this.reportableInformation = Optional.ofNullable(builder.getReportableInformation()).map(f -> f.build()).orElse(null);
            this.collateralDetails = Optional.ofNullable(builder.getCollateralDetails()).map(f -> f.build()).orElse(null);
            this.eventIdentifier = Optional.ofNullable(builder.getEventIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.level = builder.getLevel();
        }

        @Override
        @RosettaAttribute(value="valuationDetails")
        @RuneAttribute(value="valuationDetails")
        public ValuationDetails getValuationDetails() {
            return this.valuationDetails;
        }

        @Override
        @RosettaAttribute(value="reportableInformation", isRequired=true)
        @RuneAttribute(value="reportableInformation", isRequired=true)
        public ReportableInformation getReportableInformation() {
            return this.reportableInformation;
        }

        @Override
        @RosettaAttribute(value="collateralDetails")
        @RuneAttribute(value="collateralDetails")
        public Collateral getCollateralDetails() {
            return this.collateralDetails;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public List<? extends Identifier> getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public ReportLevelEnum getLevel() {
            return this.level;
        }

        @Override
        public ReportableValuation build() {
            return this;
        }

        @Override
        public ReportableValuationBuilder toBuilder() {
            ReportableValuationBuilder builder = ReportableValuation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReportableValuationBuilder builder) {
            Optional.ofNullable(this.getValuationDetails()).ifPresent(builder::setValuationDetails);
            Optional.ofNullable(this.getReportableInformation()).ifPresent(builder::setReportableInformation);
            Optional.ofNullable(this.getCollateralDetails()).ifPresent(builder::setCollateralDetails);
            Optional.ofNullable(this.getEventIdentifier()).ifPresent(builder::setEventIdentifier);
            Optional.ofNullable(this.getLevel()).ifPresent(builder::setLevel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReportableValuation _that = this.getType().cast(o);
            if (!Objects.equals(this.valuationDetails, _that.getValuationDetails())) {
                return false;
            }
            if (!Objects.equals(this.reportableInformation, _that.getReportableInformation())) {
                return false;
            }
            if (!Objects.equals(this.collateralDetails, _that.getCollateralDetails())) {
                return false;
            }
            if (!ListEquals.listEquals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            return Objects.equals((Object)this.level, (Object)_that.getLevel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.valuationDetails != null ? this.valuationDetails.hashCode() : 0);
            _result = 31 * _result + (this.reportableInformation != null ? this.reportableInformation.hashCode() : 0);
            _result = 31 * _result + (this.collateralDetails != null ? this.collateralDetails.hashCode() : 0);
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.level != null ? ((Object)((Object)this.level)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReportableValuation {valuationDetails=" + String.valueOf(this.valuationDetails) + ", reportableInformation=" + String.valueOf(this.reportableInformation) + ", collateralDetails=" + String.valueOf(this.collateralDetails) + ", eventIdentifier=" + String.valueOf(this.eventIdentifier) + ", level=" + String.valueOf((Object)this.level) + "}";
        }
    }
}

