/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.emir.contract.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.functions.ProductForEvent;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TradableOnTradingVenueEnum;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.emir.contract.functions.GetMicDataForFacility;
import drr.regulation.common.emir.contract.functions.IsEmirTradingVenue;
import drr.regulation.common.emir.contract.functions.IsSI;
import drr.regulation.common.functions.GetIsin;
import drr.regulation.common.functions.GetTransactionInformationForRegime;
import drr.standards.iosco.cde.version3.datetime.reports.ExecutionTimestampRule;
import drr.standards.iso.MicData;
import drr.standards.iso.MicTypeEnum;
import java.time.LocalDate;
import javax.inject.Inject;

@ImplementedBy(value=ExecutionISINDefault.class)
public abstract class ExecutionISIN
implements RosettaFunction {
    @Inject
    protected ExecutionTimestampRule executionTimestampRule;
    @Inject
    protected GetIsin getIsin;
    @Inject
    protected GetMicDataForFacility getMicDataForFacility;
    @Inject
    protected GetTransactionInformationForRegime getTransactionInformationForRegime;
    @Inject
    protected IsEmirTradingVenue isEmirTradingVenue;
    @Inject
    protected IsSI isSI;
    @Inject
    protected ProductForEvent productForEvent;

    public String evaluate(TransactionReportInstruction transaction, RegimeNameEnum regime) {
        String isin = this.doEvaluate(transaction, regime);
        return isin;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1, RegimeNameEnum var2);

    protected abstract MapperS<? extends MicData> micDataForFacility(TransactionReportInstruction var1, RegimeNameEnum var2);

    protected abstract MapperS<String> venueMic(TransactionReportInstruction var1, RegimeNameEnum var2);

    protected abstract MapperS<String> productIsin(TransactionReportInstruction var1, RegimeNameEnum var2);

    protected abstract MapperS<? extends TransactionInformation> transactionInformation(TransactionReportInstruction var1, RegimeNameEnum var2);

    protected abstract MapperS<Boolean> isinTotv(TransactionReportInstruction var1, RegimeNameEnum var2);

    public static class ExecutionISINDefault
    extends ExecutionISIN {
        @Override
        protected String doEvaluate(TransactionReportInstruction transaction, RegimeNameEnum regime) {
            String isin = null;
            return this.assignOutput(isin, transaction, regime);
        }

        protected String assignOutput(String isin, TransactionReportInstruction transaction, RegimeNameEnum regime) {
            isin = ExpressionOperators.exists(this.venueMic(transaction, regime)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperators.exists(this.productIsin(transaction, regime)).and(ComparisonResult.of((Mapper)MapperS.of((Object)this.isEmirTradingVenue.evaluate((MicData)this.micDataForFacility(transaction, regime).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (String)this.productIsin(transaction, regime).get() : (ComparisonResult.of((Mapper)MapperS.of((Object)this.isSI.evaluate((MicData)this.micDataForFacility(transaction, regime).get()))).and(ComparisonResult.of(this.isinTotv(transaction, regime))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (String)this.productIsin(transaction, regime).get() : null)) : (ExpressionOperators.exists(this.productIsin(transaction, regime)).and(ComparisonResult.of(this.isinTotv(transaction, regime))).getOrDefault(Boolean.valueOf(false)) != false ? (String)this.productIsin(transaction, regime).get() : null);
            return isin;
        }

        @Override
        protected MapperS<? extends MicData> micDataForFacility(TransactionReportInstruction transaction, RegimeNameEnum regime) {
            return MapperS.of((Object)this.getMicDataForFacility.evaluate((ReportableInformation)MapperS.of((Object)transaction).map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get()));
        }

        @Override
        protected MapperS<String> venueMic(TransactionReportInstruction transaction, RegimeNameEnum regime) {
            MapperS<? extends MicData> thenArg = this.micDataForFacility(transaction, regime);
            return thenArg.mapSingleToItem(item -> {
                if (ExpressionOperators.areEqual((Mapper)item.map("getStatus", micData -> micData.getStatus()), (Mapper)MapperS.of((Object)"EXPIRED"), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.lessThanEquals((Mapper)item.map("getExpiryDate", micData -> micData.getExpiryDate()), (Mapper)MapperS.of((Object)this.executionTimestampRule.evaluate(transaction)).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.notEqual((Mapper)item.map("getStatus", micData -> micData.getStatus()), (Mapper)MapperS.of((Object)"EXPIRED"), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperators.areEqual((Mapper)item.map("getMicType", micData -> micData.getMicType()), (Mapper)MapperS.of((Object)((Object)MicTypeEnum.SGMT)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return item.map("getMic", micData -> micData.getMic());
                    }
                    return item.map("getOperatingMic", micData -> micData.getOperatingMic());
                }
                return MapperS.ofNull();
            });
        }

        @Override
        protected MapperS<String> productIsin(TransactionReportInstruction transaction, RegimeNameEnum regime) {
            return MapperS.of((Object)this.getIsin.evaluate(this.productForEvent.evaluate(transaction)));
        }

        @Override
        protected MapperS<? extends TransactionInformation> transactionInformation(TransactionReportInstruction transaction, RegimeNameEnum regime) {
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)regime)), (Mapper)MapperS.of((Object)((Object)RegimeNameEnum.UKEMIR)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.getTransactionInformationForRegime.evaluate(transaction, RegimeNameEnum.UKEMIR, SupervisoryBodyEnum.FCA));
            }
            return MapperS.of((Object)this.getTransactionInformationForRegime.evaluate(transaction, RegimeNameEnum.EMIR, SupervisoryBodyEnum.ESMA));
        }

        @Override
        protected MapperS<Boolean> isinTotv(TransactionReportInstruction transaction, RegimeNameEnum regime) {
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)regime)), (Mapper)MapperS.of((Object)((Object)RegimeNameEnum.UKEMIR)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)ExpressionOperators.areEqual((Mapper)this.transactionInformation(transaction, regime).map("getFcaTransactionInformation", _transactionInformation -> _transactionInformation.getFcaTransactionInformation()).map("getTradableOnTradingVenue", commonTransactionInformation -> commonTransactionInformation.getTradableOnTradingVenue()), (Mapper)MapperS.of((Object)((Object)TradableOnTradingVenueEnum.ADMITTED)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)));
            }
            return MapperS.of((Object)ExpressionOperators.areEqual((Mapper)this.transactionInformation(transaction, regime).map("getEsmaTransactionInformation", _transactionInformation -> _transactionInformation.getEsmaTransactionInformation()).map("getTradableOnTradingVenue", eSMATransactionInformation -> eSMATransactionInformation.getTradableOnTradingVenue()), (Mapper)MapperS.of((Object)((Object)TradableOnTradingVenueEnum.ADMITTED)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)));
        }
    }
}

