/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.emir.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.time.LocalDate;
import java.time.ZonedDateTime;

@ImplementedBy(value=EventDate_04_ValidationDefault.class)
public abstract class EventDate_04_Validation
implements RosettaFunction {
    public Boolean evaluate(Date eventDate, ZonedDateTime reportingTimestamp) {
        Boolean result = this.doEvaluate(eventDate, reportingTimestamp);
        return result;
    }

    protected abstract Boolean doEvaluate(Date var1, ZonedDateTime var2);

    public static class EventDate_04_ValidationDefault
    extends EventDate_04_Validation {
        @Override
        protected Boolean doEvaluate(Date eventDate, ZonedDateTime reportingTimestamp) {
            Boolean result = null;
            return this.assignOutput(result, eventDate, reportingTimestamp);
        }

        protected Boolean assignOutput(Boolean result, Date eventDate, ZonedDateTime reportingTimestamp) {
            result = ExpressionOperators.lessThanEquals((Mapper)MapperS.of((Object)eventDate), (Mapper)MapperS.of((Object)reportingTimestamp).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (CardinalityOperator)CardinalityOperator.All).get();
            return result;
        }
    }
}

