/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomyClassification;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.EconomicTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import javax.inject.Inject;

@ImplementedBy(value=ExtractCommodityClassificationDefault.class)
public abstract class ExtractCommodityClassification
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected Qualify_Commodity_Forward qualify_Commodity_Forward;
    @Inject
    protected Qualify_Commodity_Option qualify_Commodity_Option;
    @Inject
    protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
    @Inject
    protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
    @Inject
    protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;

    public String evaluate(EconomicTerms economicTerms, TaxonomySourceEnum taxonomySource, Integer ordinal) {
        String commodityClassification = this.doEvaluate(economicTerms, taxonomySource, ordinal);
        return commodityClassification;
    }

    protected abstract String doEvaluate(EconomicTerms var1, TaxonomySourceEnum var2, Integer var3);

    protected abstract MapperS<? extends ReferenceWithMetaCommodity> commodityUnderlier(EconomicTerms var1, TaxonomySourceEnum var2, Integer var3);

    protected abstract MapperC<? extends ProductTaxonomy> taxonomy(EconomicTerms var1, TaxonomySourceEnum var2, Integer var3);

    public static class ExtractCommodityClassificationDefault
    extends ExtractCommodityClassification {
        @Override
        protected String doEvaluate(EconomicTerms economicTerms, TaxonomySourceEnum taxonomySource, Integer ordinal) {
            String commodityClassification = null;
            return this.assignOutput(commodityClassification, economicTerms, taxonomySource, ordinal);
        }

        protected String assignOutput(String commodityClassification, EconomicTerms economicTerms, TaxonomySourceEnum taxonomySource, Integer ordinal) {
            MapperC thenArg = MapperS.of((Object)((ProductTaxonomy)this.taxonomy(economicTerms, taxonomySource, ordinal).get())).map("getValue", productTaxonomy -> productTaxonomy.getValue()).mapC("getClassification", taxonomyValue -> taxonomyValue.getClassification()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getOrdinal", taxonomyClassification -> taxonomyClassification.getOrdinal()), (Mapper)MapperS.of((Object)ordinal), (CardinalityOperator)CardinalityOperator.All).get());
            commodityClassification = (String)MapperS.of((Object)((TaxonomyClassification)thenArg.get())).map("getValue", taxonomyClassification -> taxonomyClassification.getValue()).get();
            return commodityClassification;
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaCommodity> commodityUnderlier(EconomicTerms economicTerms, TaxonomySourceEnum taxonomySource, Integer ordinal) {
            if (ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_FixedFloat.evaluate(economicTerms))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_Basis.evaluate(economicTerms)))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)economicTerms).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).first().map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", product -> product.getCommodity());
            }
            Boolean boolean0 = this.qualify_Commodity_Option.evaluate(economicTerms);
            if (boolean0 != null && boolean0.booleanValue()) {
                return MapperS.of((Object)((OptionPayout)MapperS.of((Object)economicTerms).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).map("getCommodity", product -> product.getCommodity());
            }
            Boolean boolean1 = this.qualify_Commodity_Swaption.evaluate(economicTerms);
            if (boolean1 != null && boolean1.booleanValue()) {
                return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)MapperS.of((Object)((OptionPayout)MapperS.of((Object)economicTerms).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).get())).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).first().map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", product -> product.getCommodity());
            }
            Boolean boolean2 = this.qualify_Commodity_Forward.evaluate(economicTerms);
            if (boolean2 != null && boolean2.booleanValue()) {
                return MapperS.of((Object)((ForwardPayout)MapperS.of((Object)economicTerms).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).map("getCommodity", product -> product.getCommodity());
            }
            return MapperS.of((Object)((CommodityPayout)MapperS.of((Object)economicTerms).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", product -> product.getCommodity());
        }

        @Override
        protected MapperC<? extends ProductTaxonomy> taxonomy(EconomicTerms economicTerms, TaxonomySourceEnum taxonomySource, Integer ordinal) {
            return this.commodityUnderlier(economicTerms, taxonomySource, ordinal).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).mapC("getProductTaxonomy", commodity -> commodity.getProductTaxonomy()).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getSource", productTaxonomy -> productTaxonomy.getSource()), (Mapper)MapperS.of((Object)taxonomySource), (CardinalityOperator)CardinalityOperator.All).get());
        }
    }
}

