/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.TradeForEvent;
import drr.regulation.common.ReportableEvent;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ExtractTradeCounterpartyDefault.class)
public abstract class ExtractTradeCounterparty
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ExtractCounterpartyByRole extractCounterpartyByRole;
    @Inject
    protected TradeForEvent tradeForEvent;

    public Counterparty evaluate(ReportableEvent reportableEvent, CounterpartyRoleEnum role) {
        Counterparty counterparty;
        Counterparty.CounterpartyBuilder counterpartyBuilder = this.doEvaluate(reportableEvent, role);
        if (counterpartyBuilder == null) {
            counterparty = null;
        } else {
            counterparty = counterpartyBuilder.build();
            this.objectValidator.validate(Counterparty.class, (RosettaModelObject)counterparty);
        }
        return counterparty;
    }

    protected abstract Counterparty.CounterpartyBuilder doEvaluate(ReportableEvent var1, CounterpartyRoleEnum var2);

    protected abstract MapperC<? extends Counterparty> counterparties(ReportableEvent var1, CounterpartyRoleEnum var2);

    public static class ExtractTradeCounterpartyDefault
    extends ExtractTradeCounterparty {
        @Override
        protected Counterparty.CounterpartyBuilder doEvaluate(ReportableEvent reportableEvent, CounterpartyRoleEnum role) {
            Counterparty.CounterpartyBuilder counterparty = Counterparty.builder();
            return this.assignOutput(counterparty, reportableEvent, role);
        }

        protected Counterparty.CounterpartyBuilder assignOutput(Counterparty.CounterpartyBuilder counterparty, ReportableEvent reportableEvent, CounterpartyRoleEnum role) {
            counterparty = (Counterparty.CounterpartyBuilder)this.toBuilder((RosettaModelObject)this.extractCounterpartyByRole.evaluate(this.counterparties(reportableEvent, role).getMulti(), role));
            return Optional.ofNullable(counterparty).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends Counterparty> counterparties(ReportableEvent reportableEvent, CounterpartyRoleEnum role) {
            return MapperS.of((Object)this.tradeForEvent.evaluate(reportableEvent)).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty());
        }
    }
}

