/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCapFloor;
import drr.base.qualification.product.functions.IsCreditDefaultSwap;
import drr.base.qualification.product.functions.IsFixedFloatZeroCouponSwapKnownAmount;
import drr.base.qualification.product.functions.IsInterestRateBasis;
import drr.base.qualification.product.functions.IsInterestRateCrossCurrency;
import drr.base.qualification.product.functions.IsInterestRateFixedFixed;
import drr.base.qualification.product.functions.IsInterestRateFixedFloatSingleCurrency;
import drr.base.qualification.product.functions.IsInterestRateReturnSwap;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.InterestRateLeg1Basis;
import drr.regulation.common.functions.InterestRateLeg1CapFloor;
import drr.regulation.common.functions.InterestRateLeg1CrossCurrency;
import drr.regulation.common.functions.InterestRateLeg1FixedFixed;
import drr.regulation.common.functions.InterestRateLeg1FixedFloatSingleCurrency;
import drr.regulation.common.functions.InterestRateLeg1ZeroCouponSwapKnownAmount;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=InterestRateLeg1Default.class)
public abstract class InterestRateLeg1
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected InterestRateLeg1Basis interestRateLeg1Basis;
    @Inject
    protected InterestRateLeg1CapFloor interestRateLeg1CapFloor;
    @Inject
    protected InterestRateLeg1CrossCurrency interestRateLeg1CrossCurrency;
    @Inject
    protected InterestRateLeg1FixedFixed interestRateLeg1FixedFixed;
    @Inject
    protected InterestRateLeg1FixedFloatSingleCurrency interestRateLeg1FixedFloatSingleCurrency;
    @Inject
    protected InterestRateLeg1ZeroCouponSwapKnownAmount interestRateLeg1ZeroCouponSwapKnownAmount;
    @Inject
    protected IsCapFloor isCapFloor;
    @Inject
    protected IsCreditDefaultSwap isCreditDefaultSwap;
    @Inject
    protected IsFixedFloatZeroCouponSwapKnownAmount isFixedFloatZeroCouponSwapKnownAmount;
    @Inject
    protected IsInterestRateBasis isInterestRateBasis;
    @Inject
    protected IsInterestRateCrossCurrency isInterestRateCrossCurrency;
    @Inject
    protected IsInterestRateFixedFixed isInterestRateFixedFixed;
    @Inject
    protected IsInterestRateFixedFloatSingleCurrency isInterestRateFixedFloatSingleCurrency;
    @Inject
    protected IsInterestRateReturnSwap isInterestRateReturnSwap;

    public InterestRatePayout evaluate(Product product) {
        InterestRatePayout interestRateLeg1;
        InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1Builder = this.doEvaluate(product);
        if (interestRateLeg1Builder == null) {
            interestRateLeg1 = null;
        } else {
            interestRateLeg1 = interestRateLeg1Builder.build();
            this.objectValidator.validate(InterestRatePayout.class, (RosettaModelObject)interestRateLeg1);
        }
        return interestRateLeg1;
    }

    protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product var1);

    public static class InterestRateLeg1Default
    extends InterestRateLeg1 {
        @Override
        protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product) {
            InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1 = InterestRatePayout.builder();
            return this.assignOutput(interestRateLeg1, product);
        }

        protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder interestRateLeg1, Product product) {
            Boolean boolean7;
            Boolean boolean6;
            Boolean boolean5;
            Boolean boolean4;
            Boolean boolean3;
            Boolean boolean2;
            Boolean boolean1;
            Boolean boolean0 = this.isFixedFloatZeroCouponSwapKnownAmount.evaluate(product);
            interestRateLeg1 = boolean0 != null && boolean0.booleanValue() ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRateLeg1ZeroCouponSwapKnownAmount.evaluate(product)) : ((boolean1 = this.isInterestRateFixedFloatSingleCurrency.evaluate(product)) != null && boolean1.booleanValue() ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRateLeg1FixedFloatSingleCurrency.evaluate(product)) : ((boolean2 = this.isInterestRateCrossCurrency.evaluate(product)) != null && boolean2.booleanValue() ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRateLeg1CrossCurrency.evaluate(product)) : ((boolean3 = this.isInterestRateFixedFixed.evaluate(product)) != null && boolean3.booleanValue() ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRateLeg1FixedFixed.evaluate(product)) : ((boolean4 = this.isInterestRateBasis.evaluate(product)) != null && boolean4.booleanValue() ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRateLeg1Basis.evaluate(product)) : ((boolean5 = this.isCapFloor.evaluate(product)) != null && boolean5.booleanValue() ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRateLeg1CapFloor.evaluate(product)) : ((boolean6 = this.isCreditDefaultSwap.evaluate(product)) != null && boolean6.booleanValue() ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get()) : ((boolean7 = this.isInterestRateReturnSwap.evaluate(product)) != null && boolean7.booleanValue() ? (ExpressionOperators.exists((Mapper)MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getContractualProduct", _product -> _product.getContractualProduct())).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get()) : (ExpressionOperators.exists((Mapper)MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getSecurity", _product -> _product.getSecurity())).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((PerformancePayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get())).map("getUnderlier", performancePayout -> performancePayout.getUnderlier()).map("getSecurity", _product -> _product.getSecurity()).map("getEconomicTerms", security -> security.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get()) : null)) : null)))))));
            return Optional.ofNullable(interestRateLeg1).map(o -> o.prune()).orElse(null);
        }
    }
}

