/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.InterestRateReturnSwap;
import drr.base.qualification.product.functions.IsEquity;
import drr.base.qualification.product.functions.IsFixedFloatZeroCouponSwapKnownAmount;
import drr.base.qualification.product.functions.IsInterestRateBasis;
import drr.base.qualification.product.functions.IsInterestRateCrossCurrency;
import drr.base.qualification.product.functions.IsInterestRateFixedFixed;
import drr.base.qualification.product.functions.IsInterestRateFixedFloatSingleCurrency;
import drr.base.qualification.product.functions.IsTotalReturnSwapDebtUnderlier;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.InterestRateLeg2Basis;
import drr.regulation.common.functions.InterestRateLeg2CrossCurrency;
import drr.regulation.common.functions.InterestRateLeg2FixedFixed;
import drr.regulation.common.functions.InterestRateLeg2FixedFloatSingleCurrency;
import drr.regulation.common.functions.IsCreditTotalReturnSwap;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=InterestRateLeg2Default.class)
public abstract class InterestRateLeg2
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected InterestRateLeg2Basis interestRateLeg2Basis;
    @Inject
    protected InterestRateLeg2CrossCurrency interestRateLeg2CrossCurrency;
    @Inject
    protected InterestRateLeg2FixedFixed interestRateLeg2FixedFixed;
    @Inject
    protected InterestRateLeg2FixedFloatSingleCurrency interestRateLeg2FixedFloatSingleCurrency;
    @Inject
    protected InterestRateReturnSwap interestRateReturnSwap;
    @Inject
    protected IsCreditTotalReturnSwap isCreditTotalReturnSwap;
    @Inject
    protected IsEquity isEquity;
    @Inject
    protected IsFixedFloatZeroCouponSwapKnownAmount isFixedFloatZeroCouponSwapKnownAmount;
    @Inject
    protected IsInterestRateBasis isInterestRateBasis;
    @Inject
    protected IsInterestRateCrossCurrency isInterestRateCrossCurrency;
    @Inject
    protected IsInterestRateFixedFixed isInterestRateFixedFixed;
    @Inject
    protected IsInterestRateFixedFloatSingleCurrency isInterestRateFixedFloatSingleCurrency;
    @Inject
    protected IsTotalReturnSwapDebtUnderlier isTotalReturnSwapDebtUnderlier;

    public InterestRatePayout evaluate(Product product) {
        InterestRatePayout interestRateLeg2;
        InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2Builder = this.doEvaluate(product);
        if (interestRateLeg2Builder == null) {
            interestRateLeg2 = null;
        } else {
            interestRateLeg2 = interestRateLeg2Builder.build();
            this.objectValidator.validate(InterestRatePayout.class, (RosettaModelObject)interestRateLeg2);
        }
        return interestRateLeg2;
    }

    protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product var1);

    public static class InterestRateLeg2Default
    extends InterestRateLeg2 {
        @Override
        protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product) {
            InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2 = InterestRatePayout.builder();
            return this.assignOutput(interestRateLeg2, product);
        }

        protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2, Product product) {
            Boolean boolean3;
            Boolean boolean2;
            Boolean boolean1;
            Boolean boolean0;
            interestRateLeg2 = ComparisonResult.of((Mapper)MapperS.of((Object)this.isInterestRateFixedFloatSingleCurrency.evaluate(product))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isFixedFloatZeroCouponSwapKnownAmount.evaluate(product)))).getOrDefault(Boolean.valueOf(false)) != false ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRateLeg2FixedFloatSingleCurrency.evaluate(product)) : ((boolean0 = this.isInterestRateCrossCurrency.evaluate(product)) != null && boolean0 != false ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRateLeg2CrossCurrency.evaluate(product)) : ((boolean1 = this.isInterestRateFixedFixed.evaluate(product)) != null && boolean1 != false ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRateLeg2FixedFixed.evaluate(product)) : ((boolean2 = this.isInterestRateBasis.evaluate(product)) != null && boolean2 != false ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRateLeg2Basis.evaluate(product)) : ((boolean3 = this.isTotalReturnSwapDebtUnderlier.evaluate(product)) != null && boolean3 != false ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRateReturnSwap.evaluate(product)) : (ComparisonResult.of((Mapper)MapperS.of((Object)this.isEquity.evaluate(product))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.isCreditTotalReturnSwap.evaluate(product)))).getOrDefault(Boolean.valueOf(false)) != false ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get()) : null)))));
            return Optional.ofNullable(interestRateLeg2).map(o -> o.prune()).orElse(null);
        }
    }
}

