/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.ResetFrequencyPeriodToDays;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=InterestRateLeg2BasisDefault.class)
public abstract class InterestRateLeg2Basis
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected ResetFrequencyPeriodToDays resetFrequencyPeriodToDays;

    public InterestRatePayout evaluate(Product product) {
        InterestRatePayout interestRateLeg2;
        InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2Builder = this.doEvaluate(product);
        if (interestRateLeg2Builder == null) {
            interestRateLeg2 = null;
        } else {
            interestRateLeg2 = interestRateLeg2Builder.build();
            this.objectValidator.validate(InterestRatePayout.class, (RosettaModelObject)interestRateLeg2);
        }
        return interestRateLeg2;
    }

    protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> interestRatePayouts(Product var1);

    public static class InterestRateLeg2BasisDefault
    extends InterestRateLeg2Basis {
        @Override
        protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product) {
            InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2 = InterestRatePayout.builder();
            return this.assignOutput(interestRateLeg2, product);
        }

        protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2, Product product) {
            if (ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)ExpressionOperators.distinct((Mapper)this.interestRatePayouts(product).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getSpreadSchedule", floatingRateSpecification -> floatingRateSpecification.getSpreadSchedule()).map("getPrice", spreadSchedule -> spreadSchedule.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                interestRateLeg2 = (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRatePayouts(product).min(item -> item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getSpreadSchedule", floatingRateSpecification -> floatingRateSpecification.getSpreadSchedule()).map("getPrice", spreadSchedule -> spreadSchedule.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule == null ? null : referenceWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue())).get());
            } else if (ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)this.interestRatePayouts(product).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getSpreadSchedule", floatingRateSpecification -> floatingRateSpecification.getSpreadSchedule()).map("getPrice", spreadSchedule -> spreadSchedule.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue()).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)ExpressionOperators.distinct((Mapper)this.interestRatePayouts(product).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getSpreadSchedule", floatingRateSpecification -> floatingRateSpecification.getSpreadSchedule()).map("getPrice", spreadSchedule -> spreadSchedule.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All)).or(ExpressionOperators.notExists((Mapper)this.interestRatePayouts(product).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getSpreadSchedule", floatingRateSpecification -> floatingRateSpecification.getSpreadSchedule()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                interestRateLeg2 = ExpressionOperators.areEqual((Mapper)this.interestRatePayouts(product).min(item -> MapperS.of((Object)this.resetFrequencyPeriodToDays.evaluate((InterestRatePayout)item.get()))), (Mapper)this.interestRatePayouts(product).max(item -> MapperS.of((Object)this.resetFrequencyPeriodToDays.evaluate((InterestRatePayout)item.get()))), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRatePayouts(product).last().get()) : (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRatePayouts(product).max(item -> MapperS.of((Object)this.resetFrequencyPeriodToDays.evaluate((InterestRatePayout)item.get()))).get());
            } else if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)ExpressionOperators.distinct((Mapper)this.interestRatePayouts(product).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getSpreadSchedule", floatingRateSpecification -> floatingRateSpecification.getSpreadSchedule())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg = this.interestRatePayouts(product).filterItemNullSafe(item -> ExpressionOperators.notExists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getSpreadSchedule", floatingRateSpecification -> floatingRateSpecification.getSpreadSchedule()).map("getPrice", spreadSchedule -> spreadSchedule.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule == null ? null : referenceWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue())).get());
                interestRateLeg2 = (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((InterestRatePayout)thenArg.get())).get());
            } else {
                interestRateLeg2 = null;
            }
            return Optional.ofNullable(interestRateLeg2).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends InterestRatePayout> interestRatePayouts(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
        }
    }
}

