/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.util.string.functions.StringContains;
import drr.base.util.string.functions.SubString;
import javax.inject.Inject;

@ImplementedBy(value=IsValidRefEntityDefault.class)
public abstract class IsValidRefEntity
implements RosettaFunction {
    @Inject
    protected StringContains stringContains;
    @Inject
    protected SubString subString;

    public Boolean evaluate(String refEntity) {
        Boolean validRefEntity = this.doEvaluate(refEntity);
        return validRefEntity;
    }

    protected abstract Boolean doEvaluate(String var1);

    protected abstract MapperS<Boolean> validFormat(String var1);

    protected abstract MapperS<Boolean> validCountryCode(String var1);

    public static class IsValidRefEntityDefault
    extends IsValidRefEntity {
        @Override
        protected Boolean doEvaluate(String refEntity) {
            Boolean validRefEntity = null;
            return this.assignOutput(validRefEntity, refEntity);
        }

        protected Boolean assignOutput(Boolean validRefEntity, String refEntity) {
            validRefEntity = ComparisonResult.of(this.validCountryCode(refEntity)).and(ComparisonResult.of(this.validFormat(refEntity))).get();
            return validRefEntity;
        }

        @Override
        protected MapperS<Boolean> validFormat(String refEntity) {
            return MapperS.of((Object)this.stringContains.evaluate(refEntity, "[A-Z]{2}(-[A-Z]{3})?"));
        }

        @Override
        protected MapperS<Boolean> validCountryCode(String refEntity) {
            return ExpressionOperators.exists((Mapper)MapperS.of((Object)this.subString.evaluate(refEntity, 1, 2)).checkedMap("to-enum", ISOCountryCodeEnum::fromDisplayName, IllegalArgumentException.class)).asMapper();
        }
    }
}

