/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.datetime.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetExpirationDate;
import javax.inject.Inject;

@ImplementedBy(value=ExpirationDateRuleDefault.class)
public abstract class ExpirationDateRule
implements ReportFunction<TransactionReportInstruction, Date> {
    @Inject
    protected GetExpirationDate getExpirationDate;

    public Date evaluate(TransactionReportInstruction input) {
        Date output = this.doEvaluate(input);
        return output;
    }

    protected abstract Date doEvaluate(TransactionReportInstruction var1);

    public static class ExpirationDateRuleDefault
    extends ExpirationDateRule {
        @Override
        protected Date doEvaluate(TransactionReportInstruction input) {
            Date output = null;
            return this.assignOutput(output, input);
        }

        protected Date assignOutput(Date output, TransactionReportInstruction input) {
            output = (Date)MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.getExpirationDate.evaluate((TransactionReportInstruction)item.get()))).get();
            return output;
        }
    }
}

