/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.index.reports;

import cdm.event.common.Trade;
import cdm.product.qualification.functions.Qualify_Credit_OptionOther;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.product.functions.IsCreditDefaultSwapIndex;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForTrade;
import drr.base.trade.functions.TradeForEvent;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsCreditTotalReturnSwap;
import drr.standards.iso.functions.FormatToBaseOne18Rate;
import drr.standards.iso.functions.FormatToBaseOneRate;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=IndexFactorRuleDefault.class)
public abstract class IndexFactorRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected FormatToBaseOne18Rate formatToBaseOne18Rate;
    @Inject
    protected FormatToBaseOneRate formatToBaseOneRate;
    @Inject
    protected IsCreditDefaultSwapIndex isCreditDefaultSwapIndex;
    @Inject
    protected IsCreditTotalReturnSwap isCreditTotalReturnSwap;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected Qualify_Credit_OptionOther qualify_Credit_OptionOther;
    @Inject
    protected TradeForEvent tradeForEvent;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class IndexFactorRuleDefault
    extends IndexFactorRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEventBase)item.get())));
            output = (BigDecimal)thenArg.mapSingleToItem(item -> {
                Boolean _boolean = this.isCreditDefaultSwapIndex.evaluate((Trade)item.get());
                if (_boolean != null && _boolean.booleanValue()) {
                    return item.map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).map("getIndexFactor", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexFactor());
                }
                if (ComparisonResult.of((Mapper)MapperS.of((Object)this.isCreditTotalReturnSwap.evaluate(this.productForTrade.evaluate((Trade)item.get())))).or(ComparisonResult.of((Mapper)MapperS.of((Object)this.qualify_Credit_OptionOther.evaluate(this.economicTermsForProduct.evaluate(this.productForTrade.evaluate((Trade)item.get())))))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.formatToBaseOne18Rate.evaluate(BigDecimal.valueOf(1L)));
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate((Product)item.map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.formatToBaseOneRate.evaluate((BigDecimal)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate((Product)item.map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).map("getIndexFactor", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexFactor()).get()));
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

