/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.party.functions;

import cdm.base.staticdata.identifier.TradeIdentifierTypeEnum;
import cdm.event.common.TradeIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.trade.ReportingSide;
import java.util.Collections;
import java.util.List;

@ImplementedBy(value=GetInternalIdDefault.class)
public abstract class GetInternalId
implements RosettaFunction {
    public String evaluate(List<? extends TradeIdentifier> tradeIdentifier, ReportingSide reportingSide, String internalTradeIdentifier) {
        String internalTradeId = this.doEvaluate(tradeIdentifier, reportingSide, internalTradeIdentifier);
        return internalTradeId;
    }

    protected abstract String doEvaluate(List<? extends TradeIdentifier> var1, ReportingSide var2, String var3);

    protected abstract MapperC<? extends FieldWithMetaString> internalIdentifiers(List<? extends TradeIdentifier> var1, ReportingSide var2, String var3);

    public static class GetInternalIdDefault
    extends GetInternalId {
        @Override
        protected String doEvaluate(List<? extends TradeIdentifier> tradeIdentifier, ReportingSide reportingSide, String internalTradeIdentifier) {
            if (tradeIdentifier == null) {
                tradeIdentifier = Collections.emptyList();
            }
            String internalTradeId = null;
            return this.assignOutput(internalTradeId, tradeIdentifier, reportingSide, internalTradeIdentifier);
        }

        protected String assignOutput(String internalTradeId, List<? extends TradeIdentifier> tradeIdentifier, ReportingSide reportingSide, String internalTradeIdentifier) {
            MapperC<? extends FieldWithMetaString> thenArg = this.internalIdentifiers(tradeIdentifier, reportingSide, internalTradeIdentifier);
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)ExpressionOperators.distinct(thenArg).first().get();
            internalTradeId = (String)MapperS.of((Object)internalTradeIdentifier).getOrDefault((Object)(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            return internalTradeId;
        }

        @Override
        protected MapperC<? extends FieldWithMetaString> internalIdentifiers(List<? extends TradeIdentifier> tradeIdentifier, ReportingSide reportingSide, String internalTradeIdentifier) {
            MapperC thenArg0 = MapperC.of(tradeIdentifier);
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getIssuerReference", _tradeIdentifier -> _tradeIdentifier.getIssuerReference()).map("Type coercion", referenceWithMetaParty0 -> referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()), (Mapper)MapperS.of((Object)reportingSide).map("getReportingParty", _reportingSide -> _reportingSide.getReportingParty()).map("Type coercion", referenceWithMetaParty1 -> referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()), (CardinalityOperator)CardinalityOperator.All).get());
            MapperC thenArg2 = thenArg1.filterItemNullSafe(item -> ExpressionOperators.notEqual((Mapper)item.map("getIdentifierType", _tradeIdentifier -> _tradeIdentifier.getIdentifierType()), (Mapper)MapperS.of((Object)TradeIdentifierTypeEnum.UNIQUE_TRANSACTION_IDENTIFIER), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.notEqual((Mapper)item.map("getIdentifierType", _tradeIdentifier -> _tradeIdentifier.getIdentifierType()), (Mapper)MapperS.of((Object)TradeIdentifierTypeEnum.UNIQUE_SWAP_IDENTIFIER), (CardinalityOperator)CardinalityOperator.Any)).get());
            MapperListOfLists thenArg3 = thenArg2.mapItemToList(item -> item.mapC("getAssignedIdentifier", _tradeIdentifier -> _tradeIdentifier.getAssignedIdentifier()).map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier()));
            return thenArg3.flattenList();
        }
    }
}

