/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.underlier.reports;

import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.GetIndexIndicatorFromFloatingRate;
import drr.regulation.common.functions.RateOption;
import drr.standards.iso.IndexEnum;
import javax.inject.Inject;

@ImplementedBy(value=FloatingRateIndicatorRuleDefault.class)
public abstract class FloatingRateIndicatorRule
implements ReportFunction<InterestRatePayout, IndexEnum> {
    @Inject
    protected GetIndexIndicatorFromFloatingRate getIndexIndicatorFromFloatingRate;
    @Inject
    protected RateOption rateOption;

    public IndexEnum evaluate(InterestRatePayout input) {
        IndexEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract IndexEnum doEvaluate(InterestRatePayout var1);

    public static class FloatingRateIndicatorRuleDefault
    extends FloatingRateIndicatorRule {
        @Override
        protected IndexEnum doEvaluate(InterestRatePayout input) {
            IndexEnum output = null;
            return this.assignOutput(output, input);
        }

        protected IndexEnum assignOutput(IndexEnum output, InterestRatePayout input) {
            MapperS thenArg = MapperS.of((Object)this.rateOption.evaluate(input));
            output = (IndexEnum)((Object)thenArg.mapSingleToItem(item -> MapperS.of((Object)((Object)this.getIndexIndicatorFromFloatingRate.evaluate((String)item.map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex()).map("Type coercion", fieldWithMetaFloatingRateIndexEnum -> fieldWithMetaFloatingRateIndexEnum == null ? null : fieldWithMetaFloatingRateIndexEnum.getValue()).map("to-string", FloatingRateIndexEnum::toDisplayString).get())))).get());
            return output;
        }
    }
}

