/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.valuation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.valuation.CriticalDataElement;
import drr.regulation.common.valuation.meta.CommonValuationReportMeta;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommonValuationReport", builder=CommonValuationReportBuilderImpl.class, version="7.0.0-dev.73")
@RuneDataType(value="CommonValuationReport", model="drr", builder=CommonValuationReportBuilderImpl.class, version="7.0.0-dev.73")
public interface CommonValuationReport
extends CriticalDataElement {
    public static final CommonValuationReportMeta metaData = new CommonValuationReportMeta();

    public String getReportSubmittingEntityID();

    public String getEntityResponsibleForReporting();

    public String getUniqueTransactionIdentifier();

    public String getUniqueTransactionIdentifierProprietary();

    public Date getEventDate();

    @Override
    public CommonValuationReport build();

    @Override
    public CommonValuationReportBuilder toBuilder();

    public static CommonValuationReportBuilder builder() {
        return new CommonValuationReportBuilderImpl();
    }

    default public RosettaMetaData<? extends CommonValuationReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommonValuationReport> getType() {
        return CommonValuationReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CommonValuationReportBuilderImpl
    extends CriticalDataElement.CriticalDataElementBuilderImpl
    implements CommonValuationReportBuilder {
        protected String reportSubmittingEntityID;
        protected String entityResponsibleForReporting;
        protected String uniqueTransactionIdentifier;
        protected String uniqueTransactionIdentifierProprietary;
        protected Date eventDate;

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public String getUniqueTransactionIdentifierProprietary() {
            return this.uniqueTransactionIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public CommonValuationReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public CommonValuationReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public CommonValuationReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public CommonValuationReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public CommonValuationReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public CommonValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public CommonValuationReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public CommonValuationReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public CommonValuationReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public CommonValuationReportBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public CommonValuationReportBuilder setLevel(ReportLevelEnum _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public CommonValuationReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public CommonValuationReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        public CommonValuationReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public CommonValuationReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public CommonValuationReportBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        public CommonValuationReport build() {
            return new CommonValuationReportImpl(this);
        }

        @Override
        public CommonValuationReportBuilder toBuilder() {
            return this;
        }

        @Override
        public CommonValuationReportBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getReportSubmittingEntityID() != null) {
                return true;
            }
            if (this.getEntityResponsibleForReporting() != null) {
                return true;
            }
            if (this.getUniqueTransactionIdentifier() != null) {
                return true;
            }
            if (this.getUniqueTransactionIdentifierProprietary() != null) {
                return true;
            }
            return this.getEventDate() != null;
        }

        @Override
        public CommonValuationReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommonValuationReportBuilder o = (CommonValuationReportBuilder)other;
            merger.mergeBasic((Object)this.getReportSubmittingEntityID(), (Object)o.getReportSubmittingEntityID(), this::setReportSubmittingEntityID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEntityResponsibleForReporting(), (Object)o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifier(), (Object)o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifierProprietary(), (Object)o.getUniqueTransactionIdentifierProprietary(), this::setUniqueTransactionIdentifierProprietary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventDate(), (Object)o.getEventDate(), this::setEventDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommonValuationReport _that = (CommonValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) {
                return false;
            }
            return Objects.equals(this.eventDate, _that.getEventDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietary != null ? this.uniqueTransactionIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommonValuationReportBuilder {reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", eventDate=" + String.valueOf(this.eventDate) + "} " + super.toString();
        }
    }

    public static interface CommonValuationReportBuilder
    extends CommonValuationReport,
    CriticalDataElement.CriticalDataElementBuilder {
        @Override
        public CommonValuationReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public CommonValuationReportBuilder setCounterparty1(String var1);

        @Override
        public CommonValuationReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public CommonValuationReportBuilder setCounterparty2(String var1);

        @Override
        public CommonValuationReportBuilder setValuationAmount(BigDecimal var1);

        @Override
        public CommonValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CommonValuationReportBuilder setValuationTimestamp(ZonedDateTime var1);

        @Override
        public CommonValuationReportBuilder setValuationMethod(ValuationType1Code var1);

        @Override
        public CommonValuationReportBuilder setDelta(BigDecimal var1);

        @Override
        public CommonValuationReportBuilder setActionType(ActionTypeEnum var1);

        @Override
        public CommonValuationReportBuilder setLevel(ReportLevelEnum var1);

        public CommonValuationReportBuilder setReportSubmittingEntityID(String var1);

        public CommonValuationReportBuilder setEntityResponsibleForReporting(String var1);

        public CommonValuationReportBuilder setUniqueTransactionIdentifier(String var1);

        public CommonValuationReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        public CommonValuationReportBuilder setEventDate(Date var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CommonValuationReportBuilder prune();
    }

    public static class CommonValuationReportImpl
    extends CriticalDataElement.CriticalDataElementImpl
    implements CommonValuationReport {
        private final String reportSubmittingEntityID;
        private final String entityResponsibleForReporting;
        private final String uniqueTransactionIdentifier;
        private final String uniqueTransactionIdentifierProprietary;
        private final Date eventDate;

        protected CommonValuationReportImpl(CommonValuationReportBuilder builder) {
            super(builder);
            this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
            this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
            this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
            this.uniqueTransactionIdentifierProprietary = builder.getUniqueTransactionIdentifierProprietary();
            this.eventDate = builder.getEventDate();
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public String getUniqueTransactionIdentifierProprietary() {
            return this.uniqueTransactionIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        public CommonValuationReport build() {
            return this;
        }

        @Override
        public CommonValuationReportBuilder toBuilder() {
            CommonValuationReportBuilder builder = CommonValuationReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommonValuationReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityID);
            Optional.ofNullable(this.getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
            Optional.ofNullable(this.getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
            Optional.ofNullable(this.getUniqueTransactionIdentifierProprietary()).ifPresent(builder::setUniqueTransactionIdentifierProprietary);
            Optional.ofNullable(this.getEventDate()).ifPresent(builder::setEventDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommonValuationReport _that = (CommonValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) {
                return false;
            }
            return Objects.equals(this.eventDate, _that.getEventDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietary != null ? this.uniqueTransactionIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommonValuationReport {reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", eventDate=" + String.valueOf(this.eventDate) + "} " + super.toString();
        }
    }
}

