/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.base.trade.basket.BasketConstituentsReport;
import drr.base.trade.payment.OtherPayment;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.PricePeriod;
import drr.regulation.common.ClearingAccountOriginEnum;
import drr.regulation.common.ClearingExceptionsAndExemptionsEnum;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.Counterparty2IdentifierEnum;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonTransactionReport;
import drr.regulation.common.trade.NonReportable;
import drr.regulation.common.trade.contract.MasterAgreementEnum;
import drr.regulation.common.trade.party.NatureOfCounterpartyEnum;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier;
import drr.regulation.common.trade.underlier.UnderlyingIdentificationTypeEnum;
import drr.regulation.csa.rewrite.dtcc.DTCCAdditionalFields;
import drr.regulation.csa.rewrite.trade.CSALeg;
import drr.regulation.csa.rewrite.trade.CSANonReportable;
import drr.regulation.csa.rewrite.trade.meta.CSATransactionReportMeta;
import drr.standards.iosco.cde.version1.LegV1;
import drr.standards.iosco.cde.version2.LegV2;
import drr.standards.iosco.cde.version3.Leg;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.DeliveryTypeEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.SeniorityEnum;
import drr.standards.iso.TradingCapacity7Code;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CSATransactionReport", builder=CSATransactionReportBuilderImpl.class, version="7.0.0-dev.73")
@RuneDataType(value="CSATransactionReport", model="drr", builder=CSATransactionReportBuilderImpl.class, version="7.0.0-dev.73")
public interface CSATransactionReport
extends CommonTransactionReport {
    public static final CSATransactionReportMeta metaData = new CSATransactionReportMeta();

    @Override
    public Counterparty2IdentifierEnum getCounterparty2IdentifierSource();

    @Override
    public ClearedEnum getCleared();

    @Override
    public ZonedDateTime getEventTimestamp();

    @Override
    public CSALeg getLeg1();

    @Override
    public CSALeg getLeg2();

    @Override
    public CSANonReportable getNonReportable();

    public String getCountryAndProvinceOrTerritoryOfIndividual();

    public List<String> getJurisdictionOfCounterparty1();

    public List<String> getJurisdictionOfCounterparty2();

    public Boolean getInterAffiliateIndicator();

    public Boolean getPlatformAnonymousExecutionIndicator();

    public DTCCAdditionalFields getDtccAdditionalFields();

    @Override
    public CSATransactionReport build();

    @Override
    public CSATransactionReportBuilder toBuilder();

    public static CSATransactionReportBuilder builder() {
        return new CSATransactionReportBuilderImpl();
    }

    default public RosettaMetaData<? extends CSATransactionReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CSATransactionReport> getType() {
        return CSATransactionReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, (Object)this.getBuyerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, (Object)this.getSellerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, (Object)this.getCleared(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, (Object)this.getConfirmed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.class, this.getPriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("price"), processor, PriceFormat.class, this.getPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, (Object)this.getPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.class, this.getPackageTransactionPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.class, this.getPackageTransactionSpread(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.class, this.getStrikePrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, (Object)this.getStrikePriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, (Object)this.getStrikePriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, (Object)this.getDirection1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, this.getBasketConstituents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.class, this.getOtherPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leg1"), processor, CSALeg.class, this.getLeg1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leg2"), processor, CSALeg.class, this.getLeg2(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, (Object)this.getUnderlyingAssetPriceSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, (Object)this.getCryptoAssetUnderlyingIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, (Object)this.getEventType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, (Object)this.getConfirmationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, (Object)this.getBookingLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, (Object)this.getTraderLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, (Object)this.getDeliveryType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, (Object)this.getExecutionAgentCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentCounterparty2"), String.class, (Object)this.getExecutionAgentCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("natureOfCounterparty1"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("natureOfCounterparty2"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, this.getCorporateSectorOfTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, this.getCorporateSectorOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, (Object)this.getCountryOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, (Object)this.getTradingCapacity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("brokerID"), String.class, (Object)this.getBrokerID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, (Object)this.getContractType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, (Object)this.getEmbeddedOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("masterAgreementType"), MasterAgreementEnum.class, (Object)this.getMasterAgreementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, (Object)this.getMasterAgreementVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, (Object)this.getSecondaryTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("intragroup"), Boolean.class, (Object)this.getIntragroup(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, (Object)this.getNonStandardizedTermIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, (Object)this.getAmendmentIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, (Object)this.getUnderlyingIdentification(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentificationType"), UnderlyingIdentificationTypeEnum.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, (Object)this.getNameOfTheUnderlyingIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("swapLinkID"), String.class, (Object)this.getSwapLinkID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, (Object)this.getPackageIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, (Object)this.getCustomBasketIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, (Object)this.getPriorUTIProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, (Object)this.getClearingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, (Object)this.getClearingAccountOrigin(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, (Object)this.getClearingReceiptTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, (Object)this.getOriginalSwapUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, (Object)this.getSubsequentPositionUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, (Object)this.getOriginalSwapSDRIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUSI"), String.class, (Object)this.getPriorUSI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, (Object)this.getNewSDRIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("referenceEntity"), String.class, (Object)this.getReferenceEntity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, (Object)this.getSeniority(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("series"), Integer.class, (Object)this.getSeries(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seriesVersion"), Integer.class, (Object)this.getSeriesVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("baseProduct"), String.class, (Object)this.getBaseProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("subProduct"), String.class, (Object)this.getSubProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, (Object)this.getFurtherSubProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.class, this.getBarrier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonReportable"), processor, CSANonReportable.class, this.getNonReportable(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("countryAndProvinceOrTerritoryOfIndividual"), String.class, (Object)this.getCountryAndProvinceOrTerritoryOfIndividual(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("jurisdictionOfCounterparty1"), String.class, this.getJurisdictionOfCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("jurisdictionOfCounterparty2"), String.class, this.getJurisdictionOfCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("interAffiliateIndicator"), Boolean.class, (Object)this.getInterAffiliateIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("platformAnonymousExecutionIndicator"), Boolean.class, (Object)this.getPlatformAnonymousExecutionIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dtccAdditionalFields"), processor, DTCCAdditionalFields.class, this.getDtccAdditionalFields(), new AttributeMeta[0]);
    }

    public static class CSATransactionReportBuilderImpl
    implements CSATransactionReportBuilder {
        protected Date effectiveDate;
        protected Date earlyTerminationDate;
        protected ZonedDateTime reportingTimestamp;
        protected ZonedDateTime executionTimestamp;
        protected Date expirationDate;
        protected String counterparty1;
        protected String counterparty2;
        protected Boolean counterparty2IdentifierType;
        protected String beneficiary1;
        protected Boolean beneficiary1IdentifierTypeIndicator;
        protected String buyerIdentifier;
        protected String sellerIdentifier;
        protected ClearedEnum cleared;
        protected String centralCounterparty;
        protected String clearingMember;
        protected ConfirmationEnum confirmed;
        protected BigDecimal callAmount;
        protected BigDecimal putAmount;
        protected ISOCurrencyCodeEnum callCurrency;
        protected ISOCurrencyCodeEnum putCurrency;
        protected BigDecimal delta;
        protected List<PricePeriod.PricePeriodBuilder> priceSchedule = new ArrayList<PricePeriod.PricePeriodBuilder>();
        protected List<PricePeriod.PricePeriodBuilder> strikePriceSchedule = new ArrayList<PricePeriod.PricePeriodBuilder>();
        protected PriceFormat.PriceFormatBuilder price;
        protected PriceNotationEnum priceNotation;
        protected ISOCurrencyCodeEnum priceCurrency;
        protected PriceFormat.PriceFormatBuilder packageTransactionPrice;
        protected PriceNotationEnum packageTransactionPriceNotation;
        protected ISOCurrencyCodeEnum packageTransactionPriceCurrency;
        protected PriceFormat.PriceFormatBuilder packageTransactionSpread;
        protected PriceNotationEnum packageTransactionSpreadNotation;
        protected ISOCurrencyCodeEnum packageTransactionSpreadCurrency;
        protected String packageIdentifier;
        protected PriceFormat.PriceFormatBuilder strikePrice;
        protected PriceNotationEnum strikePriceNotation;
        protected String strikePriceCurrency;
        protected String priceUnitOfMeasure;
        protected BigDecimal optionPremiumAmount;
        protected ISOCurrencyCodeEnum optionPremiumCurrency;
        protected Date optionPremiumPaymentDate;
        protected BigDecimal exchangeRate;
        protected String exchangeRateBasis;
        protected BigDecimal cdSIndexAttachmentPoint;
        protected BigDecimal cdSIndexDetachmentPoint;
        protected Boolean collateralPortfolioIndicator;
        protected Date firstExerciseDate;
        protected Date finalContractualSettlementDate;
        protected ISOCountryCodeEnum settlementLocation;
        protected String priorUTI;
        protected Direction1Enum direction1;
        protected BigDecimal valuationAmount;
        protected ISOCurrencyCodeEnum valuationCurrency;
        protected ValuationType1Code valuationMethod;
        protected ZonedDateTime valuationTimestamp;
        protected String customBasketCode;
        protected List<BasketConstituentsReport.BasketConstituentsReportBuilder> basketConstituents = new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>();
        protected List<OtherPayment.OtherPaymentBuilder> otherPayment = new ArrayList<OtherPayment.OtherPaymentBuilder>();
        protected CSALeg.CSALegBuilder leg1;
        protected CSALeg.CSALegBuilder leg2;
        protected String underlyingIdOther;
        protected ProductIdTypeEnum underlyingIdOtherSource;
        protected String underlyingAssetTradingPlatformIdentifier;
        protected String underlyingAssetPriceSource;
        protected Boolean cryptoAssetUnderlyingIndicator;
        protected ReportLevelEnum level;
        protected ActionTypeEnum actionType;
        protected EventTypeEnum eventType;
        protected String eventIdentifier;
        protected ZonedDateTime eventTimestamp;
        protected ZonedDateTime confirmationTimestamp;
        protected String platformIdentifier;
        protected ISOCountryCodeEnum bookingLocation;
        protected ISOCountryCodeEnum traderLocation;
        protected DeliveryTypeEnum deliveryType;
        protected String executionAgentCounterparty1;
        protected String executionAgentCounterparty2;
        protected NatureOfCounterpartyEnum natureOfCounterparty1;
        protected NatureOfCounterpartyEnum natureOfCounterparty2;
        protected List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1 = new ArrayList<ClearingExceptionsAndExemptionsEnum>();
        protected List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2 = new ArrayList<ClearingExceptionsAndExemptionsEnum>();
        protected List<String> corporateSectorOfTheCounterparty1 = new ArrayList<String>();
        protected List<String> corporateSectorOfTheCounterparty2 = new ArrayList<String>();
        protected String counterparty2Name;
        protected String reportSubmittingEntityID;
        protected String entityResponsibleForReporting;
        protected ISOCountryCodeEnum countryOfTheCounterparty2;
        protected Counterparty2IdentifierEnum counterparty2IdentifierSource;
        protected TradingCapacity7Code tradingCapacity;
        protected String brokerID;
        protected CommonContractType contractType;
        protected CommonAssetClass assetClass;
        protected OptionTypeCode optionType;
        protected OptionStyleEnum optionStyle;
        protected EmbeddedOptionTypeEnum embeddedOptionType;
        protected MasterAgreementEnum masterAgreementType;
        protected Integer masterAgreementVersion;
        protected String secondaryTransactionIdentifier;
        protected Boolean intragroup;
        protected Boolean nonStandardizedTermIndicator;
        protected Boolean amendmentIndicator;
        protected String underlyingIdentification;
        protected UnderlyingIdentificationTypeEnum underlyingIdentificationType;
        protected String nameOfTheUnderlyingIndex;
        protected Date maturityDateOfTheUnderlying;
        protected String swapLinkID;
        protected Boolean packageIndicator;
        protected Boolean customBasketIndicator;
        protected String priorUTIProprietary;
        protected ZonedDateTime clearingTimestamp;
        protected ClearingAccountOriginEnum clearingAccountOrigin;
        protected ZonedDateTime clearingReceiptTimestamp;
        protected String uniqueTransactionIdentifier;
        protected String uniqueTransactionIdentifierProprietary;
        protected String uniqueProductIdentifier;
        protected String originalSwapUTI;
        protected String subsequentPositionUTI;
        protected String originalSwapSDRIdentifier;
        protected String priorUSI;
        protected String newSDRIdentifier;
        protected String technicalRecordId;
        protected String referenceEntity;
        protected SeniorityEnum seniority;
        protected Integer series;
        protected BigDecimal indexFactor;
        protected Integer seriesVersion;
        protected String baseProduct;
        protected String subProduct;
        protected String furtherSubProduct;
        protected SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder barrier;
        protected String initialMarginCollateralPortfolioCode;
        protected String variationMarginCollateralPortfolioCode;
        protected CSANonReportable.CSANonReportableBuilder nonReportable;
        protected String countryAndProvinceOrTerritoryOfIndividual;
        protected List<String> jurisdictionOfCounterparty1 = new ArrayList<String>();
        protected List<String> jurisdictionOfCounterparty2 = new ArrayList<String>();
        protected Boolean interAffiliateIndicator;
        protected Boolean platformAnonymousExecutionIndicator;
        protected DTCCAdditionalFields.DTCCAdditionalFieldsBuilder dtccAdditionalFields;

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationDate")
        @RuneAttribute(value="earlyTerminationDate")
        public Date getEarlyTerminationDate() {
            return this.earlyTerminationDate;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp")
        @RuneAttribute(value="executionTimestamp")
        public ZonedDateTime getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public Date getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType")
        @RuneAttribute(value="counterparty2IdentifierType")
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="beneficiary1")
        @RuneAttribute(value="beneficiary1")
        public String getBeneficiary1() {
            return this.beneficiary1;
        }

        @Override
        @RosettaAttribute(value="beneficiary1IdentifierTypeIndicator")
        @RuneAttribute(value="beneficiary1IdentifierTypeIndicator")
        public Boolean getBeneficiary1IdentifierTypeIndicator() {
            return this.beneficiary1IdentifierTypeIndicator;
        }

        @Override
        @RosettaAttribute(value="buyerIdentifier")
        @RuneAttribute(value="buyerIdentifier")
        public String getBuyerIdentifier() {
            return this.buyerIdentifier;
        }

        @Override
        @RosettaAttribute(value="sellerIdentifier")
        @RuneAttribute(value="sellerIdentifier")
        public String getSellerIdentifier() {
            return this.sellerIdentifier;
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public ClearedEnum getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public String getCentralCounterparty() {
            return this.centralCounterparty;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public String getClearingMember() {
            return this.clearingMember;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public ConfirmationEnum getConfirmed() {
            return this.confirmed;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public BigDecimal getCallAmount() {
            return this.callAmount;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public BigDecimal getPutAmount() {
            return this.putAmount;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public ISOCurrencyCodeEnum getCallCurrency() {
            return this.callCurrency;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public ISOCurrencyCodeEnum getPutCurrency() {
            return this.putCurrency;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public List<? extends PricePeriod.PricePeriodBuilder> getPriceSchedule() {
            return this.priceSchedule;
        }

        @Override
        public PricePeriod.PricePeriodBuilder getOrCreatePriceSchedule(int index) {
            if (this.priceSchedule == null) {
                this.priceSchedule = new ArrayList<PricePeriod.PricePeriodBuilder>();
            }
            return (PricePeriod.PricePeriodBuilder)this.getIndex(this.priceSchedule, index, () -> {
                PricePeriod.PricePeriodBuilder newPriceSchedule = PricePeriod.builder();
                return newPriceSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public List<? extends PricePeriod.PricePeriodBuilder> getStrikePriceSchedule() {
            return this.strikePriceSchedule;
        }

        @Override
        public PricePeriod.PricePeriodBuilder getOrCreateStrikePriceSchedule(int index) {
            if (this.strikePriceSchedule == null) {
                this.strikePriceSchedule = new ArrayList<PricePeriod.PricePeriodBuilder>();
            }
            return (PricePeriod.PricePeriodBuilder)this.getIndex(this.strikePriceSchedule, index, () -> {
                PricePeriod.PricePeriodBuilder newStrikePriceSchedule = PricePeriod.builder();
                return newStrikePriceSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public PriceFormat.PriceFormatBuilder getPrice() {
            return this.price;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreatePrice() {
            PriceFormat.PriceFormatBuilder result = this.price != null ? this.price : (this.price = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceNotation")
        @RuneAttribute(value="priceNotation")
        public PriceNotationEnum getPriceNotation() {
            return this.priceNotation;
        }

        @Override
        @RosettaAttribute(value="priceCurrency")
        @RuneAttribute(value="priceCurrency")
        public ISOCurrencyCodeEnum getPriceCurrency() {
            return this.priceCurrency;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public PriceFormat.PriceFormatBuilder getPackageTransactionPrice() {
            return this.packageTransactionPrice;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreatePackageTransactionPrice() {
            PriceFormat.PriceFormatBuilder result = this.packageTransactionPrice != null ? this.packageTransactionPrice : (this.packageTransactionPrice = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceNotation")
        @RuneAttribute(value="packageTransactionPriceNotation")
        public PriceNotationEnum getPackageTransactionPriceNotation() {
            return this.packageTransactionPriceNotation;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceCurrency")
        @RuneAttribute(value="packageTransactionPriceCurrency")
        public ISOCurrencyCodeEnum getPackageTransactionPriceCurrency() {
            return this.packageTransactionPriceCurrency;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public PriceFormat.PriceFormatBuilder getPackageTransactionSpread() {
            return this.packageTransactionSpread;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreatePackageTransactionSpread() {
            PriceFormat.PriceFormatBuilder result = this.packageTransactionSpread != null ? this.packageTransactionSpread : (this.packageTransactionSpread = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadNotation")
        @RuneAttribute(value="packageTransactionSpreadNotation")
        public PriceNotationEnum getPackageTransactionSpreadNotation() {
            return this.packageTransactionSpreadNotation;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadCurrency")
        @RuneAttribute(value="packageTransactionSpreadCurrency")
        public ISOCurrencyCodeEnum getPackageTransactionSpreadCurrency() {
            return this.packageTransactionSpreadCurrency;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public String getPackageIdentifier() {
            return this.packageIdentifier;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public PriceFormat.PriceFormatBuilder getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        public PriceFormat.PriceFormatBuilder getOrCreateStrikePrice() {
            PriceFormat.PriceFormatBuilder result = this.strikePrice != null ? this.strikePrice : (this.strikePrice = PriceFormat.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public PriceNotationEnum getStrikePriceNotation() {
            return this.strikePriceNotation;
        }

        @Override
        @RosettaAttribute(value="strikePriceCurrency")
        @RuneAttribute(value="strikePriceCurrency")
        public String getStrikePriceCurrency() {
            return this.strikePriceCurrency;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public String getPriceUnitOfMeasure() {
            return this.priceUnitOfMeasure;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public BigDecimal getOptionPremiumAmount() {
            return this.optionPremiumAmount;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
            return this.optionPremiumCurrency;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public Date getOptionPremiumPaymentDate() {
            return this.optionPremiumPaymentDate;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public BigDecimal getExchangeRate() {
            return this.exchangeRate;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public String getExchangeRateBasis() {
            return this.exchangeRateBasis;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public BigDecimal getCdSIndexAttachmentPoint() {
            return this.cdSIndexAttachmentPoint;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public BigDecimal getCdSIndexDetachmentPoint() {
            return this.cdSIndexDetachmentPoint;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public Boolean getCollateralPortfolioIndicator() {
            return this.collateralPortfolioIndicator;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public Date getFirstExerciseDate() {
            return this.firstExerciseDate;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public Date getFinalContractualSettlementDate() {
            return this.finalContractualSettlementDate;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public ISOCountryCodeEnum getSettlementLocation() {
            return this.settlementLocation;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public String getPriorUTI() {
            return this.priorUTI;
        }

        @Override
        @RosettaAttribute(value="direction1")
        @RuneAttribute(value="direction1")
        public Direction1Enum getDirection1() {
            return this.direction1;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public BigDecimal getValuationAmount() {
            return this.valuationAmount;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public ISOCurrencyCodeEnum getValuationCurrency() {
            return this.valuationCurrency;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public ValuationType1Code getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public ZonedDateTime getValuationTimestamp() {
            return this.valuationTimestamp;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public String getCustomBasketCode() {
            return this.customBasketCode;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public List<? extends BasketConstituentsReport.BasketConstituentsReportBuilder> getBasketConstituents() {
            return this.basketConstituents;
        }

        @Override
        public BasketConstituentsReport.BasketConstituentsReportBuilder getOrCreateBasketConstituents(int index) {
            if (this.basketConstituents == null) {
                this.basketConstituents = new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>();
            }
            return (BasketConstituentsReport.BasketConstituentsReportBuilder)this.getIndex(this.basketConstituents, index, () -> {
                BasketConstituentsReport.BasketConstituentsReportBuilder newBasketConstituents = BasketConstituentsReport.builder();
                return newBasketConstituents;
            });
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public List<? extends OtherPayment.OtherPaymentBuilder> getOtherPayment() {
            return this.otherPayment;
        }

        @Override
        public OtherPayment.OtherPaymentBuilder getOrCreateOtherPayment(int index) {
            if (this.otherPayment == null) {
                this.otherPayment = new ArrayList<OtherPayment.OtherPaymentBuilder>();
            }
            return (OtherPayment.OtherPaymentBuilder)this.getIndex(this.otherPayment, index, () -> {
                OtherPayment.OtherPaymentBuilder newOtherPayment = OtherPayment.builder();
                return newOtherPayment;
            });
        }

        @Override
        @RosettaAttribute(value="leg1")
        @RuneAttribute(value="leg1")
        public CSALeg.CSALegBuilder getLeg1() {
            return this.leg1;
        }

        @Override
        public CSALeg.CSALegBuilder getOrCreateLeg1() {
            CSALeg.CSALegBuilder result = this.leg1 != null ? this.leg1 : (this.leg1 = CSALeg.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="leg2")
        @RuneAttribute(value="leg2")
        public CSALeg.CSALegBuilder getLeg2() {
            return this.leg2;
        }

        @Override
        public CSALeg.CSALegBuilder getOrCreateLeg2() {
            CSALeg.CSALegBuilder result = this.leg2 != null ? this.leg2 : (this.leg2 = CSALeg.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOther")
        @RuneAttribute(value="underlyingIdOther")
        public String getUnderlyingIdOther() {
            return this.underlyingIdOther;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOtherSource")
        @RuneAttribute(value="underlyingIdOtherSource")
        public ProductIdTypeEnum getUnderlyingIdOtherSource() {
            return this.underlyingIdOtherSource;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlyingAssetTradingPlatformIdentifier")
        public String getUnderlyingAssetTradingPlatformIdentifier() {
            return this.underlyingAssetTradingPlatformIdentifier;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public String getUnderlyingAssetPriceSource() {
            return this.underlyingAssetPriceSource;
        }

        @Override
        @RosettaAttribute(value="cryptoAssetUnderlyingIndicator")
        @RuneAttribute(value="cryptoAssetUnderlyingIndicator")
        public Boolean getCryptoAssetUnderlyingIndicator() {
            return this.cryptoAssetUnderlyingIndicator;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public ReportLevelEnum getLevel() {
            return this.level;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public ActionTypeEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public EventTypeEnum getEventType() {
            return this.eventType;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public String getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="confirmationTimestamp")
        @RuneAttribute(value="confirmationTimestamp")
        public ZonedDateTime getConfirmationTimestamp() {
            return this.confirmationTimestamp;
        }

        @Override
        @RosettaAttribute(value="platformIdentifier")
        @RuneAttribute(value="platformIdentifier")
        public String getPlatformIdentifier() {
            return this.platformIdentifier;
        }

        @Override
        @RosettaAttribute(value="bookingLocation")
        @RuneAttribute(value="bookingLocation")
        public ISOCountryCodeEnum getBookingLocation() {
            return this.bookingLocation;
        }

        @Override
        @RosettaAttribute(value="traderLocation")
        @RuneAttribute(value="traderLocation")
        public ISOCountryCodeEnum getTraderLocation() {
            return this.traderLocation;
        }

        @Override
        @RosettaAttribute(value="deliveryType")
        @RuneAttribute(value="deliveryType")
        public DeliveryTypeEnum getDeliveryType() {
            return this.deliveryType;
        }

        @Override
        @RosettaAttribute(value="executionAgentCounterparty1")
        @RuneAttribute(value="executionAgentCounterparty1")
        public String getExecutionAgentCounterparty1() {
            return this.executionAgentCounterparty1;
        }

        @Override
        @RosettaAttribute(value="executionAgentCounterparty2")
        @RuneAttribute(value="executionAgentCounterparty2")
        public String getExecutionAgentCounterparty2() {
            return this.executionAgentCounterparty2;
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty1")
        @RuneAttribute(value="natureOfCounterparty1")
        public NatureOfCounterpartyEnum getNatureOfCounterparty1() {
            return this.natureOfCounterparty1;
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty2")
        @RuneAttribute(value="natureOfCounterparty2")
        public NatureOfCounterpartyEnum getNatureOfCounterparty2() {
            return this.natureOfCounterparty2;
        }

        @Override
        @RosettaAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        public List<ClearingExceptionsAndExemptionsEnum> getClearingExceptionsAndExemptionsCounterparty1() {
            return this.clearingExceptionsAndExemptionsCounterparty1;
        }

        @Override
        @RosettaAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        public List<ClearingExceptionsAndExemptionsEnum> getClearingExceptionsAndExemptionsCounterparty2() {
            return this.clearingExceptionsAndExemptionsCounterparty2;
        }

        @Override
        @RosettaAttribute(value="corporateSectorOfTheCounterparty1")
        @RuneAttribute(value="corporateSectorOfTheCounterparty1")
        public List<String> getCorporateSectorOfTheCounterparty1() {
            return this.corporateSectorOfTheCounterparty1;
        }

        @Override
        @RosettaAttribute(value="corporateSectorOfTheCounterparty2")
        @RuneAttribute(value="corporateSectorOfTheCounterparty2")
        public List<String> getCorporateSectorOfTheCounterparty2() {
            return this.corporateSectorOfTheCounterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name")
        @RuneAttribute(value="counterparty2Name")
        public String getCounterparty2Name() {
            return this.counterparty2Name;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        @RosettaAttribute(value="countryOfTheCounterparty2")
        @RuneAttribute(value="countryOfTheCounterparty2")
        public ISOCountryCodeEnum getCountryOfTheCounterparty2() {
            return this.countryOfTheCounterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public Counterparty2IdentifierEnum getCounterparty2IdentifierSource() {
            return this.counterparty2IdentifierSource;
        }

        @Override
        @RosettaAttribute(value="tradingCapacity")
        @RuneAttribute(value="tradingCapacity")
        public TradingCapacity7Code getTradingCapacity() {
            return this.tradingCapacity;
        }

        @Override
        @RosettaAttribute(value="brokerID")
        @RuneAttribute(value="brokerID")
        public String getBrokerID() {
            return this.brokerID;
        }

        @Override
        @RosettaAttribute(value="contractType")
        @RuneAttribute(value="contractType")
        public CommonContractType getContractType() {
            return this.contractType;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public CommonAssetClass getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public OptionTypeCode getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public OptionStyleEnum getOptionStyle() {
            return this.optionStyle;
        }

        @Override
        @RosettaAttribute(value="embeddedOptionType")
        @RuneAttribute(value="embeddedOptionType")
        public EmbeddedOptionTypeEnum getEmbeddedOptionType() {
            return this.embeddedOptionType;
        }

        @Override
        @RosettaAttribute(value="masterAgreementType")
        @RuneAttribute(value="masterAgreementType")
        public MasterAgreementEnum getMasterAgreementType() {
            return this.masterAgreementType;
        }

        @Override
        @RosettaAttribute(value="masterAgreementVersion")
        @RuneAttribute(value="masterAgreementVersion")
        public Integer getMasterAgreementVersion() {
            return this.masterAgreementVersion;
        }

        @Override
        @RosettaAttribute(value="secondaryTransactionIdentifier")
        @RuneAttribute(value="secondaryTransactionIdentifier")
        public String getSecondaryTransactionIdentifier() {
            return this.secondaryTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="intragroup")
        @RuneAttribute(value="intragroup")
        public Boolean getIntragroup() {
            return this.intragroup;
        }

        @Override
        @RosettaAttribute(value="nonStandardizedTermIndicator")
        @RuneAttribute(value="nonStandardizedTermIndicator")
        public Boolean getNonStandardizedTermIndicator() {
            return this.nonStandardizedTermIndicator;
        }

        @Override
        @RosettaAttribute(value="amendmentIndicator")
        @RuneAttribute(value="amendmentIndicator")
        public Boolean getAmendmentIndicator() {
            return this.amendmentIndicator;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentification")
        @RuneAttribute(value="underlyingIdentification")
        public String getUnderlyingIdentification() {
            return this.underlyingIdentification;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentificationType")
        @RuneAttribute(value="underlyingIdentificationType")
        public UnderlyingIdentificationTypeEnum getUnderlyingIdentificationType() {
            return this.underlyingIdentificationType;
        }

        @Override
        @RosettaAttribute(value="nameOfTheUnderlyingIndex")
        @RuneAttribute(value="nameOfTheUnderlyingIndex")
        public String getNameOfTheUnderlyingIndex() {
            return this.nameOfTheUnderlyingIndex;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public Date getMaturityDateOfTheUnderlying() {
            return this.maturityDateOfTheUnderlying;
        }

        @Override
        @RosettaAttribute(value="swapLinkID")
        @RuneAttribute(value="swapLinkID")
        public String getSwapLinkID() {
            return this.swapLinkID;
        }

        @Override
        @RosettaAttribute(value="packageIndicator")
        @RuneAttribute(value="packageIndicator")
        public Boolean getPackageIndicator() {
            return this.packageIndicator;
        }

        @Override
        @RosettaAttribute(value="customBasketIndicator")
        @RuneAttribute(value="customBasketIndicator")
        public Boolean getCustomBasketIndicator() {
            return this.customBasketIndicator;
        }

        @Override
        @RosettaAttribute(value="priorUTIProprietary")
        @RuneAttribute(value="priorUTIProprietary")
        public String getPriorUTIProprietary() {
            return this.priorUTIProprietary;
        }

        @Override
        @RosettaAttribute(value="clearingTimestamp")
        @RuneAttribute(value="clearingTimestamp")
        public ZonedDateTime getClearingTimestamp() {
            return this.clearingTimestamp;
        }

        @Override
        @RosettaAttribute(value="clearingAccountOrigin")
        @RuneAttribute(value="clearingAccountOrigin")
        public ClearingAccountOriginEnum getClearingAccountOrigin() {
            return this.clearingAccountOrigin;
        }

        @Override
        @RosettaAttribute(value="clearingReceiptTimestamp")
        @RuneAttribute(value="clearingReceiptTimestamp")
        public ZonedDateTime getClearingReceiptTimestamp() {
            return this.clearingReceiptTimestamp;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public String getUniqueTransactionIdentifierProprietary() {
            return this.uniqueTransactionIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier")
        @RuneAttribute(value="uniqueProductIdentifier")
        public String getUniqueProductIdentifier() {
            return this.uniqueProductIdentifier;
        }

        @Override
        @RosettaAttribute(value="originalSwapUTI")
        @RuneAttribute(value="originalSwapUTI")
        public String getOriginalSwapUTI() {
            return this.originalSwapUTI;
        }

        @Override
        @RosettaAttribute(value="subsequentPositionUTI")
        @RuneAttribute(value="subsequentPositionUTI")
        public String getSubsequentPositionUTI() {
            return this.subsequentPositionUTI;
        }

        @Override
        @RosettaAttribute(value="originalSwapSDRIdentifier")
        @RuneAttribute(value="originalSwapSDRIdentifier")
        public String getOriginalSwapSDRIdentifier() {
            return this.originalSwapSDRIdentifier;
        }

        @Override
        @RosettaAttribute(value="priorUSI")
        @RuneAttribute(value="priorUSI")
        public String getPriorUSI() {
            return this.priorUSI;
        }

        @Override
        @RosettaAttribute(value="newSDRIdentifier")
        @RuneAttribute(value="newSDRIdentifier")
        public String getNewSDRIdentifier() {
            return this.newSDRIdentifier;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="referenceEntity")
        @RuneAttribute(value="referenceEntity")
        public String getReferenceEntity() {
            return this.referenceEntity;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public SeniorityEnum getSeniority() {
            return this.seniority;
        }

        @Override
        @RosettaAttribute(value="series")
        @RuneAttribute(value="series")
        public Integer getSeries() {
            return this.series;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public BigDecimal getIndexFactor() {
            return this.indexFactor;
        }

        @Override
        @RosettaAttribute(value="seriesVersion")
        @RuneAttribute(value="seriesVersion")
        public Integer getSeriesVersion() {
            return this.seriesVersion;
        }

        @Override
        @RosettaAttribute(value="baseProduct")
        @RuneAttribute(value="baseProduct")
        public String getBaseProduct() {
            return this.baseProduct;
        }

        @Override
        @RosettaAttribute(value="subProduct")
        @RuneAttribute(value="subProduct")
        public String getSubProduct() {
            return this.subProduct;
        }

        @Override
        @RosettaAttribute(value="furtherSubProduct")
        @RuneAttribute(value="furtherSubProduct")
        public String getFurtherSubProduct() {
            return this.furtherSubProduct;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder getBarrier() {
            return this.barrier;
        }

        @Override
        public SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder getOrCreateBarrier() {
            SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder result = this.barrier != null ? this.barrier : (this.barrier = SingleOrUpperAndLowerBarrier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public CSANonReportable.CSANonReportableBuilder getNonReportable() {
            return this.nonReportable;
        }

        @Override
        public CSANonReportable.CSANonReportableBuilder getOrCreateNonReportable() {
            CSANonReportable.CSANonReportableBuilder result = this.nonReportable != null ? this.nonReportable : (this.nonReportable = CSANonReportable.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="countryAndProvinceOrTerritoryOfIndividual")
        @RuneAttribute(value="countryAndProvinceOrTerritoryOfIndividual")
        public String getCountryAndProvinceOrTerritoryOfIndividual() {
            return this.countryAndProvinceOrTerritoryOfIndividual;
        }

        @Override
        @RosettaAttribute(value="jurisdictionOfCounterparty1")
        @RuneAttribute(value="jurisdictionOfCounterparty1")
        public List<String> getJurisdictionOfCounterparty1() {
            return this.jurisdictionOfCounterparty1;
        }

        @Override
        @RosettaAttribute(value="jurisdictionOfCounterparty2")
        @RuneAttribute(value="jurisdictionOfCounterparty2")
        public List<String> getJurisdictionOfCounterparty2() {
            return this.jurisdictionOfCounterparty2;
        }

        @Override
        @RosettaAttribute(value="interAffiliateIndicator")
        @RuneAttribute(value="interAffiliateIndicator")
        public Boolean getInterAffiliateIndicator() {
            return this.interAffiliateIndicator;
        }

        @Override
        @RosettaAttribute(value="platformAnonymousExecutionIndicator")
        @RuneAttribute(value="platformAnonymousExecutionIndicator")
        public Boolean getPlatformAnonymousExecutionIndicator() {
            return this.platformAnonymousExecutionIndicator;
        }

        @Override
        @RosettaAttribute(value="dtccAdditionalFields")
        @RuneAttribute(value="dtccAdditionalFields")
        public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder getDtccAdditionalFields() {
            return this.dtccAdditionalFields;
        }

        @Override
        public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder getOrCreateDtccAdditionalFields() {
            DTCCAdditionalFields.DTCCAdditionalFieldsBuilder result = this.dtccAdditionalFields != null ? this.dtccAdditionalFields : (this.dtccAdditionalFields = DTCCAdditionalFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public CSATransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationDate")
        @RuneAttribute(value="earlyTerminationDate")
        public CSATransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
            this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public CSATransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp")
        @RuneAttribute(value="executionTimestamp")
        public CSATransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
            this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public CSATransactionReportBuilder setExpirationDate(Date _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public CSATransactionReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public CSATransactionReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType")
        @RuneAttribute(value="counterparty2IdentifierType")
        public CSATransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary1")
        @RuneAttribute(value="beneficiary1")
        public CSATransactionReportBuilder setBeneficiary1(String _beneficiary1) {
            this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary1IdentifierTypeIndicator")
        @RuneAttribute(value="beneficiary1IdentifierTypeIndicator")
        public CSATransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
            this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerIdentifier")
        @RuneAttribute(value="buyerIdentifier")
        public CSATransactionReportBuilder setBuyerIdentifier(String _buyerIdentifier) {
            this.buyerIdentifier = _buyerIdentifier == null ? null : _buyerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="sellerIdentifier")
        @RuneAttribute(value="sellerIdentifier")
        public CSATransactionReportBuilder setSellerIdentifier(String _sellerIdentifier) {
            this.sellerIdentifier = _sellerIdentifier == null ? null : _sellerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public CSATransactionReportBuilder setClearedOverriddenAsClearedEnum(ClearedEnum _cleared) {
            this.cleared = _cleared == null ? null : _cleared;
            return this;
        }

        @Override
        @RosettaIgnore
        public CSATransactionReportBuilder setCleared(ClearedEnum _cleared) {
            return this.setClearedOverriddenAsClearedEnum(_cleared);
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public CSATransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
            this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public CSATransactionReportBuilder setClearingMember(String _clearingMember) {
            this.clearingMember = _clearingMember == null ? null : _clearingMember;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public CSATransactionReportBuilder setConfirmed(ConfirmationEnum _confirmed) {
            this.confirmed = _confirmed == null ? null : _confirmed;
            return this;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public CSATransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
            this.callAmount = _callAmount == null ? null : _callAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public CSATransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
            this.putAmount = _putAmount == null ? null : _putAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public CSATransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
            this.callCurrency = _callCurrency == null ? null : _callCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public CSATransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
            this.putCurrency = _putCurrency == null ? null : _putCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public CSATransactionReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public CSATransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule) {
            if (_priceSchedule != null) {
                this.priceSchedule.add(_priceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public CSATransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule, int idx) {
            this.getIndex(this.priceSchedule, idx, () -> _priceSchedule.toBuilder());
            return this;
        }

        @Override
        public CSATransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedules) {
            if (priceSchedules != null) {
                for (PricePeriod pricePeriod : priceSchedules) {
                    this.priceSchedule.add(pricePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceSchedule")
        public CSATransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedules) {
            this.priceSchedule = priceSchedules == null ? new ArrayList<PricePeriod.PricePeriodBuilder>() : (List)priceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public CSATransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule) {
            if (_strikePriceSchedule != null) {
                this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public CSATransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule, int idx) {
            this.getIndex(this.strikePriceSchedule, idx, () -> _strikePriceSchedule.toBuilder());
            return this;
        }

        @Override
        public CSATransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
            if (strikePriceSchedules != null) {
                for (PricePeriod pricePeriod : strikePriceSchedules) {
                    this.strikePriceSchedule.add(pricePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="strikePriceSchedule")
        public CSATransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
            this.strikePriceSchedule = strikePriceSchedules == null ? new ArrayList<PricePeriod.PricePeriodBuilder>() : (List)strikePriceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public CSATransactionReportBuilder setPrice(PriceFormat _price) {
            this.price = _price == null ? null : _price.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceNotation")
        @RuneAttribute(value="priceNotation")
        public CSATransactionReportBuilder setPriceNotation(PriceNotationEnum _priceNotation) {
            this.priceNotation = _priceNotation == null ? null : _priceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceCurrency")
        @RuneAttribute(value="priceCurrency")
        public CSATransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
            this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public CSATransactionReportBuilder setPackageTransactionPrice(PriceFormat _packageTransactionPrice) {
            this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceNotation")
        @RuneAttribute(value="packageTransactionPriceNotation")
        public CSATransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
            this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceCurrency")
        @RuneAttribute(value="packageTransactionPriceCurrency")
        public CSATransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
            this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public CSATransactionReportBuilder setPackageTransactionSpread(PriceFormat _packageTransactionSpread) {
            this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadNotation")
        @RuneAttribute(value="packageTransactionSpreadNotation")
        public CSATransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
            this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadCurrency")
        @RuneAttribute(value="packageTransactionSpreadCurrency")
        public CSATransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
            this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public CSATransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
            this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public CSATransactionReportBuilder setStrikePrice(PriceFormat _strikePrice) {
            this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public CSATransactionReportBuilder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
            this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceCurrency")
        @RuneAttribute(value="strikePriceCurrency")
        public CSATransactionReportBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
            this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public CSATransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
            this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public CSATransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
            this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public CSATransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
            this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public CSATransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
            this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public CSATransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
            this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public CSATransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
            this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public CSATransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
            this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public CSATransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
            this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public CSATransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public CSATransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
            this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public CSATransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
            this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public CSATransactionReportBuilder setSettlementLocation(ISOCountryCodeEnum _settlementLocation) {
            this.settlementLocation = _settlementLocation == null ? null : _settlementLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public CSATransactionReportBuilder setPriorUTI(String _priorUTI) {
            this.priorUTI = _priorUTI == null ? null : _priorUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction1")
        @RuneAttribute(value="direction1")
        public CSATransactionReportBuilder setDirection1(Direction1Enum _direction1) {
            this.direction1 = _direction1 == null ? null : _direction1;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public CSATransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public CSATransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public CSATransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public CSATransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public CSATransactionReportBuilder setCustomBasketCode(String _customBasketCode) {
            this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public CSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
            if (_basketConstituents != null) {
                this.basketConstituents.add(_basketConstituents.toBuilder());
            }
            return this;
        }

        @Override
        public CSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int idx) {
            this.getIndex(this.basketConstituents, idx, () -> _basketConstituents.toBuilder());
            return this;
        }

        @Override
        public CSATransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            if (basketConstituentss != null) {
                for (BasketConstituentsReport basketConstituentsReport : basketConstituentss) {
                    this.basketConstituents.add(basketConstituentsReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketConstituents")
        public CSATransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            this.basketConstituents = basketConstituentss == null ? new ArrayList<BasketConstituentsReport.BasketConstituentsReportBuilder>() : (List)basketConstituentss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public CSATransactionReportBuilder addOtherPayment(OtherPayment _otherPayment) {
            if (_otherPayment != null) {
                this.otherPayment.add(_otherPayment.toBuilder());
            }
            return this;
        }

        @Override
        public CSATransactionReportBuilder addOtherPayment(OtherPayment _otherPayment, int idx) {
            this.getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
            return this;
        }

        @Override
        public CSATransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayments) {
            if (otherPayments != null) {
                for (OtherPayment otherPayment : otherPayments) {
                    this.otherPayment.add(otherPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPayment")
        public CSATransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayments) {
            this.otherPayment = otherPayments == null ? new ArrayList<OtherPayment.OtherPaymentBuilder>() : (List)otherPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="leg1")
        @RuneAttribute(value="leg1")
        public CSATransactionReportBuilder setLeg1(CSALeg _leg1) {
            this.leg1 = _leg1 == null ? null : _leg1.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        public CSATransactionReportBuilder setLeg1(CommonLeg _leg1) {
            CSALeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CSALeg ? (CSALeg)CSALeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public CSATransactionReportBuilder setLeg1(Leg _leg1) {
            CSALeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CSALeg ? (CSALeg)CSALeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public CSATransactionReportBuilder setLeg1(LegV2 _leg1) {
            CSALeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CSALeg ? (CSALeg)CSALeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public CSATransactionReportBuilder setLeg1(LegV1 _leg1) {
            CSALeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CSALeg ? (CSALeg)CSALeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="leg2")
        @RuneAttribute(value="leg2")
        public CSATransactionReportBuilder setLeg2(CSALeg _leg2) {
            this.leg2 = _leg2 == null ? null : _leg2.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        public CSATransactionReportBuilder setLeg2(CommonLeg _leg2) {
            CSALeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CSALeg ? (CSALeg)CSALeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public CSATransactionReportBuilder setLeg2(Leg _leg2) {
            CSALeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CSALeg ? (CSALeg)CSALeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public CSATransactionReportBuilder setLeg2(LegV2 _leg2) {
            CSALeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CSALeg ? (CSALeg)CSALeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        public CSATransactionReportBuilder setLeg2(LegV1 _leg2) {
            CSALeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CSALeg ? (CSALeg)CSALeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="underlyingIdOther")
        @RuneAttribute(value="underlyingIdOther")
        public CSATransactionReportBuilder setUnderlyingIdOther(String _underlyingIdOther) {
            this.underlyingIdOther = _underlyingIdOther == null ? null : _underlyingIdOther;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOtherSource")
        @RuneAttribute(value="underlyingIdOtherSource")
        public CSATransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum _underlyingIdOtherSource) {
            this.underlyingIdOtherSource = _underlyingIdOtherSource == null ? null : _underlyingIdOtherSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlyingAssetTradingPlatformIdentifier")
        public CSATransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifier(String _underlyingAssetTradingPlatformIdentifier) {
            this.underlyingAssetTradingPlatformIdentifier = _underlyingAssetTradingPlatformIdentifier == null ? null : _underlyingAssetTradingPlatformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public CSATransactionReportBuilder setUnderlyingAssetPriceSource(String _underlyingAssetPriceSource) {
            this.underlyingAssetPriceSource = _underlyingAssetPriceSource == null ? null : _underlyingAssetPriceSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="cryptoAssetUnderlyingIndicator")
        @RuneAttribute(value="cryptoAssetUnderlyingIndicator")
        public CSATransactionReportBuilder setCryptoAssetUnderlyingIndicator(Boolean _cryptoAssetUnderlyingIndicator) {
            this.cryptoAssetUnderlyingIndicator = _cryptoAssetUnderlyingIndicator == null ? null : _cryptoAssetUnderlyingIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public CSATransactionReportBuilder setLevel(ReportLevelEnum _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public CSATransactionReportBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public CSATransactionReportBuilder setEventType(EventTypeEnum _eventType) {
            this.eventType = _eventType == null ? null : _eventType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public CSATransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
            this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public CSATransactionReportBuilder setEventTimestampOverriddenAsZonedDateTime(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        @RosettaIgnore
        public CSATransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            return this.setEventTimestampOverriddenAsZonedDateTime(_eventTimestamp);
        }

        @Override
        @RosettaAttribute(value="confirmationTimestamp")
        @RuneAttribute(value="confirmationTimestamp")
        public CSATransactionReportBuilder setConfirmationTimestamp(ZonedDateTime _confirmationTimestamp) {
            this.confirmationTimestamp = _confirmationTimestamp == null ? null : _confirmationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="platformIdentifier")
        @RuneAttribute(value="platformIdentifier")
        public CSATransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
            this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="bookingLocation")
        @RuneAttribute(value="bookingLocation")
        public CSATransactionReportBuilder setBookingLocation(ISOCountryCodeEnum _bookingLocation) {
            this.bookingLocation = _bookingLocation == null ? null : _bookingLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="traderLocation")
        @RuneAttribute(value="traderLocation")
        public CSATransactionReportBuilder setTraderLocation(ISOCountryCodeEnum _traderLocation) {
            this.traderLocation = _traderLocation == null ? null : _traderLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryType")
        @RuneAttribute(value="deliveryType")
        public CSATransactionReportBuilder setDeliveryType(DeliveryTypeEnum _deliveryType) {
            this.deliveryType = _deliveryType == null ? null : _deliveryType;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentCounterparty1")
        @RuneAttribute(value="executionAgentCounterparty1")
        public CSATransactionReportBuilder setExecutionAgentCounterparty1(String _executionAgentCounterparty1) {
            this.executionAgentCounterparty1 = _executionAgentCounterparty1 == null ? null : _executionAgentCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentCounterparty2")
        @RuneAttribute(value="executionAgentCounterparty2")
        public CSATransactionReportBuilder setExecutionAgentCounterparty2(String _executionAgentCounterparty2) {
            this.executionAgentCounterparty2 = _executionAgentCounterparty2 == null ? null : _executionAgentCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty1")
        @RuneAttribute(value="natureOfCounterparty1")
        public CSATransactionReportBuilder setNatureOfCounterparty1(NatureOfCounterpartyEnum _natureOfCounterparty1) {
            this.natureOfCounterparty1 = _natureOfCounterparty1 == null ? null : _natureOfCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty2")
        @RuneAttribute(value="natureOfCounterparty2")
        public CSATransactionReportBuilder setNatureOfCounterparty2(NatureOfCounterpartyEnum _natureOfCounterparty2) {
            this.natureOfCounterparty2 = _natureOfCounterparty2 == null ? null : _natureOfCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        public CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1) {
            if (_clearingExceptionsAndExemptionsCounterparty1 != null) {
                this.clearingExceptionsAndExemptionsCounterparty1.add(_clearingExceptionsAndExemptionsCounterparty1);
            }
            return this;
        }

        @Override
        public CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1, int idx) {
            this.getIndex(this.clearingExceptionsAndExemptionsCounterparty1, idx, () -> _clearingExceptionsAndExemptionsCounterparty1);
            return this;
        }

        @Override
        public CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
            if (clearingExceptionsAndExemptionsCounterparty1s != null) {
                for (ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty1s) {
                    this.clearingExceptionsAndExemptionsCounterparty1.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        public CSATransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
            this.clearingExceptionsAndExemptionsCounterparty1 = clearingExceptionsAndExemptionsCounterparty1s == null ? new ArrayList<ClearingExceptionsAndExemptionsEnum>() : (List)clearingExceptionsAndExemptionsCounterparty1s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        public CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2) {
            if (_clearingExceptionsAndExemptionsCounterparty2 != null) {
                this.clearingExceptionsAndExemptionsCounterparty2.add(_clearingExceptionsAndExemptionsCounterparty2);
            }
            return this;
        }

        @Override
        public CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2, int idx) {
            this.getIndex(this.clearingExceptionsAndExemptionsCounterparty2, idx, () -> _clearingExceptionsAndExemptionsCounterparty2);
            return this;
        }

        @Override
        public CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
            if (clearingExceptionsAndExemptionsCounterparty2s != null) {
                for (ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty2s) {
                    this.clearingExceptionsAndExemptionsCounterparty2.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        public CSATransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
            this.clearingExceptionsAndExemptionsCounterparty2 = clearingExceptionsAndExemptionsCounterparty2s == null ? new ArrayList<ClearingExceptionsAndExemptionsEnum>() : (List)clearingExceptionsAndExemptionsCounterparty2s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateSectorOfTheCounterparty1")
        @RuneAttribute(value="corporateSectorOfTheCounterparty1")
        public CSATransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1) {
            if (_corporateSectorOfTheCounterparty1 != null) {
                this.corporateSectorOfTheCounterparty1.add(_corporateSectorOfTheCounterparty1);
            }
            return this;
        }

        @Override
        public CSATransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1, int idx) {
            this.getIndex(this.corporateSectorOfTheCounterparty1, idx, () -> _corporateSectorOfTheCounterparty1);
            return this;
        }

        @Override
        public CSATransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
            if (corporateSectorOfTheCounterparty1s != null) {
                for (String toAdd : corporateSectorOfTheCounterparty1s) {
                    this.corporateSectorOfTheCounterparty1.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="corporateSectorOfTheCounterparty1")
        public CSATransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
            this.corporateSectorOfTheCounterparty1 = corporateSectorOfTheCounterparty1s == null ? new ArrayList<String>() : (List)corporateSectorOfTheCounterparty1s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateSectorOfTheCounterparty2")
        @RuneAttribute(value="corporateSectorOfTheCounterparty2")
        public CSATransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2) {
            if (_corporateSectorOfTheCounterparty2 != null) {
                this.corporateSectorOfTheCounterparty2.add(_corporateSectorOfTheCounterparty2);
            }
            return this;
        }

        @Override
        public CSATransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2, int idx) {
            this.getIndex(this.corporateSectorOfTheCounterparty2, idx, () -> _corporateSectorOfTheCounterparty2);
            return this;
        }

        @Override
        public CSATransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
            if (corporateSectorOfTheCounterparty2s != null) {
                for (String toAdd : corporateSectorOfTheCounterparty2s) {
                    this.corporateSectorOfTheCounterparty2.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="corporateSectorOfTheCounterparty2")
        public CSATransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
            this.corporateSectorOfTheCounterparty2 = corporateSectorOfTheCounterparty2s == null ? new ArrayList<String>() : (List)corporateSectorOfTheCounterparty2s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name")
        @RuneAttribute(value="counterparty2Name")
        public CSATransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
            this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public CSATransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public CSATransactionReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaAttribute(value="countryOfTheCounterparty2")
        @RuneAttribute(value="countryOfTheCounterparty2")
        public CSATransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum _countryOfTheCounterparty2) {
            this.countryOfTheCounterparty2 = _countryOfTheCounterparty2 == null ? null : _countryOfTheCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public CSATransactionReportBuilder setCounterparty2IdentifierSourceOverriddenAsCounterparty2IdentifierEnum(Counterparty2IdentifierEnum _counterparty2IdentifierSource) {
            this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
            return this;
        }

        @Override
        @RosettaIgnore
        public CSATransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum _counterparty2IdentifierSource) {
            return this.setCounterparty2IdentifierSourceOverriddenAsCounterparty2IdentifierEnum(_counterparty2IdentifierSource);
        }

        @Override
        @RosettaAttribute(value="tradingCapacity")
        @RuneAttribute(value="tradingCapacity")
        public CSATransactionReportBuilder setTradingCapacity(TradingCapacity7Code _tradingCapacity) {
            this.tradingCapacity = _tradingCapacity == null ? null : _tradingCapacity;
            return this;
        }

        @Override
        @RosettaAttribute(value="brokerID")
        @RuneAttribute(value="brokerID")
        public CSATransactionReportBuilder setBrokerID(String _brokerID) {
            this.brokerID = _brokerID == null ? null : _brokerID;
            return this;
        }

        @Override
        @RosettaAttribute(value="contractType")
        @RuneAttribute(value="contractType")
        public CSATransactionReportBuilder setContractType(CommonContractType _contractType) {
            this.contractType = _contractType == null ? null : _contractType;
            return this;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public CSATransactionReportBuilder setAssetClass(CommonAssetClass _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public CSATransactionReportBuilder setOptionType(OptionTypeCode _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public CSATransactionReportBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
            this.optionStyle = _optionStyle == null ? null : _optionStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="embeddedOptionType")
        @RuneAttribute(value="embeddedOptionType")
        public CSATransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum _embeddedOptionType) {
            this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="masterAgreementType")
        @RuneAttribute(value="masterAgreementType")
        public CSATransactionReportBuilder setMasterAgreementType(MasterAgreementEnum _masterAgreementType) {
            this.masterAgreementType = _masterAgreementType == null ? null : _masterAgreementType;
            return this;
        }

        @Override
        @RosettaAttribute(value="masterAgreementVersion")
        @RuneAttribute(value="masterAgreementVersion")
        public CSATransactionReportBuilder setMasterAgreementVersion(Integer _masterAgreementVersion) {
            this.masterAgreementVersion = _masterAgreementVersion == null ? null : _masterAgreementVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="secondaryTransactionIdentifier")
        @RuneAttribute(value="secondaryTransactionIdentifier")
        public CSATransactionReportBuilder setSecondaryTransactionIdentifier(String _secondaryTransactionIdentifier) {
            this.secondaryTransactionIdentifier = _secondaryTransactionIdentifier == null ? null : _secondaryTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="intragroup")
        @RuneAttribute(value="intragroup")
        public CSATransactionReportBuilder setIntragroup(Boolean _intragroup) {
            this.intragroup = _intragroup == null ? null : _intragroup;
            return this;
        }

        @Override
        @RosettaAttribute(value="nonStandardizedTermIndicator")
        @RuneAttribute(value="nonStandardizedTermIndicator")
        public CSATransactionReportBuilder setNonStandardizedTermIndicator(Boolean _nonStandardizedTermIndicator) {
            this.nonStandardizedTermIndicator = _nonStandardizedTermIndicator == null ? null : _nonStandardizedTermIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="amendmentIndicator")
        @RuneAttribute(value="amendmentIndicator")
        public CSATransactionReportBuilder setAmendmentIndicator(Boolean _amendmentIndicator) {
            this.amendmentIndicator = _amendmentIndicator == null ? null : _amendmentIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentification")
        @RuneAttribute(value="underlyingIdentification")
        public CSATransactionReportBuilder setUnderlyingIdentification(String _underlyingIdentification) {
            this.underlyingIdentification = _underlyingIdentification == null ? null : _underlyingIdentification;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentificationType")
        @RuneAttribute(value="underlyingIdentificationType")
        public CSATransactionReportBuilder setUnderlyingIdentificationType(UnderlyingIdentificationTypeEnum _underlyingIdentificationType) {
            this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
            return this;
        }

        @Override
        @RosettaAttribute(value="nameOfTheUnderlyingIndex")
        @RuneAttribute(value="nameOfTheUnderlyingIndex")
        public CSATransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
            this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public CSATransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
            this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
            return this;
        }

        @Override
        @RosettaAttribute(value="swapLinkID")
        @RuneAttribute(value="swapLinkID")
        public CSATransactionReportBuilder setSwapLinkID(String _swapLinkID) {
            this.swapLinkID = _swapLinkID == null ? null : _swapLinkID;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIndicator")
        @RuneAttribute(value="packageIndicator")
        public CSATransactionReportBuilder setPackageIndicator(Boolean _packageIndicator) {
            this.packageIndicator = _packageIndicator == null ? null : _packageIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasketIndicator")
        @RuneAttribute(value="customBasketIndicator")
        public CSATransactionReportBuilder setCustomBasketIndicator(Boolean _customBasketIndicator) {
            this.customBasketIndicator = _customBasketIndicator == null ? null : _customBasketIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTIProprietary")
        @RuneAttribute(value="priorUTIProprietary")
        public CSATransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
            this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingTimestamp")
        @RuneAttribute(value="clearingTimestamp")
        public CSATransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
            this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingAccountOrigin")
        @RuneAttribute(value="clearingAccountOrigin")
        public CSATransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum _clearingAccountOrigin) {
            this.clearingAccountOrigin = _clearingAccountOrigin == null ? null : _clearingAccountOrigin;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingReceiptTimestamp")
        @RuneAttribute(value="clearingReceiptTimestamp")
        public CSATransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime _clearingReceiptTimestamp) {
            this.clearingReceiptTimestamp = _clearingReceiptTimestamp == null ? null : _clearingReceiptTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public CSATransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public CSATransactionReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier")
        @RuneAttribute(value="uniqueProductIdentifier")
        public CSATransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
            this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapUTI")
        @RuneAttribute(value="originalSwapUTI")
        public CSATransactionReportBuilder setOriginalSwapUTI(String _originalSwapUTI) {
            this.originalSwapUTI = _originalSwapUTI == null ? null : _originalSwapUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="subsequentPositionUTI")
        @RuneAttribute(value="subsequentPositionUTI")
        public CSATransactionReportBuilder setSubsequentPositionUTI(String _subsequentPositionUTI) {
            this.subsequentPositionUTI = _subsequentPositionUTI == null ? null : _subsequentPositionUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapSDRIdentifier")
        @RuneAttribute(value="originalSwapSDRIdentifier")
        public CSATransactionReportBuilder setOriginalSwapSDRIdentifier(String _originalSwapSDRIdentifier) {
            this.originalSwapSDRIdentifier = _originalSwapSDRIdentifier == null ? null : _originalSwapSDRIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUSI")
        @RuneAttribute(value="priorUSI")
        public CSATransactionReportBuilder setPriorUSI(String _priorUSI) {
            this.priorUSI = _priorUSI == null ? null : _priorUSI;
            return this;
        }

        @Override
        @RosettaAttribute(value="newSDRIdentifier")
        @RuneAttribute(value="newSDRIdentifier")
        public CSATransactionReportBuilder setNewSDRIdentifier(String _newSDRIdentifier) {
            this.newSDRIdentifier = _newSDRIdentifier == null ? null : _newSDRIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public CSATransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceEntity")
        @RuneAttribute(value="referenceEntity")
        public CSATransactionReportBuilder setReferenceEntity(String _referenceEntity) {
            this.referenceEntity = _referenceEntity == null ? null : _referenceEntity;
            return this;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public CSATransactionReportBuilder setSeniority(SeniorityEnum _seniority) {
            this.seniority = _seniority == null ? null : _seniority;
            return this;
        }

        @Override
        @RosettaAttribute(value="series")
        @RuneAttribute(value="series")
        public CSATransactionReportBuilder setSeries(Integer _series) {
            this.series = _series == null ? null : _series;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public CSATransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
            this.indexFactor = _indexFactor == null ? null : _indexFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="seriesVersion")
        @RuneAttribute(value="seriesVersion")
        public CSATransactionReportBuilder setSeriesVersion(Integer _seriesVersion) {
            this.seriesVersion = _seriesVersion == null ? null : _seriesVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="baseProduct")
        @RuneAttribute(value="baseProduct")
        public CSATransactionReportBuilder setBaseProduct(String _baseProduct) {
            this.baseProduct = _baseProduct == null ? null : _baseProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="subProduct")
        @RuneAttribute(value="subProduct")
        public CSATransactionReportBuilder setSubProduct(String _subProduct) {
            this.subProduct = _subProduct == null ? null : _subProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="furtherSubProduct")
        @RuneAttribute(value="furtherSubProduct")
        public CSATransactionReportBuilder setFurtherSubProduct(String _furtherSubProduct) {
            this.furtherSubProduct = _furtherSubProduct == null ? null : _furtherSubProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public CSATransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier _barrier) {
            this.barrier = _barrier == null ? null : _barrier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public CSATransactionReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public CSATransactionReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public CSATransactionReportBuilder setNonReportable(CSANonReportable _nonReportable) {
            this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        public CSATransactionReportBuilder setNonReportable(NonReportable _nonReportable) {
            CSANonReportable ifThenElseResult = _nonReportable == null ? null : (_nonReportable instanceof CSANonReportable ? (CSANonReportable)CSANonReportable.class.cast(_nonReportable) : null);
            return this.setNonReportable(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="countryAndProvinceOrTerritoryOfIndividual")
        @RuneAttribute(value="countryAndProvinceOrTerritoryOfIndividual")
        public CSATransactionReportBuilder setCountryAndProvinceOrTerritoryOfIndividual(String _countryAndProvinceOrTerritoryOfIndividual) {
            this.countryAndProvinceOrTerritoryOfIndividual = _countryAndProvinceOrTerritoryOfIndividual == null ? null : _countryAndProvinceOrTerritoryOfIndividual;
            return this;
        }

        @Override
        @RosettaAttribute(value="jurisdictionOfCounterparty1")
        @RuneAttribute(value="jurisdictionOfCounterparty1")
        public CSATransactionReportBuilder addJurisdictionOfCounterparty1(String _jurisdictionOfCounterparty1) {
            if (_jurisdictionOfCounterparty1 != null) {
                this.jurisdictionOfCounterparty1.add(_jurisdictionOfCounterparty1);
            }
            return this;
        }

        @Override
        public CSATransactionReportBuilder addJurisdictionOfCounterparty1(String _jurisdictionOfCounterparty1, int idx) {
            this.getIndex(this.jurisdictionOfCounterparty1, idx, () -> _jurisdictionOfCounterparty1);
            return this;
        }

        @Override
        public CSATransactionReportBuilder addJurisdictionOfCounterparty1(List<String> jurisdictionOfCounterparty1s) {
            if (jurisdictionOfCounterparty1s != null) {
                for (String toAdd : jurisdictionOfCounterparty1s) {
                    this.jurisdictionOfCounterparty1.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="jurisdictionOfCounterparty1")
        public CSATransactionReportBuilder setJurisdictionOfCounterparty1(List<String> jurisdictionOfCounterparty1s) {
            this.jurisdictionOfCounterparty1 = jurisdictionOfCounterparty1s == null ? new ArrayList<String>() : (List)jurisdictionOfCounterparty1s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="jurisdictionOfCounterparty2")
        @RuneAttribute(value="jurisdictionOfCounterparty2")
        public CSATransactionReportBuilder addJurisdictionOfCounterparty2(String _jurisdictionOfCounterparty2) {
            if (_jurisdictionOfCounterparty2 != null) {
                this.jurisdictionOfCounterparty2.add(_jurisdictionOfCounterparty2);
            }
            return this;
        }

        @Override
        public CSATransactionReportBuilder addJurisdictionOfCounterparty2(String _jurisdictionOfCounterparty2, int idx) {
            this.getIndex(this.jurisdictionOfCounterparty2, idx, () -> _jurisdictionOfCounterparty2);
            return this;
        }

        @Override
        public CSATransactionReportBuilder addJurisdictionOfCounterparty2(List<String> jurisdictionOfCounterparty2s) {
            if (jurisdictionOfCounterparty2s != null) {
                for (String toAdd : jurisdictionOfCounterparty2s) {
                    this.jurisdictionOfCounterparty2.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="jurisdictionOfCounterparty2")
        public CSATransactionReportBuilder setJurisdictionOfCounterparty2(List<String> jurisdictionOfCounterparty2s) {
            this.jurisdictionOfCounterparty2 = jurisdictionOfCounterparty2s == null ? new ArrayList<String>() : (List)jurisdictionOfCounterparty2s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="interAffiliateIndicator")
        @RuneAttribute(value="interAffiliateIndicator")
        public CSATransactionReportBuilder setInterAffiliateIndicator(Boolean _interAffiliateIndicator) {
            this.interAffiliateIndicator = _interAffiliateIndicator == null ? null : _interAffiliateIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="platformAnonymousExecutionIndicator")
        @RuneAttribute(value="platformAnonymousExecutionIndicator")
        public CSATransactionReportBuilder setPlatformAnonymousExecutionIndicator(Boolean _platformAnonymousExecutionIndicator) {
            this.platformAnonymousExecutionIndicator = _platformAnonymousExecutionIndicator == null ? null : _platformAnonymousExecutionIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="dtccAdditionalFields")
        @RuneAttribute(value="dtccAdditionalFields")
        public CSATransactionReportBuilder setDtccAdditionalFields(DTCCAdditionalFields _dtccAdditionalFields) {
            this.dtccAdditionalFields = _dtccAdditionalFields == null ? null : _dtccAdditionalFields.toBuilder();
            return this;
        }

        @Override
        public CSATransactionReport build() {
            return new CSATransactionReportImpl(this);
        }

        @Override
        public CSATransactionReportBuilder toBuilder() {
            return this;
        }

        @Override
        public CSATransactionReportBuilder prune() {
            this.priceSchedule = this.priceSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.strikePriceSchedule = this.strikePriceSchedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.price != null && !this.price.prune().hasData()) {
                this.price = null;
            }
            if (this.packageTransactionPrice != null && !this.packageTransactionPrice.prune().hasData()) {
                this.packageTransactionPrice = null;
            }
            if (this.packageTransactionSpread != null && !this.packageTransactionSpread.prune().hasData()) {
                this.packageTransactionSpread = null;
            }
            if (this.strikePrice != null && !this.strikePrice.prune().hasData()) {
                this.strikePrice = null;
            }
            this.basketConstituents = this.basketConstituents.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.otherPayment = this.otherPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.leg1 != null && !this.leg1.prune().hasData()) {
                this.leg1 = null;
            }
            if (this.leg2 != null && !this.leg2.prune().hasData()) {
                this.leg2 = null;
            }
            if (this.barrier != null && !this.barrier.prune().hasData()) {
                this.barrier = null;
            }
            if (this.nonReportable != null && !this.nonReportable.prune().hasData()) {
                this.nonReportable = null;
            }
            if (this.dtccAdditionalFields != null && !this.dtccAdditionalFields.prune().hasData()) {
                this.dtccAdditionalFields = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getEarlyTerminationDate() != null) {
                return true;
            }
            if (this.getReportingTimestamp() != null) {
                return true;
            }
            if (this.getExecutionTimestamp() != null) {
                return true;
            }
            if (this.getExpirationDate() != null) {
                return true;
            }
            if (this.getCounterparty1() != null) {
                return true;
            }
            if (this.getCounterparty2() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierType() != null) {
                return true;
            }
            if (this.getBeneficiary1() != null) {
                return true;
            }
            if (this.getBeneficiary1IdentifierTypeIndicator() != null) {
                return true;
            }
            if (this.getBuyerIdentifier() != null) {
                return true;
            }
            if (this.getSellerIdentifier() != null) {
                return true;
            }
            if (this.getCleared() != null) {
                return true;
            }
            if (this.getCentralCounterparty() != null) {
                return true;
            }
            if (this.getClearingMember() != null) {
                return true;
            }
            if (this.getConfirmed() != null) {
                return true;
            }
            if (this.getCallAmount() != null) {
                return true;
            }
            if (this.getPutAmount() != null) {
                return true;
            }
            if (this.getCallCurrency() != null) {
                return true;
            }
            if (this.getPutCurrency() != null) {
                return true;
            }
            if (this.getDelta() != null) {
                return true;
            }
            if (this.getPriceSchedule() != null && this.getPriceSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getStrikePriceSchedule() != null && this.getStrikePriceSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPrice() != null && this.getPrice().hasData()) {
                return true;
            }
            if (this.getPriceNotation() != null) {
                return true;
            }
            if (this.getPriceCurrency() != null) {
                return true;
            }
            if (this.getPackageTransactionPrice() != null && this.getPackageTransactionPrice().hasData()) {
                return true;
            }
            if (this.getPackageTransactionPriceNotation() != null) {
                return true;
            }
            if (this.getPackageTransactionPriceCurrency() != null) {
                return true;
            }
            if (this.getPackageTransactionSpread() != null && this.getPackageTransactionSpread().hasData()) {
                return true;
            }
            if (this.getPackageTransactionSpreadNotation() != null) {
                return true;
            }
            if (this.getPackageTransactionSpreadCurrency() != null) {
                return true;
            }
            if (this.getPackageIdentifier() != null) {
                return true;
            }
            if (this.getStrikePrice() != null && this.getStrikePrice().hasData()) {
                return true;
            }
            if (this.getStrikePriceNotation() != null) {
                return true;
            }
            if (this.getStrikePriceCurrency() != null) {
                return true;
            }
            if (this.getPriceUnitOfMeasure() != null) {
                return true;
            }
            if (this.getOptionPremiumAmount() != null) {
                return true;
            }
            if (this.getOptionPremiumCurrency() != null) {
                return true;
            }
            if (this.getOptionPremiumPaymentDate() != null) {
                return true;
            }
            if (this.getExchangeRate() != null) {
                return true;
            }
            if (this.getExchangeRateBasis() != null) {
                return true;
            }
            if (this.getCdSIndexAttachmentPoint() != null) {
                return true;
            }
            if (this.getCdSIndexDetachmentPoint() != null) {
                return true;
            }
            if (this.getCollateralPortfolioIndicator() != null) {
                return true;
            }
            if (this.getFirstExerciseDate() != null) {
                return true;
            }
            if (this.getFinalContractualSettlementDate() != null) {
                return true;
            }
            if (this.getSettlementLocation() != null) {
                return true;
            }
            if (this.getPriorUTI() != null) {
                return true;
            }
            if (this.getDirection1() != null) {
                return true;
            }
            if (this.getValuationAmount() != null) {
                return true;
            }
            if (this.getValuationCurrency() != null) {
                return true;
            }
            if (this.getValuationMethod() != null) {
                return true;
            }
            if (this.getValuationTimestamp() != null) {
                return true;
            }
            if (this.getCustomBasketCode() != null) {
                return true;
            }
            if (this.getBasketConstituents() != null && this.getBasketConstituents().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getOtherPayment() != null && this.getOtherPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLeg1() != null && this.getLeg1().hasData()) {
                return true;
            }
            if (this.getLeg2() != null && this.getLeg2().hasData()) {
                return true;
            }
            if (this.getUnderlyingIdOther() != null) {
                return true;
            }
            if (this.getUnderlyingIdOtherSource() != null) {
                return true;
            }
            if (this.getUnderlyingAssetTradingPlatformIdentifier() != null) {
                return true;
            }
            if (this.getUnderlyingAssetPriceSource() != null) {
                return true;
            }
            if (this.getCryptoAssetUnderlyingIndicator() != null) {
                return true;
            }
            if (this.getLevel() != null) {
                return true;
            }
            if (this.getActionType() != null) {
                return true;
            }
            if (this.getEventType() != null) {
                return true;
            }
            if (this.getEventIdentifier() != null) {
                return true;
            }
            if (this.getEventTimestamp() != null) {
                return true;
            }
            if (this.getConfirmationTimestamp() != null) {
                return true;
            }
            if (this.getPlatformIdentifier() != null) {
                return true;
            }
            if (this.getBookingLocation() != null) {
                return true;
            }
            if (this.getTraderLocation() != null) {
                return true;
            }
            if (this.getDeliveryType() != null) {
                return true;
            }
            if (this.getExecutionAgentCounterparty1() != null) {
                return true;
            }
            if (this.getExecutionAgentCounterparty2() != null) {
                return true;
            }
            if (this.getNatureOfCounterparty1() != null) {
                return true;
            }
            if (this.getNatureOfCounterparty2() != null) {
                return true;
            }
            if (this.getClearingExceptionsAndExemptionsCounterparty1() != null && !this.getClearingExceptionsAndExemptionsCounterparty1().isEmpty()) {
                return true;
            }
            if (this.getClearingExceptionsAndExemptionsCounterparty2() != null && !this.getClearingExceptionsAndExemptionsCounterparty2().isEmpty()) {
                return true;
            }
            if (this.getCorporateSectorOfTheCounterparty1() != null && !this.getCorporateSectorOfTheCounterparty1().isEmpty()) {
                return true;
            }
            if (this.getCorporateSectorOfTheCounterparty2() != null && !this.getCorporateSectorOfTheCounterparty2().isEmpty()) {
                return true;
            }
            if (this.getCounterparty2Name() != null) {
                return true;
            }
            if (this.getReportSubmittingEntityID() != null) {
                return true;
            }
            if (this.getEntityResponsibleForReporting() != null) {
                return true;
            }
            if (this.getCountryOfTheCounterparty2() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierSource() != null) {
                return true;
            }
            if (this.getTradingCapacity() != null) {
                return true;
            }
            if (this.getBrokerID() != null) {
                return true;
            }
            if (this.getContractType() != null) {
                return true;
            }
            if (this.getAssetClass() != null) {
                return true;
            }
            if (this.getOptionType() != null) {
                return true;
            }
            if (this.getOptionStyle() != null) {
                return true;
            }
            if (this.getEmbeddedOptionType() != null) {
                return true;
            }
            if (this.getMasterAgreementType() != null) {
                return true;
            }
            if (this.getMasterAgreementVersion() != null) {
                return true;
            }
            if (this.getSecondaryTransactionIdentifier() != null) {
                return true;
            }
            if (this.getIntragroup() != null) {
                return true;
            }
            if (this.getNonStandardizedTermIndicator() != null) {
                return true;
            }
            if (this.getAmendmentIndicator() != null) {
                return true;
            }
            if (this.getUnderlyingIdentification() != null) {
                return true;
            }
            if (this.getUnderlyingIdentificationType() != null) {
                return true;
            }
            if (this.getNameOfTheUnderlyingIndex() != null) {
                return true;
            }
            if (this.getMaturityDateOfTheUnderlying() != null) {
                return true;
            }
            if (this.getSwapLinkID() != null) {
                return true;
            }
            if (this.getPackageIndicator() != null) {
                return true;
            }
            if (this.getCustomBasketIndicator() != null) {
                return true;
            }
            if (this.getPriorUTIProprietary() != null) {
                return true;
            }
            if (this.getClearingTimestamp() != null) {
                return true;
            }
            if (this.getClearingAccountOrigin() != null) {
                return true;
            }
            if (this.getClearingReceiptTimestamp() != null) {
                return true;
            }
            if (this.getUniqueTransactionIdentifier() != null) {
                return true;
            }
            if (this.getUniqueTransactionIdentifierProprietary() != null) {
                return true;
            }
            if (this.getUniqueProductIdentifier() != null) {
                return true;
            }
            if (this.getOriginalSwapUTI() != null) {
                return true;
            }
            if (this.getSubsequentPositionUTI() != null) {
                return true;
            }
            if (this.getOriginalSwapSDRIdentifier() != null) {
                return true;
            }
            if (this.getPriorUSI() != null) {
                return true;
            }
            if (this.getNewSDRIdentifier() != null) {
                return true;
            }
            if (this.getTechnicalRecordId() != null) {
                return true;
            }
            if (this.getReferenceEntity() != null) {
                return true;
            }
            if (this.getSeniority() != null) {
                return true;
            }
            if (this.getSeries() != null) {
                return true;
            }
            if (this.getIndexFactor() != null) {
                return true;
            }
            if (this.getSeriesVersion() != null) {
                return true;
            }
            if (this.getBaseProduct() != null) {
                return true;
            }
            if (this.getSubProduct() != null) {
                return true;
            }
            if (this.getFurtherSubProduct() != null) {
                return true;
            }
            if (this.getBarrier() != null && this.getBarrier().hasData()) {
                return true;
            }
            if (this.getInitialMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getVariationMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getNonReportable() != null && this.getNonReportable().hasData()) {
                return true;
            }
            if (this.getCountryAndProvinceOrTerritoryOfIndividual() != null) {
                return true;
            }
            if (this.getJurisdictionOfCounterparty1() != null && !this.getJurisdictionOfCounterparty1().isEmpty()) {
                return true;
            }
            if (this.getJurisdictionOfCounterparty2() != null && !this.getJurisdictionOfCounterparty2().isEmpty()) {
                return true;
            }
            if (this.getInterAffiliateIndicator() != null) {
                return true;
            }
            if (this.getPlatformAnonymousExecutionIndicator() != null) {
                return true;
            }
            return this.getDtccAdditionalFields() != null && this.getDtccAdditionalFields().hasData();
        }

        public CSATransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CSATransactionReportBuilder o = (CSATransactionReportBuilder)other;
            merger.mergeRosetta(this.getPriceSchedule(), o.getPriceSchedule(), this::getOrCreatePriceSchedule);
            merger.mergeRosetta(this.getStrikePriceSchedule(), o.getStrikePriceSchedule(), this::getOrCreateStrikePriceSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrice(), (RosettaModelObjectBuilder)o.getPrice(), this::setPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageTransactionPrice(), (RosettaModelObjectBuilder)o.getPackageTransactionPrice(), this::setPackageTransactionPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageTransactionSpread(), (RosettaModelObjectBuilder)o.getPackageTransactionSpread(), this::setPackageTransactionSpread);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrikePrice(), (RosettaModelObjectBuilder)o.getStrikePrice(), this::setStrikePrice);
            merger.mergeRosetta(this.getBasketConstituents(), o.getBasketConstituents(), this::getOrCreateBasketConstituents);
            merger.mergeRosetta(this.getOtherPayment(), o.getOtherPayment(), this::getOrCreateOtherPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLeg1(), (RosettaModelObjectBuilder)o.getLeg1(), this::setLeg1);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLeg2(), (RosettaModelObjectBuilder)o.getLeg2(), this::setLeg2);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBarrier(), (RosettaModelObjectBuilder)o.getBarrier(), this::setBarrier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNonReportable(), (RosettaModelObjectBuilder)o.getNonReportable(), this::setNonReportable);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDtccAdditionalFields(), (RosettaModelObjectBuilder)o.getDtccAdditionalFields(), this::setDtccAdditionalFields);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEarlyTerminationDate(), (Object)o.getEarlyTerminationDate(), this::setEarlyTerminationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingTimestamp(), (Object)o.getReportingTimestamp(), this::setReportingTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionTimestamp(), (Object)o.getExecutionTimestamp(), this::setExecutionTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExpirationDate(), (Object)o.getExpirationDate(), this::setExpirationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty1(), (Object)o.getCounterparty1(), this::setCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2(), (Object)o.getCounterparty2(), this::setCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierType(), (Object)o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBeneficiary1(), (Object)o.getBeneficiary1(), this::setBeneficiary1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBeneficiary1IdentifierTypeIndicator(), (Object)o.getBeneficiary1IdentifierTypeIndicator(), this::setBeneficiary1IdentifierTypeIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBuyerIdentifier(), (Object)o.getBuyerIdentifier(), this::setBuyerIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSellerIdentifier(), (Object)o.getSellerIdentifier(), this::setSellerIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCleared(), (Object)o.getCleared(), this::setClearedOverriddenAsClearedEnum, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCentralCounterparty(), (Object)o.getCentralCounterparty(), this::setCentralCounterparty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingMember(), (Object)o.getClearingMember(), this::setClearingMember, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getConfirmed(), (Object)o.getConfirmed(), this::setConfirmed, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCallAmount(), (Object)o.getCallAmount(), this::setCallAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPutAmount(), (Object)o.getPutAmount(), this::setPutAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCallCurrency(), (Object)o.getCallCurrency(), this::setCallCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPutCurrency(), (Object)o.getPutCurrency(), this::setPutCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDelta(), (Object)o.getDelta(), this::setDelta, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceNotation(), (Object)o.getPriceNotation(), this::setPriceNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceCurrency(), (Object)o.getPriceCurrency(), this::setPriceCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageTransactionPriceNotation(), (Object)o.getPackageTransactionPriceNotation(), this::setPackageTransactionPriceNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageTransactionPriceCurrency(), (Object)o.getPackageTransactionPriceCurrency(), this::setPackageTransactionPriceCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageTransactionSpreadNotation(), (Object)o.getPackageTransactionSpreadNotation(), this::setPackageTransactionSpreadNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageTransactionSpreadCurrency(), (Object)o.getPackageTransactionSpreadCurrency(), this::setPackageTransactionSpreadCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageIdentifier(), (Object)o.getPackageIdentifier(), this::setPackageIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getStrikePriceNotation(), (Object)o.getStrikePriceNotation(), this::setStrikePriceNotation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getStrikePriceCurrency(), (Object)o.getStrikePriceCurrency(), this::setStrikePriceCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriceUnitOfMeasure(), (Object)o.getPriceUnitOfMeasure(), this::setPriceUnitOfMeasure, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumAmount(), (Object)o.getOptionPremiumAmount(), this::setOptionPremiumAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumCurrency(), (Object)o.getOptionPremiumCurrency(), this::setOptionPremiumCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionPremiumPaymentDate(), (Object)o.getOptionPremiumPaymentDate(), this::setOptionPremiumPaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExchangeRate(), (Object)o.getExchangeRate(), this::setExchangeRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExchangeRateBasis(), (Object)o.getExchangeRateBasis(), this::setExchangeRateBasis, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCdSIndexAttachmentPoint(), (Object)o.getCdSIndexAttachmentPoint(), this::setCdSIndexAttachmentPoint, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCdSIndexDetachmentPoint(), (Object)o.getCdSIndexDetachmentPoint(), this::setCdSIndexDetachmentPoint, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralPortfolioIndicator(), (Object)o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFirstExerciseDate(), (Object)o.getFirstExerciseDate(), this::setFirstExerciseDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFinalContractualSettlementDate(), (Object)o.getFinalContractualSettlementDate(), this::setFinalContractualSettlementDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementLocation(), (Object)o.getSettlementLocation(), this::setSettlementLocation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriorUTI(), (Object)o.getPriorUTI(), this::setPriorUTI, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirection1(), (Object)o.getDirection1(), this::setDirection1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationAmount(), (Object)o.getValuationAmount(), this::setValuationAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationCurrency(), (Object)o.getValuationCurrency(), this::setValuationCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationMethod(), (Object)o.getValuationMethod(), this::setValuationMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationTimestamp(), (Object)o.getValuationTimestamp(), this::setValuationTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCustomBasketCode(), (Object)o.getCustomBasketCode(), this::setCustomBasketCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIdOther(), (Object)o.getUnderlyingIdOther(), this::setUnderlyingIdOther, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIdOtherSource(), (Object)o.getUnderlyingIdOtherSource(), this::setUnderlyingIdOtherSource, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (Object)o.getUnderlyingAssetTradingPlatformIdentifier(), this::setUnderlyingAssetTradingPlatformIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingAssetPriceSource(), (Object)o.getUnderlyingAssetPriceSource(), this::setUnderlyingAssetPriceSource, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCryptoAssetUnderlyingIndicator(), (Object)o.getCryptoAssetUnderlyingIndicator(), this::setCryptoAssetUnderlyingIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLevel(), (Object)o.getLevel(), this::setLevel, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getActionType(), (Object)o.getActionType(), this::setActionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventType(), (Object)o.getEventType(), this::setEventType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventIdentifier(), (Object)o.getEventIdentifier(), this::setEventIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventTimestamp(), (Object)o.getEventTimestamp(), this::setEventTimestampOverriddenAsZonedDateTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getConfirmationTimestamp(), (Object)o.getConfirmationTimestamp(), this::setConfirmationTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPlatformIdentifier(), (Object)o.getPlatformIdentifier(), this::setPlatformIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBookingLocation(), (Object)o.getBookingLocation(), this::setBookingLocation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTraderLocation(), (Object)o.getTraderLocation(), this::setTraderLocation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDeliveryType(), (Object)o.getDeliveryType(), this::setDeliveryType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionAgentCounterparty1(), (Object)o.getExecutionAgentCounterparty1(), this::setExecutionAgentCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionAgentCounterparty2(), (Object)o.getExecutionAgentCounterparty2(), this::setExecutionAgentCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNatureOfCounterparty1(), (Object)o.getNatureOfCounterparty1(), this::setNatureOfCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNatureOfCounterparty2(), (Object)o.getNatureOfCounterparty2(), this::setNatureOfCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic(this.getClearingExceptionsAndExemptionsCounterparty1(), o.getClearingExceptionsAndExemptionsCounterparty1(), this::addClearingExceptionsAndExemptionsCounterparty1);
            merger.mergeBasic(this.getClearingExceptionsAndExemptionsCounterparty2(), o.getClearingExceptionsAndExemptionsCounterparty2(), this::addClearingExceptionsAndExemptionsCounterparty2);
            merger.mergeBasic(this.getCorporateSectorOfTheCounterparty1(), o.getCorporateSectorOfTheCounterparty1(), this::addCorporateSectorOfTheCounterparty1);
            merger.mergeBasic(this.getCorporateSectorOfTheCounterparty2(), o.getCorporateSectorOfTheCounterparty2(), this::addCorporateSectorOfTheCounterparty2);
            merger.mergeBasic((Object)this.getCounterparty2Name(), (Object)o.getCounterparty2Name(), this::setCounterparty2Name, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportSubmittingEntityID(), (Object)o.getReportSubmittingEntityID(), this::setReportSubmittingEntityID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEntityResponsibleForReporting(), (Object)o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCountryOfTheCounterparty2(), (Object)o.getCountryOfTheCounterparty2(), this::setCountryOfTheCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierSource(), (Object)o.getCounterparty2IdentifierSource(), this::setCounterparty2IdentifierSourceOverriddenAsCounterparty2IdentifierEnum, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradingCapacity(), (Object)o.getTradingCapacity(), this::setTradingCapacity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBrokerID(), (Object)o.getBrokerID(), this::setBrokerID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getContractType(), (Object)o.getContractType(), this::setContractType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAssetClass(), (Object)o.getAssetClass(), this::setAssetClass, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionType(), (Object)o.getOptionType(), this::setOptionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOptionStyle(), (Object)o.getOptionStyle(), this::setOptionStyle, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEmbeddedOptionType(), (Object)o.getEmbeddedOptionType(), this::setEmbeddedOptionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMasterAgreementType(), (Object)o.getMasterAgreementType(), this::setMasterAgreementType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMasterAgreementVersion(), (Object)o.getMasterAgreementVersion(), this::setMasterAgreementVersion, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSecondaryTransactionIdentifier(), (Object)o.getSecondaryTransactionIdentifier(), this::setSecondaryTransactionIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIntragroup(), (Object)o.getIntragroup(), this::setIntragroup, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNonStandardizedTermIndicator(), (Object)o.getNonStandardizedTermIndicator(), this::setNonStandardizedTermIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAmendmentIndicator(), (Object)o.getAmendmentIndicator(), this::setAmendmentIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIdentification(), (Object)o.getUnderlyingIdentification(), this::setUnderlyingIdentification, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingIdentificationType(), (Object)o.getUnderlyingIdentificationType(), this::setUnderlyingIdentificationType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNameOfTheUnderlyingIndex(), (Object)o.getNameOfTheUnderlyingIndex(), this::setNameOfTheUnderlyingIndex, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMaturityDateOfTheUnderlying(), (Object)o.getMaturityDateOfTheUnderlying(), this::setMaturityDateOfTheUnderlying, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSwapLinkID(), (Object)o.getSwapLinkID(), this::setSwapLinkID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageIndicator(), (Object)o.getPackageIndicator(), this::setPackageIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCustomBasketIndicator(), (Object)o.getCustomBasketIndicator(), this::setCustomBasketIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriorUTIProprietary(), (Object)o.getPriorUTIProprietary(), this::setPriorUTIProprietary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingTimestamp(), (Object)o.getClearingTimestamp(), this::setClearingTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingAccountOrigin(), (Object)o.getClearingAccountOrigin(), this::setClearingAccountOrigin, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingReceiptTimestamp(), (Object)o.getClearingReceiptTimestamp(), this::setClearingReceiptTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifier(), (Object)o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifierProprietary(), (Object)o.getUniqueTransactionIdentifierProprietary(), this::setUniqueTransactionIdentifierProprietary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueProductIdentifier(), (Object)o.getUniqueProductIdentifier(), this::setUniqueProductIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOriginalSwapUTI(), (Object)o.getOriginalSwapUTI(), this::setOriginalSwapUTI, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubsequentPositionUTI(), (Object)o.getSubsequentPositionUTI(), this::setSubsequentPositionUTI, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOriginalSwapSDRIdentifier(), (Object)o.getOriginalSwapSDRIdentifier(), this::setOriginalSwapSDRIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPriorUSI(), (Object)o.getPriorUSI(), this::setPriorUSI, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNewSDRIdentifier(), (Object)o.getNewSDRIdentifier(), this::setNewSDRIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordId, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReferenceEntity(), (Object)o.getReferenceEntity(), this::setReferenceEntity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSeniority(), (Object)o.getSeniority(), this::setSeniority, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSeries(), (Object)o.getSeries(), this::setSeries, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIndexFactor(), (Object)o.getIndexFactor(), this::setIndexFactor, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSeriesVersion(), (Object)o.getSeriesVersion(), this::setSeriesVersion, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBaseProduct(), (Object)o.getBaseProduct(), this::setBaseProduct, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubProduct(), (Object)o.getSubProduct(), this::setSubProduct, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFurtherSubProduct(), (Object)o.getFurtherSubProduct(), this::setFurtherSubProduct, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginCollateralPortfolioCode(), (Object)o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginCollateralPortfolioCode(), (Object)o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCountryAndProvinceOrTerritoryOfIndividual(), (Object)o.getCountryAndProvinceOrTerritoryOfIndividual(), this::setCountryAndProvinceOrTerritoryOfIndividual, new AttributeMeta[0]);
            merger.mergeBasic(this.getJurisdictionOfCounterparty1(), o.getJurisdictionOfCounterparty1(), this::addJurisdictionOfCounterparty1);
            merger.mergeBasic(this.getJurisdictionOfCounterparty2(), o.getJurisdictionOfCounterparty2(), this::addJurisdictionOfCounterparty2);
            merger.mergeBasic((Object)this.getInterAffiliateIndicator(), (Object)o.getInterAffiliateIndicator(), this::setInterAffiliateIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPlatformAnonymousExecutionIndicator(), (Object)o.getPlatformAnonymousExecutionIndicator(), this::setPlatformAnonymousExecutionIndicator, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CSATransactionReport _that = this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.earlyTerminationDate, _that.getEarlyTerminationDate())) {
                return false;
            }
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.executionTimestamp, _that.getExecutionTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.expirationDate, _that.getExpirationDate())) {
                return false;
            }
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.beneficiary1, _that.getBeneficiary1())) {
                return false;
            }
            if (!Objects.equals(this.beneficiary1IdentifierTypeIndicator, _that.getBeneficiary1IdentifierTypeIndicator())) {
                return false;
            }
            if (!Objects.equals(this.buyerIdentifier, _that.getBuyerIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.sellerIdentifier, _that.getSellerIdentifier())) {
                return false;
            }
            if (!Objects.equals((Object)this.cleared, (Object)_that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.centralCounterparty, _that.getCentralCounterparty())) {
                return false;
            }
            if (!Objects.equals(this.clearingMember, _that.getClearingMember())) {
                return false;
            }
            if (!Objects.equals((Object)this.confirmed, (Object)_that.getConfirmed())) {
                return false;
            }
            if (!Objects.equals(this.callAmount, _that.getCallAmount())) {
                return false;
            }
            if (!Objects.equals(this.putAmount, _that.getPutAmount())) {
                return false;
            }
            if (!Objects.equals(this.callCurrency, _that.getCallCurrency())) {
                return false;
            }
            if (!Objects.equals(this.putCurrency, _that.getPutCurrency())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!ListEquals.listEquals(this.priceSchedule, _that.getPriceSchedule())) {
                return false;
            }
            if (!ListEquals.listEquals(this.strikePriceSchedule, _that.getStrikePriceSchedule())) {
                return false;
            }
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.priceNotation, (Object)_that.getPriceNotation())) {
                return false;
            }
            if (!Objects.equals(this.priceCurrency, _that.getPriceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionPrice, _that.getPackageTransactionPrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.packageTransactionPriceNotation, (Object)_that.getPackageTransactionPriceNotation())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionPriceCurrency, _that.getPackageTransactionPriceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionSpread, _that.getPackageTransactionSpread())) {
                return false;
            }
            if (!Objects.equals((Object)this.packageTransactionSpreadNotation, (Object)_that.getPackageTransactionSpreadNotation())) {
                return false;
            }
            if (!Objects.equals(this.packageTransactionSpreadCurrency, _that.getPackageTransactionSpreadCurrency())) {
                return false;
            }
            if (!Objects.equals(this.packageIdentifier, _that.getPackageIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            if (!Objects.equals((Object)this.strikePriceNotation, (Object)_that.getStrikePriceNotation())) {
                return false;
            }
            if (!Objects.equals(this.strikePriceCurrency, _that.getStrikePriceCurrency())) {
                return false;
            }
            if (!Objects.equals(this.priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumAmount, _that.getOptionPremiumAmount())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumCurrency, _that.getOptionPremiumCurrency())) {
                return false;
            }
            if (!Objects.equals(this.optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRate, _that.getExchangeRate())) {
                return false;
            }
            if (!Objects.equals(this.exchangeRateBasis, _that.getExchangeRateBasis())) {
                return false;
            }
            if (!Objects.equals(this.cdSIndexAttachmentPoint, _that.getCdSIndexAttachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.cdSIndexDetachmentPoint, _that.getCdSIndexDetachmentPoint())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) {
                return false;
            }
            if (!Objects.equals(this.firstExerciseDate, _that.getFirstExerciseDate())) {
                return false;
            }
            if (!Objects.equals(this.finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.settlementLocation, _that.getSettlementLocation())) {
                return false;
            }
            if (!Objects.equals(this.priorUTI, _that.getPriorUTI())) {
                return false;
            }
            if (!Objects.equals((Object)this.direction1, (Object)_that.getDirection1())) {
                return false;
            }
            if (!Objects.equals(this.valuationAmount, _that.getValuationAmount())) {
                return false;
            }
            if (!Objects.equals(this.valuationCurrency, _that.getValuationCurrency())) {
                return false;
            }
            if (!Objects.equals((Object)this.valuationMethod, (Object)_that.getValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.valuationTimestamp, _that.getValuationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.customBasketCode, _that.getCustomBasketCode())) {
                return false;
            }
            if (!ListEquals.listEquals(this.basketConstituents, _that.getBasketConstituents())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherPayment, _that.getOtherPayment())) {
                return false;
            }
            if (!Objects.equals(this.leg1, _that.getLeg1())) {
                return false;
            }
            if (!Objects.equals(this.leg2, _that.getLeg2())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdOther, _that.getUnderlyingIdOther())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdOtherSource, _that.getUnderlyingIdOtherSource())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetTradingPlatformIdentifier, _that.getUnderlyingAssetTradingPlatformIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetPriceSource, _that.getUnderlyingAssetPriceSource())) {
                return false;
            }
            if (!Objects.equals(this.cryptoAssetUnderlyingIndicator, _that.getCryptoAssetUnderlyingIndicator())) {
                return false;
            }
            if (!Objects.equals((Object)this.level, (Object)_that.getLevel())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals((Object)this.eventType, (Object)_that.getEventType())) {
                return false;
            }
            if (!Objects.equals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.confirmationTimestamp, _that.getConfirmationTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.platformIdentifier, _that.getPlatformIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.bookingLocation, _that.getBookingLocation())) {
                return false;
            }
            if (!Objects.equals(this.traderLocation, _that.getTraderLocation())) {
                return false;
            }
            if (!Objects.equals((Object)this.deliveryType, (Object)_that.getDeliveryType())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentCounterparty1, _that.getExecutionAgentCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentCounterparty2, _that.getExecutionAgentCounterparty2())) {
                return false;
            }
            if (!Objects.equals((Object)this.natureOfCounterparty1, (Object)_that.getNatureOfCounterparty1())) {
                return false;
            }
            if (!Objects.equals((Object)this.natureOfCounterparty2, (Object)_that.getNatureOfCounterparty2())) {
                return false;
            }
            if (!ListEquals.listEquals(this.clearingExceptionsAndExemptionsCounterparty1, _that.getClearingExceptionsAndExemptionsCounterparty1())) {
                return false;
            }
            if (!ListEquals.listEquals(this.clearingExceptionsAndExemptionsCounterparty2, _that.getClearingExceptionsAndExemptionsCounterparty2())) {
                return false;
            }
            if (!ListEquals.listEquals(this.corporateSectorOfTheCounterparty1, _that.getCorporateSectorOfTheCounterparty1())) {
                return false;
            }
            if (!ListEquals.listEquals(this.corporateSectorOfTheCounterparty2, _that.getCorporateSectorOfTheCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2Name, _that.getCounterparty2Name())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) {
                return false;
            }
            if (!Objects.equals(this.countryOfTheCounterparty2, _that.getCountryOfTheCounterparty2())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2IdentifierSource, (Object)_that.getCounterparty2IdentifierSource())) {
                return false;
            }
            if (!Objects.equals((Object)this.tradingCapacity, (Object)_that.getTradingCapacity())) {
                return false;
            }
            if (!Objects.equals(this.brokerID, _that.getBrokerID())) {
                return false;
            }
            if (!Objects.equals((Object)this.contractType, (Object)_that.getContractType())) {
                return false;
            }
            if (!Objects.equals((Object)this.assetClass, (Object)_that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionType, (Object)_that.getOptionType())) {
                return false;
            }
            if (!Objects.equals((Object)this.optionStyle, (Object)_that.getOptionStyle())) {
                return false;
            }
            if (!Objects.equals((Object)this.embeddedOptionType, (Object)_that.getEmbeddedOptionType())) {
                return false;
            }
            if (!Objects.equals((Object)this.masterAgreementType, (Object)_that.getMasterAgreementType())) {
                return false;
            }
            if (!Objects.equals(this.masterAgreementVersion, _that.getMasterAgreementVersion())) {
                return false;
            }
            if (!Objects.equals(this.secondaryTransactionIdentifier, _that.getSecondaryTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.intragroup, _that.getIntragroup())) {
                return false;
            }
            if (!Objects.equals(this.nonStandardizedTermIndicator, _that.getNonStandardizedTermIndicator())) {
                return false;
            }
            if (!Objects.equals(this.amendmentIndicator, _that.getAmendmentIndicator())) {
                return false;
            }
            if (!Objects.equals(this.underlyingIdentification, _that.getUnderlyingIdentification())) {
                return false;
            }
            if (!Objects.equals((Object)this.underlyingIdentificationType, (Object)_that.getUnderlyingIdentificationType())) {
                return false;
            }
            if (!Objects.equals(this.nameOfTheUnderlyingIndex, _that.getNameOfTheUnderlyingIndex())) {
                return false;
            }
            if (!Objects.equals(this.maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) {
                return false;
            }
            if (!Objects.equals(this.swapLinkID, _that.getSwapLinkID())) {
                return false;
            }
            if (!Objects.equals(this.packageIndicator, _that.getPackageIndicator())) {
                return false;
            }
            if (!Objects.equals(this.customBasketIndicator, _that.getCustomBasketIndicator())) {
                return false;
            }
            if (!Objects.equals(this.priorUTIProprietary, _that.getPriorUTIProprietary())) {
                return false;
            }
            if (!Objects.equals(this.clearingTimestamp, _that.getClearingTimestamp())) {
                return false;
            }
            if (!Objects.equals((Object)this.clearingAccountOrigin, (Object)_that.getClearingAccountOrigin())) {
                return false;
            }
            if (!Objects.equals(this.clearingReceiptTimestamp, _that.getClearingReceiptTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) {
                return false;
            }
            if (!Objects.equals(this.uniqueProductIdentifier, _that.getUniqueProductIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.originalSwapUTI, _that.getOriginalSwapUTI())) {
                return false;
            }
            if (!Objects.equals(this.subsequentPositionUTI, _that.getSubsequentPositionUTI())) {
                return false;
            }
            if (!Objects.equals(this.originalSwapSDRIdentifier, _that.getOriginalSwapSDRIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.priorUSI, _that.getPriorUSI())) {
                return false;
            }
            if (!Objects.equals(this.newSDRIdentifier, _that.getNewSDRIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.referenceEntity, _that.getReferenceEntity())) {
                return false;
            }
            if (!Objects.equals((Object)this.seniority, (Object)_that.getSeniority())) {
                return false;
            }
            if (!Objects.equals(this.series, _that.getSeries())) {
                return false;
            }
            if (!Objects.equals(this.indexFactor, _that.getIndexFactor())) {
                return false;
            }
            if (!Objects.equals(this.seriesVersion, _that.getSeriesVersion())) {
                return false;
            }
            if (!Objects.equals(this.baseProduct, _that.getBaseProduct())) {
                return false;
            }
            if (!Objects.equals(this.subProduct, _that.getSubProduct())) {
                return false;
            }
            if (!Objects.equals(this.furtherSubProduct, _that.getFurtherSubProduct())) {
                return false;
            }
            if (!Objects.equals(this.barrier, _that.getBarrier())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.nonReportable, _that.getNonReportable())) {
                return false;
            }
            if (!Objects.equals(this.countryAndProvinceOrTerritoryOfIndividual, _that.getCountryAndProvinceOrTerritoryOfIndividual())) {
                return false;
            }
            if (!ListEquals.listEquals(this.jurisdictionOfCounterparty1, _that.getJurisdictionOfCounterparty1())) {
                return false;
            }
            if (!ListEquals.listEquals(this.jurisdictionOfCounterparty2, _that.getJurisdictionOfCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.interAffiliateIndicator, _that.getInterAffiliateIndicator())) {
                return false;
            }
            if (!Objects.equals(this.platformAnonymousExecutionIndicator, _that.getPlatformAnonymousExecutionIndicator())) {
                return false;
            }
            return Objects.equals(this.dtccAdditionalFields, _that.getDtccAdditionalFields());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.earlyTerminationDate != null ? this.earlyTerminationDate.hashCode() : 0);
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.executionTimestamp != null ? this.executionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.beneficiary1 != null ? this.beneficiary1.hashCode() : 0);
            _result = 31 * _result + (this.beneficiary1IdentifierTypeIndicator != null ? this.beneficiary1IdentifierTypeIndicator.hashCode() : 0);
            _result = 31 * _result + (this.buyerIdentifier != null ? this.buyerIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.sellerIdentifier != null ? this.sellerIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? ((Object)((Object)this.cleared)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.centralCounterparty != null ? this.centralCounterparty.hashCode() : 0);
            _result = 31 * _result + (this.clearingMember != null ? this.clearingMember.hashCode() : 0);
            _result = 31 * _result + (this.confirmed != null ? ((Object)((Object)this.confirmed)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.callAmount != null ? this.callAmount.hashCode() : 0);
            _result = 31 * _result + (this.putAmount != null ? this.putAmount.hashCode() : 0);
            _result = 31 * _result + (this.callCurrency != null ? this.callCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.putCurrency != null ? this.putCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.priceSchedule != null ? this.priceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceSchedule != null ? this.strikePriceSchedule.hashCode() : 0);
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.priceNotation != null ? ((Object)((Object)this.priceNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priceCurrency != null ? this.priceCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPrice != null ? this.packageTransactionPrice.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPriceNotation != null ? ((Object)((Object)this.packageTransactionPriceNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionPriceCurrency != null ? this.packageTransactionPriceCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpread != null ? this.packageTransactionSpread.hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpreadNotation != null ? ((Object)((Object)this.packageTransactionSpreadNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageTransactionSpreadCurrency != null ? this.packageTransactionSpreadCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.packageIdentifier != null ? this.packageIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.strikePriceNotation != null ? ((Object)((Object)this.strikePriceNotation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.strikePriceCurrency != null ? this.strikePriceCurrency.hashCode() : 0);
            _result = 31 * _result + (this.priceUnitOfMeasure != null ? this.priceUnitOfMeasure.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumAmount != null ? this.optionPremiumAmount.hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumCurrency != null ? this.optionPremiumCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.optionPremiumPaymentDate != null ? this.optionPremiumPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRate != null ? this.exchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.exchangeRateBasis != null ? this.exchangeRateBasis.hashCode() : 0);
            _result = 31 * _result + (this.cdSIndexAttachmentPoint != null ? this.cdSIndexAttachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.cdSIndexDetachmentPoint != null ? this.cdSIndexDetachmentPoint.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioIndicator != null ? this.collateralPortfolioIndicator.hashCode() : 0);
            _result = 31 * _result + (this.firstExerciseDate != null ? this.firstExerciseDate.hashCode() : 0);
            _result = 31 * _result + (this.finalContractualSettlementDate != null ? this.finalContractualSettlementDate.hashCode() : 0);
            _result = 31 * _result + (this.settlementLocation != null ? this.settlementLocation.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.priorUTI != null ? this.priorUTI.hashCode() : 0);
            _result = 31 * _result + (this.direction1 != null ? ((Object)((Object)this.direction1)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationAmount != null ? this.valuationAmount.hashCode() : 0);
            _result = 31 * _result + (this.valuationCurrency != null ? this.valuationCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? ((Object)((Object)this.valuationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationTimestamp != null ? this.valuationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.customBasketCode != null ? this.customBasketCode.hashCode() : 0);
            _result = 31 * _result + (this.basketConstituents != null ? this.basketConstituents.hashCode() : 0);
            _result = 31 * _result + (this.otherPayment != null ? this.otherPayment.hashCode() : 0);
            _result = 31 * _result + (this.leg1 != null ? this.leg1.hashCode() : 0);
            _result = 31 * _result + (this.leg2 != null ? this.leg2.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdOther != null ? this.underlyingIdOther.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdOtherSource != null ? this.underlyingIdOtherSource.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetTradingPlatformIdentifier != null ? this.underlyingAssetTradingPlatformIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetPriceSource != null ? this.underlyingAssetPriceSource.hashCode() : 0);
            _result = 31 * _result + (this.cryptoAssetUnderlyingIndicator != null ? this.cryptoAssetUnderlyingIndicator.hashCode() : 0);
            _result = 31 * _result + (this.level != null ? ((Object)((Object)this.level)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventType != null ? ((Object)((Object)this.eventType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.confirmationTimestamp != null ? this.confirmationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.platformIdentifier != null ? this.platformIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.bookingLocation != null ? this.bookingLocation.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.traderLocation != null ? this.traderLocation.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.deliveryType != null ? ((Object)((Object)this.deliveryType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.executionAgentCounterparty1 != null ? this.executionAgentCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentCounterparty2 != null ? this.executionAgentCounterparty2.hashCode() : 0);
            _result = 31 * _result + (this.natureOfCounterparty1 != null ? ((Object)((Object)this.natureOfCounterparty1)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.natureOfCounterparty2 != null ? ((Object)((Object)this.natureOfCounterparty2)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.clearingExceptionsAndExemptionsCounterparty1 != null ? this.clearingExceptionsAndExemptionsCounterparty1.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.clearingExceptionsAndExemptionsCounterparty2 != null ? this.clearingExceptionsAndExemptionsCounterparty2.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.corporateSectorOfTheCounterparty1 != null ? this.corporateSectorOfTheCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.corporateSectorOfTheCounterparty2 != null ? this.corporateSectorOfTheCounterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2Name != null ? this.counterparty2Name.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            _result = 31 * _result + (this.countryOfTheCounterparty2 != null ? this.countryOfTheCounterparty2.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierSource != null ? ((Object)((Object)this.counterparty2IdentifierSource)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradingCapacity != null ? ((Object)((Object)this.tradingCapacity)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.brokerID != null ? this.brokerID.hashCode() : 0);
            _result = 31 * _result + (this.contractType != null ? ((Object)((Object)this.contractType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? ((Object)((Object)this.assetClass)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.optionType != null ? ((Object)((Object)this.optionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.optionStyle != null ? ((Object)((Object)this.optionStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.embeddedOptionType != null ? ((Object)((Object)this.embeddedOptionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.masterAgreementType != null ? ((Object)((Object)this.masterAgreementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.masterAgreementVersion != null ? this.masterAgreementVersion.hashCode() : 0);
            _result = 31 * _result + (this.secondaryTransactionIdentifier != null ? this.secondaryTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.intragroup != null ? this.intragroup.hashCode() : 0);
            _result = 31 * _result + (this.nonStandardizedTermIndicator != null ? this.nonStandardizedTermIndicator.hashCode() : 0);
            _result = 31 * _result + (this.amendmentIndicator != null ? this.amendmentIndicator.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdentification != null ? this.underlyingIdentification.hashCode() : 0);
            _result = 31 * _result + (this.underlyingIdentificationType != null ? ((Object)((Object)this.underlyingIdentificationType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.nameOfTheUnderlyingIndex != null ? this.nameOfTheUnderlyingIndex.hashCode() : 0);
            _result = 31 * _result + (this.maturityDateOfTheUnderlying != null ? this.maturityDateOfTheUnderlying.hashCode() : 0);
            _result = 31 * _result + (this.swapLinkID != null ? this.swapLinkID.hashCode() : 0);
            _result = 31 * _result + (this.packageIndicator != null ? this.packageIndicator.hashCode() : 0);
            _result = 31 * _result + (this.customBasketIndicator != null ? this.customBasketIndicator.hashCode() : 0);
            _result = 31 * _result + (this.priorUTIProprietary != null ? this.priorUTIProprietary.hashCode() : 0);
            _result = 31 * _result + (this.clearingTimestamp != null ? this.clearingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.clearingAccountOrigin != null ? ((Object)((Object)this.clearingAccountOrigin)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.clearingReceiptTimestamp != null ? this.clearingReceiptTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietary != null ? this.uniqueTransactionIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.uniqueProductIdentifier != null ? this.uniqueProductIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.originalSwapUTI != null ? this.originalSwapUTI.hashCode() : 0);
            _result = 31 * _result + (this.subsequentPositionUTI != null ? this.subsequentPositionUTI.hashCode() : 0);
            _result = 31 * _result + (this.originalSwapSDRIdentifier != null ? this.originalSwapSDRIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.priorUSI != null ? this.priorUSI.hashCode() : 0);
            _result = 31 * _result + (this.newSDRIdentifier != null ? this.newSDRIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.referenceEntity != null ? this.referenceEntity.hashCode() : 0);
            _result = 31 * _result + (this.seniority != null ? ((Object)((Object)this.seniority)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.series != null ? this.series.hashCode() : 0);
            _result = 31 * _result + (this.indexFactor != null ? this.indexFactor.hashCode() : 0);
            _result = 31 * _result + (this.seriesVersion != null ? this.seriesVersion.hashCode() : 0);
            _result = 31 * _result + (this.baseProduct != null ? this.baseProduct.hashCode() : 0);
            _result = 31 * _result + (this.subProduct != null ? this.subProduct.hashCode() : 0);
            _result = 31 * _result + (this.furtherSubProduct != null ? this.furtherSubProduct.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.nonReportable != null ? this.nonReportable.hashCode() : 0);
            _result = 31 * _result + (this.countryAndProvinceOrTerritoryOfIndividual != null ? this.countryAndProvinceOrTerritoryOfIndividual.hashCode() : 0);
            _result = 31 * _result + (this.jurisdictionOfCounterparty1 != null ? this.jurisdictionOfCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.jurisdictionOfCounterparty2 != null ? this.jurisdictionOfCounterparty2.hashCode() : 0);
            _result = 31 * _result + (this.interAffiliateIndicator != null ? this.interAffiliateIndicator.hashCode() : 0);
            _result = 31 * _result + (this.platformAnonymousExecutionIndicator != null ? this.platformAnonymousExecutionIndicator.hashCode() : 0);
            _result = 31 * _result + (this.dtccAdditionalFields != null ? this.dtccAdditionalFields.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CSATransactionReportBuilder {effectiveDate=" + String.valueOf(this.effectiveDate) + ", earlyTerminationDate=" + String.valueOf(this.earlyTerminationDate) + ", reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", executionTimestamp=" + String.valueOf(this.executionTimestamp) + ", expirationDate=" + String.valueOf(this.expirationDate) + ", counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", beneficiary1=" + this.beneficiary1 + ", beneficiary1IdentifierTypeIndicator=" + this.beneficiary1IdentifierTypeIndicator + ", buyerIdentifier=" + this.buyerIdentifier + ", sellerIdentifier=" + this.sellerIdentifier + ", cleared=" + String.valueOf((Object)this.cleared) + ", centralCounterparty=" + this.centralCounterparty + ", clearingMember=" + this.clearingMember + ", confirmed=" + String.valueOf((Object)this.confirmed) + ", callAmount=" + String.valueOf(this.callAmount) + ", putAmount=" + String.valueOf(this.putAmount) + ", callCurrency=" + String.valueOf(this.callCurrency) + ", putCurrency=" + String.valueOf(this.putCurrency) + ", delta=" + String.valueOf(this.delta) + ", priceSchedule=" + String.valueOf(this.priceSchedule) + ", strikePriceSchedule=" + String.valueOf(this.strikePriceSchedule) + ", price=" + String.valueOf(this.price) + ", priceNotation=" + String.valueOf((Object)this.priceNotation) + ", priceCurrency=" + String.valueOf(this.priceCurrency) + ", packageTransactionPrice=" + String.valueOf(this.packageTransactionPrice) + ", packageTransactionPriceNotation=" + String.valueOf((Object)this.packageTransactionPriceNotation) + ", packageTransactionPriceCurrency=" + String.valueOf(this.packageTransactionPriceCurrency) + ", packageTransactionSpread=" + String.valueOf(this.packageTransactionSpread) + ", packageTransactionSpreadNotation=" + String.valueOf((Object)this.packageTransactionSpreadNotation) + ", packageTransactionSpreadCurrency=" + String.valueOf(this.packageTransactionSpreadCurrency) + ", packageIdentifier=" + this.packageIdentifier + ", strikePrice=" + String.valueOf(this.strikePrice) + ", strikePriceNotation=" + String.valueOf((Object)this.strikePriceNotation) + ", strikePriceCurrency=" + this.strikePriceCurrency + ", priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", optionPremiumAmount=" + String.valueOf(this.optionPremiumAmount) + ", optionPremiumCurrency=" + String.valueOf(this.optionPremiumCurrency) + ", optionPremiumPaymentDate=" + String.valueOf(this.optionPremiumPaymentDate) + ", exchangeRate=" + String.valueOf(this.exchangeRate) + ", exchangeRateBasis=" + this.exchangeRateBasis + ", cdSIndexAttachmentPoint=" + String.valueOf(this.cdSIndexAttachmentPoint) + ", cdSIndexDetachmentPoint=" + String.valueOf(this.cdSIndexDetachmentPoint) + ", collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", firstExerciseDate=" + String.valueOf(this.firstExerciseDate) + ", finalContractualSettlementDate=" + String.valueOf(this.finalContractualSettlementDate) + ", settlementLocation=" + String.valueOf(this.settlementLocation) + ", priorUTI=" + this.priorUTI + ", direction1=" + String.valueOf((Object)this.direction1) + ", valuationAmount=" + String.valueOf(this.valuationAmount) + ", valuationCurrency=" + String.valueOf(this.valuationCurrency) + ", valuationMethod=" + String.valueOf((Object)this.valuationMethod) + ", valuationTimestamp=" + String.valueOf(this.valuationTimestamp) + ", customBasketCode=" + this.customBasketCode + ", basketConstituents=" + String.valueOf(this.basketConstituents) + ", otherPayment=" + String.valueOf(this.otherPayment) + ", leg1=" + String.valueOf(this.leg1) + ", leg2=" + String.valueOf(this.leg2) + ", underlyingIdOther=" + this.underlyingIdOther + ", underlyingIdOtherSource=" + String.valueOf(this.underlyingIdOtherSource) + ", underlyingAssetTradingPlatformIdentifier=" + this.underlyingAssetTradingPlatformIdentifier + ", underlyingAssetPriceSource=" + this.underlyingAssetPriceSource + ", cryptoAssetUnderlyingIndicator=" + this.cryptoAssetUnderlyingIndicator + ", level=" + String.valueOf((Object)this.level) + ", actionType=" + String.valueOf((Object)this.actionType) + ", eventType=" + String.valueOf((Object)this.eventType) + ", eventIdentifier=" + this.eventIdentifier + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", confirmationTimestamp=" + String.valueOf(this.confirmationTimestamp) + ", platformIdentifier=" + this.platformIdentifier + ", bookingLocation=" + String.valueOf(this.bookingLocation) + ", traderLocation=" + String.valueOf(this.traderLocation) + ", deliveryType=" + String.valueOf((Object)this.deliveryType) + ", executionAgentCounterparty1=" + this.executionAgentCounterparty1 + ", executionAgentCounterparty2=" + this.executionAgentCounterparty2 + ", natureOfCounterparty1=" + String.valueOf((Object)this.natureOfCounterparty1) + ", natureOfCounterparty2=" + String.valueOf((Object)this.natureOfCounterparty2) + ", clearingExceptionsAndExemptionsCounterparty1=" + String.valueOf(this.clearingExceptionsAndExemptionsCounterparty1) + ", clearingExceptionsAndExemptionsCounterparty2=" + String.valueOf(this.clearingExceptionsAndExemptionsCounterparty2) + ", corporateSectorOfTheCounterparty1=" + String.valueOf(this.corporateSectorOfTheCounterparty1) + ", corporateSectorOfTheCounterparty2=" + String.valueOf(this.corporateSectorOfTheCounterparty2) + ", counterparty2Name=" + this.counterparty2Name + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", countryOfTheCounterparty2=" + String.valueOf(this.countryOfTheCounterparty2) + ", counterparty2IdentifierSource=" + String.valueOf((Object)this.counterparty2IdentifierSource) + ", tradingCapacity=" + String.valueOf((Object)this.tradingCapacity) + ", brokerID=" + this.brokerID + ", contractType=" + String.valueOf((Object)this.contractType) + ", assetClass=" + String.valueOf((Object)this.assetClass) + ", optionType=" + String.valueOf((Object)this.optionType) + ", optionStyle=" + String.valueOf((Object)this.optionStyle) + ", embeddedOptionType=" + String.valueOf((Object)this.embeddedOptionType) + ", masterAgreementType=" + String.valueOf((Object)this.masterAgreementType) + ", masterAgreementVersion=" + this.masterAgreementVersion + ", secondaryTransactionIdentifier=" + this.secondaryTransactionIdentifier + ", intragroup=" + this.intragroup + ", nonStandardizedTermIndicator=" + this.nonStandardizedTermIndicator + ", amendmentIndicator=" + (this.amendmentIndicator + ", underlyingIdentification=" + this.underlyingIdentification + ", underlyingIdentificationType=" + String.valueOf((Object)this.underlyingIdentificationType) + ", nameOfTheUnderlyingIndex=" + this.nameOfTheUnderlyingIndex + ", maturityDateOfTheUnderlying=" + String.valueOf(this.maturityDateOfTheUnderlying) + ", swapLinkID=" + this.swapLinkID + ", packageIndicator=" + this.packageIndicator + ", customBasketIndicator=" + this.customBasketIndicator + ", priorUTIProprietary=" + this.priorUTIProprietary + ", clearingTimestamp=" + String.valueOf(this.clearingTimestamp) + ", clearingAccountOrigin=" + String.valueOf((Object)this.clearingAccountOrigin) + ", clearingReceiptTimestamp=" + String.valueOf(this.clearingReceiptTimestamp) + ", uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", originalSwapUTI=" + this.originalSwapUTI + ", subsequentPositionUTI=" + this.subsequentPositionUTI + ", originalSwapSDRIdentifier=" + this.originalSwapSDRIdentifier + ", priorUSI=" + this.priorUSI + ", newSDRIdentifier=" + this.newSDRIdentifier + ", technicalRecordId=" + this.technicalRecordId + ", referenceEntity=" + this.referenceEntity + ", seniority=" + String.valueOf((Object)this.seniority) + ", series=" + this.series + ", indexFactor=" + String.valueOf(this.indexFactor) + ", seriesVersion=" + this.seriesVersion + ", baseProduct=" + this.baseProduct + ", subProduct=" + this.subProduct + ", furtherSubProduct=" + this.furtherSubProduct + ", barrier=" + String.valueOf(this.barrier) + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", nonReportable=" + String.valueOf(this.nonReportable) + ", countryAndProvinceOrTerritoryOfIndividual=" + this.countryAndProvinceOrTerritoryOfIndividual + ", jurisdictionOfCounterparty1=" + String.valueOf(this.jurisdictionOfCounterparty1) + ", jurisdictionOfCounterparty2=" + String.valueOf(this.jurisdictionOfCounterparty2) + ", interAffiliateIndicator=" + this.interAffiliateIndicator + ", platformAnonymousExecutionIndicator=" + this.platformAnonymousExecutionIndicator + ", dtccAdditionalFields=" + String.valueOf(this.dtccAdditionalFields) + "}");
        }
    }

    public static interface CSATransactionReportBuilder
    extends CSATransactionReport,
    CommonTransactionReport.CommonTransactionReportBuilder {
        @Override
        public CSALeg.CSALegBuilder getOrCreateLeg1();

        @Override
        public CSALeg.CSALegBuilder getLeg1();

        @Override
        public CSALeg.CSALegBuilder getOrCreateLeg2();

        @Override
        public CSALeg.CSALegBuilder getLeg2();

        @Override
        public CSANonReportable.CSANonReportableBuilder getOrCreateNonReportable();

        @Override
        public CSANonReportable.CSANonReportableBuilder getNonReportable();

        public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder getOrCreateDtccAdditionalFields();

        @Override
        public DTCCAdditionalFields.DTCCAdditionalFieldsBuilder getDtccAdditionalFields();

        @Override
        public CSATransactionReportBuilder setEffectiveDate(Date var1);

        @Override
        public CSATransactionReportBuilder setEarlyTerminationDate(Date var1);

        @Override
        public CSATransactionReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public CSATransactionReportBuilder setExecutionTimestamp(ZonedDateTime var1);

        @Override
        public CSATransactionReportBuilder setExpirationDate(Date var1);

        @Override
        public CSATransactionReportBuilder setCounterparty1(String var1);

        @Override
        public CSATransactionReportBuilder setCounterparty2(String var1);

        @Override
        public CSATransactionReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public CSATransactionReportBuilder setBeneficiary1(String var1);

        @Override
        public CSATransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean var1);

        @Override
        public CSATransactionReportBuilder setBuyerIdentifier(String var1);

        @Override
        public CSATransactionReportBuilder setSellerIdentifier(String var1);

        @Override
        public CSATransactionReportBuilder setCleared(ClearedEnum var1);

        @Override
        public CSATransactionReportBuilder setCentralCounterparty(String var1);

        @Override
        public CSATransactionReportBuilder setClearingMember(String var1);

        @Override
        public CSATransactionReportBuilder setConfirmed(ConfirmationEnum var1);

        @Override
        public CSATransactionReportBuilder setCallAmount(BigDecimal var1);

        @Override
        public CSATransactionReportBuilder setPutAmount(BigDecimal var1);

        @Override
        public CSATransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CSATransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CSATransactionReportBuilder setDelta(BigDecimal var1);

        @Override
        public CSATransactionReportBuilder addPriceSchedule(PricePeriod var1);

        @Override
        public CSATransactionReportBuilder addPriceSchedule(PricePeriod var1, int var2);

        @Override
        public CSATransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public CSATransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public CSATransactionReportBuilder addStrikePriceSchedule(PricePeriod var1);

        @Override
        public CSATransactionReportBuilder addStrikePriceSchedule(PricePeriod var1, int var2);

        @Override
        public CSATransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public CSATransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public CSATransactionReportBuilder setPrice(PriceFormat var1);

        @Override
        public CSATransactionReportBuilder setPriceNotation(PriceNotationEnum var1);

        @Override
        public CSATransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CSATransactionReportBuilder setPackageTransactionPrice(PriceFormat var1);

        @Override
        public CSATransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum var1);

        @Override
        public CSATransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CSATransactionReportBuilder setPackageTransactionSpread(PriceFormat var1);

        @Override
        public CSATransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum var1);

        @Override
        public CSATransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CSATransactionReportBuilder setPackageIdentifier(String var1);

        @Override
        public CSATransactionReportBuilder setStrikePrice(PriceFormat var1);

        @Override
        public CSATransactionReportBuilder setStrikePriceNotation(PriceNotationEnum var1);

        @Override
        public CSATransactionReportBuilder setStrikePriceCurrency(String var1);

        @Override
        public CSATransactionReportBuilder setPriceUnitOfMeasure(String var1);

        @Override
        public CSATransactionReportBuilder setOptionPremiumAmount(BigDecimal var1);

        @Override
        public CSATransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CSATransactionReportBuilder setOptionPremiumPaymentDate(Date var1);

        @Override
        public CSATransactionReportBuilder setExchangeRate(BigDecimal var1);

        @Override
        public CSATransactionReportBuilder setExchangeRateBasis(String var1);

        @Override
        public CSATransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal var1);

        @Override
        public CSATransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal var1);

        @Override
        public CSATransactionReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        @Override
        public CSATransactionReportBuilder setFirstExerciseDate(Date var1);

        @Override
        public CSATransactionReportBuilder setFinalContractualSettlementDate(Date var1);

        @Override
        public CSATransactionReportBuilder setSettlementLocation(ISOCountryCodeEnum var1);

        @Override
        public CSATransactionReportBuilder setPriorUTI(String var1);

        @Override
        public CSATransactionReportBuilder setDirection1(Direction1Enum var1);

        @Override
        public CSATransactionReportBuilder setValuationAmount(BigDecimal var1);

        @Override
        public CSATransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CSATransactionReportBuilder setValuationMethod(ValuationType1Code var1);

        @Override
        public CSATransactionReportBuilder setValuationTimestamp(ZonedDateTime var1);

        @Override
        public CSATransactionReportBuilder setCustomBasketCode(String var1);

        @Override
        public CSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport var1);

        @Override
        public CSATransactionReportBuilder addBasketConstituents(BasketConstituentsReport var1, int var2);

        @Override
        public CSATransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> var1);

        @Override
        public CSATransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> var1);

        @Override
        public CSATransactionReportBuilder addOtherPayment(OtherPayment var1);

        @Override
        public CSATransactionReportBuilder addOtherPayment(OtherPayment var1, int var2);

        @Override
        public CSATransactionReportBuilder addOtherPayment(List<? extends OtherPayment> var1);

        @Override
        public CSATransactionReportBuilder setOtherPayment(List<? extends OtherPayment> var1);

        @Override
        public CSATransactionReportBuilder setLeg1(LegV1 var1);

        @Override
        public CSATransactionReportBuilder setLeg2(LegV1 var1);

        @Override
        public CSATransactionReportBuilder setLeg1(LegV2 var1);

        @Override
        public CSATransactionReportBuilder setLeg2(LegV2 var1);

        @Override
        public CSATransactionReportBuilder setLeg1(Leg var1);

        @Override
        public CSATransactionReportBuilder setLeg2(Leg var1);

        @Override
        public CSATransactionReportBuilder setUnderlyingIdOther(String var1);

        @Override
        public CSATransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum var1);

        @Override
        public CSATransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifier(String var1);

        @Override
        public CSATransactionReportBuilder setUnderlyingAssetPriceSource(String var1);

        @Override
        public CSATransactionReportBuilder setCryptoAssetUnderlyingIndicator(Boolean var1);

        @Override
        public CSATransactionReportBuilder setLevel(ReportLevelEnum var1);

        @Override
        public CSATransactionReportBuilder setActionType(ActionTypeEnum var1);

        @Override
        public CSATransactionReportBuilder setEventType(EventTypeEnum var1);

        @Override
        public CSATransactionReportBuilder setEventIdentifier(String var1);

        @Override
        public CSATransactionReportBuilder setEventTimestamp(ZonedDateTime var1);

        @Override
        public CSATransactionReportBuilder setLeg1(CommonLeg var1);

        @Override
        public CSATransactionReportBuilder setLeg2(CommonLeg var1);

        @Override
        public CSATransactionReportBuilder setConfirmationTimestamp(ZonedDateTime var1);

        @Override
        public CSATransactionReportBuilder setPlatformIdentifier(String var1);

        @Override
        public CSATransactionReportBuilder setBookingLocation(ISOCountryCodeEnum var1);

        @Override
        public CSATransactionReportBuilder setTraderLocation(ISOCountryCodeEnum var1);

        @Override
        public CSATransactionReportBuilder setDeliveryType(DeliveryTypeEnum var1);

        @Override
        public CSATransactionReportBuilder setExecutionAgentCounterparty1(String var1);

        @Override
        public CSATransactionReportBuilder setExecutionAgentCounterparty2(String var1);

        @Override
        public CSATransactionReportBuilder setNatureOfCounterparty1(NatureOfCounterpartyEnum var1);

        @Override
        public CSATransactionReportBuilder setNatureOfCounterparty2(NatureOfCounterpartyEnum var1);

        @Override
        public CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum var1);

        @Override
        public CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum var1, int var2);

        @Override
        public CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public CSATransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum var1);

        @Override
        public CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum var1, int var2);

        @Override
        public CSATransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public CSATransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public CSATransactionReportBuilder addCorporateSectorOfTheCounterparty1(String var1);

        @Override
        public CSATransactionReportBuilder addCorporateSectorOfTheCounterparty1(String var1, int var2);

        @Override
        public CSATransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> var1);

        @Override
        public CSATransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> var1);

        @Override
        public CSATransactionReportBuilder addCorporateSectorOfTheCounterparty2(String var1);

        @Override
        public CSATransactionReportBuilder addCorporateSectorOfTheCounterparty2(String var1, int var2);

        @Override
        public CSATransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> var1);

        @Override
        public CSATransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> var1);

        @Override
        public CSATransactionReportBuilder setCounterparty2Name(String var1);

        @Override
        public CSATransactionReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public CSATransactionReportBuilder setEntityResponsibleForReporting(String var1);

        @Override
        public CSATransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum var1);

        @Override
        public CSATransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum var1);

        @Override
        public CSATransactionReportBuilder setTradingCapacity(TradingCapacity7Code var1);

        @Override
        public CSATransactionReportBuilder setBrokerID(String var1);

        @Override
        public CSATransactionReportBuilder setContractType(CommonContractType var1);

        @Override
        public CSATransactionReportBuilder setAssetClass(CommonAssetClass var1);

        @Override
        public CSATransactionReportBuilder setOptionType(OptionTypeCode var1);

        @Override
        public CSATransactionReportBuilder setOptionStyle(OptionStyleEnum var1);

        @Override
        public CSATransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum var1);

        @Override
        public CSATransactionReportBuilder setMasterAgreementType(MasterAgreementEnum var1);

        @Override
        public CSATransactionReportBuilder setMasterAgreementVersion(Integer var1);

        @Override
        public CSATransactionReportBuilder setSecondaryTransactionIdentifier(String var1);

        @Override
        public CSATransactionReportBuilder setIntragroup(Boolean var1);

        @Override
        public CSATransactionReportBuilder setNonStandardizedTermIndicator(Boolean var1);

        @Override
        public CSATransactionReportBuilder setAmendmentIndicator(Boolean var1);

        @Override
        public CSATransactionReportBuilder setUnderlyingIdentification(String var1);

        @Override
        public CSATransactionReportBuilder setUnderlyingIdentificationType(UnderlyingIdentificationTypeEnum var1);

        @Override
        public CSATransactionReportBuilder setNameOfTheUnderlyingIndex(String var1);

        @Override
        public CSATransactionReportBuilder setMaturityDateOfTheUnderlying(Date var1);

        @Override
        public CSATransactionReportBuilder setSwapLinkID(String var1);

        @Override
        public CSATransactionReportBuilder setPackageIndicator(Boolean var1);

        @Override
        public CSATransactionReportBuilder setCustomBasketIndicator(Boolean var1);

        @Override
        public CSATransactionReportBuilder setPriorUTIProprietary(String var1);

        @Override
        public CSATransactionReportBuilder setClearingTimestamp(ZonedDateTime var1);

        @Override
        public CSATransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum var1);

        @Override
        public CSATransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime var1);

        @Override
        public CSATransactionReportBuilder setUniqueTransactionIdentifier(String var1);

        @Override
        public CSATransactionReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        @Override
        public CSATransactionReportBuilder setUniqueProductIdentifier(String var1);

        @Override
        public CSATransactionReportBuilder setOriginalSwapUTI(String var1);

        @Override
        public CSATransactionReportBuilder setSubsequentPositionUTI(String var1);

        @Override
        public CSATransactionReportBuilder setOriginalSwapSDRIdentifier(String var1);

        @Override
        public CSATransactionReportBuilder setPriorUSI(String var1);

        @Override
        public CSATransactionReportBuilder setNewSDRIdentifier(String var1);

        @Override
        public CSATransactionReportBuilder setTechnicalRecordId(String var1);

        @Override
        public CSATransactionReportBuilder setReferenceEntity(String var1);

        @Override
        public CSATransactionReportBuilder setSeniority(SeniorityEnum var1);

        @Override
        public CSATransactionReportBuilder setSeries(Integer var1);

        @Override
        public CSATransactionReportBuilder setIndexFactor(BigDecimal var1);

        @Override
        public CSATransactionReportBuilder setSeriesVersion(Integer var1);

        @Override
        public CSATransactionReportBuilder setBaseProduct(String var1);

        @Override
        public CSATransactionReportBuilder setSubProduct(String var1);

        @Override
        public CSATransactionReportBuilder setFurtherSubProduct(String var1);

        @Override
        public CSATransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier var1);

        @Override
        public CSATransactionReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        @Override
        public CSATransactionReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        @Override
        public CSATransactionReportBuilder setNonReportable(NonReportable var1);

        public CSATransactionReportBuilder setCounterparty2IdentifierSourceOverriddenAsCounterparty2IdentifierEnum(Counterparty2IdentifierEnum var1);

        public CSATransactionReportBuilder setClearedOverriddenAsClearedEnum(ClearedEnum var1);

        public CSATransactionReportBuilder setEventTimestampOverriddenAsZonedDateTime(ZonedDateTime var1);

        public CSATransactionReportBuilder setLeg1(CSALeg var1);

        public CSATransactionReportBuilder setLeg2(CSALeg var1);

        public CSATransactionReportBuilder setNonReportable(CSANonReportable var1);

        public CSATransactionReportBuilder setCountryAndProvinceOrTerritoryOfIndividual(String var1);

        public CSATransactionReportBuilder addJurisdictionOfCounterparty1(String var1);

        public CSATransactionReportBuilder addJurisdictionOfCounterparty1(String var1, int var2);

        public CSATransactionReportBuilder addJurisdictionOfCounterparty1(List<String> var1);

        public CSATransactionReportBuilder setJurisdictionOfCounterparty1(List<String> var1);

        public CSATransactionReportBuilder addJurisdictionOfCounterparty2(String var1);

        public CSATransactionReportBuilder addJurisdictionOfCounterparty2(String var1, int var2);

        public CSATransactionReportBuilder addJurisdictionOfCounterparty2(List<String> var1);

        public CSATransactionReportBuilder setJurisdictionOfCounterparty2(List<String> var1);

        public CSATransactionReportBuilder setInterAffiliateIndicator(Boolean var1);

        public CSATransactionReportBuilder setPlatformAnonymousExecutionIndicator(Boolean var1);

        public CSATransactionReportBuilder setDtccAdditionalFields(DTCCAdditionalFields var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, (Object)this.getBuyerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, (Object)this.getSellerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, (Object)this.getCleared(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, (Object)this.getConfirmed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, this.getPriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, (Object)this.getPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPackageTransactionPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPackageTransactionSpread(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getStrikePrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, (Object)this.getStrikePriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, (Object)this.getStrikePriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, (Object)this.getDirection1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, this.getBasketConstituents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.OtherPaymentBuilder.class, this.getOtherPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leg1"), processor, CSALeg.CSALegBuilder.class, this.getLeg1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leg2"), processor, CSALeg.CSALegBuilder.class, this.getLeg2(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, (Object)this.getUnderlyingAssetPriceSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, (Object)this.getCryptoAssetUnderlyingIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, (Object)this.getEventType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, (Object)this.getConfirmationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, (Object)this.getBookingLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, (Object)this.getTraderLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, (Object)this.getDeliveryType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, (Object)this.getExecutionAgentCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentCounterparty2"), String.class, (Object)this.getExecutionAgentCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("natureOfCounterparty1"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("natureOfCounterparty2"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, this.getCorporateSectorOfTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, this.getCorporateSectorOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, (Object)this.getCountryOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, (Object)this.getTradingCapacity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("brokerID"), String.class, (Object)this.getBrokerID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, (Object)this.getContractType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, (Object)this.getEmbeddedOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("masterAgreementType"), MasterAgreementEnum.class, (Object)this.getMasterAgreementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, (Object)this.getMasterAgreementVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, (Object)this.getSecondaryTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("intragroup"), Boolean.class, (Object)this.getIntragroup(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, (Object)this.getNonStandardizedTermIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, (Object)this.getAmendmentIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, (Object)this.getUnderlyingIdentification(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentificationType"), UnderlyingIdentificationTypeEnum.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, (Object)this.getNameOfTheUnderlyingIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("swapLinkID"), String.class, (Object)this.getSwapLinkID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, (Object)this.getPackageIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, (Object)this.getCustomBasketIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, (Object)this.getPriorUTIProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, (Object)this.getClearingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, (Object)this.getClearingAccountOrigin(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, (Object)this.getClearingReceiptTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, (Object)this.getOriginalSwapUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, (Object)this.getSubsequentPositionUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, (Object)this.getOriginalSwapSDRIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUSI"), String.class, (Object)this.getPriorUSI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, (Object)this.getNewSDRIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("referenceEntity"), String.class, (Object)this.getReferenceEntity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, (Object)this.getSeniority(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("series"), Integer.class, (Object)this.getSeries(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seriesVersion"), Integer.class, (Object)this.getSeriesVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("baseProduct"), String.class, (Object)this.getBaseProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("subProduct"), String.class, (Object)this.getSubProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, (Object)this.getFurtherSubProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder.class, (RosettaModelObjectBuilder)this.getBarrier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonReportable"), processor, CSANonReportable.CSANonReportableBuilder.class, this.getNonReportable(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("countryAndProvinceOrTerritoryOfIndividual"), String.class, (Object)this.getCountryAndProvinceOrTerritoryOfIndividual(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("jurisdictionOfCounterparty1"), String.class, this.getJurisdictionOfCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("jurisdictionOfCounterparty2"), String.class, this.getJurisdictionOfCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("interAffiliateIndicator"), Boolean.class, (Object)this.getInterAffiliateIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("platformAnonymousExecutionIndicator"), Boolean.class, (Object)this.getPlatformAnonymousExecutionIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dtccAdditionalFields"), processor, DTCCAdditionalFields.DTCCAdditionalFieldsBuilder.class, this.getDtccAdditionalFields(), new AttributeMeta[0]);
        }

        @Override
        public CSATransactionReportBuilder prune();
    }

    public static class CSATransactionReportImpl
    extends CommonTransactionReport.CommonTransactionReportImpl
    implements CSATransactionReport {
        private final Counterparty2IdentifierEnum counterparty2IdentifierSource;
        private final ClearedEnum cleared;
        private final ZonedDateTime eventTimestamp;
        private final CSALeg leg1;
        private final CSALeg leg2;
        private final CSANonReportable nonReportable;
        private final String countryAndProvinceOrTerritoryOfIndividual;
        private final List<String> jurisdictionOfCounterparty1;
        private final List<String> jurisdictionOfCounterparty2;
        private final Boolean interAffiliateIndicator;
        private final Boolean platformAnonymousExecutionIndicator;
        private final DTCCAdditionalFields dtccAdditionalFields;

        protected CSATransactionReportImpl(CSATransactionReportBuilder builder) {
            super(builder);
            this.counterparty2IdentifierSource = builder.getCounterparty2IdentifierSource();
            this.cleared = builder.getCleared();
            this.eventTimestamp = builder.getEventTimestamp();
            this.leg1 = Optional.ofNullable(builder.getLeg1()).map(f -> f.build()).orElse(null);
            this.leg2 = Optional.ofNullable(builder.getLeg2()).map(f -> f.build()).orElse(null);
            this.nonReportable = Optional.ofNullable(builder.getNonReportable()).map(f -> f.build()).orElse(null);
            this.countryAndProvinceOrTerritoryOfIndividual = builder.getCountryAndProvinceOrTerritoryOfIndividual();
            this.jurisdictionOfCounterparty1 = Optional.ofNullable(builder.getJurisdictionOfCounterparty1()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.jurisdictionOfCounterparty2 = Optional.ofNullable(builder.getJurisdictionOfCounterparty2()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.interAffiliateIndicator = builder.getInterAffiliateIndicator();
            this.platformAnonymousExecutionIndicator = builder.getPlatformAnonymousExecutionIndicator();
            this.dtccAdditionalFields = Optional.ofNullable(builder.getDtccAdditionalFields()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public Counterparty2IdentifierEnum getCounterparty2IdentifierSource() {
            return this.counterparty2IdentifierSource;
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public ClearedEnum getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="leg1")
        @RuneAttribute(value="leg1")
        public CSALeg getLeg1() {
            return this.leg1;
        }

        @Override
        @RosettaAttribute(value="leg2")
        @RuneAttribute(value="leg2")
        public CSALeg getLeg2() {
            return this.leg2;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public CSANonReportable getNonReportable() {
            return this.nonReportable;
        }

        @Override
        @RosettaAttribute(value="countryAndProvinceOrTerritoryOfIndividual")
        @RuneAttribute(value="countryAndProvinceOrTerritoryOfIndividual")
        public String getCountryAndProvinceOrTerritoryOfIndividual() {
            return this.countryAndProvinceOrTerritoryOfIndividual;
        }

        @Override
        @RosettaAttribute(value="jurisdictionOfCounterparty1")
        @RuneAttribute(value="jurisdictionOfCounterparty1")
        public List<String> getJurisdictionOfCounterparty1() {
            return this.jurisdictionOfCounterparty1;
        }

        @Override
        @RosettaAttribute(value="jurisdictionOfCounterparty2")
        @RuneAttribute(value="jurisdictionOfCounterparty2")
        public List<String> getJurisdictionOfCounterparty2() {
            return this.jurisdictionOfCounterparty2;
        }

        @Override
        @RosettaAttribute(value="interAffiliateIndicator")
        @RuneAttribute(value="interAffiliateIndicator")
        public Boolean getInterAffiliateIndicator() {
            return this.interAffiliateIndicator;
        }

        @Override
        @RosettaAttribute(value="platformAnonymousExecutionIndicator")
        @RuneAttribute(value="platformAnonymousExecutionIndicator")
        public Boolean getPlatformAnonymousExecutionIndicator() {
            return this.platformAnonymousExecutionIndicator;
        }

        @Override
        @RosettaAttribute(value="dtccAdditionalFields")
        @RuneAttribute(value="dtccAdditionalFields")
        public DTCCAdditionalFields getDtccAdditionalFields() {
            return this.dtccAdditionalFields;
        }

        @Override
        public CSATransactionReport build() {
            return this;
        }

        @Override
        public CSATransactionReportBuilder toBuilder() {
            CSATransactionReportBuilder builder = CSATransactionReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CSATransactionReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCounterparty2IdentifierSource()).ifPresent(builder::setCounterparty2IdentifierSourceOverriddenAsCounterparty2IdentifierEnum);
            Optional.ofNullable(this.getCleared()).ifPresent(builder::setClearedOverriddenAsClearedEnum);
            Optional.ofNullable(this.getEventTimestamp()).ifPresent(builder::setEventTimestampOverriddenAsZonedDateTime);
            Optional.ofNullable(this.getLeg1()).ifPresent(builder::setLeg1);
            Optional.ofNullable(this.getLeg2()).ifPresent(builder::setLeg2);
            Optional.ofNullable(this.getNonReportable()).ifPresent(builder::setNonReportable);
            Optional.ofNullable(this.getCountryAndProvinceOrTerritoryOfIndividual()).ifPresent(builder::setCountryAndProvinceOrTerritoryOfIndividual);
            Optional.ofNullable(this.getJurisdictionOfCounterparty1()).ifPresent(builder::setJurisdictionOfCounterparty1);
            Optional.ofNullable(this.getJurisdictionOfCounterparty2()).ifPresent(builder::setJurisdictionOfCounterparty2);
            Optional.ofNullable(this.getInterAffiliateIndicator()).ifPresent(builder::setInterAffiliateIndicator);
            Optional.ofNullable(this.getPlatformAnonymousExecutionIndicator()).ifPresent(builder::setPlatformAnonymousExecutionIndicator);
            Optional.ofNullable(this.getDtccAdditionalFields()).ifPresent(builder::setDtccAdditionalFields);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CSATransactionReport _that = (CSATransactionReport)this.getType().cast(o);
            if (!Objects.equals((Object)this.counterparty2IdentifierSource, (Object)_that.getCounterparty2IdentifierSource())) {
                return false;
            }
            if (!Objects.equals((Object)this.cleared, (Object)_that.getCleared())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.leg1, _that.getLeg1())) {
                return false;
            }
            if (!Objects.equals(this.leg2, _that.getLeg2())) {
                return false;
            }
            if (!Objects.equals(this.nonReportable, _that.getNonReportable())) {
                return false;
            }
            if (!Objects.equals(this.countryAndProvinceOrTerritoryOfIndividual, _that.getCountryAndProvinceOrTerritoryOfIndividual())) {
                return false;
            }
            if (!ListEquals.listEquals(this.jurisdictionOfCounterparty1, _that.getJurisdictionOfCounterparty1())) {
                return false;
            }
            if (!ListEquals.listEquals(this.jurisdictionOfCounterparty2, _that.getJurisdictionOfCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.interAffiliateIndicator, _that.getInterAffiliateIndicator())) {
                return false;
            }
            if (!Objects.equals(this.platformAnonymousExecutionIndicator, _that.getPlatformAnonymousExecutionIndicator())) {
                return false;
            }
            return Objects.equals(this.dtccAdditionalFields, _that.getDtccAdditionalFields());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2IdentifierSource != null ? ((Object)((Object)this.counterparty2IdentifierSource)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? ((Object)((Object)this.cleared)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.leg1 != null ? this.leg1.hashCode() : 0);
            _result = 31 * _result + (this.leg2 != null ? this.leg2.hashCode() : 0);
            _result = 31 * _result + (this.nonReportable != null ? this.nonReportable.hashCode() : 0);
            _result = 31 * _result + (this.countryAndProvinceOrTerritoryOfIndividual != null ? this.countryAndProvinceOrTerritoryOfIndividual.hashCode() : 0);
            _result = 31 * _result + (this.jurisdictionOfCounterparty1 != null ? this.jurisdictionOfCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.jurisdictionOfCounterparty2 != null ? this.jurisdictionOfCounterparty2.hashCode() : 0);
            _result = 31 * _result + (this.interAffiliateIndicator != null ? this.interAffiliateIndicator.hashCode() : 0);
            _result = 31 * _result + (this.platformAnonymousExecutionIndicator != null ? this.platformAnonymousExecutionIndicator.hashCode() : 0);
            _result = 31 * _result + (this.dtccAdditionalFields != null ? this.dtccAdditionalFields.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CSATransactionReport {counterparty2IdentifierSource=" + String.valueOf((Object)this.counterparty2IdentifierSource) + ", cleared=" + String.valueOf((Object)this.cleared) + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", leg1=" + String.valueOf(this.leg1) + ", leg2=" + String.valueOf(this.leg2) + ", nonReportable=" + String.valueOf(this.nonReportable) + ", countryAndProvinceOrTerritoryOfIndividual=" + this.countryAndProvinceOrTerritoryOfIndividual + ", jurisdictionOfCounterparty1=" + String.valueOf(this.jurisdictionOfCounterparty1) + ", jurisdictionOfCounterparty2=" + String.valueOf(this.jurisdictionOfCounterparty2) + ", interAffiliateIndicator=" + this.interAffiliateIndicator + ", platformAnonymousExecutionIndicator=" + this.platformAnonymousExecutionIndicator + ", dtccAdditionalFields=" + String.valueOf(this.dtccAdditionalFields) + "} " + super.toString();
        }
    }
}

