/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.product.functions.IsCreditDefaultSwap;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.functions.ProductForEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=CDSIndexDetachmentPointRuleDefault.class)
public abstract class CDSIndexDetachmentPointRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected drr.standards.iosco.cde.version3.index.reports.CDSIndexDetachmentPointRule cDSIndexDetachmentPointRule;
    @Inject
    protected IsAllowableActionForCSA isAllowableActionForCSA;
    @Inject
    protected IsCreditDefaultSwap isCreditDefaultSwap;
    @Inject
    protected ProductForEvent productForEvent;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class CDSIndexDetachmentPointRuleDefault
    extends CDSIndexDetachmentPointRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCSA.evaluate((ReportableEventBase)item.get()));
            output = (BigDecimal)thenArg.mapSingleToItem(item -> {
                Boolean _boolean = this.isCreditDefaultSwap.evaluate(this.productForEvent.evaluate((ReportableEventBase)item.get()));
                if (_boolean != null && _boolean.booleanValue()) {
                    return MapperS.of((Object)this.cDSIndexDetachmentPointRule.evaluate((TransactionReportInstructionBase)item.get()));
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

