/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.base.trade.price.PriceNotationEnum;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CSATransactionReportCSA_VR_0057_01")
@ImplementedBy(value=Default.class)
public interface CSATransactionReportCSA_VR_0057_01
extends Validator<CSATransactionReport> {
    public static final String NAME = "CSATransactionReportCSA_VR_0057_01";
    public static final String DEFINITION = "if strikePriceNotation = Monetary then strikePriceCurrency exists else strikePriceCurrency is absent";

    public static class NoOp
    implements CSATransactionReportCSA_VR_0057_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CSATransactionReportCSA_VR_0057_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            ComparisonResult result = this.executeDataRule(cSATransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CSATransactionReportCSA_VR_0057_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportCSA_VR_0057_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CSATransactionReportCSA_VR_0057_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportCSA_VR_0057_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getStrikePriceNotation", _cSATransactionReport -> _cSATransactionReport.getStrikePriceNotation()), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getStrikePriceCurrency", _cSATransactionReport -> _cSATransactionReport.getStrikePriceCurrency()));
                }
                return ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getStrikePriceCurrency", _cSATransactionReport -> _cSATransactionReport.getStrikePriceCurrency()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

