/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iosco.upi.AnnaDsbAssetClassEnum;
import drr.standards.iso.FrequencyPeriodEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CSATransactionReportDTCC_CSA_VR_0034_02")
@ImplementedBy(value=Default.class)
public interface CSATransactionReportDTCC_CSA_VR_0034_02
extends Validator<CSATransactionReport> {
    public static final String NAME = "CSATransactionReportDTCC_CSA_VR_0034_02";
    public static final String DEFINITION = "if (nonReportable -> postUpiData -> Header -> AssetClass = Commodities or dtccAdditionalFields -> primaryAssetClass = Commodity) and leg2 -> quantityFrequency exists and [FrequencyPeriodEnum -> ONDE, FrequencyPeriodEnum -> ADHO] all <> leg2 -> quantityFrequency then leg2 -> quantityFrequencyMultiplier exists else leg2 -> quantityFrequencyMultiplier is absent";

    public static class NoOp
    implements CSATransactionReportDTCC_CSA_VR_0034_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CSATransactionReportDTCC_CSA_VR_0034_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            ComparisonResult result = this.executeDataRule(cSATransactionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CSATransactionReportDTCC_CSA_VR_0034_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportDTCC_CSA_VR_0034_02.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CSATransactionReportDTCC_CSA_VR_0034_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportDTCC_CSA_VR_0034_02.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (Mapper)MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.COMMODITIES)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (Mapper)MapperS.of((Object)AssetClassEnum.COMMODITY), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getQuantityFrequency", cSALeg -> cSALeg.getQuantityFrequency()))).and(ExpressionOperators.notEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)FrequencyPeriodEnum.ONDE)), MapperS.of((Object)((Object)FrequencyPeriodEnum.ADHO))}), (Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getQuantityFrequency", cSALeg -> cSALeg.getQuantityFrequency()), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getQuantityFrequencyMultiplier", cSALeg -> cSALeg.getQuantityFrequencyMultiplier()));
                }
                return ExpressionOperators.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getLeg2", _cSATransactionReport -> _cSATransactionReport.getLeg2()).map("getQuantityFrequencyMultiplier", cSALeg -> cSALeg.getQuantityFrequencyMultiplier()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

